/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class X509CRLEntry
extends java.security.cert.X509CRLEntry {
    private byte[] encoded;
    private BigInteger serialNo;
    private Date revocationDate;
    private HashMap extensions = new HashMap();
    private HashSet critOids = new HashSet();
    private HashSet nonCritOids = new HashSet();

    /*
     * WARNING - void declaration
     */
    X509CRLEntry(int version, InputStream encoded) throws CRLException, IOException {
        try {
            this.parse(version, encoded);
        }
        catch (IOException ioe) {
            void x;
            throw x;
        }
        catch (Exception x) {
            throw new CRLException(x.toString());
        }
    }

    public boolean equals(Object o) {
        return ((X509CRLEntry)o).serialNo.equals(this.serialNo) && ((X509CRLEntry)o).revocationDate.equals(this.revocationDate);
    }

    public int hashCode() {
        return this.serialNo.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    public boolean hasExtensions() {
        return this.extensions.isEmpty() ^ true;
    }

    public String toString() {
        return "X509CRLEntry serial=" + this.serialNo + " revocation date=" + this.revocationDate + " critExt=" + this.critOids + " ext=" + this.nonCritOids;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        return Collections.unmodifiableSet(this.critOids);
    }

    public Set getNonCriticalExtensionOIDs() {
        return Collections.unmodifiableSet(this.nonCritOids);
    }

    public byte[] getExtensionValue(String oid) {
        byte[] ext = (byte[])this.extensions.get(oid);
        if (ext != null) {
            return (byte[])ext.clone();
        }
        return null;
    }

    private void parse(int version, InputStream in) throws Exception {
        DERReader der = new DERReader(in);
        DERValue entry = der.read();
        if (!entry.isConstructed()) {
            throw new ASN1ParsingException("malformed revokedCertificate");
        }
        this.encoded = entry.getEncoded();
        int len = 0;
        DERValue val = der.read();
        this.serialNo = (BigInteger)val.getValue();
        len += DERWriter.definiteEncodingSize(val.getLength()) + val.getLength() + 1;
        val = der.read();
        this.revocationDate = (Date)val.getValue();
        if ((len += DERWriter.definiteEncodingSize(val.getLength()) + val.getLength() + 1) < entry.getLength()) {
            if (version < 2) {
                throw new ASN1ParsingException("extra data in CRL entry");
            }
            while (len < entry.getLength()) {
                val = der.read();
                if (!val.isConstructed()) {
                    throw new ASN1ParsingException("malformed Extension");
                }
                OID extOid = (OID)der.read().getValue();
                Boolean critical = false;
                DERValue val2 = der.read();
                if (val2.getValue() instanceof Boolean) {
                    critical = (Boolean)val2.getValue();
                    val2 = der.read();
                }
                byte[] ext = (byte[])val2.getValue();
                this.extensions.put(extOid.toString(), ext);
                if (critical.booleanValue()) {
                    this.critOids.add(extOid.toString());
                } else {
                    this.nonCritOids.add(extOid.toString());
                }
                len += val.getEncodedLength();
            }
        }
    }
}

