/*
 *  Copyright (C) 2002 Mickael Marchand <marchand@kde.org> 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef KCMVIM_H
#define KCMVIM_H

#include <kcmodule.h>
#include <kconfig.h>
#include <kprocess.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <kled.h>
#include <kurlrequester.h>
#include <vimbase.h>

enum GUI {
	KVIM,
	GTK,
	GNOME,
	OTHER,
	NONE
};

typedef enum GUI guiT;

class KCMVim : public KCModule
{
		Q_OBJECT
		public:
				KCMVim(QWidget *parent=0, const char * name=0, const QStringList &list = QStringList( ));
				virtual ~KCMVim();

				void load();
				void save();
				void defaults();

				vimbase *base;


		protected slots:
				void checkPath(const QString&); 
				void test(); 
				void testExited(KProcess *);
				void Err(KProcess*,char*,int);
				void Out(KProcess*,char*,int);
				void setModified();
				void reset();

		private:
				KConfig *config;
				KProcess *myProc;
				guiT vimgui;
				bool haseval, hasclientserver, configurationok;
};

#endif
