/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.sparc;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCRegisterMap
extends RegisterMap {
    private Address window;
    private Address youngerWindow;
    private static int registerImplNumberOfRegisters;
    private static int[] R_L_nums;
    private static int[] R_I_nums;
    private static int[] R_O_nums;
    private static int[] R_G_nums;
    private static int once;
    private static int badMask;
    private static int R_LIO_mask;
    private static int sizeofJint;

    private static void initialize(TypeDataBase db) {
        once = 0;
        badMask = 0;
        R_LIO_mask = 0;
        sizeofJint = (int)db.lookupType("jint").getSize();
        registerImplNumberOfRegisters = db.lookupIntConstant("RegisterImpl::number_of_registers");
        if (VM.getVM().isClientCompiler()) {
            R_L_nums = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
            R_I_nums = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
            R_O_nums = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
            R_G_nums = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        }
        if (VM.getVM().isServerCompiler()) {
            R_L_nums = new int[]{db.lookupIntConstant("R_L0_num"), db.lookupIntConstant("R_L1_num"), db.lookupIntConstant("R_L2_num"), db.lookupIntConstant("R_L3_num"), db.lookupIntConstant("R_L4_num"), db.lookupIntConstant("R_L5_num"), db.lookupIntConstant("R_L6_num"), db.lookupIntConstant("R_L7_num")};
            R_I_nums = new int[]{db.lookupIntConstant("R_I0_num"), db.lookupIntConstant("R_I1_num"), db.lookupIntConstant("R_I2_num"), db.lookupIntConstant("R_I3_num"), db.lookupIntConstant("R_I4_num"), db.lookupIntConstant("R_I5_num"), db.lookupIntConstant("R_FP_num"), db.lookupIntConstant("R_I7_num")};
            R_O_nums = new int[]{db.lookupIntConstant("R_O0_num"), db.lookupIntConstant("R_O1_num"), db.lookupIntConstant("R_O2_num"), db.lookupIntConstant("R_O3_num"), db.lookupIntConstant("R_O4_num"), db.lookupIntConstant("R_O5_num"), db.lookupIntConstant("R_SP_num"), db.lookupIntConstant("R_O7_num")};
            R_G_nums = new int[]{db.lookupIntConstant("R_G0_num"), db.lookupIntConstant("R_G1_num"), db.lookupIntConstant("R_G2_num"), db.lookupIntConstant("R_G3_num"), db.lookupIntConstant("R_G4_num"), db.lookupIntConstant("R_G5_num"), db.lookupIntConstant("R_G6_num"), db.lookupIntConstant("R_G7_num")};
        }
    }

    public SPARCRegisterMap(JavaThread thread, boolean updateMap) {
        super(thread, updateMap);
    }

    protected SPARCRegisterMap(RegisterMap map) {
        super(map);
    }

    public Object clone() {
        SPARCRegisterMap retval = new SPARCRegisterMap(this);
        return retval;
    }

    protected void clearPD() {
        if (this.thread.hasLastJavaFrame()) {
            Frame fr = this.thread.getLastFrame();
            this.window = fr.getSP();
        } else {
            Frame fr;
            this.window = null;
            if (VM.getVM().isDebugging() && (fr = this.thread.getCurrentFrameGuess()) != null) {
                this.window = fr.getSP();
            }
        }
        this.youngerWindow = null;
    }

    protected Address getLocationPD(VMReg regname) {
        VM vm = VM.getVM();
        int enc = regname.getValue();
        int secondWord = 0;
        Assert.that(0 <= enc && enc < regCount, "sanity check");
        if (vm.isServerCompiler()) {
            enc = regname.regEncode();
            if (enc == 255) {
                return null;
            }
            if (enc > registerImplNumberOfRegisters) {
                enc -= 128;
                secondWord += sizeofJint;
            }
            Assert.that(enc >= 0 && enc < registerImplNumberOfRegisters, "sanity check on ad file register encoding");
        }
        if (enc < registerImplNumberOfRegisters) {
            SPARCRegister reg = new SPARCRegister(enc);
            if (reg.isOut()) {
                Assert.that(this.youngerWindow != null, "Younger window should be available");
                return this.youngerWindow.addOffsetTo(reg.afterSave().spOffsetInSavedWindow() + (long)secondWord);
            }
            if (reg.isLocal() || reg.isIn()) {
                Assert.that(this.window != null, "Window should be available");
                return this.window.addOffsetTo(reg.spOffsetInSavedWindow() + (long)secondWord);
            }
        }
        return null;
    }

    protected String getRegisterNamePD(int i) {
        return SPARCRegisters.getRegisterName(i);
    }

    protected void initializePD() {
        this.window = null;
        this.youngerWindow = null;
        this.makeIntegerRegsUnsaved();
    }

    protected void initializeFromPD(RegisterMap map) {
        SPARCRegisterMap srm = (SPARCRegisterMap)map;
        this.window = srm.window;
        this.youngerWindow = srm.youngerWindow;
        this.makeIntegerRegsUnsaved();
    }

    public void shiftWindow(Address sp, Address youngerSP) {
        this.window = sp;
        this.youngerWindow = youngerSP;
        Assert.that(registerImplNumberOfRegisters == 32, "one word has valid bits for int-regs");
        if (this.locationValid[0] != 0) {
            this.shiftIndividualRegisters();
        }
    }

    public void makeIntegerRegsUnsaved() {
        this.locationValid[0] = 0;
    }

    private void shiftIndividualRegisters() {
        int i;
        int lv;
        if (!this.getUpdateMap()) {
            return;
        }
        int lv0 = lv = this.locationValid[0];
        if (once++ == 0) {
            int bitsPerWord = (int)VM.getVM().getAddressSize() * 8;
            for (i = 0; i < 8; ++i) {
                Assert.that(R_L_nums[i] < bitsPerWord, "in first chunk");
                Assert.that(R_I_nums[i] < bitsPerWord, "in first chunk");
                Assert.that(R_O_nums[i] < bitsPerWord, "in first chunk");
                Assert.that(R_G_nums[i] < bitsPerWord, "in first chunk");
            }
        }
        if (VM.getVM().isServerCompiler() && badMask == 0) {
            int m = 0;
            m |= 1 << R_O_nums[6];
            m |= 1 << R_O_nums[7];
            m |= 1 << R_I_nums[6];
            m |= 1 << R_I_nums[7];
            m |= 1 << R_G_nums[2];
            badMask = m |= 1 << R_G_nums[7];
        }
        Assert.that((lv & badMask) == 0, "cannot have special locations for SP,FP,TLS,etc.");
        int mask = R_LIO_mask;
        if (mask == 0) {
            for (i = 0; i < 8; ++i) {
                mask |= 1 << R_L_nums[i];
                mask |= 1 << R_I_nums[i];
                mask |= 1 << R_O_nums[i];
            }
            R_LIO_mask = mask;
        }
        if ((lv &= ~mask) != lv0) {
            for (i = 0; i < 8; ++i) {
                if ((lv0 & 1 << R_I_nums[i]) == 0) continue;
                this.location[SPARCRegisterMap.R_O_nums[i]] = this.location[R_I_nums[i]];
                lv |= 1 << R_O_nums[i];
            }
        }
        this.locationValid[0] = lv;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SPARCRegisterMap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

