/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CarSpace;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.memory.TrainGeneration;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class Train
extends VMObject {
    private static AddressField tgField;
    private static AddressField firstCarField;
    private static AddressField lastCarField;
    private static AddressField nextTrainField;
    private static AddressField prevTrainField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Train");
        tgField = type.getAddressField("_tg");
        firstCarField = type.getAddressField("_first_car");
        lastCarField = type.getAddressField("_last_car");
        nextTrainField = type.getAddressField("_next_train");
        prevTrainField = type.getAddressField("_prev_train");
    }

    public Train(Address addr) {
        super(addr);
    }

    public TrainGeneration gen() {
        return (TrainGeneration)VMObjectFactory.newObject(TrainGeneration.class, tgField.getValue(this.addr));
    }

    public CarSpace firstCar() {
        return (CarSpace)VMObjectFactory.newObject(CarSpace.class, firstCarField.getValue(this.addr));
    }

    public CarSpace lastCar() {
        return (CarSpace)VMObjectFactory.newObject(CarSpace.class, lastCarField.getValue(this.addr));
    }

    public Train nextTrain() {
        return (Train)VMObjectFactory.newObject(Train.class, nextTrainField.getValue(this.addr));
    }

    public Train prevTrain() {
        return (Train)VMObjectFactory.newObject(Train.class, prevTrainField.getValue(this.addr));
    }

    public long trainNumber() {
        return this.firstCar().trainNumber();
    }

    public void spaceIterate(SpaceClosure blk, boolean usedOnly) {
        for (CarSpace c = this.firstCar(); c != null; c = c.nextCar()) {
            blk.doSpace(c);
        }
    }

    public long free() {
        return this.lastCar().free();
    }

    public long used() {
        long size = 0L;
        CarSpace c = this.firstCar();
        while (!((Object)c.getAddress()).equals(this.lastCar().getAddress())) {
            size += c.capacity();
            c = c.nextCar();
        }
        return size += c.used();
    }

    public long capacity() {
        long size = 0L;
        for (CarSpace c = this.firstCar(); c != null; c = c.nextCar()) {
            size += c.capacity();
        }
        return size;
    }

    public void printOn(PrintStream tty) {
        tty.print(" train ");
        tty.println(this.trainNumber());
        for (CarSpace c = this.firstCar(); c != null; c = c.nextCar()) {
            c.printOn(tty);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Train.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

