/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeLoadStore;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeLoad
extends BytecodeLoadStore {
    BytecodeLoad(Method method, int bci) {
        super(method, bci);
    }

    public void verify() {
        Assert.that(this.isValid(), "check load");
    }

    public boolean isValid() {
        int jcode = this.javaCode();
        switch (jcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static BytecodeLoad at(Method method, int bci) {
        BytecodeLoad b = new BytecodeLoad(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeLoad atCheck(Method method, int bci) {
        BytecodeLoad b = new BytecodeLoad(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeLoad at(BytecodeStream bcs) {
        return new BytecodeLoad(bcs.method(), bcs.bci());
    }
}

