/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.util.AboutDialog;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.Globals;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.CacheObject;
import com.sun.javaws.ui.CacheTable;
import com.sun.javaws.util.JavawsConsoleController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class CacheViewer
extends JFrame
implements ActionListener,
ChangeListener,
ListSelectionListener,
DeploySIListener {
    private final JButton _removeBtn;
    private final JButton _launchOnlineBtn;
    private final JButton _launchOfflineBtn;
    private final JTabbedPane _tabbedPane;
    private final CacheTable _userTable;
    private final CacheTable _sysTable;
    private final JScrollPane _userTab;
    private final JScrollPane _systemTab;
    private static final String BOUNDS_PROPERTY_KEY = "deployment.javaws.viewer.bounds";
    private JMenuItem _launchOnlineMI;
    private JMenuItem _launchOfflineMI;
    private JMenuItem _removeMI;
    private JMenuItem _showMI;
    private JMenuItem _installMI;
    private JMenuItem _browseMI;
    private JMenu _fileMenu;
    private JMenu _editMenu;
    private JMenu _appMenu;
    private JMenu _viewMenu;
    private JMenu _helpMenu;
    private TitledBorder _titledBorder;
    public static final int STATUS_OK = 0;
    public static final int STATUS_REMOVING = 1;
    public static final int STATUS_LAUNCHING = 2;
    public static final int STATUS_BROWSING = 3;
    public static final int STATUS_SORTING = 4;
    public static final int STATUS_SEARCHING = 5;
    public static final int STATUS_INSTALLING = 6;
    private static int _status = 0;
    private static JLabel _statusLabel;
    private static final JLabel _totalSize;
    private static final LocalInstallHandler _lih;
    private static final boolean _isLocalInstallSupported;
    private static long t0;
    private static long t1;
    private static long t2;
    private static long t3;
    private static long t4;
    private SingleInstanceImpl _sil = new SingleInstanceImpl();
    private static final String JAVAWS_CV_ID;
    private static final int SLEEP_DELAY = 2000;
    static /* synthetic */ Class class$java$lang$String;

    public CacheViewer() {
        this._sil.addSingleInstanceListener((DeploySIListener)this, JAVAWS_CV_ID);
        this._removeBtn = this.makeButton("jnlp.viewer.remove.btn");
        this._launchOnlineBtn = this.makeButton("jnlp.viewer.launch.online.btn");
        this._launchOfflineBtn = this.makeButton("jnlp.viewer.launch.offline.btn");
        _statusLabel = new JLabel(" ");
        this._tabbedPane = new JTabbedPane();
        this._userTable = new CacheTable(this, false);
        this._sysTable = new CacheTable(this, true);
        this._userTab = new JScrollPane(this._userTable);
        this._systemTab = new JScrollPane(this._sysTable);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(ResourceManager.getMessage((String)"jnlp.viewer.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CacheViewer.this.exitViewer();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._titledBorder = new TitledBorder(ResourceManager.getMessage((String)"jnlp.viewer.all"));
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, this._titledBorder);
        jPanel.setBorder(BorderFactory.createCompoundBorder(compoundBorder, border));
        if (Globals.isSystemCache()) {
            this._tabbedPane.addTab(ResourceManager.getMessage((String)"cert.dialog.system.level"), this._userTab);
        } else {
            this._tabbedPane.addTab(ResourceManager.getMessage((String)"cert.dialog.user.level"), this._userTab);
            this._tabbedPane.addTab(ResourceManager.getMessage((String)"cert.dialog.system.level"), this._systemTab);
        }
        this._tabbedPane.setSelectedIndex(0);
        this._tabbedPane.addChangeListener(this);
        jPanel.add((Component)this._tabbedPane, "Center");
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        box.add(this._removeBtn);
        box.add(Box.createHorizontalGlue());
        box.add(this._launchOnlineBtn);
        box.add(Box.createHorizontalStrut(5));
        box.add(this._launchOfflineBtn);
        jPanel.add((Component)box, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        _totalSize.setText(this.getAppMessage("jnlp.viewer.totalSize", ""));
        _totalSize.setHorizontalAlignment(0);
        _totalSize.setFont(ResourceManager.getUIFont());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        _statusLabel = new JLabel(" ");
        _statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        _statusLabel.setFont(ResourceManager.getUIFont());
        jPanel3.add((Component)_statusLabel, "West");
        jPanel3.add((Component)_totalSize, "Center");
        jPanel3.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel2.add((Component)jPanel3, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.getContentPane().add(Box.createVerticalStrut(8), "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.createMenuBar();
        this.pack();
        this._userTable.getSelectionModel().addListSelectionListener(this);
        this._sysTable.getSelectionModel().addListSelectionListener(this);
    }

    private void createMenuBar() {
        this._fileMenu = new JMenu(ResourceManager.getMessage((String)"jnlp.viewer.file.menu"));
        this._fileMenu.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.file.menu.mnemonic"));
        JMenuItem jMenuItem = this._fileMenu.add(ResourceManager.getMessage((String)"jnlp.viewer.exit.mi"));
        jMenuItem.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.exit.mi.mnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.exitViewer();
            }
        });
        this._editMenu = new JMenu(ResourceManager.getMessage((String)"jnlp.viewer.edit.menu"));
        this._editMenu.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.edit.menu.mnemonic"));
        jMenuItem = this._editMenu.add(ResourceManager.getMessage((String)"jnlp.viewer.reinstall.mi"));
        jMenuItem.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.reinstall.mi.mnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.showReInstallDialog();
            }
        });
        this._editMenu.addSeparator();
        jMenuItem = this._editMenu.add(ResourceManager.getMessage((String)"jnlp.viewer.preferences.mi"));
        jMenuItem.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.preferences.mi.mnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.launchJavaControlPanel("general");
            }
        });
        this._appMenu = new JMenu(ResourceManager.getMessage((String)"jnlp.viewer.app.menu"));
        this._appMenu.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.app.menu.mnemonic"));
        this._appMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.refresh();
            }
        });
        this._launchOfflineMI = this._appMenu.add("");
        this._launchOfflineMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.launch.offline.mi.mnemonic"));
        this._launchOnlineMI = this._appMenu.add("");
        this._launchOnlineMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.launch.online.mi.mnemonic"));
        this._appMenu.addSeparator();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (_isLocalInstallSupported) {
            this._installMI = this._appMenu.add("");
            this._installMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.install.mi.mnemonic"));
            this._installMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CacheViewer.this.integrateApplication();
                }
            });
        }
        this._showMI = this._appMenu.add("");
        this._showMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.show.mi.mnemonic"));
        this._browseMI = this._appMenu.add("");
        this._browseMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.browse.mi.mnemonic"));
        this._appMenu.addSeparator();
        this._removeMI = this._appMenu.add("");
        this._removeMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.remove.mi.mnemonic"));
        this._launchOfflineMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.launchApplication(false);
            }
        });
        this._launchOnlineMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.launchApplication(true);
            }
        });
        this._showMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.showApplication();
            }
        });
        this._browseMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.browseApplication();
            }
        });
        this._removeMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.removeApplications();
            }
        });
        this._viewMenu = new JMenu(ResourceManager.getMessage((String)"jnlp.viewer.view.menu"));
        this._viewMenu.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.view.menu.mnemonic"));
        for (int i = 0; i < 5; ++i) {
            jMenuItem = this._viewMenu.add(new JCheckBoxMenuItem(ResourceManager.getMessage((String)("jnlp.viewer.view." + i + ".mi")), i == 0));
            jMenuItem.setMnemonic(ResourceManager.getVKCode((String)("jnlp.viewer.view." + i + ".mi.mnemonic")));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final Object object = actionEvent.getSource();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (int i = 0; i < 5; ++i) {
                                JMenuItem jMenuItem = CacheViewer.this._viewMenu.getItem(i);
                                if (!(jMenuItem instanceof JCheckBoxMenuItem)) continue;
                                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenuItem;
                                if (object.equals(jCheckBoxMenuItem)) {
                                    jCheckBoxMenuItem.setState(true);
                                    CacheViewer.this.setFilter(i);
                                    continue;
                                }
                                jCheckBoxMenuItem.setState(false);
                            }
                        }
                    });
                }
            });
        }
        this._helpMenu = new JMenu(ResourceManager.getMessage((String)"jnlp.viewer.help.menu"));
        this._helpMenu.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.help.menu.mnemonic"));
        jMenuItem = this._helpMenu.add(ResourceManager.getMessage((String)"jnlp.viewer.help.java.mi"));
        jMenuItem.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.help.java.mi.mnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Config.getProperty((String)"deployment.home.j2se.url");
                try {
                    URL uRL = new URL(string);
                    CacheViewer.this.showDocument(uRL);
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
        });
        jMenuItem = this._helpMenu.add(ResourceManager.getMessage((String)"jnlp.viewer.help.jnlp.mi"));
        jMenuItem.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.help.jnlp.mi.mnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Config.getProperty((String)"deployment.javaws.home.jnlp.url");
                try {
                    URL uRL = new URL(string);
                    CacheViewer.this.showDocument(uRL);
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
        });
        this._appMenu.addSeparator();
        jMenuItem = this._helpMenu.add(ResourceManager.getMessage((String)"jnlp.viewer.about.mi"));
        jMenuItem.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.about.mi.mnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.showAbout();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this._fileMenu);
        jMenuBar.add(this._editMenu);
        jMenuBar.add(this._appMenu);
        jMenuBar.add(this._viewMenu);
        jMenuBar.add(this._helpMenu);
        this.setJMenuBar(jMenuBar);
        this.resetSizes();
        this.refresh();
    }

    private void setFilter(int n) {
        String string;
        if (n == 0) {
            string = ResourceManager.getMessage((String)"jnlp.viewer.all");
        } else {
            MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage((String)"jnlp.viewer.type"));
            Object[] objectArray = new Object[]{ResourceManager.getMessage((String)("jnlp.viewer.view." + n))};
            string = messageFormat.format(objectArray);
        }
        this._titledBorder.setTitle(string);
        this.getSelectedTable().setFilter(n);
        this.getContentPane().repaint();
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(ResourceManager.getMessage((String)string));
        jButton.setMnemonic(ResourceManager.getVKCode((String)(string + ".mnemonic")));
        jButton.addActionListener(this);
        return jButton;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.refresh();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh();
        this.resetSizes();
    }

    private void resetSizes() {
        Component component = this._tabbedPane.getSelectedComponent();
        final boolean bl = !component.equals(this._userTab);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (CacheViewer.getStatus() == 0) {
                    CacheViewer.setStatus(5);
                }
                try {
                    long l = Cache.getCacheSize(bl);
                    if (l > 0L) {
                        _totalSize.setText(CacheViewer.this.getAppMessage("jnlp.viewer.totalSize", CacheViewer.tformat(l)));
                    } else if (l < 0L) {
                        String string = CacheViewer.this._tabbedPane.getTitleAt(CacheViewer.this._tabbedPane.getSelectedIndex());
                        _totalSize.setText(CacheViewer.this.getMessage("jnlp.viewer.noCache"));
                    } else {
                        String string = CacheViewer.this._tabbedPane.getTitleAt(CacheViewer.this._tabbedPane.getSelectedIndex());
                        _totalSize.setText(CacheViewer.this.getAppMessage("jnlp.viewer.emptyCache", string));
                    }
                }
                finally {
                    if (CacheViewer.getStatus() == 5) {
                        CacheViewer.setStatus(0);
                    }
                }
            }
        }).start();
    }

    private static String tformat(long l) {
        if (l > 10240L) {
            return "" + l / 1024L + " KB";
        }
        return "" + l / 1024L + "." + l % 1024L / 102L + " KB";
    }

    public void refresh() {
        Component component = this._tabbedPane.getSelectedComponent();
        boolean bl = !component.equals(this._userTab);
        CacheTable cacheTable = bl ? this._sysTable : this._userTable;
        int[] nArray = cacheTable.getSelectedRows();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = !bl && nArray.length > 0;
        String string = "";
        if (nArray.length == 1) {
            bl5 = true;
            CacheObject cacheObject = cacheTable.getCacheObject(nArray[0]);
            if (cacheObject != null) {
                LaunchDesc launchDesc = cacheObject.getLaunchDesc();
                string = cacheObject.getTypeString();
                InformationDesc informationDesc = launchDesc.getInformation();
                if (launchDesc.isApplication() || launchDesc.isApplet()) {
                    if (_isLocalInstallSupported) {
                        LocalApplicationProperties localApplicationProperties = cacheObject.getLocalApplicationProperties();
                        bl7 = localApplicationProperties.isLocallyInstalled();
                        boolean bl9 = bl4 = !bl && !localApplicationProperties.isLocallyInstalledSystem();
                    }
                    if (informationDesc.supportsOfflineOperation()) {
                        bl3 = true;
                    }
                    if (launchDesc.getLocation() != null) {
                        bl2 = true;
                    }
                }
                if (informationDesc.getHome() != null) {
                    bl6 = true;
                }
                this._removeBtn.setText(this.getAppMessage("jnlp.viewer.remove.1.btn", string));
            }
        } else if (nArray.length == 0) {
            this._removeBtn.setText(ResourceManager.getMessage((String)"jnlp.viewer.remove.btn"));
        } else {
            this._removeBtn.setText(ResourceManager.getMessage((String)"jnlp.viewer.remove.2.btn"));
        }
        this._launchOnlineBtn.setEnabled(bl2);
        this._launchOnlineMI.setEnabled(bl2);
        this._launchOnlineMI.setText(this.getMessage("jnlp.viewer.launch.online.mi"));
        this._launchOfflineBtn.setEnabled(bl3);
        this._launchOfflineMI.setEnabled(bl3);
        this._launchOfflineMI.setText(this.getMessage("jnlp.viewer.launch.offline.mi"));
        if (_isLocalInstallSupported) {
            this._installMI.setEnabled(bl4);
            if (bl7) {
                this._installMI.setText(this.getMessage("jnlp.viewer.uninstall.mi"));
                this._installMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.uninstall.mi.mnemonic"));
            } else {
                this._installMI.setText(this.getMessage("jnlp.viewer.install.mi"));
                this._installMI.setMnemonic(ResourceManager.getVKCode((String)"jnlp.viewer.install.mi.mnemonic"));
            }
        }
        this._showMI.setEnabled(bl5);
        this._showMI.setText(this.getMessage("jnlp.viewer.show.mi"));
        this._browseMI.setEnabled(bl6);
        this._browseMI.setText(this.getMessage("jnlp.viewer.browse.mi"));
        this._removeBtn.setEnabled(bl8);
        this._removeMI.setEnabled(bl8);
        if (nArray.length == 1) {
            this._removeMI.setText(this.getAppMessage("jnlp.viewer.remove.mi", string));
        } else {
            this._removeMI.setText(this.getMessage("jnlp.viewer.remove.0.mi"));
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage((String)string);
    }

    private String getAppMessage(String string, String string2) {
        MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage((String)string));
        Object[] objectArray = new Object[]{string2};
        return messageFormat.format(objectArray);
    }

    private CacheObject getSelectedCacheObject() {
        Component component = this._tabbedPane.getSelectedComponent();
        CacheTable cacheTable = component.equals(this._userTab) ? this._userTable : this._sysTable;
        int[] nArray = cacheTable.getSelectedRows();
        if (nArray.length == 1) {
            return cacheTable.getCacheObject(nArray[0]);
        }
        return null;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.exitViewer();
    }

    private void exitViewer() {
        this._sil.removeSingleInstanceListener((DeploySIListener)this);
        this.setVisible(false);
        this.dispose();
        Rectangle rectangle = this.getBounds();
        Config.setProperty((String)BOUNDS_PROPERTY_KEY, (String)("" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height));
        Config.storeIfDirty();
        Main.systemExit(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this._removeBtn) {
            this.removeApplications();
        } else if (jButton == this._launchOnlineBtn) {
            this.launchApplication(true);
        } else if (jButton == this._launchOfflineBtn) {
            this.launchApplication(false);
        }
    }

    private CacheTable getSelectedTable() {
        return this._tabbedPane.getSelectedComponent() == this._userTab ? this._userTable : this._sysTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchApplication(boolean bl) {
        if (CacheViewer.getStatus() != 2) {
            if (CacheViewer.getStatus() == 0) {
                CacheViewer.setStatus(2);
            }
            try {
                CacheObject cacheObject = this.getSelectedCacheObject();
                if (cacheObject != null) {
                    try {
                        File file = cacheObject.getJnlpFile();
                        String[] stringArray = new String[]{Config.getJavawsCommand(), bl ? "-online" : "-offline", file.getPath()};
                        Runtime.getRuntime().exec(stringArray);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CacheViewer.this.reset(CacheViewer.this._userTable);
                    }
                });
            }
            finally {
                if (CacheViewer.getStatus() == 2) {
                    CacheViewer.setStatus(0);
                }
            }
        }
    }

    public void launchApplication() {
        if (this._launchOnlineBtn.isEnabled()) {
            this.launchApplication(true);
        } else if (this._launchOfflineBtn.isEnabled()) {
            this.launchApplication(false);
        }
    }

    private void browseApplication() {
        LaunchDesc launchDesc;
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null && (launchDesc = cacheObject.getLaunchDesc()) != null) {
            URL uRL = launchDesc.getInformation().getHome();
            this.showDocument(uRL);
        }
    }

    private void showDocument(final URL uRL) {
        if (CacheViewer.getStatus() != 3) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (CacheViewer.getStatus() == 0) {
                        CacheViewer.setStatus(3);
                    }
                    try {
                        BrowserSupport.showDocument(uRL);
                    }
                    finally {
                        if (CacheViewer.getStatus() == 3) {
                            CacheViewer.setStatus(0);
                        }
                    }
                }
            }).start();
        }
    }

    private void showApplication() {
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null) {
            LaunchDesc launchDesc = cacheObject.getLaunchDesc();
            String string = launchDesc.toString();
            JTextArea jTextArea = new JTextArea(string, 24, 81);
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
            DialogFactory.showMessageDialog((Component)this, (int)2, (Object)jScrollPane, (String)this.getAppMessage("jnlp.viewer.show.title", launchDesc.getInformation().getTitle()), (boolean)false);
        }
    }

    private void showAbout() {
        new AboutDialog((JFrame)this, true).setVisible(true);
    }

    private void cleanCache() {
        if (CacheViewer.getStatus() == 0) {
            new Thread(new Runnable(){

                public void run() {
                    CacheViewer.setStatus(1);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                Cache.clean();
                                CacheViewer.this.reset(CacheViewer.this._userTable);
                            }
                            finally {
                                if (CacheViewer.getStatus() == 1) {
                                    CacheViewer.setStatus(0);
                                }
                            }
                        }
                    });
                }
            }).start();
        }
    }

    private void removeApplications() {
        if (CacheViewer.getStatus() == 0) {
            new Thread(new Runnable(){

                public void run() {
                    CacheViewer.setStatus(1);
                    Component component = CacheViewer.this._tabbedPane.getSelectedComponent();
                    boolean bl = !component.equals(CacheViewer.this._userTab);
                    CacheTable cacheTable = bl ? CacheViewer.this._sysTable : CacheViewer.this._userTable;
                    int[] nArray = cacheTable.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        CacheObject cacheObject = cacheTable.getCacheObject(nArray[i]);
                        Cache.remove(cacheObject.getDCE(), cacheObject.getLocalApplicationProperties(), cacheObject.getLaunchDesc());
                    }
                    Cache.clean();
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                CacheViewer.this.reset(CacheViewer.this._userTable);
                            }
                            finally {
                                if (CacheViewer.getStatus() == 1) {
                                    CacheViewer.setStatus(0);
                                }
                            }
                        }
                    });
                }
            }).start();
        }
    }

    public void popupApplicationMenu(Component component, int n, int n2) {
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Component[] componentArray = this._appMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)componentArray[i];
                    JMenuItem jMenuItem2 = jPopupMenu.add(new JMenuItem(jMenuItem.getText(), jMenuItem.getMnemonic()));
                    jMenuItem2.setEnabled(jMenuItem.isEnabled());
                    ActionListener[] actionListenerArray = jMenuItem.getActionListeners();
                    int n3 = 0;
                    while (n3 < actionListenerArray.length) {
                        jMenuItem2.addActionListener(actionListenerArray[n3++]);
                    }
                    continue;
                }
                jPopupMenu.addSeparator();
            }
            jPopupMenu.show(component, n, n2);
        }
    }

    private void integrateApplication() {
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null && _isLocalInstallSupported) {
            LocalApplicationProperties localApplicationProperties = cacheObject.getLocalApplicationProperties();
            Component component = this._tabbedPane.getSelectedComponent();
            boolean bl = !component.equals(this._userTab);
            CacheTable cacheTable = bl ? this._sysTable : this._userTable;
            new Thread(new Installer(cacheObject.getLaunchDesc(), localApplicationProperties, cacheTable)).start();
        }
    }

    public void reset(CacheTable cacheTable) {
        this.resetSizes();
        cacheTable.reset();
        this.refresh();
    }

    public static int getStatus() {
        return _status;
    }

    public static void setStatus(int n) {
        String string;
        _status = n;
        switch (n) {
            case 1: {
                string = ResourceManager.getMessage((String)"jnlp.viewer.removing");
                break;
            }
            case 2: {
                string = ResourceManager.getMessage((String)"jnlp.viewer.launching");
                break;
            }
            case 3: {
                string = ResourceManager.getMessage((String)"jnlp.viewer.browsing");
                break;
            }
            case 4: {
                string = ResourceManager.getMessage((String)"jnlp.viewer.sorting");
                break;
            }
            case 5: {
                string = ResourceManager.getMessage((String)"jnlp.viewer.searching");
                break;
            }
            case 6: {
                string = ResourceManager.getMessage((String)"jnlp.viewer.installing");
                break;
            }
            default: {
                string = "";
            }
        }
        if (n == 0) {
            _statusLabel.setText(string);
            _totalSize.setVisible(true);
        } else {
            _totalSize.setVisible(false);
            _statusLabel.setText(string);
        }
    }

    private void showReInstallDialog() {
        String string;
        Properties properties = Cache.getRemovedApps();
        Object object = this._userTable.getAllHrefs();
        boolean bl = false;
        for (int i = 0; i < ((String[])object).length; ++i) {
            if (properties.getProperty(object[i]) == null) continue;
            properties.remove(object[i]);
            bl = true;
        }
        if (bl) {
            Cache.setRemovedApps(properties);
        }
        object = new ArrayList();
        final ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ((ArrayList)object).add(string);
            arrayList.add(properties.getProperty(string));
        }
        string = ResourceManager.getMessage((String)"jnlp.viewer.reinstall.column.title");
        final String string2 = ResourceManager.getMessage((String)"jnlp.viewer.reinstall.column.location");
        AbstractTableModel abstractTableModel = new AbstractTableModel((ArrayList)object){
            private final /* synthetic */ ArrayList val$hrefs;
            {
                this.val$hrefs = arrayList2;
            }

            public String getColumnName(int n) {
                return n == 0 ? string : string2;
            }

            public Object getValueAt(int n, int n2) {
                return n2 == 0 ? arrayList.get(n) : this.val$hrefs.get(n);
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return this.val$hrefs.size();
            }

            public Class getColumnClass(int n) {
                return class$java$lang$String == null ? (class$java$lang$String = CacheViewer.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        String string3 = "jnlp.viewer.reinstallBtn";
        final JButton jButton = new JButton(ResourceManager.getMessage((String)string3));
        jButton.setMnemonic(ResourceManager.getVKCode((String)(string3 + ".mnemonic")));
        jButton.setEnabled(false);
        string3 = "jnlp.viewer.closeBtn";
        JButton jButton2 = new JButton(ResourceManager.getMessage((String)string3));
        jButton2.setMnemonic(ResourceManager.getVKCode((String)(string3 + ".mnemonic")));
        Object[] objectArray = new Object[]{jButton, jButton2};
        final JTable jTable = new JTable(abstractTableModel);
        jButton.addActionListener(new ActionListener((ArrayList)object){
            private final /* synthetic */ ArrayList val$hrefs;
            {
                this.val$hrefs = arrayList;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jTable.getSelectedRows();
                String[] stringArray = new String[nArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)this.val$hrefs.get(nArray[i]);
                }
                CacheViewer.this.do_reinstall(stringArray);
            }
        });
        jTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(440);
        jTable.setPreferredScrollableViewportSize(new Dimension(640, 180));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jButton.setEnabled(jTable.getSelectedRowCount() > 0);
            }
        });
        int n = DialogFactory.showOptionDialog((Component)this, (int)5, (Object)jScrollPane, (String)ResourceManager.getMessage((String)"jnlp.viewer.reinstall.title"), (Object[])objectArray, (Object)jButton2);
    }

    public void do_reinstall(final String[] stringArray) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (CacheViewer.getStatus() == 0) {
                    CacheViewer.setStatus(6);
                }
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        Main.importApp(stringArray[i]);
                        int n = 0;
                        while (Main.getLaunchThreadGroup().activeCount() > 8) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (++n <= 5) continue;
                        }
                        if (Main.getLaunchThreadGroup().activeCount() <= 8) continue;
                        Trace.println((String)("Warning: after waiting, still " + Main.getLaunchThreadGroup().activeCount() + " launching threads"));
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
                finally {
                    int n;
                    for (int i = 10; i > 0 && (n = Main.getLaunchThreadGroup().activeCount()) > 0; --i) {
                        try {
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (Exception exception) {}
                    }
                    if (Main.getLaunchThreadGroup().activeCount() > 0) {
                        Trace.println((String)("Warning: after waiting 20 sec., still " + Main.getLaunchThreadGroup().activeCount() + " launching threads"));
                    }
                    if (CacheViewer.getStatus() == 6) {
                        CacheViewer.setStatus(0);
                    }
                }
            }
        }).start();
    }

    public void newActivation(String[] stringArray) {
        this._userTable.setFilter(0);
        this._sysTable.setFilter(0);
        this.setExtendedState(this.getExtendedState() & 0xFFFFFFFE);
        this.toFront();
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        SplashScreen.hide();
        if (SingleInstanceManager.isServerRunning((String)JAVAWS_CV_ID) && SingleInstanceManager.connectToServer((String)"dummy")) {
            System.exit(0);
        }
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            if (Config.getBooleanProperty((String)"deployment.debug.console")) {
                JavawsConsoleController.showConsoleIfEnable();
            }
            final CacheViewer cacheViewer = new CacheViewer();
            String string = Config.getProperty((String)BOUNDS_PROPERTY_KEY);
            if (string != null) {
                int n;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int[] nArray = new int[4];
                for (n = 0; n < 4; ++n) {
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    String string2 = stringTokenizer.nextToken();
                    try {
                        nArray[n] = Integer.parseInt(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n == 4) {
                    cacheViewer.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
                }
            }
            cacheViewer.setVisible(true);
            long l = Cache.getLastAccessed(false);
            long l2 = Cache.getLastAccessed(true);
            while (true) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                long l3 = Cache.getLastAccessed(false);
                long l4 = Cache.getLastAccessed(true);
                if (l3 != l) {
                    if (cacheViewer.getStatus() == 0) {
                        l = l3;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                cacheViewer.reset(cacheViewer._userTable);
                            }
                        });
                    }
                }
                if (l4 == l2) continue;
                if (cacheViewer.getStatus() != 0) continue;
                l2 = l4;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        cacheViewer.reset(cacheViewer._sysTable);
                    }
                });
            }
        }
        finally {
            DeployUIManager.restoreLookAndFeel((LookAndFeel)lookAndFeel);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _totalSize = new JLabel();
        _lih = LocalInstallHandler.getInstance();
        _isLocalInstallSupported = _lih.isLocalInstallSupported();
        JAVAWS_CV_ID = "JNLP Cache Viewer" + Config.getInstance().getSessionSpecificString();
    }

    class Installer
    implements Runnable {
        private final LaunchDesc _ld;
        private final LocalApplicationProperties _lap;
        private final CacheTable _table;

        public Installer(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, CacheTable cacheTable) {
            this._ld = launchDesc;
            this._lap = localApplicationProperties;
            this._table = cacheTable;
        }

        public void run() {
            this._lap.refreshIfNecessary();
            if (this._lap.isLocallyInstalled()) {
                _lih.uninstall(this._ld, this._lap, true);
            } else {
                _lih.doInstall(this._ld, this._lap);
            }
            this._lap.setAskedForInstall(true);
            try {
                this._lap.store();
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            CacheViewer.this.refresh();
        }
    }
}

