/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;

public abstract class CalendarDate
implements Cloneable {
    public static final int FIELD_UNDEFINED = Integer.MIN_VALUE;
    public static final long TIME_UNDEFINED = Long.MIN_VALUE;
    private Era era;
    private int year;
    private int month;
    private int dayOfMonth;
    private int dayOfWeek = Integer.MIN_VALUE;
    private boolean leapYear;
    private int hours;
    private int minutes;
    private int seconds;
    private int millis;
    private long fraction;
    private boolean normalized;
    private TimeZone zoneinfo;
    private int zoneOffset;
    private int daylightSaving;
    private boolean forceStandardTime;
    private Locale locale;

    protected CalendarDate() {
        this(TimeZone.getDefault());
    }

    protected CalendarDate(TimeZone timeZone) {
        this.zoneinfo = timeZone;
    }

    public Era getEra() {
        return this.era;
    }

    public CalendarDate setEra(Era era) {
        if (this.era == era) {
            return this;
        }
        this.era = era;
        this.normalized = false;
        return this;
    }

    public int getYear() {
        return this.year;
    }

    public CalendarDate setYear(int n2) {
        if (this.year != n2) {
            this.year = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addYear(int n2) {
        if (n2 != 0) {
            this.year += n2;
            this.normalized = false;
        }
        return this;
    }

    public boolean isLeapYear() {
        return this.leapYear;
    }

    void setLeapYear(boolean bl2) {
        this.leapYear = bl2;
    }

    public int getMonth() {
        return this.month;
    }

    public CalendarDate setMonth(int n2) {
        if (this.month != n2) {
            this.month = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addMonth(int n2) {
        if (n2 != 0) {
            this.month += n2;
            this.normalized = false;
        }
        return this;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public CalendarDate setDayOfMonth(int n2) {
        if (this.dayOfMonth != n2) {
            this.dayOfMonth = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addDayOfMonth(int n2) {
        if (n2 != 0) {
            this.dayOfMonth += n2;
            this.normalized = false;
        }
        return this;
    }

    public int getDayOfWeek() {
        if (!this.isNormalized()) {
            this.dayOfWeek = Integer.MIN_VALUE;
        }
        return this.dayOfWeek;
    }

    public int getHours() {
        return this.hours;
    }

    public CalendarDate setHours(int n2) {
        if (this.hours != n2) {
            this.hours = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addHours(int n2) {
        if (n2 != 0) {
            this.hours += n2;
            this.normalized = false;
        }
        return this;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public CalendarDate setMinutes(int n2) {
        if (this.minutes != n2) {
            this.minutes = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addMinutes(int n2) {
        if (n2 != 0) {
            this.minutes += n2;
            this.normalized = false;
        }
        return this;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public CalendarDate setSeconds(int n2) {
        if (this.seconds != n2) {
            this.seconds = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addSeconds(int n2) {
        if (n2 != 0) {
            this.seconds += n2;
            this.normalized = false;
        }
        return this;
    }

    public int getMillis() {
        return this.millis;
    }

    public CalendarDate setMillis(int n2) {
        if (this.millis != n2) {
            this.millis = n2;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addMillis(int n2) {
        if (n2 != 0) {
            this.millis += n2;
            this.normalized = false;
        }
        return this;
    }

    public long getTimeOfDay() {
        if (!this.isNormalized()) {
            this.fraction = Long.MIN_VALUE;
            return Long.MIN_VALUE;
        }
        return this.fraction;
    }

    public CalendarDate setDate(int n2, int n3, int n4) {
        this.setYear(n2);
        this.setMonth(n3);
        this.setDayOfMonth(n4);
        return this;
    }

    public CalendarDate addDate(int n2, int n3, int n4) {
        this.addYear(n2);
        this.addMonth(n3);
        this.addDayOfMonth(n4);
        return this;
    }

    public CalendarDate setTimeOfDay(int n2, int n3, int n4, int n5) {
        this.setHours(n2);
        this.setMinutes(n3);
        this.setSeconds(n4);
        this.setMillis(n5);
        return this;
    }

    public CalendarDate addTimeOfDay(int n2, int n3, int n4, int n5) {
        this.addHours(n2);
        this.addMinutes(n3);
        this.addSeconds(n4);
        this.addMillis(n5);
        return this;
    }

    protected void setTimeOfDay(long l2) {
        this.fraction = l2;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public boolean isStandardTime() {
        return this.forceStandardTime;
    }

    public void setStandardTime(boolean bl2) {
        this.forceStandardTime = bl2;
    }

    public boolean isDaylightTime() {
        if (this.isStandardTime()) {
            return false;
        }
        return this.daylightSaving != 0;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getZone() {
        return this.zoneinfo;
    }

    public CalendarDate setZone(TimeZone timeZone) {
        this.zoneinfo = timeZone;
        return this;
    }

    public boolean isSameDate(CalendarDate calendarDate) {
        return this.getDayOfWeek() == calendarDate.getDayOfWeek() && this.getMonth() == calendarDate.getMonth() && this.getYear() == calendarDate.getYear() && this.getEra() == calendarDate.getEra();
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (!(object instanceof CalendarDate)) {
            return false;
        }
        CalendarDate calendarDate = (CalendarDate)object;
        if (this.isNormalized() != calendarDate.isNormalized()) {
            return false;
        }
        boolean bl3 = this.zoneinfo != null;
        boolean bl4 = bl2 = calendarDate.zoneinfo != null;
        if (bl3 != bl2) {
            return false;
        }
        if (bl3 && !this.zoneinfo.equals(calendarDate.zoneinfo)) {
            return false;
        }
        return this.getEra() == calendarDate.getEra() && this.year == calendarDate.year && this.month == calendarDate.month && this.dayOfMonth == calendarDate.dayOfMonth && this.hours == calendarDate.hours && this.minutes == calendarDate.minutes && this.seconds == calendarDate.seconds && this.millis == calendarDate.millis && this.zoneOffset == calendarDate.zoneOffset;
    }

    public int hashCode() {
        long l2 = ((((long)this.year - 1970L) * 12L + (long)(this.month - 1)) * 30L + (long)this.dayOfMonth) * 24L;
        l2 = (((l2 + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds) * 1000L + (long)this.millis;
        l2 -= (long)this.zoneOffset;
        int n2 = this.isNormalized() ? 1 : 0;
        int n3 = 0;
        Era era = this.getEra();
        if (era != null) {
            n3 = era.hashCode();
        }
        int n4 = this.zoneinfo != null ? this.zoneinfo.hashCode() : 0;
        return (int)l2 * (int)(l2 >> 32) ^ n3 ^ n2 ^ n4;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarUtils.sprintf0d(stringBuilder, this.year, 4).append('-');
        CalendarUtils.sprintf0d(stringBuilder, this.month, 2).append('-');
        CalendarUtils.sprintf0d(stringBuilder, this.dayOfMonth, 2).append('T');
        CalendarUtils.sprintf0d(stringBuilder, this.hours, 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, this.minutes, 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, this.seconds, 2).append('.');
        CalendarUtils.sprintf0d(stringBuilder, this.millis, 3);
        if (this.zoneOffset == 0) {
            stringBuilder.append('Z');
        } else if (this.zoneOffset != Integer.MIN_VALUE) {
            char c2;
            int n2;
            if (this.zoneOffset > 0) {
                n2 = this.zoneOffset;
                c2 = '+';
            } else {
                n2 = -this.zoneOffset;
                c2 = '-';
            }
            stringBuilder.append(c2);
            CalendarUtils.sprintf0d(stringBuilder, (n2 /= 60000) / 60, 2);
            CalendarUtils.sprintf0d(stringBuilder, n2 % 60, 2);
        } else {
            stringBuilder.append(" local time");
        }
        return stringBuilder.toString();
    }

    protected void setDayOfWeek(int n2) {
        this.dayOfWeek = n2;
    }

    protected void setNormalized(boolean bl2) {
        this.normalized = bl2;
    }

    public int getZoneOffset() {
        return this.zoneOffset;
    }

    protected void setZoneOffset(int n2) {
        this.zoneOffset = n2;
    }

    public int getDaylightSaving() {
        return this.daylightSaving;
    }

    protected void setDaylightSaving(int n2) {
        this.daylightSaving = n2;
    }
}

