/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateExtensions
implements CertAttrSet<Extension> {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private static final Debug debug = Debug.getInstance("x509");
    private Hashtable<String, Extension> map = new Hashtable();
    private boolean unsupportedCritExt = false;
    private List<Extension> unparseableExtensions;
    private static Class[] PARAMS = new Class[]{Boolean.class, Object.class};

    public CertificateExtensions() {
    }

    public CertificateExtensions(DerInputStream derInputStream) throws IOException {
        this.init(derInputStream);
    }

    private void init(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        for (int i2 = 0; i2 < derValueArray.length; ++i2) {
            Extension extension = new Extension(derValueArray[i2]);
            this.parseExtension(extension);
        }
    }

    private void parseExtension(Extension extension) throws IOException {
        try {
            Class clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) == null) {
                    return;
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            Constructor constructor = clazz.getConstructor(PARAMS);
            Object[] objectArray = new Object[]{extension.isCritical(), extension.getExtensionValue()};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), (Extension)((Object)certAttrSet)) != null) {
                throw new IOException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!extension.isCritical()) {
                if (this.unparseableExtensions == null) {
                    this.unparseableExtensions = new ArrayList<Extension>();
                }
                this.unparseableExtensions.add(extension);
                if (debug != null) {
                    debug.println("Error parsing extension: " + extension);
                    throwable.printStackTrace();
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.err.println(hexDumpEncoder.encodeBuffer(extension.getExtensionValue()));
                }
                return;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw (IOException)new IOException(throwable.toString()).initCause(throwable);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl2) throws CertificateException, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        Collection<Extension> collection = this.map.values();
        Object[] objectArray = collection.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof CertAttrSet) {
                ((CertAttrSet)objectArray[i2]).encode(derOutputStream2);
                continue;
            }
            if (objectArray[i2] instanceof Extension) {
                ((Extension)objectArray[i2]).encode(derOutputStream2);
                continue;
            }
            throw new CertificateException("Illegal extension object");
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        if (!bl2) {
            derOutputStream = new DerOutputStream();
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream3);
        } else {
            derOutputStream = derOutputStream3;
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Extension)) {
            throw new IOException("Unknown extension type.");
        }
        this.map.put(string, (Extension)object);
    }

    @Override
    public Object get(String string) throws IOException {
        Extension extension = this.map.get(string);
        if (extension == null) {
            throw new IOException("No extension found with name " + string);
        }
        return extension;
    }

    @Override
    public void delete(String string) throws IOException {
        Extension extension = this.map.get(string);
        if (extension == null) {
            throw new IOException("No extension found with name " + string);
        }
        this.map.remove(string);
    }

    @Override
    public Enumeration<Extension> getElements() {
        return this.map.elements();
    }

    public Collection<Extension> getAllExtensions() {
        return this.map.values();
    }

    public List getUnparseableExtensions() {
        if (this.unparseableExtensions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.unparseableExtensions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertificateExtensions)) {
            return false;
        }
        Collection<Extension> collection = ((CertificateExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Extension extension;
            if (objectArray[i2] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i2]).getName();
            }
            Extension extension2 = (Extension)objectArray[i2];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = this.map.get(string)) == null) {
                return false;
            }
            if (extension.equals(extension2)) continue;
            return false;
        }
        return ((Object)this.getUnparseableExtensions()).equals(((CertificateExtensions)object).getUnparseableExtensions());
    }

    public int hashCode() {
        return this.map.hashCode() + ((Object)this.getUnparseableExtensions()).hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }
}

