/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import sun.security.provider.DigestBase;

public final class SHA2
extends DigestBase {
    private static final int ITERATION = 64;
    private static final int[] ROUND_CONSTS = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private final int[] W;
    private final int[] state;
    private final byte[] bits;
    private final int[] intBits;

    public SHA2() {
        super("SHA-256", 32, 64);
        this.state = new int[8];
        this.W = new int[64];
        this.bits = new byte[8];
        this.intBits = new int[2];
        this.implReset();
    }

    private SHA2(SHA2 sHA2) {
        super(sHA2);
        this.state = (int[])sHA2.state.clone();
        this.W = new int[64];
        this.bits = new byte[8];
        this.intBits = new int[2];
    }

    public Object clone() {
        return new SHA2(this);
    }

    void implReset() {
        this.state[0] = 1779033703;
        this.state[1] = -1150833019;
        this.state[2] = 1013904242;
        this.state[3] = -1521486534;
        this.state[4] = 1359893119;
        this.state[5] = -1694144372;
        this.state[6] = 528734635;
        this.state[7] = 1541459225;
    }

    void implDigest(byte[] byArray, int n2) {
        long l2 = this.bytesProcessed << 3;
        int n3 = (int)this.bytesProcessed & 0x3F;
        int n4 = n3 < 56 ? 56 - n3 : 120 - n3;
        this.engineUpdate(padding, 0, n4);
        this.intBits[1] = (int)l2;
        this.intBits[0] = (int)(l2 >> 32);
        SHA2.i2bBig(this.intBits, 0, this.bits, 0, 8);
        this.engineUpdate(this.bits, 0, 8);
        SHA2.i2bBig(this.state, 0, byArray, n2, 32);
    }

    private static int lf_ch(int n2, int n3, int n4) {
        return n2 & n3 ^ ~n2 & n4;
    }

    private static int lf_maj(int n2, int n3, int n4) {
        return n2 & n3 ^ n2 & n4 ^ n3 & n4;
    }

    private static int lf_R(int n2, int n3) {
        return n2 >>> n3;
    }

    private static int lf_S(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private static int lf_sigma0(int n2) {
        return SHA2.lf_S(n2, 2) ^ SHA2.lf_S(n2, 13) ^ SHA2.lf_S(n2, 22);
    }

    private static int lf_sigma1(int n2) {
        return SHA2.lf_S(n2, 6) ^ SHA2.lf_S(n2, 11) ^ SHA2.lf_S(n2, 25);
    }

    private static int lf_delta0(int n2) {
        return SHA2.lf_S(n2, 7) ^ SHA2.lf_S(n2, 18) ^ SHA2.lf_R(n2, 3);
    }

    private static int lf_delta1(int n2) {
        return SHA2.lf_S(n2, 17) ^ SHA2.lf_S(n2, 19) ^ SHA2.lf_R(n2, 10);
    }

    void implCompress(byte[] byArray, int n2) {
        int n3;
        SHA2.b2iBig(byArray, n2, this.W, 0, 64);
        for (n3 = 16; n3 < 64; ++n3) {
            this.W[n3] = SHA2.lf_delta1(this.W[n3 - 2]) + this.W[n3 - 7] + SHA2.lf_delta0(this.W[n3 - 15]) + this.W[n3 - 16];
        }
        n3 = this.state[0];
        int n4 = this.state[1];
        int n5 = this.state[2];
        int n6 = this.state[3];
        int n7 = this.state[4];
        int n8 = this.state[5];
        int n9 = this.state[6];
        int n10 = this.state[7];
        for (int i2 = 0; i2 < 64; ++i2) {
            int n11 = n10 + SHA2.lf_sigma1(n7) + SHA2.lf_ch(n7, n8, n9) + ROUND_CONSTS[i2] + this.W[i2];
            int n12 = SHA2.lf_sigma0(n3) + SHA2.lf_maj(n3, n4, n5);
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6 + n11;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n11 + n12;
        }
        this.state[0] = this.state[0] + n3;
        this.state[1] = this.state[1] + n4;
        this.state[2] = this.state[2] + n5;
        this.state[3] = this.state[3] + n6;
        this.state[4] = this.state[4] + n7;
        this.state[5] = this.state[5] + n8;
        this.state[6] = this.state[6] + n9;
        this.state[7] = this.state[7] + n10;
    }
}

