/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Reflect;
import sun.nio.ch.SelectorProviderImpl;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

class InheritedChannel {
    private static final int UNKNOWN = -1;
    private static final int SOCK_STREAM = 1;
    private static final int SOCK_DGRAM = 2;
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    private static final int O_RDWR = 2;
    private static int devnull = -1;
    private static boolean haveChannel = false;
    private static Channel channel = null;

    InheritedChannel() {
    }

    private static void detachIOStreams() {
        try {
            InheritedChannel.dup2(devnull, 0);
            InheritedChannel.dup2(devnull, 1);
            InheritedChannel.dup2(devnull, 2);
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    private static void checkAccess(Channel channel) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("inheritedChannel"));
        }
    }

    private static Channel createChannel() throws IOException {
        AbstractSelectableChannel abstractSelectableChannel;
        int n2 = InheritedChannel.dup(0);
        int n3 = InheritedChannel.soType0(n2);
        if (n3 != 1 && n3 != 2) {
            InheritedChannel.close0(n2);
            return null;
        }
        Class[] classArray = new Class[]{Integer.TYPE};
        Constructor constructor = Reflect.lookupConstructor("java.io.FileDescriptor", classArray);
        Object[] objectArray = new Object[]{new Integer(n2)};
        FileDescriptor fileDescriptor = (FileDescriptor)Reflect.invoke(constructor, objectArray);
        SelectorProvider selectorProvider = SelectorProvider.provider();
        assert (selectorProvider instanceof SelectorProviderImpl);
        if (n3 == 1) {
            InetAddress inetAddress = InheritedChannel.peerAddress0(n2);
            if (inetAddress == null) {
                abstractSelectableChannel = new InheritedServerSocketChannelImpl(selectorProvider, fileDescriptor);
            } else {
                int n4 = InheritedChannel.peerPort0(n2);
                assert (n4 > 0);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n4);
                abstractSelectableChannel = new InheritedSocketChannelImpl(selectorProvider, fileDescriptor, inetSocketAddress);
            }
        } else {
            abstractSelectableChannel = new InheritedDatagramChannelImpl(selectorProvider, fileDescriptor);
        }
        return abstractSelectableChannel;
    }

    public static synchronized Channel getChannel() throws IOException {
        if (devnull < 0) {
            devnull = InheritedChannel.open0("/dev/null", 2);
        }
        if (!haveChannel) {
            channel = InheritedChannel.createChannel();
            haveChannel = true;
        }
        if (channel != null) {
            InheritedChannel.checkAccess(channel);
        }
        return channel;
    }

    private static native int dup(int var0) throws IOException;

    private static native void dup2(int var0, int var1) throws IOException;

    private static native int open0(String var0, int var1) throws IOException;

    private static native void close0(int var0) throws IOException;

    private static native int soType0(int var0);

    private static native InetAddress peerAddress0(int var0);

    private static native int peerPort0(int var0);

    static {
        Util.load();
    }

    public static class InheritedDatagramChannelImpl
    extends DatagramChannelImpl {
        InheritedDatagramChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) throws IOException {
            super(selectorProvider, fileDescriptor);
        }

        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }

    public static class InheritedServerSocketChannelImpl
    extends ServerSocketChannelImpl {
        InheritedServerSocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) throws IOException {
            super(selectorProvider, fileDescriptor);
        }

        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }

    public static class InheritedSocketChannelImpl
    extends SocketChannelImpl {
        InheritedSocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
            super(selectorProvider, fileDescriptor, inetSocketAddress);
        }

        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            InheritedChannel.detachIOStreams();
        }
    }
}

