/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcher;

class DevPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLPRI = 2;
    static final short POLLOUT = 4;
    static final short POLLRDNORM = 64;
    static final short POLLWRNORM = 4;
    static final short POLLRDBAND = 128;
    static final short POLLWRBAND = 256;
    static final short POLLNORM = 64;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 4;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    static final int NUM_POLLFDS = 8192;
    private long pollArrayAddress;
    private int MAX_UPDATE_SIZE = 10000;
    private LinkedList<Updator> updateList = new LinkedList();
    private AllocatedNativeObject pollArray;
    int wfd;
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    DevPollArrayWrapper() {
        int n2 = 65536;
        this.pollArray = new AllocatedNativeObject(n2, true);
        this.pollArrayAddress = this.pollArray.address();
        this.wfd = this.init();
        for (int i2 = 0; i2 < 8192; ++i2) {
            this.putDescriptor(i2, 0);
            this.putEventOps(i2, 0);
            this.putReventOps(i2, 0);
        }
    }

    void initInterrupt(int n2, int n3) {
        this.outgoingInterruptFD = n3;
        this.incomingInterruptFD = n2;
        this.register(this.wfd, n2, 1);
    }

    void putEventOps(int n2, int n3) {
        int n4 = 8 * n2 + 4;
        this.pollArray.putShort(n4, (short)n3);
    }

    void putReventOps(int n2, int n3) {
        int n4 = 8 * n2 + 6;
        this.pollArray.putShort(n4, (short)n3);
    }

    void putDescriptor(int n2, int n3) {
        int n4 = 8 * n2 + 0;
        this.pollArray.putInt(n4, n3);
    }

    int getEventOps(int n2) {
        int n3 = 8 * n2 + 4;
        return this.pollArray.getShort(n3);
    }

    int getReventOps(int n2) {
        int n3 = 8 * n2 + 6;
        return this.pollArray.getShort(n3);
    }

    int getDescriptor(int n2) {
        int n3 = 8 * n2 + 0;
        return this.pollArray.getInt(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n2, int n3) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(n2, n3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n2) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(n2, 2048));
        }
    }

    void closeDevPollFD() throws IOException {
        FileDispatcher.closeIntFD(this.wfd);
        this.pollArray.free();
    }

    int poll(long l2) {
        this.updateRegistrations();
        this.updated = this.poll0(this.pollArrayAddress, 8192, l2, this.wfd);
        for (int i2 = 0; i2 < this.updated; ++i2) {
            if (this.getDescriptor(i2) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i2;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        int n2;
        int n3 = this.updateList.size() * 2 * 8;
        n3 = n3 > (n2 = this.MAX_UPDATE_SIZE * 8) ? n2 : n3;
        AllocatedNativeObject allocatedNativeObject = new AllocatedNativeObject(n3, true);
        try {
            LinkedList<Updator> linkedList = this.updateList;
            synchronized (linkedList) {
                while (this.updateList.size() > 0) {
                    int n4 = 0;
                    Updator updator = null;
                    while ((updator = this.updateList.poll()) != null) {
                        this.putPollFD(allocatedNativeObject, n4, updator.fd, (short)2048);
                        ++n4;
                        if (updator.mask != 2048) {
                            this.putPollFD(allocatedNativeObject, n4, updator.fd, (short)updator.mask);
                            ++n4;
                        }
                        if (n4 <= this.MAX_UPDATE_SIZE - 2) continue;
                    }
                    this.registerMultiple(this.wfd, allocatedNativeObject.address(), n4);
                }
            }
        }
        finally {
            allocatedNativeObject.free();
        }
    }

    private void putPollFD(AllocatedNativeObject allocatedNativeObject, int n2, int n3, short s2) {
        int n4 = 8 * n2;
        allocatedNativeObject.putInt(n4 + 0, n3);
        allocatedNativeObject.putShort(n4 + 4, s2);
        allocatedNativeObject.putShort(n4 + 6, (short)0);
    }

    public void interrupt() {
        DevPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int init();

    private native void register(int var1, int var2, int var3);

    private native void registerMultiple(int var1, long var2, int var4);

    private native int poll0(long var1, int var3, long var4, int var6);

    private static native void interrupt(int var0);

    private static class Updator {
        int fd;
        int mask;

        Updator(int n2, int n3) {
            this.fd = n2;
            this.mask = n3;
        }
    }
}

