/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public class NetworkClient {
    protected Proxy proxy = Proxy.NO_PROXY;
    protected Socket serverSocket = null;
    public PrintStream serverOutput;
    public InputStream serverInput;
    protected static int defaultSoTimeout;
    protected static int defaultConnectTimeout;
    protected int readTimeout = -1;
    protected int connectTimeout = -1;
    protected static String encoding;

    private static boolean isASCIISuperset(String string) throws Exception {
        String string2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] byArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        byte[] byArray2 = string2.getBytes(string);
        return Arrays.equals(byArray2, byArray);
    }

    public void openServer(String string, int n2) throws IOException, UnknownHostException {
        if (this.serverSocket != null) {
            this.closeServer();
        }
        this.serverSocket = this.doConnect(string, n2);
        try {
            this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + "encoding not found");
        }
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    protected Socket doConnect(String string, int n2) throws IOException, UnknownHostException {
        Socket socket = this.proxy != null ? (this.proxy.type() == Proxy.Type.SOCKS ? (Socket)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Socket(NetworkClient.this.proxy);
            }
        }) : new Socket(Proxy.NO_PROXY)) : new Socket();
        if (this.connectTimeout >= 0) {
            socket.connect(new InetSocketAddress(string, n2), this.connectTimeout);
        } else if (defaultConnectTimeout > 0) {
            socket.connect(new InetSocketAddress(string, n2), defaultConnectTimeout);
        } else {
            socket.connect(new InetSocketAddress(string, n2));
        }
        if (this.readTimeout >= 0) {
            socket.setSoTimeout(this.readTimeout);
        } else if (defaultSoTimeout > 0) {
            socket.setSoTimeout(defaultSoTimeout);
        }
        return socket;
    }

    protected InetAddress getLocalAddress() throws IOException {
        if (this.serverSocket == null) {
            throw new IOException("not connected");
        }
        return this.serverSocket.getLocalAddress();
    }

    public void closeServer() throws IOException {
        if (!this.serverIsOpen()) {
            return;
        }
        this.serverSocket.close();
        this.serverSocket = null;
        this.serverInput = null;
        this.serverOutput = null;
    }

    public boolean serverIsOpen() {
        return this.serverSocket != null;
    }

    public NetworkClient(String string, int n2) throws IOException {
        this.openServer(string, n2);
    }

    public NetworkClient() {
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int n2) {
        if (this.serverSocket != null && n2 >= 0) {
            try {
                this.serverSocket.setSoTimeout(n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.readTimeout = n2;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    static {
        final int[] nArray = new int[]{0, 0};
        final String[] stringArray = new String[]{null};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nArray[0] = Integer.getInteger("sun.net.client.defaultReadTimeout", 0);
                nArray[1] = Integer.getInteger("sun.net.client.defaultConnectTimeout", 0);
                stringArray[0] = System.getProperty("file.encoding", "ISO8859_1");
                return null;
            }
        });
        defaultSoTimeout = nArray[0] == 0 ? -1 : nArray[0];
        defaultConnectTimeout = nArray[1] == 0 ? -1 : nArray[1];
        encoding = stringArray[0];
        try {
            if (!NetworkClient.isASCIISuperset(encoding)) {
                encoding = "ISO8859_1";
            }
        }
        catch (Exception exception) {
            encoding = "ISO8859_1";
        }
    }
}

