/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.font.GlyphVector;
import sun.font.StandardGlyphVector;
import sun.font.StrikeCache;
import sun.java2d.loops.FontInfo;

public final class GlyphList {
    private static final int MINGRAYLENGTH = 1024;
    private static final int MAXGRAYLENGTH = 8192;
    private static final int DEFAULT_LENGTH = 32;
    int glyphindex;
    int[] metrics;
    byte[] graybits;
    Object strikelist;
    int len = 0;
    int maxLen = 0;
    int maxPosLen = 0;
    int[] glyphData;
    char[] chData;
    long[] images;
    float[] positions;
    float x;
    float y;
    float gposx;
    float gposy;
    boolean usePositions;
    private static GlyphList reusableGL = new GlyphList();
    private static boolean inUse;

    void ensureCapacity(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.usePositions && n2 > this.maxPosLen) {
            this.positions = new float[n2 * 2 + 2];
            this.maxPosLen = n2;
        }
        if (this.maxLen == 0 || n2 > this.maxLen) {
            this.glyphData = new int[n2];
            this.chData = new char[n2];
            this.images = new long[n2];
            this.maxLen = n2;
        }
    }

    private GlyphList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphList getInstance() {
        if (inUse) {
            return new GlyphList();
        }
        Class<GlyphList> clazz = GlyphList.class;
        synchronized (GlyphList.class) {
            if (inUse) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new GlyphList();
            }
            inUse = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return reusableGL;
        }
    }

    public boolean setFromString(FontInfo fontInfo, String string, float f2, float f3) {
        this.x = f2;
        this.y = f3;
        this.len = string.length();
        this.ensureCapacity(this.len);
        string.getChars(0, this.len, this.chData, 0);
        return this.mapChars(fontInfo, this.len);
    }

    public boolean setFromChars(FontInfo fontInfo, char[] cArray, int n2, int n3, float f2, float f3) {
        this.x = f2;
        this.y = f3;
        this.len = n3;
        this.len = n3 < 0 ? 0 : n3;
        this.ensureCapacity(this.len);
        System.arraycopy(cArray, n2, this.chData, 0, this.len);
        return this.mapChars(fontInfo, this.len);
    }

    private final boolean mapChars(FontInfo fontInfo, int n2) {
        if (fontInfo.font2D.getMapper().charsToGlyphsNS(n2, this.chData, this.glyphData)) {
            return false;
        }
        fontInfo.fontStrike.getGlyphImagePtrs(this.glyphData, this.images, n2);
        this.glyphindex = -1;
        return true;
    }

    public void setFromGlyphVector(FontInfo fontInfo, GlyphVector glyphVector, float f2, float f3) {
        this.x = f2;
        this.y = f3;
        StandardGlyphVector standardGlyphVector = StandardGlyphVector.getStandardGV(glyphVector);
        this.usePositions = standardGlyphVector.needsPositions(fontInfo.devTx);
        this.len = standardGlyphVector.getNumGlyphs();
        this.ensureCapacity(this.len);
        this.strikelist = standardGlyphVector.setupGlyphImages(this.images, this.usePositions ? this.positions : null, fontInfo.devTx);
        this.glyphindex = -1;
    }

    public int[] getBounds() {
        if (this.glyphindex >= 0) {
            throw new InternalError("calling getBounds after setGlyphIndex");
        }
        if (this.metrics == null) {
            this.metrics = new int[4];
        }
        this.gposx = this.x + 0.5f;
        this.gposy = this.y + 0.5f;
        this.fillBounds(this.metrics);
        return this.metrics;
    }

    public void setGlyphIndex(int n2) {
        this.glyphindex = n2;
        float f2 = StrikeCache.unsafe.getFloat(this.images[n2] + (long)StrikeCache.topLeftXOffset);
        float f3 = StrikeCache.unsafe.getFloat(this.images[n2] + (long)StrikeCache.topLeftYOffset);
        if (this.usePositions) {
            this.metrics[0] = (int)Math.floor(this.positions[n2 << 1] + this.gposx + f2);
            this.metrics[1] = (int)Math.floor(this.positions[(n2 << 1) + 1] + this.gposy + f3);
        } else {
            this.metrics[0] = (int)Math.floor(this.gposx + f2);
            this.metrics[1] = (int)Math.floor(this.gposy + f3);
            this.gposx += StrikeCache.unsafe.getFloat(this.images[n2] + (long)StrikeCache.xAdvanceOffset);
            this.gposy += StrikeCache.unsafe.getFloat(this.images[n2] + (long)StrikeCache.yAdvanceOffset);
        }
        this.metrics[2] = StrikeCache.unsafe.getChar(this.images[n2] + (long)StrikeCache.widthOffset);
        this.metrics[3] = StrikeCache.unsafe.getChar(this.images[n2] + (long)StrikeCache.heightOffset);
    }

    public int[] getMetrics() {
        return this.metrics;
    }

    public byte[] getGrayBits() {
        int n2 = this.metrics[2] * this.metrics[3];
        if (this.graybits == null) {
            this.graybits = new byte[Math.max(n2, 1024)];
        } else if (n2 > this.graybits.length) {
            this.graybits = new byte[n2];
        }
        long l2 = StrikeCache.nativeAddressSize == 4 ? (long)(0xFFFFFFFF & StrikeCache.unsafe.getInt(this.images[this.glyphindex] + (long)StrikeCache.pixelDataOffset)) : StrikeCache.unsafe.getLong(this.images[this.glyphindex] + (long)StrikeCache.pixelDataOffset);
        if (l2 == 0L) {
            return this.graybits;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.graybits[i2] = StrikeCache.unsafe.getByte(l2 + (long)i2);
        }
        return this.graybits;
    }

    public void dispose() {
        if (this == reusableGL) {
            if (this.graybits != null && this.graybits.length > 8192) {
                this.graybits = null;
            }
            this.usePositions = false;
            this.strikelist = null;
            inUse = false;
        }
    }

    public int getNumGlyphs() {
        return this.len;
    }

    private void fillBounds(int[] nArray) {
        int n2 = StrikeCache.topLeftXOffset;
        int n3 = StrikeCache.topLeftYOffset;
        int n4 = StrikeCache.widthOffset;
        int n5 = StrikeCache.heightOffset;
        int n6 = StrikeCache.xAdvanceOffset;
        int n7 = StrikeCache.yAdvanceOffset;
        if (this.len == 0) {
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
            return;
        }
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        int n8 = 0;
        float f6 = this.x + 0.5f;
        float f7 = this.y + 0.5f;
        for (int i2 = 0; i2 < this.len; ++i2) {
            float f8;
            float f9;
            float f10 = StrikeCache.unsafe.getFloat(this.images[i2] + (long)n2);
            float f11 = StrikeCache.unsafe.getFloat(this.images[i2] + (long)n3);
            char c2 = StrikeCache.unsafe.getChar(this.images[i2] + (long)n4);
            char c3 = StrikeCache.unsafe.getChar(this.images[i2] + (long)n5);
            if (this.usePositions) {
                f9 = this.positions[n8++] + f10 + f6;
                f8 = this.positions[n8++] + f11 + f7;
            } else {
                f9 = f6 + f10;
                f8 = f7 + f11;
                f6 += StrikeCache.unsafe.getFloat(this.images[i2] + (long)n6);
                f7 += StrikeCache.unsafe.getFloat(this.images[i2] + (long)n7);
            }
            float f12 = f9 + (float)c2;
            float f13 = f8 + (float)c3;
            if (f3 > f9) {
                f3 = f9;
            }
            if (f2 > f8) {
                f2 = f8;
            }
            if (f5 < f12) {
                f5 = f12;
            }
            if (!(f4 < f13)) continue;
            f4 = f13;
        }
        nArray[0] = (int)Math.floor(f3);
        nArray[1] = (int)Math.floor(f2);
        nArray[2] = (int)Math.floor(f5);
        nArray[3] = (int)Math.floor(f4);
    }
}

