/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.FontStrikeDesc;
import sun.font.FontStrikeDisposer;
import sun.font.NativeStrike;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;
import sun.font.TrueTypeFont;

public class FileFontStrike
extends PhysicalStrike {
    static final int INVISIBLE_GLYPHS = 65534;
    private FileFont fileFont;
    protected float[] horizontalAdvances;
    HashMap boundsMap;
    SoftReference glyphMetricsMapRef;
    AffineTransform invertDevTx;
    boolean useNatives;
    NativeStrike[] nativeStrikes;
    private static final int SLOTZEROMAX = 0xFFFFFF;

    FileFontStrike(FileFont fileFont, FontStrikeDesc fontStrikeDesc) {
        super(fileFont, fontStrikeDesc);
        int n2;
        this.fileFont = fileFont;
        if (fontStrikeDesc.style != fileFont.style) {
            if ((fontStrikeDesc.style & 2) == 2 && (fileFont.style & 2) == 0) {
                this.algoStyle = true;
                this.italic = 0.7f;
            }
            if ((fontStrikeDesc.style & 1) == 1 && (fileFont.style & 1) == 0) {
                this.algoStyle = true;
                this.boldness = 1.33f;
            }
        }
        double[] dArray = new double[4];
        AffineTransform affineTransform = fontStrikeDesc.glyphTx;
        affineTransform.getMatrix(dArray);
        if (!fontStrikeDesc.devTx.isIdentity() && fontStrikeDesc.devTx.getType() != 1) {
            try {
                this.invertDevTx = fontStrikeDesc.devTx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        this.pScalerContext = this.createScalerContext(fileFont.getScaler(), dArray, fileFont instanceof TrueTypeFont, fontStrikeDesc.aaHint, fontStrikeDesc.fmHint, this.algoStyle, this.boldness, this.italic);
        this.mapper = fileFont.getMapper();
        int n3 = this.mapper.getNumGlyphs();
        if (this.pScalerContext == 0L) {
            if (FontManager.longAddresses) {
                this.longGlyphImages = new long[n3];
            } else {
                this.intGlyphImages = new int[n3];
            }
            this.pScalerContext = FileFontStrike.getNullScalerContext(fileFont.getNullScaler());
            FontManager.deRegisterBadFont(fileFont);
            return;
        }
        if (fileFont.useNatives && !fontStrikeDesc.aaHint && !this.algoStyle && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[0] >= 6.0 && dArray[0] <= 36.0 && dArray[0] == dArray[3]) {
            this.useNatives = true;
            n2 = fileFont.nativeFonts.length;
            this.nativeStrikes = new NativeStrike[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.nativeStrikes[i2] = new NativeStrike(fileFont.nativeFonts[i2], fontStrikeDesc, false);
            }
        }
        this.disposer = new FontStrikeDisposer(fileFont, fontStrikeDesc, this.pScalerContext);
        boolean bl2 = this.getImageWithAdvance = this.useNatives || affineTransform.getScaleY() < 20.0 && (affineTransform.getType() & 0x7C) == 0;
        if (this.getImageWithAdvance && n3 < 1000) {
            this.horizontalAdvances = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.horizontalAdvances[n2] = Float.MAX_VALUE;
            }
        }
    }

    private boolean usingIntGlyphImages() {
        if (this.intGlyphImages != null) {
            return true;
        }
        if (FontManager.longAddresses) {
            return false;
        }
        this.intGlyphImages = new int[this.mapper.getNumGlyphs()];
        this.disposer.intGlyphImages = this.intGlyphImages;
        return true;
    }

    private long[] getLongGlyphImages() {
        if (this.longGlyphImages == null && FontManager.longAddresses) {
            this.longGlyphImages = new long[this.mapper.getNumGlyphs()];
            this.disposer.longGlyphImages = this.longGlyphImages;
        }
        return this.longGlyphImages;
    }

    static synchronized native long getNullScalerContext(long var0);

    private native long createScalerContext(long var1, double[] var3, boolean var4, boolean var5, boolean var6, boolean var7, float var8, float var9);

    public int getNumGlyphs() {
        return this.fileFont.getNumGlyphs();
    }

    long getGlyphImageFromNative(int n2) {
        char c2 = this.fileFont.glyphToCharMap[n2];
        for (int i2 = 0; i2 < this.nativeStrikes.length; ++i2) {
            long l2;
            CharToGlyphMapper charToGlyphMapper = this.fileFont.nativeFonts[i2].getMapper();
            int n3 = charToGlyphMapper.charToGlyph(c2) & 0xFFFF;
            if (n3 == charToGlyphMapper.getMissingGlyphCode() || (l2 = this.nativeStrikes[i2].getGlyphImagePtrNoCache(n3)) == 0L) continue;
            return l2;
        }
        return this.fileFont.getGlyphImage(this.pScalerContext, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getGlyphImagePtr(int n2) {
        if (n2 >= 65534) {
            return StrikeCache.invisibleGlyphPtr;
        }
        if (this.usingIntGlyphImages()) {
            long l2 = (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
            if (l2 != 0L) {
                return l2;
            }
            l2 = this.useNatives ? this.getGlyphImageFromNative(n2) : this.fileFont.getGlyphImage(this.pScalerContext, n2);
            FileFontStrike fileFontStrike = this;
            synchronized (fileFontStrike) {
                if (this.intGlyphImages[n2] == 0) {
                    this.intGlyphImages[n2] = (int)l2;
                    return l2;
                }
                StrikeCache.freeIntPointer((int)l2);
                return (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
            }
        }
        long l3 = this.getLongGlyphImages()[n2];
        if (l3 != 0L) {
            return l3;
        }
        l3 = this.useNatives ? this.getGlyphImageFromNative(n2) : this.fileFont.getGlyphImage(this.pScalerContext, n2);
        FileFontStrike fileFontStrike = this;
        synchronized (fileFontStrike) {
            if (this.longGlyphImages[n2] == 0L) {
                this.longGlyphImages[n2] = l3;
                return l3;
            }
            StrikeCache.freeLongPointer(l3);
            return this.longGlyphImages[n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n2) {
        if (this.usingIntGlyphImages()) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                if (n3 >= 65534) {
                    lArray[i2] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i2] = (long)this.intGlyphImages[n3] & 0xFFFFFFFFL;
                if (lArray[i2] != 0L) continue;
                long l2 = this.useNatives ? this.getGlyphImageFromNative(n3) : this.fileFont.getGlyphImage(this.pScalerContext, n3);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (this.intGlyphImages[n3] == 0) {
                        this.intGlyphImages[n3] = (int)l2;
                        lArray[i2] = l2;
                    } else {
                        StrikeCache.freeIntPointer((int)l2);
                        lArray[i2] = (long)this.intGlyphImages[n3] & 0xFFFFFFFFL;
                    }
                    continue;
                }
            }
        } else {
            long[] lArray2 = this.getLongGlyphImages();
            for (int i3 = 0; i3 < n2; ++i3) {
                int n4 = nArray[i3];
                if (n4 >= 65534) {
                    lArray[i3] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i3] = lArray2[n4];
                if (lArray[i3] != 0L) continue;
                long l3 = this.useNatives ? this.getGlyphImageFromNative(n4) : this.fileFont.getGlyphImage(this.pScalerContext, n4);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (lArray2[n4] == 0L) {
                        lArray2[n4] = l3;
                        lArray[i3] = l3;
                    } else {
                        StrikeCache.freeLongPointer(l3);
                        lArray[i3] = lArray2[n4];
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSlot0GlyphImagePtrs(int[] nArray, long[] lArray, int n2) {
        int n3 = 0;
        if (this.usingIntGlyphImages()) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = nArray[i2];
                if (n4 >= 0xFFFFFF) {
                    return n3;
                }
                ++n3;
                if (n4 >= 65534) {
                    lArray[i2] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i2] = (long)this.intGlyphImages[n4] & 0xFFFFFFFFL;
                if (lArray[i2] != 0L) continue;
                long l2 = this.useNatives ? this.getGlyphImageFromNative(n4) : this.fileFont.getGlyphImage(this.pScalerContext, n4);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (this.intGlyphImages[n4] == 0) {
                        this.intGlyphImages[n4] = (int)l2;
                        lArray[i2] = l2;
                    } else {
                        StrikeCache.freeIntPointer((int)l2);
                        lArray[i2] = (long)this.intGlyphImages[n4] & 0xFFFFFFFFL;
                    }
                    continue;
                }
            }
        } else {
            long[] lArray2 = this.getLongGlyphImages();
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = nArray[i3];
                if (n5 >= 0xFFFFFF) {
                    return n3;
                }
                ++n3;
                if (n5 >= 65534) {
                    lArray[i3] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i3] = lArray2[n5];
                if (lArray[i3] != 0L) continue;
                long l3 = this.fileFont.getGlyphImage(this.pScalerContext, n5);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (lArray2[n5] == 0L) {
                        lArray2[n5] = l3;
                        lArray[i3] = l3;
                    } else {
                        StrikeCache.freeLongPointer(l3);
                        lArray[i3] = lArray2[n5];
                    }
                    continue;
                }
            }
        }
        return n3;
    }

    long getCachedGlyphPtr(int n2) {
        if (this.intGlyphImages != null) {
            return (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
        }
        if (this.longGlyphImages != null) {
            return this.longGlyphImages[n2];
        }
        return 0L;
    }

    float getGlyphAdvance(int n2) {
        float f2;
        if (n2 >= 65534) {
            return 0.0f;
        }
        if (this.horizontalAdvances != null && (f2 = this.horizontalAdvances[n2]) != Float.MAX_VALUE) {
            return f2;
        }
        if (this.invertDevTx != null) {
            f2 = this.getGlyphMetrics((int)n2).x;
        } else {
            long l2 = this.getImageWithAdvance ? this.getGlyphImagePtr(n2) : this.getCachedGlyphPtr(n2);
            f2 = l2 != 0L ? StrikeCache.unsafe.getFloat(l2 + (long)StrikeCache.xAdvanceOffset) : this.fileFont.getGlyphAdvance(this.pScalerContext, n2);
        }
        if (this.horizontalAdvances != null) {
            this.horizontalAdvances[n2] = f2;
        }
        return f2;
    }

    float getCodePointAdvance(int n2) {
        return this.getGlyphAdvance(this.mapper.charToGlyph(n2));
    }

    void getGlyphImageBounds(int n2, Point2D.Float float_, Rectangle rectangle) {
        long l2 = this.getGlyphImagePtr(n2);
        float f2 = StrikeCache.unsafe.getFloat(l2 + (long)StrikeCache.topLeftXOffset);
        float f3 = StrikeCache.unsafe.getFloat(l2 + (long)StrikeCache.topLeftYOffset);
        rectangle.x = (int)Math.floor(float_.x + f2);
        rectangle.y = (int)Math.floor(float_.y + f3);
        rectangle.width = StrikeCache.unsafe.getShort(l2 + (long)StrikeCache.widthOffset) & 0xFFFF;
        rectangle.height = StrikeCache.unsafe.getShort(l2 + (long)StrikeCache.heightOffset) & 0xFFFF;
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.fileFont.getFontMetrics(this.pScalerContext);
            if (this.invertDevTx != null) {
                this.strikeMetrics.convertToUserSpace(this.invertDevTx);
            }
        }
        return this.strikeMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point2D.Float getGlyphMetrics(int n2) {
        Point2D.Float float_ = new Point2D.Float();
        if (n2 >= 65534) {
            return float_;
        }
        long l2 = this.getImageWithAdvance ? this.getGlyphImagePtr(n2) : this.getCachedGlyphPtr(n2);
        if (l2 != 0L) {
            float_ = new Point2D.Float();
            float_.x = StrikeCache.unsafe.getFloat(l2 + (long)StrikeCache.xAdvanceOffset);
            float_.y = StrikeCache.unsafe.getFloat(l2 + (long)StrikeCache.yAdvanceOffset);
            if (this.invertDevTx != null) {
                this.invertDevTx.deltaTransform(float_, float_);
            }
        } else {
            FileFontStrike fileFontStrike;
            Integer n3 = new Integer(n2);
            Point2D.Float float_2 = null;
            HashMap<Integer, Point2D.Float> hashMap = null;
            if (this.glyphMetricsMapRef != null) {
                hashMap = (HashMap<Integer, Point2D.Float>)this.glyphMetricsMapRef.get();
            }
            if (hashMap != null) {
                fileFontStrike = this;
                synchronized (fileFontStrike) {
                    float_2 = (Point2D.Float)hashMap.get(n3);
                    if (float_2 != null) {
                        float_.x = float_2.x;
                        float_.y = float_2.y;
                        return float_;
                    }
                }
            }
            if (float_2 == null) {
                this.fileFont.getGlyphMetrics(this.pScalerContext, n2, float_);
                if (this.invertDevTx != null) {
                    this.invertDevTx.deltaTransform(float_, float_);
                }
                float_2 = new Point2D.Float(float_.x, float_.y);
                fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, Point2D.Float>();
                        this.glyphMetricsMapRef = new SoftReference(hashMap);
                    }
                    hashMap.put(n3, float_2);
                }
            }
        }
        return float_;
    }

    Point2D.Float getCharMetrics(char c2) {
        return this.getGlyphMetrics(this.mapper.charToGlyph(c2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle2D.Float getGlyphOutlineBounds(int n2) {
        Rectangle2D.Float float_;
        Object object;
        Integer n3 = new Integer(n2);
        if (this.boundsMap == null) {
            object = this;
            synchronized (object) {
                if (this.boundsMap == null) {
                    this.boundsMap = new HashMap();
                }
            }
        }
        object = this.boundsMap;
        synchronized (object) {
            float_ = (Rectangle2D.Float)this.boundsMap.get(n3);
        }
        if (float_ == null) {
            float_ = this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n2);
            object = this.boundsMap;
            synchronized (object) {
                this.boundsMap.put(n3, float_);
            }
        }
        return float_;
    }

    public Rectangle2D getOutlineBounds(int n2) {
        return this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n2);
    }

    GeneralPath getGlyphOutline(int n2, float f2, float f3) {
        return this.fileFont.getGlyphOutline(this.pScalerContext, n2, f2, f3);
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f2, float f3) {
        return this.fileFont.getGlyphVectorOutline(this.pScalerContext, nArray, nArray.length, f2, f3);
    }

    protected void adjustPoint(Point2D.Float float_) {
        if (this.invertDevTx != null) {
            this.invertDevTx.deltaTransform(float_, float_);
        }
    }
}

