/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XException;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;

final class XDropTargetRegistry {
    private static final long DELAYED_REGISTRATION_PERIOD = 200L;
    private static final XDropTargetRegistry theInstance = new XDropTargetRegistry();
    private final HashMap<Long, Runnable> delayedRegistrationMap = new HashMap();
    private final HashMap embeddedDropSiteRegistry = new HashMap();

    private XDropTargetRegistry() {
    }

    static XDropTargetRegistry getRegistry() {
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long l2) {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        do {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, XWM.XA_WM_STATE, 0L, 0L, false, 0L);
            try {
                windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                    l3 = l2;
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
            XQueryTree xQueryTree = new XQueryTree(l2);
            try {
                if (xQueryTree.execute() == 0) {
                    long l6 = 0L;
                    return l6;
                }
                l4 = xQueryTree.get_root();
                l5 = xQueryTree.get_parent();
            }
            finally {
                xQueryTree.dispose();
            }
        } while ((l2 = l5) != l4);
        return l3;
    }

    static final long getDnDProxyWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedDropSiteEntry registerEmbedderDropSite(long l2) {
        XDropTargetProtocol xDropTargetProtocol;
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        long l3 = XDropTargetRegistry.getDnDProxyWindow();
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        ArrayList<XDropTargetProtocol> arrayList = new ArrayList<XDropTargetProtocol>();
        while (iterator.hasNext()) {
            xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
            if (!xDropTargetProtocol.isProtocolSupported(l2)) continue;
            arrayList.add(xDropTargetProtocol);
        }
        iterator = !arrayList.isEmpty() ? arrayList.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.registerEmbedderDropSite(l2);
            }
            long l4 = 0L;
            long l5 = 0L;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                int n2 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes.pData);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (n2 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XGetWindowAttributes failed");
                }
                l5 = xWindowAttributes.get_your_event_mask();
                l4 = xWindowAttributes.get_root();
            }
            finally {
                xWindowAttributes.dispose();
            }
            if ((l5 & 0x400000L) == 0L) {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l2, l5 | 0x400000L);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
            EmbeddedDropSiteEntry embeddedDropSiteEntry = new EmbeddedDropSiteEntry(l4, l5);
            return embeddedDropSiteEntry;
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbedderDropSite(long l2) {
        XDropTargetProtocol xDropTargetProtocol;
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        Long l3 = new Long(l2);
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.embeddedDropSiteRegistry.get(l3) == null) {
                return;
            }
        }
        iterator = XDragAndDropProtocols.getDropTargetProtocols();
        ArrayList<XDropTargetProtocol> arrayList = new ArrayList<XDropTargetProtocol>();
        while (iterator.hasNext()) {
            xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
            if (!xDropTargetProtocol.isProtocolSupported(l2)) continue;
            arrayList.add(xDropTargetProtocol);
        }
        iterator = !arrayList.isEmpty() ? arrayList.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.registerEmbedderDropSite(l2);
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbedderDropSite(long l2, EmbeddedDropSiteEntry embeddedDropSiteEntry) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.unregisterEmbedderDropSite(l2);
            }
            long l3 = embeddedDropSiteEntry.getEventMask();
            if ((l3 & 0x400000L) == 0L) {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l2, l3);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmbeddedDropSite(long l2, long l3) {
        Long l4 = new Long(l2);
        EmbeddedDropSiteEntry embeddedDropSiteEntry = null;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            embeddedDropSiteEntry = (EmbeddedDropSiteEntry)this.embeddedDropSiteRegistry.get(l4);
            if (embeddedDropSiteEntry == null) {
                embeddedDropSiteEntry = this.registerEmbedderDropSite(l2);
                this.embeddedDropSiteRegistry.put(l4, embeddedDropSiteEntry);
            }
        }
        assert (embeddedDropSiteEntry != null);
        embeddedDropSiteEntry.addSite(l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbeddedDropSite(long l2, long l3) {
        Long l4 = new Long(l2);
        EmbeddedDropSiteEntry embeddedDropSiteEntry = null;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            embeddedDropSiteEntry = (EmbeddedDropSiteEntry)this.embeddedDropSiteRegistry.get(l4);
            assert (embeddedDropSiteEntry != null);
            embeddedDropSiteEntry.removeSite(l3);
            if (!embeddedDropSiteEntry.hasSites()) {
                this.embeddedDropSiteRegistry.remove(l4);
                this.unregisterEmbedderDropSite(l2, embeddedDropSiteEntry);
            }
        }
    }

    public long getEmbeddedDropSite(long l2, int n2, int n3) {
        Long l3 = new Long(l2);
        EmbeddedDropSiteEntry embeddedDropSiteEntry = (EmbeddedDropSiteEntry)this.embeddedDropSiteRegistry.get(l3);
        if (embeddedDropSiteEntry == null) {
            return 0L;
        }
        return embeddedDropSiteEntry.getSite(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDropSite(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException();
        }
        XDropTargetEventProcessor.activate();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l3 = this.getToplevelWindow(l2);
            if (l3 == 0L) {
                this.addDelayedRegistrationEntry(l2);
                return;
            }
            if (l3 == l2) {
                Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
                while (iterator.hasNext()) {
                    XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                    xDropTargetProtocol.registerDropTarget(l3);
                }
            } else {
                this.registerEmbeddedDropSite(l3, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDropSite(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException();
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            this.removeDelayedRegistrationEntry(l2);
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol = (XDropTargetProtocol)iterator.next();
                xDropTargetProtocol.unregisterDropTarget(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelayedRegistrationEntry(final long l2) {
        Long l3 = new Long(l2);
        Runnable runnable = new Runnable(){

            public void run() {
                XDropTargetRegistry.this.removeDelayedRegistrationEntry(l2);
                XDropTargetRegistry.this.registerDropSite(l2);
            }
        };
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            this.removeDelayedRegistrationEntry(l2);
            this.delayedRegistrationMap.put(l3, runnable);
            XToolkit.schedule(runnable, 200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDelayedRegistrationEntry(long l2) {
        Long l3 = new Long(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Runnable runnable = this.delayedRegistrationMap.remove(l3);
            if (runnable != null) {
                XToolkit.remove(runnable);
            }
        }
    }

    private static final class EmbeddedDropSiteEntry {
        private final long root;
        private final long event_mask;
        private final List sites = new ArrayList();

        public EmbeddedDropSiteEntry(long l2, long l3) {
            this.root = l2;
            this.event_mask = l3;
        }

        public long getRoot() {
            return this.root;
        }

        public long getEventMask() {
            return this.event_mask;
        }

        public void addSite(long l2) {
            Long l3 = new Long(l2);
            if (!this.sites.contains(l3)) {
                this.sites.add(l3);
            }
        }

        public void removeSite(long l2) {
            Long l3 = new Long(l2);
            this.sites.remove(l3);
        }

        public boolean hasSites() {
            return this.sites.isEmpty();
        }

        public long[] getSites() {
            long[] lArray = new long[this.sites.size()];
            Iterator iterator = this.sites.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Long l2 = (Long)iterator.next();
                lArray[n2++] = l2;
            }
            return lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSite(int n2, int n3) {
            assert (Thread.holdsLock(XToolkit.getAWTLock()));
            for (Long l2 : this.sites) {
                long l3 = l2;
                XTranslateCoordinates xTranslateCoordinates = new XTranslateCoordinates(this.getRoot(), l3, n2, n3);
                try {
                    int n4 = xTranslateCoordinates.execute(XToolkit.IgnoreBadWindowHandler);
                    if (n4 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) continue;
                    int n5 = xTranslateCoordinates.get_dest_x();
                    int n6 = xTranslateCoordinates.get_dest_y();
                    if (n5 < 0 || n6 < 0) continue;
                    XWindowAttributes xWindowAttributes = new XWindowAttributes();
                    try {
                        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                        n4 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l3, xWindowAttributes.pData);
                        XToolkit.RESTORE_XERROR_HANDLER();
                        if (n4 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0 || xWindowAttributes.get_map_state() == 0 || n5 >= xWindowAttributes.get_width() || n6 >= xWindowAttributes.get_height()) continue;
                        long l4 = l3;
                        return l4;
                    }
                    finally {
                        xWindowAttributes.dispose();
                    }
                }
                finally {
                    xTranslateCoordinates.dispose();
                }
            }
            return 0L;
        }
    }
}

