/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XAtom {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private static XAtom[] emptyList = new XAtom[0];
    public static final long XA_PRIMARY = 1L;
    public static final long XA_SECONDARY = 2L;
    public static final long XA_ARC = 3L;
    public static final long XA_ATOM = 4L;
    public static final long XA_BITMAP = 5L;
    public static final long XA_CARDINAL = 6L;
    public static final long XA_COLORMAP = 7L;
    public static final long XA_CURSOR = 8L;
    public static final long XA_CUT_BUFFER0 = 9L;
    public static final long XA_CUT_BUFFER1 = 10L;
    public static final long XA_CUT_BUFFER2 = 11L;
    public static final long XA_CUT_BUFFER3 = 12L;
    public static final long XA_CUT_BUFFER4 = 13L;
    public static final long XA_CUT_BUFFER5 = 14L;
    public static final long XA_CUT_BUFFER6 = 15L;
    public static final long XA_CUT_BUFFER7 = 16L;
    public static final long XA_DRAWABLE = 17L;
    public static final long XA_FONT = 18L;
    public static final long XA_INTEGER = 19L;
    public static final long XA_PIXMAP = 20L;
    public static final long XA_POINT = 21L;
    public static final long XA_RECTANGLE = 22L;
    public static final long XA_RESOURCE_MANAGER = 23L;
    public static final long XA_RGB_COLOR_MAP = 24L;
    public static final long XA_RGB_BEST_MAP = 25L;
    public static final long XA_RGB_BLUE_MAP = 26L;
    public static final long XA_RGB_DEFAULT_MAP = 27L;
    public static final long XA_RGB_GRAY_MAP = 28L;
    public static final long XA_RGB_GREEN_MAP = 29L;
    public static final long XA_RGB_RED_MAP = 30L;
    public static final long XA_STRING = 31L;
    public static final long XA_VISUALID = 32L;
    public static final long XA_WINDOW = 33L;
    public static final long XA_WM_COMMAND = 34L;
    public static final long XA_WM_HINTS = 35L;
    public static final long XA_WM_CLIENT_MACHINE = 36L;
    public static final long XA_WM_ICON_NAME = 37L;
    public static final long XA_WM_ICON_SIZE = 38L;
    public static final long XA_WM_NAME = 39L;
    public static final long XA_WM_NORMAL_HINTS = 40L;
    public static final long XA_WM_SIZE_HINTS = 41L;
    public static final long XA_WM_ZOOM_HINTS = 42L;
    public static final long XA_MIN_SPACE = 43L;
    public static final long XA_NORM_SPACE = 44L;
    public static final long XA_MAX_SPACE = 45L;
    public static final long XA_END_SPACE = 46L;
    public static final long XA_SUPERSCRIPT_X = 47L;
    public static final long XA_SUPERSCRIPT_Y = 48L;
    public static final long XA_SUBSCRIPT_X = 49L;
    public static final long XA_SUBSCRIPT_Y = 50L;
    public static final long XA_UNDERLINE_POSITION = 51L;
    public static final long XA_UNDERLINE_THICKNESS = 52L;
    public static final long XA_STRIKEOUT_ASCENT = 53L;
    public static final long XA_STRIKEOUT_DESCENT = 54L;
    public static final long XA_ITALIC_ANGLE = 55L;
    public static final long XA_X_HEIGHT = 56L;
    public static final long XA_QUAD_WIDTH = 57L;
    public static final long XA_WEIGHT = 58L;
    public static final long XA_POINT_SIZE = 59L;
    public static final long XA_RESOLUTION = 60L;
    public static final long XA_COPYRIGHT = 61L;
    public static final long XA_NOTICE = 62L;
    public static final long XA_FONT_NAME = 63L;
    public static final long XA_FAMILY_NAME = 64L;
    public static final long XA_FULL_NAME = 65L;
    public static final long XA_CAP_HEIGHT = 66L;
    public static final long XA_WM_CLASS = 67L;
    public static final long XA_WM_TRANSIENT_FOR = 68L;
    public static final long XA_LAST_PREDEFINED = 68L;
    static HashMap atomToAtom = new HashMap();
    static HashMap nameToAtom = new HashMap();
    long atom = 0L;
    String name;
    long display;

    static void register(XAtom xAtom) {
        if (xAtom == null) {
            return;
        }
        if (xAtom.atom == 0L || xAtom.name == null) {
            return;
        }
        atomToAtom.put(new Long(xAtom.atom), xAtom);
        nameToAtom.put(xAtom.name, xAtom);
    }

    static XAtom lookup(long l2) {
        XAtom xAtom = (XAtom)atomToAtom.get(new Long(l2));
        return xAtom;
    }

    static XAtom lookup(String string) {
        return (XAtom)nameToAtom.get(string);
    }

    static XAtom get(long l2) {
        XAtom xAtom = XAtom.lookup(l2);
        if (xAtom == null) {
            xAtom = new XAtom(XToolkit.getDisplay(), l2);
        }
        return xAtom;
    }

    static XAtom get(String string) {
        XAtom xAtom = XAtom.lookup(string);
        if (xAtom == null) {
            xAtom = new XAtom(string);
        }
        return xAtom;
    }

    public final String getName() {
        return this.name;
    }

    static String asString(long l2) {
        XAtom xAtom = XAtom.lookup(l2);
        if (xAtom == null) {
            return Long.toString(l2);
        }
        return xAtom.toString();
    }

    void register() {
        XAtom.register(this);
    }

    public String toString() {
        if (this.name != null) {
            return this.name + ":" + this.atom;
        }
        return Long.toString(this.atom);
    }

    private XAtom(long l2, String string) {
        this(l2, string, true);
    }

    private XAtom(String string) {
        this(XToolkit.getDisplay(), string, true);
    }

    public XAtom(String string, boolean bl2) {
        this(XToolkit.getDisplay(), string, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAtom(long l2, long l3) {
        this.atom = l3;
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            this.name = XlibWrapper.XGetAtomName(l2, l3);
        }
        this.display = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAtom(long l2, String string, boolean bl2) {
        this.name = string;
        this.display = l2;
        if (bl2) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                this.atom = XlibWrapper.InternAtom(l2, string, 0);
            }
            this.register();
        }
    }

    public XAtom() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(long l2, String string) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.SetProperty(this.display, l2, this.atom, string);
        }
    }

    public void setProperty8(long l2, String string) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (byArray != null) {
            this.setAtomData(l2, 31L, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(long l2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            return XlibWrapper.GetProperty(this.display, l2, this.atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get32Property(long l2, long l3) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, this, 0L, 1L, false, l3);
        try {
            int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                long l4 = 0L;
                return l4;
            }
            if (windowPropertyGetter.getActualType() != l3 || windowPropertyGetter.getActualFormat() != 32) {
                long l5 = 0L;
                return l5;
            }
            long l6 = Native.getCard32(windowPropertyGetter.getData());
            return l6;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    public long getCard32Property(XBaseWindow xBaseWindow) {
        return this.get32Property(xBaseWindow.getWindow(), 6L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCard32Property(long l2, long l3) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Native.putCard32(XlibWrapper.larg1, l3);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, this.atom, 6L, 32, 0, XlibWrapper.larg1, 1);
        }
    }

    public void setCard32Property(XBaseWindow xBaseWindow, long l2) {
        this.setCard32Property(xBaseWindow.getWindow(), l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAtomData(long l2, long l3, int n2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, this, 0L, (long)n2, false, this);
        try {
            int n3 = windowPropertyGetter.execute();
            if (n3 != 0 || windowPropertyGetter.getData() == 0L) {
                boolean bl2 = false;
                return bl2;
            }
            if (windowPropertyGetter.getActualType() != this.atom || windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() != n2) {
                boolean bl3 = false;
                return bl3;
            }
            XlibWrapper.memcpy(l3, windowPropertyGetter.getData(), n2 * XAtom.getAtomSize());
            boolean bl4 = true;
            return bl4;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAtomData(long l2, long l3, long l4, int n2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, this, 0L, (long)n2, false, l3);
        try {
            int n3 = windowPropertyGetter.execute();
            if (n3 != 0 || windowPropertyGetter.getData() == 0L) {
                boolean bl2 = false;
                return bl2;
            }
            if (windowPropertyGetter.getActualType() != l3 || windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() != n2) {
                boolean bl3 = false;
                return bl3;
            }
            XlibWrapper.memcpy(l4, windowPropertyGetter.getData(), n2 * XAtom.getAtomSize());
            boolean bl4 = true;
            return bl4;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAtomData(long l2, long l3, int n2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, this.atom, this.atom, 32, 0, l3, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAtomData(long l2, long l3, long l4, int n2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, this.atom, l3, 32, 0, l4, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAtomData8(long l2, long l3, long l4, int n2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, this.atom, l3, 8, 0, l4, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteProperty(long l2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), l2, this.atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DeleteProperty(XBaseWindow xBaseWindow) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(xBaseWindow.getWindow());
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), xBaseWindow.getWindow(), this.atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomData(long l2, long l3, byte[] byArray) {
        long l4 = Native.toData(byArray);
        try {
            this.setAtomData8(l2, l3, l4, byArray.length);
        }
        finally {
            unsafe.freeMemory(l4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArrayProperty(long l2, long l3) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, this, 0L, 65535L, false, l3);
        try {
            byte[] byArray;
            int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                byte[] byArray2 = null;
                return byArray2;
            }
            if (windowPropertyGetter.getActualType() != l3 || windowPropertyGetter.getActualFormat() != 8) {
                byte[] byArray3 = null;
                return byArray3;
            }
            byte[] byArray4 = byArray = XlibWrapper.getStringBytes(windowPropertyGetter.getData());
            return byArray4;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intern(boolean bl2) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            this.atom = XlibWrapper.InternAtom(this.display, this.name, bl2 ? 1 : 0);
        }
        this.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterned() {
        if (this.atom == 0L) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                this.atom = XlibWrapper.InternAtom(this.display, this.name, 1);
            }
            return this.atom != 0L;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(long l2, String string, boolean bl2) {
        this.display = l2;
        this.name = string;
        if (bl2) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                this.atom = XlibWrapper.InternAtom(l2, string, 0);
            }
            this.register();
        }
    }

    public void setValues(long l2, long l3) {
        this.display = l2;
        this.atom = l3;
        this.register();
    }

    public void setValues(long l2, String string, long l3) {
        this.display = l2;
        this.atom = l3;
        this.name = string;
        this.register();
    }

    static int getAtomSize() {
        return Native.getLongSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XAtom[] getAtomListProperty(long l2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, this, 0L, 65535L, false, 4L);
        try {
            int n2 = windowPropertyGetter.execute();
            if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                XAtom[] xAtomArray = emptyList;
                return xAtomArray;
            }
            if (windowPropertyGetter.getActualType() != 4L || windowPropertyGetter.getActualFormat() != 32) {
                XAtom[] xAtomArray = emptyList;
                return xAtomArray;
            }
            int n3 = windowPropertyGetter.getNumberOfItems();
            if (n3 == 0) {
                XAtom[] xAtomArray = emptyList;
                return xAtomArray;
            }
            long l3 = windowPropertyGetter.getData();
            XAtom[] xAtomArray = new XAtom[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                xAtomArray[i2] = XAtom.get(XAtom.getAtom(l3 + (long)(i2 * XAtom.getAtomSize())));
            }
            XAtom[] xAtomArray2 = xAtomArray;
            return xAtomArray2;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    XAtomList getAtomListPropertyList(long l2) {
        return new XAtomList(this.getAtomListProperty(l2));
    }

    XAtomList getAtomListPropertyList(XBaseWindow xBaseWindow) {
        return this.getAtomListPropertyList(xBaseWindow.getWindow());
    }

    XAtom[] getAtomListProperty(XBaseWindow xBaseWindow) {
        return this.getAtomListProperty(xBaseWindow.getWindow());
    }

    void setAtomListProperty(long l2, XAtom[] xAtomArray) {
        long l3 = XAtom.toData(xAtomArray);
        this.setAtomData(l2, 4L, l3, xAtomArray.length);
        unsafe.freeMemory(l3);
    }

    void setAtomListProperty(long l2, XAtomList xAtomList) {
        long l3 = xAtomList.getAtomsData();
        this.setAtomData(l2, 4L, l3, xAtomList.size());
        unsafe.freeMemory(l3);
    }

    public void setAtomListProperty(XBaseWindow xBaseWindow, XAtom[] xAtomArray) {
        this.setAtomListProperty(xBaseWindow.getWindow(), xAtomArray);
    }

    public void setAtomListProperty(XBaseWindow xBaseWindow, XAtomList xAtomList) {
        this.setAtomListProperty(xBaseWindow.getWindow(), xAtomList);
    }

    long getAtom() {
        return this.atom;
    }

    void putAtom(long l2) {
        Native.putLong(l2, this.atom);
    }

    static long getAtom(long l2) {
        return Native.getLong(l2);
    }

    static long toData(XAtom[] xAtomArray) {
        long l2 = unsafe.allocateMemory(XAtom.getAtomSize() * xAtomArray.length);
        for (int i2 = 0; i2 < xAtomArray.length; ++i2) {
            if (xAtomArray[i2] == null) continue;
            xAtomArray[i2].putAtom(l2 + (long)(i2 * XAtom.getAtomSize()));
        }
        return l2;
    }

    void checkWindow(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("Window must not be zero");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof XAtom)) {
            return false;
        }
        XAtom xAtom = (XAtom)object;
        return this.atom == xAtom.atom && this.display == xAtom.display;
    }

    public int hashCode() {
        return (int)((this.atom ^ this.display) & 0xFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowProperty(long l2, long l3) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Native.putWindow(XlibWrapper.larg1, l3);
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l2, this.atom, 33L, 32, 0, XlibWrapper.larg1, 1);
        }
    }

    public void setWindowProperty(XBaseWindow xBaseWindow, XBaseWindow xBaseWindow2) {
        this.setWindowProperty(xBaseWindow.getWindow(), xBaseWindow2.getWindow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindowProperty(long l2) {
        if (this.atom == 0L) {
            throw new IllegalStateException("Atom should be initialized");
        }
        this.checkWindow(l2);
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, this, 0L, 1L, false, 33L);
        try {
            int n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                long l3 = 0L;
                return l3;
            }
            if (windowPropertyGetter.getActualType() != 33L || windowPropertyGetter.getActualFormat() != 32) {
                long l4 = 0L;
                return l4;
            }
            long l5 = Native.getWindow(windowPropertyGetter.getData());
            return l5;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }
}

