/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.BitSet;

public class VariableGridLayout
extends GridLayout {
    BitSet rowsSet = new BitSet();
    double[] rowFractions = null;
    BitSet colsSet = new BitSet();
    double[] colFractions = null;
    int rows;
    int cols;
    int hgap;
    int vgap;

    public VariableGridLayout(int n2, int n3) {
        this(n2, n3, 0, 0);
        if (n2 != 0) {
            this.rowsSet = new BitSet(n2);
            this.stdRowFractions(n2);
        }
        if (n3 != 0) {
            this.colsSet = new BitSet(n3);
            this.stdColFractions(n3);
        }
    }

    public VariableGridLayout(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.rows = n2;
        this.cols = n3;
        this.hgap = n4;
        this.vgap = n5;
        if (n2 != 0) {
            this.rowsSet = new BitSet(n2);
            this.stdRowFractions(n2);
        }
        if (n3 != 0) {
            this.colsSet = new BitSet(n3);
            this.stdColFractions(n3);
        }
    }

    void stdRowFractions(int n2) {
        this.rowFractions = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.rowFractions[i2] = 1.0 / (double)n2;
        }
    }

    void stdColFractions(int n2) {
        this.colFractions = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.colFractions[i2] = 1.0 / (double)n2;
        }
    }

    public void setRowFraction(int n2, double d2) {
        this.rowsSet.set(n2);
        this.rowFractions[n2] = d2;
    }

    public void setColFraction(int n2, double d2) {
        this.colsSet.set(n2);
        this.colFractions[n2] = d2;
    }

    public double getRowFraction(int n2) {
        return this.rowFractions[n2];
    }

    public double getColFraction(int n2) {
        return this.colFractions[n2];
    }

    void allocateExtraSpace(double[] dArray, BitSet bitSet) {
        int n2;
        double d2 = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (bitSet.get(n2)) {
                d2 += dArray[n2];
                continue;
            }
            ++n3;
        }
        if (n3 != 0) {
            double d3 = (1.0 - d2) / (double)n3;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (bitSet.get(n2)) continue;
                dArray[n2] = d3;
                bitSet.set(n2);
            }
        }
    }

    void allocateExtraSpace() {
        this.allocateExtraSpace(this.rowFractions, this.rowsSet);
        this.allocateExtraSpace(this.colFractions, this.colsSet);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n2 = container.countComponents();
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        if (this.rows == 0) {
            this.stdRowFractions(n3);
        }
        if (this.cols == 0) {
            this.stdColFractions(n4);
        }
        Dimension dimension = container.size();
        int n5 = dimension.width - (insets.left + insets.right);
        int n6 = dimension.height - (insets.top + insets.bottom);
        n5 -= (n4 - 1) * this.hgap;
        n6 -= (n3 - 1) * this.vgap;
        this.allocateExtraSpace();
        int n7 = insets.left;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n8 = (int)(this.getColFraction(i2) * (double)n5);
            int n9 = insets.top;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n10 = i3 * n4 + i2;
                int n11 = (int)(this.getRowFraction(i3) * (double)n6);
                if (n10 < n2) {
                    container.getComponent(n10).reshape(n7, n9, n8, n11);
                }
                n9 += n11 + this.vgap;
            }
            n7 += n8 + this.hgap;
        }
    }

    static String fracsToString(double[] dArray) {
        String string = "[" + dArray.length + "]";
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            string = string + "<" + dArray[i2] + ">";
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + ",rowFracs=" + VariableGridLayout.fracsToString(this.rowFractions) + ",colFracs=" + VariableGridLayout.fracsToString(this.colFractions) + "]";
    }
}

