/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import javax.xml.datatype.SecuritySupport;

class FactoryFinder {
    private static final String CLASS_NAME = "javax.xml.datatype.FactoryFinder";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("javax.xml.datatype.FactoryFinder:" + string);
        }
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader = ss.getContextClassLoader();
        FactoryFinder.debugPrintln("Using context class loader: " + classLoader);
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
            FactoryFinder.debugPrintln("Using the class loader of FactoryFinder: " + classLoader);
        }
        return classLoader;
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            if (debug) {
                FactoryFinder.debugPrintln("Loaded " + string + " from " + FactoryFinder.which(clazz));
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2) throws ConfigurationError {
        Object object;
        ClassLoader classLoader;
        block14: {
            classLoader = FactoryFinder.findClassLoader();
            try {
                object = ss.getSystemProperty(string);
                if (object != null) {
                    FactoryFinder.debugPrintln("found " + (String)object + " in the system property " + string);
                    return FactoryFinder.newInstance((String)object, classLoader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                object = ss.getSystemProperty("java.home");
                String string3 = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
                String string4 = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File file = new File(string3);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                FactoryFinder.debugPrintln("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            }
                        }
                    }
                }
                string4 = cacheProps.getProperty(string);
                FactoryFinder.debugPrintln("found " + string4 + " in $java.home/jaxp.properties");
                if (string4 != null) {
                    return FactoryFinder.newInstance(string4, classLoader);
                }
            }
            catch (Exception exception) {
                if (!debug) break block14;
                exception.printStackTrace();
            }
        }
        if ((object = FactoryFinder.findJarServiceProvider(string)) != null) {
            return object;
        }
        if (string2 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + string2);
        return FactoryFinder.newInstance(string2, classLoader);
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ss.getContextClassLoader();
        if (classLoader != null) {
            inputStream = ss.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                classLoader = FactoryFinder.class.getClassLoader();
                inputStream = ss.getResourceAsStream(classLoader, string2);
            }
        } else {
            classLoader = FactoryFinder.class.getClassLoader();
            inputStream = ss.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        FactoryFinder.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            FactoryFinder.debugPrintln("found in resource, value=" + string3);
            return FactoryFinder.newInstance(string3, classLoader);
        }
        return null;
    }

    private static String which(Class clazz) {
        block3: {
            try {
                String string = clazz.getName().replace('.', '/') + ".class";
                ClassLoader classLoader = clazz.getClassLoader();
                URL uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
                if (uRL != null) {
                    return uRL.toString();
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block3;
                throwable.printStackTrace();
            }
        }
        return "unknown location";
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static abstract class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

