/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.TimerQueue;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer
implements Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean notify = false;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    Runnable doPostEvent = null;
    private static boolean logTimers;
    long expirationTime;
    Timer nextTimer;
    boolean running;

    public Timer(int n2, ActionListener actionListener) {
        this.delay = n2;
        this.initialDelay = n2;
        this.doPostEvent = new DoPostEvent();
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ActionListener.class) continue;
            ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    public static void setLogTimers(boolean bl2) {
        logTimers = bl2;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public void setDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid delay: " + n2);
        }
        this.delay = n2;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + n2);
        }
        this.initialDelay = n2;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean bl2) {
        this.repeats = bl2;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setCoalesce(boolean bl2) {
        boolean bl3 = this.coalesce;
        this.coalesce = bl2;
        if (!bl3 && this.coalesce) {
            this.cancelEvent();
        }
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    synchronized void cancelEvent() {
        this.notify = false;
    }

    synchronized void post() {
        if (!this.notify || !this.coalesce) {
            this.notify = true;
            SwingUtilities.invokeLater(this.doPostEvent);
        }
    }

    class DoPostEvent
    implements Runnable,
    Serializable {
        DoPostEvent() {
        }

        public void run() {
            if (logTimers) {
                System.out.println("Timer ringing: " + Timer.this);
            }
            if (Timer.this.notify) {
                Timer.this.fireActionPerformed(new ActionEvent(Timer.this, 0, null, System.currentTimeMillis(), 0));
                if (Timer.this.coalesce) {
                    Timer.this.cancelEvent();
                }
            }
        }

        Timer getTimer() {
            return Timer.this;
        }
    }
}

