/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

public class DescriptorSupport
implements Descriptor {
    private static final long oldSerialVersionUID = 8071560848919417985L;
    private static final long newSerialVersionUID = -6292969195866300415L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", HashMap.class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", HashMap.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final String serialForm;
    private transient Map descriptorMap;
    private static final int DEFAULT_SIZE = 20;
    private static final String currClass = "DescriptorSupport";
    private static final String[] entities;
    private static final Map entityToCharMap;
    private static final String[] charToEntityMap;

    public DescriptorSupport() {
        if (this.tracing()) {
            this.trace("Descriptor()", "Constructor");
        }
        this.descriptorMap = new HashMap(20);
    }

    public DescriptorSupport(int n2) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(maxNumFields = " + n2 + ")", "Constructor");
        }
        if (n2 <= 0) {
            if (this.tracing()) {
                this.trace("Descriptor(maxNumFields)", "Illegal arguments: initNumFields <= 0");
            }
            String string = "Descriptor field limit invalid: " + n2;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            throw new RuntimeOperationsException(illegalArgumentException, string);
        }
        this.descriptorMap = new HashMap(n2);
    }

    public DescriptorSupport(DescriptorSupport descriptorSupport) {
        if (this.tracing()) {
            this.trace("Descriptor(Descriptor)", "Constructor");
        }
        this.descriptorMap = descriptorSupport == null ? new HashMap(20) : new HashMap(descriptorSupport.descriptorMap);
    }

    public DescriptorSupport(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (this.tracing()) {
            this.trace("Descriptor(String ='" + string + "')", "Constructor");
        }
        if (string == null) {
            if (this.tracing()) {
                this.trace("Descriptor(String = null)", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("String in parameter is null");
            throw new RuntimeOperationsException(illegalArgumentException, "String in parameter is null");
        }
        String string2 = string.toLowerCase();
        if (!string2.startsWith("<descriptor>") || !string2.endsWith("</descriptor>")) {
            throw new XMLParseException("No <descriptor>, </descriptor> pair");
        }
        this.descriptorMap = new HashMap(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            if (string6.equalsIgnoreCase("FIELD")) {
                bl2 = true;
                continue;
            }
            if (string6.equalsIgnoreCase("/FIELD")) {
                if (string3 != null && string4 != null) {
                    string3 = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
                    Object object = DescriptorSupport.parseQuotedFieldValue(string4);
                    this.setField(string3, object);
                }
                string3 = null;
                string4 = null;
                bl2 = false;
                continue;
            }
            if (string6.equalsIgnoreCase("DESCRIPTOR")) {
                bl3 = true;
                continue;
            }
            if (string6.equalsIgnoreCase("/DESCRIPTOR")) {
                bl3 = false;
                string3 = null;
                string4 = null;
                bl2 = false;
                continue;
            }
            if (!bl2 || !bl3) continue;
            int n2 = string6.indexOf("=");
            if (n2 > 0) {
                string5 = string6.substring(0, n2);
                String string7 = string6.substring(n2 + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string3 = string7;
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string4 = string7;
                    continue;
                }
                String string8 = "Expected `name' or `value', got `" + string6 + "'";
                throw new XMLParseException(string8);
            }
            string5 = "Expected `keyword=value', got `" + string6 + "'";
            throw new XMLParseException(string5);
        }
        if (this.tracing()) {
            this.trace("Descriptor(XMLString)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Constructor");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor(String[],Object[])", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Null or invalid fieldNames or fieldValues");
            throw new RuntimeOperationsException(illegalArgumentException, "Null or invalid fieldNames or fieldValues");
        }
        this.descriptorMap = new HashMap(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.setField(stringArray[i2], objectArray[i2]);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray) {
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Constructor");
        }
        if (stringArray == null || stringArray.length == 0) {
            this.descriptorMap = new HashMap(20);
            return;
        }
        this.descriptorMap = new HashMap(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object object;
            if (stringArray[i2] == null || stringArray[i2].equals("")) continue;
            int n2 = stringArray[i2].indexOf("=");
            if (n2 < 0) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: field does not have '=' as a name and value separator");
                }
                object = new IllegalArgumentException("Field in invalid format: no equals sign");
                throw new RuntimeOperationsException((RuntimeException)object, "Field in invalid format: no equals sign");
            }
            String string = stringArray[i2].substring(0, n2);
            object = null;
            if (n2 < stringArray[i2].length()) {
                object = stringArray[i2].substring(n2 + 1);
            }
            if (string.equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: fieldName is empty");
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Field in invalid format: no fieldName");
                throw new RuntimeOperationsException(illegalArgumentException, "Field in invalid format: no fieldName");
            }
            this.setField(string, object);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Exit");
        }
    }

    public synchronized Object getFieldValue(String string) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("getField()", "Illegal arguments: null field name.");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Fieldname requested is null");
            throw new RuntimeOperationsException(illegalArgumentException, "Fieldname requested is null");
        }
        Object v2 = this.descriptorMap.get(new CaseIgnoreString(string));
        if (this.tracing()) {
            this.trace("getField(" + string + ")", "Returns '" + v2 + "'");
        }
        return v2;
    }

    public synchronized void setField(String string, Object object) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("setField(String,String)", "Illegal arguments: null or empty field name");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Fieldname to be set is null or empty");
            throw new RuntimeOperationsException(illegalArgumentException, "Fieldname to be set is null or empty");
        }
        if (!this.validateField(string, object)) {
            if (this.tracing()) {
                this.trace("setField(fieldName,FieldValue)", "Illegal arguments");
            }
            String string2 = "Field value invalid: " + string + "=" + object;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            throw new RuntimeOperationsException(illegalArgumentException, string2);
        }
        if (this.tracing() && object != null) {
            this.trace("setField(fieldName, fieldValue)", "Entry: setting '" + string + "' to '" + object + "'.");
        }
        this.descriptorMap.put(new CaseIgnoreString(string), object);
    }

    public synchronized String[] getFields() {
        if (this.tracing()) {
            this.trace("getFields()", "Entry");
        }
        int n2 = this.descriptorMap.size();
        String[] stringArray = new String[n2];
        Set set = this.descriptorMap.entrySet();
        int n3 = 0;
        Object object = null;
        Map.Entry entry2 = null;
        if (this.tracing()) {
            this.trace("getFields()", "Returning " + n2 + " fields");
        }
        for (Map.Entry entry2 : set) {
            if (entry2 == null) {
                if (this.tracing()) {
                    this.trace("getFields()", "Element is null");
                }
            } else {
                object = entry2.getValue();
                stringArray[n3] = object == null ? entry2.getKey() + "=" : (object instanceof String ? entry2.getKey() + "=" + object.toString() : entry2.getKey() + "=(" + object.toString() + ")");
            }
            ++n3;
        }
        if (this.tracing()) {
            this.trace("getFields()", "Exit");
        }
        return stringArray;
    }

    public synchronized String[] getFieldNames() {
        if (this.tracing()) {
            this.trace("getFieldNames()", "Entry");
        }
        int n2 = this.descriptorMap.size();
        String[] stringArray = new String[n2];
        Set set = this.descriptorMap.entrySet();
        int n3 = 0;
        if (this.tracing()) {
            this.trace("getFieldNames()", "Returning " + n2 + " fields");
        }
        for (Map.Entry entry : set) {
            if (entry == null || entry.getKey() == null) {
                if (this.tracing()) {
                    this.trace("getFieldNames()", "Field is null");
                }
            } else {
                stringArray[n3] = entry.getKey().toString();
            }
            ++n3;
        }
        if (this.tracing()) {
            this.trace("getFieldNames()", "Exit");
        }
        return stringArray;
    }

    public synchronized Object[] getFieldValues(String[] stringArray) {
        int n2;
        if (this.tracing()) {
            this.trace("getFieldValues(fieldNames)", "Entry");
        }
        if ((n2 = this.descriptorMap.size()) == 0) {
            return new Object[0];
        }
        Object[] objectArray = stringArray != null ? new Object[stringArray.length] : new Object[n2];
        int n3 = 0;
        if (this.tracing()) {
            this.trace("getFieldValues()", "Returning " + n2 + " fields");
        }
        if (stringArray == null) {
            Iterator iterator = this.descriptorMap.values().iterator();
            while (iterator.hasNext()) {
                objectArray[n3] = iterator.next();
                ++n3;
            }
        } else {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                objectArray[n3] = stringArray[n3] == null || stringArray[n3].equals("") ? null : this.getFieldValue(stringArray[n3]);
            }
        }
        if (this.tracing()) {
            this.trace("getFieldValues()", "Exit");
        }
        return objectArray;
    }

    public synchronized void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("setFields(fieldNames, ObjectValues)", "Entry");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor.setFields(String[],Object[])", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("FieldNames and FieldValues are null or invalid");
            throw new RuntimeOperationsException(illegalArgumentException, "FieldNames and FieldValues are null or invalid");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor.setFields(String[],Object[])", "Null field name encountered at " + i2 + " element");
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("FieldNames is null or invalid");
                throw new RuntimeOperationsException(illegalArgumentException, "FieldNames is null or invalid");
            }
            this.setField(stringArray[i2], objectArray[i2]);
        }
        if (this.tracing()) {
            this.trace("Descriptor.setFields(fieldNames, fieldObjects)", "Exit");
        }
    }

    public synchronized Object clone() throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor.clone()", "Executed");
        }
        return new DescriptorSupport(this);
    }

    public synchronized void removeField(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.descriptorMap.remove(new CaseIgnoreString(string));
    }

    public synchronized boolean isValid() throws RuntimeOperationsException {
        Set set;
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "Executed");
        }
        if ((set = this.descriptorMap.entrySet()) == null) {
            if (this.tracing()) {
                this.trace("Descriptor.isValid()", "returns false (null set)");
            }
            return false;
        }
        String string = (String)this.getFieldValue("name");
        String string2 = (String)this.getFieldValue("descriptorType");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return false;
        }
        for (Map.Entry entry : set) {
            if (entry == null || entry.getValue() == null || this.validateField(entry.getKey().toString(), entry.getValue().toString())) continue;
            if (this.tracing()) {
                this.trace("isValid()", "Field " + entry.getKey() + "=" + entry.getValue() + " is not valid");
            }
            return false;
        }
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "returns true");
        }
        return true;
    }

    private boolean validateField(String string, Object object) {
        boolean bl2;
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "";
        boolean bl3 = false;
        if (object != null && object instanceof String) {
            string2 = (String)object;
            bl3 = true;
        }
        boolean bl4 = bl2 = string.equalsIgnoreCase("Name") || string.equalsIgnoreCase("DescriptorType");
        if (bl2 || string.equalsIgnoreCase("SetMethod") || string.equalsIgnoreCase("GetMethod") || string.equalsIgnoreCase("Role") || string.equalsIgnoreCase("Class")) {
            if (object == null || !bl3) {
                return false;
            }
            return !bl2 || !string2.equals("");
        }
        if (string.equalsIgnoreCase("visibility")) {
            long l2;
            if (object != null && bl3) {
                l2 = this.toNumeric(string2);
            } else if (object instanceof Integer) {
                l2 = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l2 >= 1L && l2 <= 4L;
        }
        if (string.equalsIgnoreCase("severity")) {
            long l3;
            if (object != null && bl3) {
                l3 = this.toNumeric(string2);
            } else if (object instanceof Integer) {
                l3 = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l3 >= 0L && l3 <= 6L;
        }
        if (string.equalsIgnoreCase("PersistPolicy")) {
            return object != null && bl3 && (string2.equalsIgnoreCase("OnUpdate") || string2.equalsIgnoreCase("OnTimer") || string2.equalsIgnoreCase("NoMoreOftenThan") || string2.equalsIgnoreCase("Always") || string2.equalsIgnoreCase("Never"));
        }
        if (string.equalsIgnoreCase("PersistPeriod") || string.equalsIgnoreCase("CurrencyTimeLimit") || string.equalsIgnoreCase("LastUpdatedTimeStamp") || string.equalsIgnoreCase("LastReturnedTimeStamp")) {
            long l4;
            if (object != null && bl3) {
                l4 = this.toNumeric(string2);
            } else if (object instanceof Number) {
                l4 = ((Number)object).longValue();
            } else {
                return false;
            }
            return l4 >= -1L;
        }
        if (string.equalsIgnoreCase("log")) {
            return object instanceof Boolean || bl3 && (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("false"));
        }
        return true;
    }

    public synchronized String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer("<Descriptor>");
        Set set = this.descriptorMap.entrySet();
        for (Map.Entry entry : set) {
            String string;
            String string2 = entry.getKey().toString();
            Object v2 = entry.getValue();
            String string3 = null;
            if (!(!(v2 instanceof String) || (string = (String)v2).startsWith("(") && string.endsWith(")"))) {
                string3 = DescriptorSupport.quote(string);
            }
            if (string3 == null) {
                string3 = DescriptorSupport.makeFieldValue(v2);
            }
            stringBuffer.append("<field name=\"").append(string2).append("\" value=\"").append(string3).append("\"></field>");
        }
        stringBuffer.append("</Descriptor>");
        return stringBuffer.toString();
    }

    private static boolean isMagic(char c2) {
        return c2 < charToEntityMap.length && charToEntityMap[c2] != null;
    }

    private static String quote(String string) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (!DescriptorSupport.isMagic(string.charAt(i2))) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c2 = string.charAt(i3);
            if (DescriptorSupport.isMagic(c2)) {
                stringBuffer.append(charToEntityMap[c2]);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static String unquote(String string) throws XMLParseException {
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            throw new XMLParseException("Value must be quoted: <" + string + ">");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length() - 1;
        for (int i2 = 1; i2 < n2; ++i2) {
            Character c2;
            int n3;
            char c3 = string.charAt(i2);
            if (c3 == '&' && (n3 = string.indexOf(59, i2 + 1)) >= 0 && (c2 = (Character)entityToCharMap.get(string.substring(i2, n3 + 1))) != null) {
                stringBuffer.append(c2);
                i2 = n3;
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    private static String makeFieldValue(Object object) {
        if (object == null) {
            return "(null)";
        }
        Class<? extends Object> clazz = object.getClass();
        try {
            clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "Class " + clazz + " does not have a public " + "constructor with a single string arg";
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            throw new RuntimeOperationsException(illegalArgumentException, "Cannot make XML descriptor");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string = DescriptorSupport.quote(object.toString());
        return "(" + clazz.getName() + "/" + string + ")";
    }

    private static Object parseQuotedFieldValue(String string) throws XMLParseException {
        Constructor constructor;
        Object object;
        if ((string = DescriptorSupport.unquote(string)).equalsIgnoreCase("(null)")) {
            return null;
        }
        if (!string.startsWith("(") || !string.endsWith(")")) {
            return string;
        }
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            return string.substring(1, string.length() - 1);
        }
        String string2 = string.substring(1, n2);
        try {
            Object object2;
            object = Thread.currentThread().getContextClassLoader();
            if (object == null && (object2 = System.getSecurityManager()) != null) {
                ((SecurityManager)object2).checkPackageAccess(string2);
            }
            object2 = Class.forName(string2, false, (ClassLoader)object);
            constructor = ((Class)object2).getConstructor(String.class);
        }
        catch (Exception exception) {
            throw new XMLParseException(exception, "Cannot parse value: <" + string + ">");
        }
        object = string.substring(n2 + 1, string.length() - 1);
        try {
            return constructor.newInstance(object);
        }
        catch (Exception exception) {
            String string3 = "Cannot construct instance of " + string2 + " with arg: <" + string + ">";
            throw new XMLParseException(exception, string3);
        }
    }

    public synchronized String toString() {
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Entry");
        }
        String string = "";
        String[] stringArray = this.getFields();
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Printing " + stringArray.length + " fields");
        }
        if (stringArray == null || stringArray.length == 0) {
            if (this.tracing()) {
                this.trace("Descriptor.toString()", "Empty Descriptor");
            }
            return string;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = i2 == stringArray.length - 1 ? string.concat(stringArray[i2]) : string.concat(stringArray[i2] + ", ");
        }
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Exit returning " + string);
        }
        return string;
    }

    private long toNumeric(String string) {
        long l2 = -2L;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            return -2L;
        }
        return l2;
    }

    private boolean tracing() {
        return Trace.isSelected(1, 128);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 128, string, string2, Integer.toHexString(this.hashCode()) + " " + string3);
    }

    private void trace(String string, String string2) {
        this.trace(currClass, string, string2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Map map = (Map)getField.get("descriptor", null);
        this.descriptorMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            this.setField((String)entry.getKey(), entry.getValue());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        boolean bl2 = "1.0".equals(serialForm);
        if (bl2) {
            putField.put("currClass", currClass);
        }
        boolean bl3 = bl2 || "1.2.0".equals(serialForm) || "1.2.1".equals(serialForm);
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.descriptorMap.entrySet()) {
            String string = entry.getKey().toString();
            if (bl3) {
                string = string.toLowerCase();
            }
            hashMap.put(string, entry.getValue());
        }
        putField.put("descriptor", hashMap);
        objectOutputStream.writeFields();
    }

    static {
        String string = null;
        int n2 = 0;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            string = (String)AccessController.doPrivileged(getPropertyAction);
            n2 = "1.0".equals(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serialForm = string;
        if (n2 != 0) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 8071560848919417985L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6292969195866300415L;
        }
        entities = new String[]{" &#32;", "\"&quot;", "<&lt;", ">&gt;", "&&amp;", "\r&#13;", "\t&#9;", "\n&#10;", "\f&#12;"};
        entityToCharMap = new HashMap();
        char c2 = '\u0000';
        for (n2 = 0; n2 < entities.length; ++n2) {
            char c3 = entities[n2].charAt(0);
            if (c3 <= c2) continue;
            c2 = c3;
        }
        charToEntityMap = new String[c2 + 1];
        for (n2 = 0; n2 < entities.length; ++n2) {
            String string2;
            char c4 = entities[n2].charAt(0);
            DescriptorSupport.charToEntityMap[c4] = string2 = entities[n2].substring(1);
            entityToCharMap.put(string2, new Character(c4));
        }
    }

    private static class CaseIgnoreString {
        private String string;

        CaseIgnoreString(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }

        public boolean equals(Object object) {
            return object instanceof CaseIgnoreString && ((CaseIgnoreString)object).string.equalsIgnoreCase(this.string);
        }

        public int hashCode() {
            return this.string.toLowerCase().hashCode();
        }
    }
}

