/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicLongFieldUpdater<T> {
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        if (AtomicLong.VM_SUPPORTS_LONG_CAS) {
            return new CASUpdater<U>(clazz, string);
        }
        return new LockedUpdater<U>(clazz, string);
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T t2, long l2) {
        long l3;
        while (!this.compareAndSet(t2, l3 = this.get(t2), l2)) {
        }
        return l3;
    }

    public long getAndIncrement(T t2) {
        long l2;
        long l3;
        while (!this.compareAndSet(t2, l3 = this.get(t2), l2 = l3 + 1L)) {
        }
        return l3;
    }

    public long getAndDecrement(T t2) {
        long l2;
        long l3;
        while (!this.compareAndSet(t2, l3 = this.get(t2), l2 = l3 - 1L)) {
        }
        return l3;
    }

    public long getAndAdd(T t2, long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(t2, l4 = this.get(t2), l3 = l4 + l2)) {
        }
        return l4;
    }

    public long incrementAndGet(T t2) {
        long l2;
        long l3;
        while (!this.compareAndSet(t2, l3 = this.get(t2), l2 = l3 + 1L)) {
        }
        return l2;
    }

    public long decrementAndGet(T t2) {
        long l2;
        long l3;
        while (!this.compareAndSet(t2, l3 = this.get(t2), l2 = l3 - 1L)) {
        }
        return l2;
    }

    public long addAndGet(T t2, long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(t2, l4 = this.get(t2), l3 = l4 + l2)) {
        }
        return l3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CASUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        CASUpdater(Class<T> clazz, String string) {
            Field field = null;
            Class clazz2 = null;
            int n2 = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz2 = Reflection.getCallerClass(3);
                n2 = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n2);
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(n2)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n2) && clazz2 != clazz ? clazz2 : null;
            this.tclass = clazz;
            this.offset = unsafe.objectFieldOffset(field);
        }

        @Override
        public boolean compareAndSet(T t2, long l2, long l3) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            return unsafe.compareAndSwapLong(t2, this.offset, l2, l3);
        }

        @Override
        public boolean weakCompareAndSet(T t2, long l2, long l3) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            return unsafe.compareAndSwapLong(t2, this.offset, l2, l3);
        }

        @Override
        public void set(T t2, long l2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            unsafe.putLongVolatile(t2, this.offset, l2);
        }

        @Override
        public long get(T t2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            return unsafe.getLongVolatile(t2, this.offset);
        }

        private void ensureProtectedAccess(T t2) {
            if (this.cclass.isInstance(t2)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t2.getClass().getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockedUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        LockedUpdater(Class<T> clazz, String string) {
            Field field = null;
            Class clazz2 = null;
            int n2 = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz2 = Reflection.getCallerClass(3);
                n2 = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n2);
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(n2)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n2) && clazz2 != clazz ? clazz2 : null;
            this.tclass = clazz;
            this.offset = unsafe.objectFieldOffset(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndSet(T t2, long l2, long l3) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                long l4 = unsafe.getLong(t2, this.offset);
                if (l4 != l2) {
                    return false;
                }
                unsafe.putLong(t2, this.offset, l3);
                return true;
            }
        }

        @Override
        public boolean weakCompareAndSet(T t2, long l2, long l3) {
            return this.compareAndSet(t2, l2, l3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T t2, long l2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                unsafe.putLong(t2, this.offset, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long get(T t2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                return unsafe.getLong(t2, this.offset);
            }
        }

        private void ensureProtectedAccess(T t2) {
            if (this.cclass.isInstance(t2)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t2.getClass().getName()));
        }
    }
}

