/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnit {
    NANOSECONDS(0),
    MICROSECONDS(1),
    MILLISECONDS(2),
    SECONDS(3);

    private final int index;
    private static final int[] multipliers;
    private static final long[] overflows;

    private TimeUnit(int n3) {
        this.index = n3;
    }

    private static long doConvert(int n2, long l2) {
        if (n2 == 0) {
            return l2;
        }
        if (n2 < 0) {
            return l2 / (long)multipliers[-n2];
        }
        if (l2 > overflows[n2]) {
            return Long.MAX_VALUE;
        }
        if (l2 < -overflows[n2]) {
            return Long.MIN_VALUE;
        }
        return l2 * (long)multipliers[n2];
    }

    public long convert(long l2, TimeUnit timeUnit) {
        return TimeUnit.doConvert(timeUnit.index - this.index, l2);
    }

    public long toNanos(long l2) {
        return TimeUnit.doConvert(this.index, l2);
    }

    public long toMicros(long l2) {
        return TimeUnit.doConvert(this.index - TimeUnit.MICROSECONDS.index, l2);
    }

    public long toMillis(long l2) {
        return TimeUnit.doConvert(this.index - TimeUnit.MILLISECONDS.index, l2);
    }

    public long toSeconds(long l2) {
        return TimeUnit.doConvert(this.index - TimeUnit.SECONDS.index, l2);
    }

    private int excessNanos(long l2, long l3) {
        if (this == NANOSECONDS) {
            return (int)(l2 - l3 * 1000L * 1000L);
        }
        if (this == MICROSECONDS) {
            return (int)(l2 * 1000L - l3 * 1000L * 1000L);
        }
        return 0;
    }

    public void timedWait(Object object, long l2) throws InterruptedException {
        if (l2 > 0L) {
            long l3 = this.toMillis(l2);
            int n2 = this.excessNanos(l2, l3);
            object.wait(l3, n2);
        }
    }

    public void timedJoin(Thread thread, long l2) throws InterruptedException {
        if (l2 > 0L) {
            long l3 = this.toMillis(l2);
            int n2 = this.excessNanos(l2, l3);
            thread.join(l3, n2);
        }
    }

    public void sleep(long l2) throws InterruptedException {
        if (l2 > 0L) {
            long l3 = this.toMillis(l2);
            int n2 = this.excessNanos(l2, l3);
            Thread.sleep(l3, n2);
        }
    }

    static {
        multipliers = new int[]{1, 1000, 1000000, 1000000000};
        overflows = new long[]{0L, 9223372036854775L, 9223372036854L, 9223372036L};
    }
}

