/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubList<E>
extends AbstractList<E> {
    private AbstractList<E> l;
    private int offset;
    private int size;
    private int expectedModCount;

    SubList(AbstractList<E> abstractList, int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n2);
        }
        if (n3 > abstractList.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        this.l = abstractList;
        this.offset = n2;
        this.size = n3 - n2;
        this.expectedModCount = this.l.modCount;
    }

    @Override
    public E set(int n2, E e2) {
        this.rangeCheck(n2);
        this.checkForComodification();
        return this.l.set(n2 + this.offset, e2);
    }

    @Override
    public E get(int n2) {
        this.rangeCheck(n2);
        this.checkForComodification();
        return this.l.get(n2 + this.offset);
    }

    @Override
    public int size() {
        this.checkForComodification();
        return this.size;
    }

    @Override
    public void add(int n2, E e2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForComodification();
        this.l.add(n2 + this.offset, e2);
        this.expectedModCount = this.l.modCount;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E remove(int n2) {
        this.rangeCheck(n2);
        this.checkForComodification();
        E e2 = this.l.remove(n2 + this.offset);
        this.expectedModCount = this.l.modCount;
        --this.size;
        ++this.modCount;
        return e2;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        this.checkForComodification();
        this.l.removeRange(n2 + this.offset, n3 + this.offset);
        this.expectedModCount = this.l.modCount;
        this.size -= n3 - n2;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + n2, collection);
        this.expectedModCount = this.l.modCount;
        this.size += n3;
        ++this.modCount;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(final int n2) {
        this.checkForComodification();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        return new ListIterator<E>(){
            private ListIterator<E> i;
            {
                this.i = SubList.this.l.listIterator(n2 + SubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < SubList.this.size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            @Override
            public E previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - SubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - SubList.this.offset;
            }

            @Override
            public void remove() {
                this.i.remove();
                SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                SubList.this.size--;
                ++SubList.this.modCount;
            }

            @Override
            public void set(E e2) {
                this.i.set(e2);
            }

            @Override
            public void add(E e2) {
                this.i.add(e2);
                SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                SubList.this.size++;
                ++SubList.this.modCount;
            }
        };
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return new SubList<E>(this, n2, n3);
    }

    private void rangeCheck(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ",Size: " + this.size);
        }
    }

    private void checkForComodification() {
        if (this.l.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

