/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.RandomAccessSubList;
import java.util.SubList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount = 0;

    protected AbstractList() {
    }

    @Override
    public boolean add(E e2) {
        this.add(this.size(), e2);
        return true;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int n2, E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n2, E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator();
        if (object == null) {
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.previousIndex();
            }
        } else {
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator(this.size());
        if (object == null) {
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.nextIndex();
            }
        } else {
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        boolean bl2 = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next());
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new ListItr(n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return this instanceof RandomAccess ? new RandomAccessSubList(this, n2, n3) : new SubList(this, n2, n3);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator<E> listIterator = this.listIterator();
        ListIterator listIterator2 = ((List)object).listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            E e2 = listIterator.next();
            Object e3 = listIterator2.next();
            if (e2 != null ? e2.equals(e3) : e3 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (E e2 : this) {
            n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    protected void removeRange(int n2, int n3) {
        ListIterator<E> listIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            listIterator.next();
            listIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                Object e2 = AbstractList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int n2) {
            this.cursor = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int n2 = this.cursor - 1;
                Object e2 = AbstractList.this.get(n2);
                this.lastRet = this.cursor = n2;
                return e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e2) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.set(this.lastRet, e2);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e2) {
            this.checkForComodification();
            try {
                AbstractList.this.add(this.cursor++, e2);
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

