/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 0) {
            this.context = null;
        } else if (protectionDomainArray.length == 1) {
            this.context = protectionDomainArray[0] != null ? (ProtectionDomain[])protectionDomainArray.clone() : null;
        } else {
            ArrayList<ProtectionDomain> arrayList = new ArrayList<ProtectionDomain>(protectionDomainArray.length);
            for (int i2 = 0; i2 < protectionDomainArray.length; ++i2) {
                if (protectionDomainArray[i2] == null || arrayList.contains(protectionDomainArray[i2])) continue;
                arrayList.add(protectionDomainArray[i2]);
            }
            this.context = new ProtectionDomain[arrayList.size()];
            this.context = arrayList.toArray(this.context);
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl2) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl2;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n2;
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            if (Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    for (n2 = 0; n2 < this.context.length; ++n2) {
                        debug.println("domain " + n2 + " " + this.context[n2]);
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        for (n2 = 0; n2 < this.context.length; ++n2) {
            if (this.context[n2] == null || this.context[n2].implies(permission)) continue;
            if (debug != null) {
                debug.println("access denied " + permission);
                if (Debug.isOn("failure")) {
                    Thread.currentThread();
                    Thread.dumpStack();
                    final ProtectionDomain protectionDomain = this.context[n2];
                    final Debug debug = AccessControlContext.debug;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            debug.println("domain that failed " + protectionDomain);
                            return null;
                        }
                    });
                }
            }
            throw new AccessControlException("access denied " + permission, permission);
        }
        if (debug != null) {
            debug.println("access allowed " + permission);
        }
    }

    AccessControlContext optimize() {
        boolean bl2;
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        boolean bl3 = this.context == null;
        boolean bl4 = bl2 = accessControlContext == null || accessControlContext.context == null;
        if (bl2 && bl3) {
            return accessControlContext != null ? accessControlContext : this;
        }
        if (accessControlContext != null && accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext);
        }
        if (bl3) {
            return accessControlContext;
        }
        int n2 = this.context.length;
        if (bl2 && n2 <= 2) {
            return this;
        }
        if (n2 == 1 && this.context[0] == accessControlContext.context[0]) {
            return accessControlContext;
        }
        int n3 = bl2 ? 0 : accessControlContext.context.length;
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n2 + n3];
        if (!bl2) {
            System.arraycopy(accessControlContext.context, 0, protectionDomainArray, 0, n3);
        }
        block0: for (int i2 = 0; i2 < this.context.length; ++i2) {
            ProtectionDomain protectionDomain = this.context[i2];
            if (protectionDomain == null) continue;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (protectionDomain == protectionDomainArray[i3]) continue block0;
            }
            protectionDomainArray[n3++] = protectionDomain;
        }
        if (n3 != protectionDomainArray.length) {
            if (!bl2 && n3 == accessControlContext.context.length) {
                return accessControlContext;
            }
            if (bl2 && n3 == n2) {
                return this;
            }
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n3];
            System.arraycopy(protectionDomainArray, 0, protectionDomainArray2, 0, n3);
            protectionDomainArray = protectionDomainArray2;
        }
        this.context = protectionDomainArray;
        this.combiner = null;
        this.isPrivileged = false;
        return this;
    }

    private AccessControlContext goCombiner(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] protectionDomainArray2 = accessControlContext.combiner.combine(protectionDomainArray, accessControlContext.context);
        this.context = protectionDomainArray2;
        this.combiner = accessControlContext.combiner;
        this.isPrivileged = false;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        if (!this.containsAllPDs(accessControlContext) || !accessControlContext.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return accessControlContext.combiner == null;
        }
        if (accessControlContext.combiner == null) {
            return false;
        }
        return this.combiner.equals(accessControlContext.combiner);
    }

    private boolean containsAllPDs(AccessControlContext accessControlContext) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.context.length; ++i2) {
            bl2 = false;
            ProtectionDomain protectionDomain = this.context[i2];
            if (protectionDomain == null) {
                for (int i3 = 0; i3 < accessControlContext.context.length && !bl2; ++i3) {
                    bl2 = accessControlContext.context[i3] == null;
                }
            } else {
                Class<? extends Object> clazz = protectionDomain.getClass();
                for (int i4 = 0; i4 < accessControlContext.context.length && !bl2; ++i4) {
                    ProtectionDomain protectionDomain2 = accessControlContext.context[i4];
                    bl2 = protectionDomain2 != null && clazz == protectionDomain2.getClass() && protectionDomain.equals(protectionDomain2);
                }
            }
            if (bl2) continue;
            return false;
        }
        return bl2;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.context == null) {
            return n2;
        }
        for (int i2 = 0; i2 < this.context.length; ++i2) {
            if (this.context[i2] == null) continue;
            n2 ^= this.context[i2].hashCode();
        }
        return n2;
    }
}

