/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BufferedImageFilter
extends ImageFilter
implements Cloneable {
    BufferedImageOp bufferedImageOp;
    ColorModel model;
    int width;
    int height;
    byte[] bytePixels;
    int[] intPixels;

    public BufferedImageFilter(BufferedImageOp bufferedImageOp) {
        if (bufferedImageOp == null) {
            throw new NullPointerException("Operation cannot be null");
        }
        this.bufferedImageOp = bufferedImageOp;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.bufferedImageOp;
    }

    public void setDimensions(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            this.imageComplete(3);
            return;
        }
        this.width = n2;
        this.height = n3;
    }

    public void setColorModel(ColorModel colorModel) {
        this.model = colorModel;
    }

    private void convertToRGB() {
        int n2 = this.width * this.height;
        int[] nArray = new int[n2];
        if (this.bytePixels != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.model.getRGB(this.bytePixels[i2] & 0xFF);
            }
        } else if (this.intPixels != null) {
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = this.model.getRGB(this.intPixels[i3]);
            }
        }
        this.bytePixels = null;
        this.intPixels = nArray;
        this.model = ColorModel.getRGBdefault();
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        int n8;
        int n9;
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException("Width (" + n4 + ") and height (" + n5 + ") must be > 0");
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        if (n3 < 0) {
            n9 = -n3;
            if (n9 >= n5) {
                return;
            }
            n6 += n7 * n9;
            n3 += n9;
            n5 -= n9;
        }
        if (n3 + n5 > this.height && (n5 = this.height - n3) <= 0) {
            return;
        }
        if (n2 < 0) {
            n9 = -n2;
            if (n9 >= n4) {
                return;
            }
            n6 += n9;
            n2 += n9;
            n4 -= n9;
        }
        if (n2 + n4 > this.width && (n4 = this.width - n2) <= 0) {
            return;
        }
        n9 = n3 * this.width + n2;
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.width * this.height];
                this.model = colorModel;
            } else if (this.model != colorModel) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                for (n8 = n5; n8 > 0; --n8) {
                    System.arraycopy(byArray, n6, this.bytePixels, n9, n4);
                    n6 += n7;
                    n9 += this.width;
                }
            }
        }
        if (this.intPixels != null) {
            n8 = this.width - n4;
            int n10 = n7 - n4;
            for (int i2 = n5; i2 > 0; --i2) {
                for (int i3 = n4; i3 > 0; --i3) {
                    this.intPixels[n9++] = colorModel.getRGB(byArray[n6++] & 0xFF);
                }
                n6 += n10;
                n9 += n8;
            }
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        int n8;
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException("Width (" + n4 + ") and height (" + n5 + ") must be > 0");
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        if (n3 < 0) {
            n8 = -n3;
            if (n8 >= n5) {
                return;
            }
            n6 += n7 * n8;
            n3 += n8;
            n5 -= n8;
        }
        if (n3 + n5 > this.height && (n5 = this.height - n3) <= 0) {
            return;
        }
        if (n2 < 0) {
            n8 = -n2;
            if (n8 >= n4) {
                return;
            }
            n6 += n8;
            n2 += n8;
            n4 -= n8;
        }
        if (n2 + n4 > this.width && (n4 = this.width - n2) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.width * this.height];
                this.model = colorModel;
            } else {
                this.convertToRGB();
            }
        }
        n8 = n3 * this.width + n2;
        if (this.model == colorModel) {
            for (int i2 = n5; i2 > 0; --i2) {
                System.arraycopy(nArray, n6, this.intPixels, n8, n4);
                n6 += n7;
                n8 += this.width;
            }
        } else {
            if (this.model != ColorModel.getRGBdefault()) {
                this.convertToRGB();
            }
            int n9 = this.width - n4;
            int n10 = n7 - n4;
            for (int i3 = n5; i3 > 0; --i3) {
                for (int i4 = n4; i4 > 0; --i4) {
                    this.intPixels[n8++] = colorModel.getRGB(nArray[n6++]);
                }
                n6 += n10;
                n8 += n9;
            }
        }
    }

    public void imageComplete(int n2) {
        switch (n2) {
            case 1: 
            case 4: {
                this.model = null;
                this.width = -1;
                this.height = -1;
                this.intPixels = null;
                this.bytePixels = null;
                break;
            }
            case 2: 
            case 3: {
                Object object;
                Object object2;
                WritableRaster writableRaster;
                if (this.width <= 0 || this.height <= 0) break;
                if (this.model instanceof DirectColorModel) {
                    if (this.intPixels == null) break;
                    writableRaster = this.createDCMraster();
                } else if (this.model instanceof IndexColorModel) {
                    object2 = new int[]{0};
                    if (this.bytePixels == null) break;
                    object = new DataBufferByte(this.bytePixels, this.width * this.height);
                    writableRaster = Raster.createInterleavedRaster((DataBuffer)object, this.width, this.height, this.width, 1, (int[])object2, null);
                } else {
                    this.convertToRGB();
                    if (this.intPixels == null) break;
                    writableRaster = this.createDCMraster();
                }
                object2 = new BufferedImage(this.model, writableRaster, this.model.isAlphaPremultiplied(), null);
                object2 = this.bufferedImageOp.filter((BufferedImage)object2, null);
                object = ((BufferedImage)object2).getRaster();
                ColorModel colorModel = ((BufferedImage)object2).getColorModel();
                int n3 = ((Raster)object).getWidth();
                int n4 = ((Raster)object).getHeight();
                this.consumer.setDimensions(n3, n4);
                this.consumer.setColorModel(colorModel);
                if (colorModel instanceof DirectColorModel) {
                    DataBufferInt dataBufferInt = (DataBufferInt)((Raster)object).getDataBuffer();
                    this.consumer.setPixels(0, 0, n3, n4, colorModel, dataBufferInt.getData(), 0, n3);
                    break;
                }
                if (colorModel instanceof IndexColorModel) {
                    DataBufferByte dataBufferByte = (DataBufferByte)((Raster)object).getDataBuffer();
                    this.consumer.setPixels(0, 0, n3, n4, colorModel, dataBufferByte.getData(), 0, n3);
                    break;
                }
                throw new InternalError("Unknown color model " + colorModel);
            }
        }
        this.consumer.imageComplete(n2);
    }

    private final WritableRaster createDCMraster() {
        DirectColorModel directColorModel = (DirectColorModel)this.model;
        boolean bl2 = this.model.hasAlpha();
        int[] nArray = new int[3 + (bl2 ? 1 : 0)];
        nArray[0] = directColorModel.getRedMask();
        nArray[1] = directColorModel.getGreenMask();
        nArray[2] = directColorModel.getBlueMask();
        if (bl2) {
            nArray[3] = directColorModel.getAlphaMask();
        }
        DataBufferInt dataBufferInt = new DataBufferInt(this.intPixels, this.width * this.height);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, this.width, this.height, this.width, nArray, null);
        return writableRaster;
    }
}

