/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextJustifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.Map;
import sun.font.BidiUtils;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.FontResolver;
import sun.font.GraphicComponent;
import sun.font.TextLabelFactory;
import sun.font.TextLineComponent;
import sun.text.CodePointIterator;

final class TextLine {
    private TextLineComponent[] fComponents;
    private float[] fBaselineOffsets;
    private int[] fComponentVisualOrder;
    private float[] locs;
    private char[] fChars;
    private int fCharsStart;
    private int fCharsLimit;
    private int[] fCharVisualOrder;
    private int[] fCharLogicalOrder;
    private byte[] fCharLevels;
    private boolean fIsDirectionLTR;
    private TextLineMetrics fMetrics = null;
    private static Function fgPosAdvF = new Function(){

        float computeFunction(TextLine textLine, int n2, int n3) {
            TextLineComponent textLineComponent = textLine.fComponents[n2];
            int n4 = textLine.fComponentVisualOrder == null ? n2 : textLine.fComponentVisualOrder[n2];
            return textLine.locs[n4 * 2] + textLineComponent.getCharX(n3) + textLineComponent.getCharAdvance(n3);
        }
    };
    private static Function fgAdvanceF = new Function(){

        float computeFunction(TextLine textLine, int n2, int n3) {
            TextLineComponent textLineComponent = textLine.fComponents[n2];
            return textLineComponent.getCharAdvance(n3);
        }
    };
    private static Function fgXPositionF = new Function(){

        float computeFunction(TextLine textLine, int n2, int n3) {
            int n4 = textLine.fComponentVisualOrder == null ? n2 : textLine.fComponentVisualOrder[n2];
            TextLineComponent textLineComponent = textLine.fComponents[n2];
            return textLine.locs[n4 * 2] + textLineComponent.getCharX(n3);
        }
    };
    private static Function fgYPositionF = new Function(){

        float computeFunction(TextLine textLine, int n2, int n3) {
            TextLineComponent textLineComponent = textLine.fComponents[n2];
            float f2 = textLineComponent.getCharY(n3);
            return f2 + textLine.getComponentShift(n2);
        }
    };

    public TextLine(TextLineComponent[] textLineComponentArray, float[] fArray, char[] cArray, int n2, int n3, int[] nArray, byte[] byArray, boolean bl2) {
        int[] nArray2 = TextLine.computeComponentOrder(textLineComponentArray, nArray);
        this.fComponents = textLineComponentArray;
        this.fBaselineOffsets = fArray;
        this.fComponentVisualOrder = nArray2;
        this.fChars = cArray;
        this.fCharsStart = n2;
        this.fCharsLimit = n3;
        this.fCharLogicalOrder = nArray;
        this.fCharLevels = byArray;
        this.fIsDirectionLTR = bl2;
        this.checkCtorArgs();
        this.init();
    }

    private void checkCtorArgs() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fComponents.length; ++i2) {
            n2 += this.fComponents[i2].getNumCharacters();
        }
        if (n2 != this.characterCount()) {
            throw new IllegalArgumentException("Invalid TextLine!  char count is different from sum of char counts of components.");
        }
    }

    private void init() {
        TextLineComponent textLineComponent;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.fComponents.length; ++i2) {
            float f8;
            float f9;
            textLineComponent = this.fComponents[i2];
            CoreMetrics coreMetrics = textLineComponent.getCoreMetrics();
            byte by = (byte)coreMetrics.baselineIndex;
            if (by >= 0) {
                f9 = this.fBaselineOffsets[by];
                f2 = Math.max(f2, -f9 + coreMetrics.ascent);
                f8 = f9 + coreMetrics.descent;
                f3 = Math.max(f3, f8);
                f4 = Math.max(f4, f8 + coreMetrics.leading);
                continue;
            }
            bl2 = true;
            f9 = coreMetrics.ascent + coreMetrics.descent;
            f8 = f9 + coreMetrics.leading;
            f6 = Math.max(f6, f9);
            f7 = Math.max(f7, f8);
        }
        if (bl2) {
            if (f6 > f2 + f3) {
                f3 = f6 - f2;
            }
            if (f7 > f2 + f4) {
                f4 = f7 - f2;
            }
        }
        f4 -= f3;
        if (bl2) {
            this.fBaselineOffsets = new float[]{this.fBaselineOffsets[0], this.fBaselineOffsets[1], this.fBaselineOffsets[2], f3, -f2};
        }
        float f10 = 0.0f;
        float f11 = 0.0f;
        CoreMetrics coreMetrics = null;
        this.locs = new float[this.fComponents.length * 2 + 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.fComponents.length) {
            int n4 = this.fComponentVisualOrder == null ? n2 : this.fComponentVisualOrder[n2];
            textLineComponent = this.fComponents[n4];
            CoreMetrics coreMetrics2 = textLineComponent.getCoreMetrics();
            if (!(coreMetrics == null || coreMetrics.italicAngle == 0.0f && coreMetrics2.italicAngle == 0.0f || coreMetrics.italicAngle == coreMetrics2.italicAngle && coreMetrics.baselineIndex == coreMetrics2.baselineIndex && coreMetrics.ssOffset == coreMetrics2.ssOffset)) {
                float f12 = coreMetrics.effectiveBaselineOffset(this.fBaselineOffsets);
                float f13 = f12 - coreMetrics.ascent;
                float f14 = f12 + coreMetrics.descent;
                f12 += coreMetrics.ssOffset;
                float f15 = coreMetrics2.effectiveBaselineOffset(this.fBaselineOffsets);
                float f16 = f15 - coreMetrics2.ascent;
                float f17 = f15 + coreMetrics2.descent;
                float f18 = Math.max(f13, f16);
                float f19 = Math.min(f14, f17);
                float f20 = coreMetrics.italicAngle * (f12 - f18);
                float f21 = coreMetrics.italicAngle * (f12 - f19);
                float f22 = coreMetrics2.italicAngle * ((f15 += coreMetrics2.ssOffset) - f18);
                float f23 = coreMetrics2.italicAngle * (f15 - f19);
                float f24 = f20 - f22;
                float f25 = f21 - f23;
                float f26 = Math.max(f24, f25);
                f10 += f26;
                f11 = f15;
            } else {
                f11 = coreMetrics2.effectiveBaselineOffset(this.fBaselineOffsets) + coreMetrics2.ssOffset;
            }
            this.locs[n3] = f10;
            this.locs[n3 + 1] = f11;
            f10 += textLineComponent.getAdvance();
            coreMetrics = coreMetrics2;
            ++n2;
            n3 += 2;
        }
        if (coreMetrics.italicAngle != 0.0f) {
            float f27 = coreMetrics.effectiveBaselineOffset(this.fBaselineOffsets);
            float f28 = f27 - coreMetrics.ascent;
            float f29 = f27 + coreMetrics.descent;
            float f30 = coreMetrics.italicAngle > 0.0f ? f27 + coreMetrics.ascent : (f27 += coreMetrics.ssOffset) - coreMetrics.descent;
            f10 += (f30 *= coreMetrics.italicAngle);
        }
        this.locs[this.locs.length - 2] = f10;
        f5 = f10;
        this.fMetrics = new TextLineMetrics(f2, f3, f4, f5);
    }

    public int characterCount() {
        return this.fCharsLimit - this.fCharsStart;
    }

    public boolean isDirectionLTR() {
        return this.fIsDirectionLTR;
    }

    public TextLineMetrics getMetrics() {
        return this.fMetrics;
    }

    public int visualToLogical(int n2) {
        if (this.fCharLogicalOrder == null) {
            return n2;
        }
        if (this.fCharVisualOrder == null) {
            this.fCharVisualOrder = BidiUtils.createInverseMap(this.fCharLogicalOrder);
        }
        return this.fCharVisualOrder[n2];
    }

    public int logicalToVisual(int n2) {
        return this.fCharLogicalOrder == null ? n2 : this.fCharLogicalOrder[n2];
    }

    public byte getCharLevel(int n2) {
        return this.fCharLevels == null ? (byte)0 : this.fCharLevels[n2];
    }

    public boolean isCharLTR(int n2) {
        return (this.getCharLevel(n2) & 1) == 0;
    }

    public int getCharType(int n2) {
        return Character.getType(this.fChars[n2 + this.fCharsStart]);
    }

    public boolean isCharSpace(int n2) {
        return Character.isSpaceChar(this.fChars[n2 + this.fCharsStart]);
    }

    public boolean isCharWhitespace(int n2) {
        return Character.isWhitespace(this.fChars[n2 + this.fCharsStart]);
    }

    public float getCharAngle(int n2) {
        return this.getCoreMetricsAt((int)n2).italicAngle;
    }

    public CoreMetrics getCoreMetricsAt(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n2 > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n5 += this.fComponents[n3].getNumCharacters()) <= n2) {
            n4 = n5;
            if (++n3 < this.fComponents.length) continue;
        }
        return this.fComponents[n3].getCoreMetrics();
    }

    public float getCharAscent(int n2) {
        return this.getCoreMetricsAt((int)n2).ascent;
    }

    public float getCharDescent(int n2) {
        return this.getCoreMetricsAt((int)n2).descent;
    }

    public float getCharShift(int n2) {
        return this.getCoreMetricsAt((int)n2).ssOffset;
    }

    private float applyFunctionAtIndex(int n2, Function function) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.fComponents.length; ++i2) {
            int n4 = n3 + this.fComponents[i2].getNumCharacters();
            if (n4 > n2) {
                return function.computeFunction(this, i2, n2 - n3);
            }
            n3 = n4;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public float getCharAdvance(int n2) {
        return this.applyFunctionAtIndex(n2, fgAdvanceF);
    }

    public float getCharXPosition(int n2) {
        return this.applyFunctionAtIndex(n2, fgXPositionF);
    }

    public float getCharYPosition(int n2) {
        return this.applyFunctionAtIndex(n2, fgYPositionF);
    }

    public float getCharLinePosition(int n2) {
        return this.getCharXPosition(n2);
    }

    public float getCharLinePosition(int n2, boolean bl2) {
        Function function = this.isCharLTR(n2) == bl2 ? fgXPositionF : fgPosAdvF;
        return this.applyFunctionAtIndex(n2, function);
    }

    public boolean caretAtOffsetIsValid(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative offset.");
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.fComponents.length; ++i2) {
            int n4 = n3 + this.fComponents[i2].getNumCharacters();
            if (n4 > n2) {
                return this.fComponents[i2].caretAtOffsetIsValid(n2 - n3);
            }
            n3 = n4;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public Rectangle2D getCharBounds(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.fComponents.length; ++i2) {
            int n4 = n3 + this.fComponents[i2].getNumCharacters();
            if (n4 > n2) {
                TextLineComponent textLineComponent = this.fComponents[i2];
                int n5 = n2 - n3;
                Rectangle2D rectangle2D = textLineComponent.getCharVisualBounds(n5);
                int n6 = this.fComponentVisualOrder == null ? i2 : this.fComponentVisualOrder[i2];
                rectangle2D.setRect(rectangle2D.getX() + (double)this.locs[n6 * 2], rectangle2D.getY() + (double)this.locs[n6 * 2 + 1], rectangle2D.getWidth(), rectangle2D.getHeight());
                return rectangle2D;
            }
            n3 = n4;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    private float getComponentShift(int n2) {
        CoreMetrics coreMetrics = this.fComponents[n2].getCoreMetrics();
        return coreMetrics.effectiveBaselineOffset(this.fBaselineOffsets);
    }

    public void draw(Graphics2D graphics2D, float f2, float f3) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.fComponents.length) {
            int n4 = this.fComponentVisualOrder == null ? n2 : this.fComponentVisualOrder[n2];
            TextLineComponent textLineComponent = this.fComponents[n4];
            textLineComponent.draw(graphics2D, this.locs[n3] + f2, this.locs[n3 + 1] + f3);
            ++n2;
            n3 += 2;
        }
    }

    public Rectangle2D getBounds() {
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.fComponents.length) {
            int n4 = this.fComponentVisualOrder == null ? n2 : this.fComponentVisualOrder[n2];
            TextLineComponent textLineComponent = this.fComponents[n4];
            Rectangle2D rectangle2D = textLineComponent.getVisualBounds();
            float f6 = this.locs[n3];
            float f7 = this.locs[n3 + 1];
            f2 = Math.min(f2, f6 + (float)rectangle2D.getX());
            f3 = Math.max(f3, f6 + (float)rectangle2D.getMaxX());
            f4 = Math.min(f4, f7 + (float)rectangle2D.getY());
            f5 = Math.max(f5, f7 + (float)rectangle2D.getMaxY());
            ++n2;
            n3 += 2;
        }
        return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
    }

    public Rectangle2D getItalicBounds() {
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.fComponents.length) {
            int n4 = this.fComponentVisualOrder == null ? n2 : this.fComponentVisualOrder[n2];
            TextLineComponent textLineComponent = this.fComponents[n4];
            Rectangle2D rectangle2D = textLineComponent.getItalicBounds();
            float f6 = this.locs[n3];
            float f7 = this.locs[n3 + 1];
            f2 = Math.min(f2, f6 + (float)rectangle2D.getX());
            f3 = Math.max(f3, f6 + (float)rectangle2D.getMaxX());
            f4 = Math.min(f4, f7 + (float)rectangle2D.getY());
            f5 = Math.max(f5, f7 + (float)rectangle2D.getMaxY());
            ++n2;
            n3 += 2;
        }
        return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
    }

    public Shape getOutline(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(1);
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.fComponents.length) {
            int n4 = this.fComponentVisualOrder == null ? n2 : this.fComponentVisualOrder[n2];
            TextLineComponent textLineComponent = this.fComponents[n4];
            generalPath.append(textLineComponent.getOutline(this.locs[n3], this.locs[n3 + 1]), false);
            ++n2;
            n3 += 2;
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public int hashCode() {
        return this.fComponents.length << 16 ^ this.fComponents[0].hashCode() << 3 ^ this.fCharsLimit - this.fCharsStart;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.fComponents.length; ++i2) {
            stringBuffer.append(this.fComponents[i2]);
        }
        return stringBuffer.toString();
    }

    public static TextLine fastCreateTextLine(FontRenderContext fontRenderContext, char[] cArray, Font font, CoreMetrics coreMetrics, Map map) {
        int n2;
        boolean bl2 = true;
        byte[] byArray = null;
        int[] nArray = null;
        Bidi bidi = null;
        int n3 = cArray.length;
        boolean bl3 = false;
        boolean bl4 = false;
        byte[] byArray2 = null;
        if (map != null) {
            Comparable<Boolean> comparable;
            try {
                comparable = (Boolean)map.get(TextAttribute.RUN_DIRECTION);
                if (comparable != null) {
                    bl4 = true;
                    bl2 = TextAttribute.RUN_DIRECTION_LTR.equals(comparable);
                    bl3 = !bl2;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            try {
                comparable = (Integer)map.get(TextAttribute.BIDI_EMBEDDING);
                if (comparable != null && (n2 = ((Integer)comparable).intValue()) >= -61 && n2 < 62) {
                    byte by = (byte)n2;
                    bl3 = true;
                    byArray2 = new byte[n3];
                    for (int i2 = 0; i2 < byArray2.length; ++i2) {
                        byArray2[i2] = by;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (!bl3) {
            bl3 = Bidi.requiresBidi(cArray, 0, cArray.length);
        }
        if (bl3) {
            int n4 = -2;
            if (bl4) {
                n4 = bl2 ? 0 : 1;
            }
            if (!(bidi = new Bidi(cArray, 0, byArray2, 0, cArray.length, n4)).isLeftToRight()) {
                byArray = BidiUtils.getLevels(bidi);
                int[] nArray2 = BidiUtils.createVisualToLogicalMap(byArray);
                nArray = BidiUtils.createInverseMap(nArray2);
                bl2 = bidi.baseIsLeftToRight();
            }
        }
        Decoration decoration = map != null ? Decoration.getDecoration(StyledParagraph.addInputMethodAttrs(map)) : Decoration.getPlainDecoration();
        n2 = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi, n2);
        TextLineComponent[] textLineComponentArray = new TextLineComponent[1];
        textLineComponentArray = TextLine.createComponentsOnRun(0, cArray.length, cArray, nArray, byArray, textLabelFactory, font, coreMetrics, fontRenderContext, decoration, textLineComponentArray, 0);
        int n5 = textLineComponentArray.length;
        while (textLineComponentArray[n5 - 1] == null) {
            --n5;
        }
        if (n5 != textLineComponentArray.length) {
            TextLineComponent[] textLineComponentArray2 = new TextLineComponent[n5];
            System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, n5);
            textLineComponentArray = textLineComponentArray2;
        }
        return new TextLine(textLineComponentArray, coreMetrics.baselineOffsets, cArray, 0, cArray.length, nArray, byArray, bl2);
    }

    private static TextLineComponent[] expandArray(TextLineComponent[] textLineComponentArray) {
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[textLineComponentArray.length + 8];
        System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, textLineComponentArray.length);
        return textLineComponentArray2;
    }

    public static TextLineComponent[] createComponentsOnRun(int n2, int n3, char[] cArray, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory, Font font, CoreMetrics coreMetrics, FontRenderContext fontRenderContext, Decoration decoration, TextLineComponent[] textLineComponentArray, int n4) {
        int n5 = n2;
        do {
            int n6;
            int n7 = TextLine.firstVisualChunk(nArray, byArray, n5, n3);
            do {
                Object object;
                int n8 = n5;
                if (coreMetrics == null) {
                    object = font.getLineMetrics(cArray, n8, n7, fontRenderContext);
                    coreMetrics = CoreMetrics.get((LineMetrics)object);
                    n6 = ((LineMetrics)object).getNumChars();
                } else {
                    n6 = n7 - n8;
                }
                object = textLabelFactory.createExtended(font, coreMetrics, decoration, n8, n8 + n6);
                if (++n4 >= textLineComponentArray.length) {
                    textLineComponentArray = TextLine.expandArray(textLineComponentArray);
                }
                textLineComponentArray[n4 - 1] = object;
            } while ((n5 += n6) < n7);
        } while (n5 < n3);
        return textLineComponentArray;
    }

    public static TextLineComponent[] getComponents(StyledParagraph styledParagraph, char[] cArray, int n2, int n3, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory) {
        TextLineComponent[] textLineComponentArray;
        FontRenderContext fontRenderContext = textLabelFactory.getFontRenderContext();
        int n4 = 0;
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[1];
        int n5 = n2;
        do {
            Object object;
            int n6 = Math.min(styledParagraph.getRunLimit(n5), n3);
            Decoration decoration = styledParagraph.getDecorationAt(n5);
            Object object2 = styledParagraph.getFontOrGraphicAt(n5);
            if (object2 instanceof GraphicAttribute) {
                object = (GraphicAttribute)object2;
                do {
                    int n7 = TextLine.firstVisualChunk(nArray, byArray, n5, n6);
                    GraphicComponent graphicComponent = new GraphicComponent((GraphicAttribute)object, decoration, nArray, byArray, n5, n7);
                    n5 = n7;
                    if (++n4 >= textLineComponentArray2.length) {
                        textLineComponentArray2 = TextLine.expandArray(textLineComponentArray2);
                    }
                    textLineComponentArray2[n4 - 1] = graphicComponent;
                } while (n5 < n6);
                continue;
            }
            object = (Font)object2;
            textLineComponentArray2 = TextLine.createComponentsOnRun(n5, n6, cArray, nArray, byArray, textLabelFactory, (Font)object, null, fontRenderContext, decoration, textLineComponentArray2, n4);
            n5 = n6;
            n4 = textLineComponentArray2.length;
            while (textLineComponentArray2[n4 - 1] == null) {
                --n4;
            }
        } while (n5 < n3);
        if (textLineComponentArray2.length == n4) {
            textLineComponentArray = textLineComponentArray2;
        } else {
            textLineComponentArray = new TextLineComponent[n4];
            System.arraycopy(textLineComponentArray2, 0, textLineComponentArray, 0, n4);
        }
        return textLineComponentArray;
    }

    public static TextLine createLineFromText(char[] cArray, StyledParagraph styledParagraph, TextLabelFactory textLabelFactory, boolean bl2, float[] fArray) {
        Object[] objectArray;
        textLabelFactory.setLineContext(0, cArray.length);
        Bidi bidi = textLabelFactory.getLineBidi();
        int[] nArray = null;
        byte[] byArray = null;
        if (bidi != null) {
            byArray = BidiUtils.getLevels(bidi);
            objectArray = BidiUtils.createVisualToLogicalMap(byArray);
            nArray = BidiUtils.createInverseMap(objectArray);
        }
        objectArray = TextLine.getComponents(styledParagraph, cArray, 0, cArray.length, nArray, byArray, textLabelFactory);
        return new TextLine((TextLineComponent[])objectArray, fArray, cArray, 0, cArray.length, nArray, byArray, bl2);
    }

    private static int[] computeComponentOrder(TextLineComponent[] textLineComponentArray, int[] nArray) {
        int[] nArray2 = null;
        if (nArray != null && textLineComponentArray.length > 1) {
            nArray2 = new int[textLineComponentArray.length];
            int n2 = 0;
            for (int i2 = 0; i2 < textLineComponentArray.length; ++i2) {
                nArray2[i2] = nArray[n2];
                n2 += textLineComponentArray[i2].getNumCharacters();
            }
            nArray2 = BidiUtils.createContiguousOrder(nArray2);
            nArray2 = BidiUtils.createInverseMap(nArray2);
        }
        return nArray2;
    }

    public static TextLine standardCreateTextLine(FontRenderContext fontRenderContext, AttributedCharacterIterator attributedCharacterIterator, char[] cArray, float[] fArray) {
        StyledParagraph styledParagraph = new StyledParagraph(attributedCharacterIterator, cArray);
        Bidi bidi = new Bidi(attributedCharacterIterator);
        if (bidi.isLeftToRight()) {
            bidi = null;
        }
        int n2 = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi, n2);
        boolean bl2 = true;
        if (bidi != null) {
            bl2 = bidi.baseIsLeftToRight();
        }
        return TextLine.createLineFromText(cArray, styledParagraph, textLabelFactory, bl2, fArray);
    }

    static boolean advanceToFirstFont(AttributedCharacterIterator attributedCharacterIterator) {
        char c2 = attributedCharacterIterator.first();
        while (true) {
            if (c2 == '\uffff') break;
            if (attributedCharacterIterator.getAttribute(TextAttribute.CHAR_REPLACEMENT) == null) {
                return true;
            }
            c2 = attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        return false;
    }

    static float[] getNormalizedOffsets(float[] fArray, byte by) {
        if (fArray[by] != 0.0f) {
            float f2 = fArray[by];
            float[] fArray2 = new float[fArray.length];
            for (int i2 = 0; i2 < fArray2.length; ++i2) {
                fArray2[i2] = fArray[i2] - f2;
            }
            fArray = fArray2;
        }
        return fArray;
    }

    static Font getFontAtCurrentPos(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.FONT);
        if (object != null) {
            return (Font)object;
        }
        if (attributedCharacterIterator.getAttribute(TextAttribute.FAMILY) != null) {
            return Font.getFont(attributedCharacterIterator.getAttributes());
        }
        int n2 = CodePointIterator.create(attributedCharacterIterator).next();
        if (n2 != -1) {
            FontResolver fontResolver = FontResolver.getInstance();
            return fontResolver.getFont(fontResolver.getFontIndex(n2), attributedCharacterIterator.getAttributes());
        }
        return null;
    }

    static float getJustifyRatio(Map map) {
        Object v2 = map.get(TextAttribute.JUSTIFICATION);
        if (v2 == null) {
            return 1.0f;
        }
        float f2 = ((Float)v2).floatValue();
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    private static int firstVisualChunk(int[] nArray, byte[] byArray, int n2, int n3) {
        if (nArray != null && byArray != null) {
            byte by = byArray[n2];
            while (++n2 < n3 && byArray[n2] == by) {
            }
            return n2;
        }
        return n3;
    }

    public TextLine getJustifiedLine(float f2, float f3, int n2, int n3) {
        int n4;
        TextLineComponent[] textLineComponentArray = new TextLineComponent[this.fComponents.length];
        System.arraycopy(this.fComponents, 0, textLineComponentArray, 0, this.fComponents.length);
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean bl2 = false;
        block0: do {
            int n5;
            int n6;
            int n7;
            f5 = TextLine.getAdvanceBetween(textLineComponentArray, 0, this.characterCount());
            float f7 = TextLine.getAdvanceBetween(textLineComponentArray, n2, n3);
            f6 = (f2 - f7) * f3;
            int[] nArray = new int[textLineComponentArray.length];
            int n8 = 0;
            for (int i2 = 0; i2 < textLineComponentArray.length; ++i2) {
                n7 = this.fComponentVisualOrder == null ? i2 : this.fComponentVisualOrder[i2];
                nArray[n7] = n8;
                n8 += textLineComponentArray[n7].getNumJustificationInfos();
            }
            GlyphJustificationInfo[] glyphJustificationInfoArray = new GlyphJustificationInfo[n8];
            n7 = 0;
            for (n6 = 0; n6 < textLineComponentArray.length; ++n6) {
                TextLineComponent textLineComponent = textLineComponentArray[n6];
                int n9 = textLineComponent.getNumCharacters();
                int n10 = n7 + n9;
                if (n10 <= n2) continue;
                n5 = Math.max(0, n2 - n7);
                n4 = Math.min(n9, n3 - n7);
                textLineComponent.getJustificationInfos(glyphJustificationInfoArray, nArray[n6], n5, n4);
                if (n10 >= n3) break;
            }
            int n11 = n8;
            for (n6 = 0; n6 < n11 && glyphJustificationInfoArray[n6] == null; ++n6) {
            }
            while (n11 > n6 && glyphJustificationInfoArray[n11 - 1] == null) {
                --n11;
            }
            TextJustifier textJustifier = new TextJustifier(glyphJustificationInfoArray, n6, n11);
            float[] fArray = textJustifier.justify(f6);
            n5 = !bl2 ? 1 : 0;
            n4 = 0;
            boolean[] blArray = new boolean[1];
            n7 = 0;
            for (int i3 = 0; i3 < textLineComponentArray.length; ++i3) {
                TextLineComponent textLineComponent = textLineComponentArray[i3];
                int n12 = textLineComponent.getNumCharacters();
                int n13 = n7 + n12;
                if (n13 <= n2) continue;
                int n14 = Math.max(0, n2 - n7);
                int n15 = Math.min(n12, n3 - n7);
                textLineComponentArray[i3] = textLineComponent.applyJustificationDeltas(fArray, nArray[i3] * 2, blArray);
                n4 |= blArray[0];
                if (n13 >= n3) continue block0;
            }
        } while (bl2 = n4 != 0 && !bl2);
        return new TextLine(textLineComponentArray, this.fBaselineOffsets, this.fChars, this.fCharsStart, this.fCharsLimit, this.fCharLogicalOrder, this.fCharLevels, this.fIsDirectionLTR);
    }

    public static float getAdvanceBetween(TextLineComponent[] textLineComponentArray, int n2, int n3) {
        float f2 = 0.0f;
        int n4 = 0;
        for (int i2 = 0; i2 < textLineComponentArray.length; ++i2) {
            TextLineComponent textLineComponent = textLineComponentArray[i2];
            int n5 = textLineComponent.getNumCharacters();
            int n6 = n4 + n5;
            if (n6 > n2) {
                int n7 = Math.max(0, n2 - n4);
                int n8 = Math.min(n5, n3 - n4);
                f2 += textLineComponent.getAdvanceBetween(n7, n8);
                if (n6 >= n3) break;
            }
            n4 = n6;
        }
        return f2;
    }

    private static abstract class Function {
        private Function() {
        }

        abstract float computeFunction(TextLine var1, int var2, int var3);
    }

    static final class TextLineMetrics {
        public final float ascent;
        public final float descent;
        public final float leading;
        public final float advance;

        public TextLineMetrics(float f2, float f3, float f4, float f5) {
            this.ascent = f2;
            this.descent = f3;
            this.leading = f4;
            this.advance = f5;
        }
    }
}

