/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.security.util.Password;

public class TextCallbackHandler
implements CallbackHandler {
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        ConfirmationCallback confirmationCallback = null;
        for (int i2 = 0; i2 < callbackArray.length; ++i2) {
            String string;
            Callback callback;
            if (callbackArray[i2] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[i2];
                switch (((TextOutputCallback)callback).getMessageType()) {
                    case 0: {
                        string = "";
                        break;
                    }
                    case 1: {
                        string = "Warning: ";
                        break;
                    }
                    case 2: {
                        string = "Error: ";
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(callbackArray[i2], "Unrecognized message type");
                    }
                }
                String string2 = ((TextOutputCallback)callback).getMessage();
                if (string2 != null) {
                    string = string + string2;
                }
                if (string == null) continue;
                System.err.println(string);
                continue;
            }
            if (callbackArray[i2] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i2];
                if (((NameCallback)callback).getDefaultName() == null) {
                    System.err.print(((NameCallback)callback).getPrompt());
                } else {
                    System.err.print(((NameCallback)callback).getPrompt() + " [" + ((NameCallback)callback).getDefaultName() + "] ");
                }
                System.err.flush();
                string = this.readLine();
                if (string.equals("")) {
                    string = ((NameCallback)callback).getDefaultName();
                }
                ((NameCallback)callback).setName(string);
                continue;
            }
            if (callbackArray[i2] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[i2];
                System.err.print(((PasswordCallback)callback).getPrompt());
                System.err.flush();
                ((PasswordCallback)callback).setPassword(Password.readPassword(System.in));
                continue;
            }
            if (callbackArray[i2] instanceof ConfirmationCallback) {
                confirmationCallback = (ConfirmationCallback)callbackArray[i2];
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i2], "Unrecognized Callback");
        }
        if (confirmationCallback != null) {
            this.doConfirmation(confirmationCallback);
        }
    }

    private String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private void doConfirmation(ConfirmationCallback confirmationCallback) throws IOException, UnsupportedCallbackException {
        int n2;
        class OptionInfo {
            String name;
            int value;

            OptionInfo(String string, int n2) {
                this.name = string;
                this.value = n2;
            }
        }
        OptionInfo[] optionInfoArray;
        String string;
        int n3 = confirmationCallback.getMessageType();
        switch (n3) {
            case 1: {
                string = "Warning: ";
                break;
            }
            case 2: {
                string = "Error: ";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized message type: " + n3);
            }
        }
        int n4 = confirmationCallback.getOptionType();
        switch (n4) {
            case 0: {
                optionInfoArray = new OptionInfo[]{new OptionInfo("Yes", 0), new OptionInfo("No", 1)};
                break;
            }
            case 1: {
                optionInfoArray = new OptionInfo[]{new OptionInfo("Yes", 0), new OptionInfo("No", 1), new OptionInfo("Cancel", 2)};
                break;
            }
            case 2: {
                optionInfoArray = new OptionInfo[]{new OptionInfo("OK", 3), new OptionInfo("Cancel", 2)};
                break;
            }
            case -1: {
                String[] stringArray = confirmationCallback.getOptions();
                optionInfoArray = new OptionInfo[stringArray.length];
                for (int i2 = 0; i2 < optionInfoArray.length; ++i2) {
                    optionInfoArray[i2].value = i2;
                }
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized option type: " + n4);
            }
        }
        int n5 = confirmationCallback.getDefaultOption();
        String string2 = confirmationCallback.getPrompt();
        if (string2 == null) {
            string2 = "";
        }
        if (!(string2 = string + string2).equals("")) {
            System.err.println(string2);
        }
        for (n2 = 0; n2 < optionInfoArray.length; ++n2) {
            if (n4 == -1) {
                System.err.println(n2 + ". " + optionInfoArray[n2].name + (n2 == n5 ? " [default]" : ""));
                continue;
            }
            System.err.println(n2 + ". " + optionInfoArray[n2].name + (optionInfoArray[n2].value == n5 ? " [default]" : ""));
        }
        System.err.print("Enter a number: ");
        System.err.flush();
        try {
            n2 = Integer.parseInt(this.readLine());
            if (n2 < 0 || n2 > optionInfoArray.length - 1) {
                n2 = n5;
            }
            n2 = optionInfoArray[n2].value;
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n5;
        }
        confirmationCallback.setSelectedIndex(n2);
    }
}

