/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.NamedAndTyped;
import com.sun.org.apache.bcel.internal.generic.Type;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;

    public LocalVariableGen(int n2, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (n2 < 0 || n2 > 65535) {
            throw new ClassGenException("Invalid index index: " + n2);
        }
        this.name = string;
        this.type = type;
        this.index = n2;
        this.setStart(instructionHandle);
        this.setEnd(instructionHandle2);
    }

    public LocalVariable getLocalVariable(ConstantPoolGen constantPoolGen) {
        int n2 = this.start.getPosition();
        int n3 = this.end.getPosition() - n2;
        int n4 = constantPoolGen.addUtf8(this.name);
        int n5 = constantPoolGen.addUtf8(this.type.getSignature());
        return new LocalVariable(n2, n3, n4, n5, this.index, constantPoolGen.getConstantPool());
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public void setStart(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.start, instructionHandle, this);
        this.start = instructionHandle;
    }

    public void setEnd(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.end, instructionHandle, this);
        this.end = instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl2 = false;
        if (this.start == instructionHandle) {
            bl2 = true;
            this.setStart(instructionHandle2);
        }
        if (this.end == instructionHandle) {
            bl2 = true;
            this.setEnd(instructionHandle2);
        }
        if (!bl2) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start == instructionHandle || this.end == instructionHandle;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen localVariableGen = (LocalVariableGen)object;
        return localVariableGen.index == this.index && localVariableGen.start == this.start && localVariableGen.end == this.end;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }
}

