/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import java.util.Arrays;
import java.util.Collection;

class Code
extends Attribute.Holder
implements Constants {
    Package.Class.Method m;
    private static final ConstantPool.Entry[] noRefs = ConstantPool.noRefs;
    int max_stack;
    int max_locals;
    ConstantPool.Entry[] handler_class = noRefs;
    int[] handler_start = noInts;
    int[] handler_end = noInts;
    int[] handler_catch = noInts;
    byte[] bytes;
    Fixups fixups;
    Object insnMap;
    static final boolean shrinkMaps = true;

    public Code(Package.Class.Method method) {
        this.m = method;
    }

    public Package.Class.Method getMethod() {
        return this.m;
    }

    public Package.Class thisClass() {
        return this.m.thisClass();
    }

    public Package getPackage() {
        return this.m.thisClass().getPackage();
    }

    public ConstantPool.Entry[] getCPMap() {
        return this.m.getCPMap();
    }

    int getLength() {
        return this.bytes.length;
    }

    int getMaxStack() {
        return this.max_stack;
    }

    void setMaxStack(int n2) {
        this.max_stack = n2;
    }

    int getMaxNALocals() {
        int n2 = this.m.getArgumentSize();
        return this.max_locals - n2;
    }

    void setMaxNALocals(int n2) {
        int n3 = this.m.getArgumentSize();
        this.max_locals = n3 + n2;
    }

    int getHandlerCount() {
        assert (this.handler_class.length == this.handler_start.length);
        assert (this.handler_class.length == this.handler_end.length);
        assert (this.handler_class.length == this.handler_catch.length);
        return this.handler_class.length;
    }

    void setHandlerCount(int n2) {
        if (n2 > 0) {
            this.handler_class = new ConstantPool.Entry[n2];
            this.handler_start = new int[n2];
            this.handler_end = new int[n2];
            this.handler_catch = new int[n2];
        }
    }

    void setBytes(byte[] byArray) {
        this.bytes = byArray;
        if (this.fixups != null) {
            this.fixups.setBytes(byArray);
        }
    }

    void setInstructionMap(int[] nArray, int n2) {
        this.insnMap = this.allocateInstructionMap(nArray, n2);
    }

    void setInstructionMap(int[] nArray) {
        this.setInstructionMap(nArray, nArray.length);
    }

    int[] getInstructionMap() {
        return this.expandInstructionMap(this.getInsnMap());
    }

    void addFixups(Collection collection) {
        if (this.fixups == null) {
            this.fixups = new Fixups(this.bytes);
        }
        assert (this.fixups.getBytes() == this.bytes);
        this.fixups.addAll(collection);
    }

    public void trimToSize() {
        if (this.fixups != null) {
            this.fixups.trimToSize();
            if (this.fixups.size() == 0) {
                this.fixups = null;
            }
        }
        super.trimToSize();
    }

    protected void visitRefs(int n2, Collection collection) {
        int n3 = this.getPackage().verbose;
        if (n3 > 2) {
            System.out.println("Reference scan " + this);
        }
        Package.Class clazz = this.thisClass();
        Package package_ = clazz.getPackage();
        for (int i2 = 0; i2 < this.handler_class.length; ++i2) {
            collection.add(this.handler_class[i2]);
        }
        if (this.fixups != null) {
            this.fixups.visitRefs(collection);
        } else {
            ConstantPool.Entry[] entryArray = this.getCPMap();
            for (Instruction instruction = this.instructionAt(0); instruction != null; instruction = instruction.next()) {
                int n4;
                if (n3 > 4) {
                    System.out.println(instruction);
                }
                if ((n4 = instruction.getCPIndex()) < 0) continue;
                collection.add(entryArray[n4]);
            }
        }
        super.visitRefs(n2, collection);
    }

    private Object allocateInstructionMap(int[] nArray, int n2) {
        int n3 = this.getLength();
        if (n3 <= 255) {
            byte[] byArray = new byte[n2 + 1];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = (byte)(nArray[i2] + -128);
            }
            byArray[n2] = (byte)(n3 + -128);
            return byArray;
        }
        if (n3 < 65535) {
            short[] sArray = new short[n2 + 1];
            for (int i3 = 0; i3 < n2; ++i3) {
                sArray[i3] = (short)(nArray[i3] + Short.MIN_VALUE);
            }
            sArray[n2] = (short)(n3 + Short.MIN_VALUE);
            return sArray;
        }
        int[] nArray2 = new int[n2 + 1];
        for (int i4 = 0; i4 < n2; ++i4) {
            nArray2[i4] = nArray[i4];
        }
        nArray2[n2] = n3;
        return nArray2;
    }

    private int[] expandInstructionMap(Object object) {
        int[] nArray;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            nArray = new int[byArray.length - 1];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = byArray[i2] - -128;
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            nArray = new int[sArray.length - 1];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray[i3] = sArray[i3] - -128;
            }
        } else {
            int[] nArray2 = (int[])object;
            nArray = new int[nArray2.length - 1];
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                nArray[i4] = nArray2[i4];
            }
        }
        return nArray;
    }

    Object getInsnMap() {
        if (this.insnMap != null) {
            return this.insnMap;
        }
        int[] nArray = new int[this.getLength()];
        int n2 = 0;
        for (Instruction instruction = this.instructionAt(0); instruction != null; instruction = instruction.next()) {
            nArray[n2++] = instruction.getPC();
        }
        this.insnMap = this.allocateInstructionMap(nArray, n2);
        return this.insnMap;
    }

    public int encodeBCI(int n2) {
        int n3;
        int n4;
        if (n2 <= 0 || n2 > this.getLength()) {
            return n2;
        }
        Object object = this.getInsnMap();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            n4 = byArray.length;
            n3 = Arrays.binarySearch(byArray, (byte)(n2 + -128));
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            n4 = sArray.length;
            n3 = Arrays.binarySearch(sArray, (short)(n2 + Short.MIN_VALUE));
        } else {
            int[] nArray = (int[])object;
            n4 = nArray.length;
            n3 = Arrays.binarySearch(nArray, n2);
        }
        assert (n3 != -1);
        assert (n3 != 0);
        assert (n3 != n4);
        assert (n3 != -n4 - 1);
        return n3 >= 0 ? n3 : n4 + n2 - (-n3 - 1);
    }

    public int decodeBCI(int n2) {
        int n3;
        int n4;
        if (n2 <= 0 || n2 > this.getLength()) {
            return n2;
        }
        Object object = this.getInsnMap();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            n4 = byArray.length;
            if (n2 < n4) {
                return byArray[n2] - -128;
            }
            n3 = Arrays.binarySearch(byArray, (byte)(n2 + -128));
            if (n3 < 0) {
                n3 = -n3 - 1;
            }
            int n5 = n2 - n4 + -128;
            while (byArray[n3 - 1] - (n3 - 1) > n5) {
                --n3;
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            n4 = sArray.length;
            if (n2 < n4) {
                return sArray[n2] - Short.MIN_VALUE;
            }
            n3 = Arrays.binarySearch(sArray, (short)(n2 + Short.MIN_VALUE));
            if (n3 < 0) {
                n3 = -n3 - 1;
            }
            int n6 = n2 - n4 + Short.MIN_VALUE;
            while (sArray[n3 - 1] - (n3 - 1) > n6) {
                --n3;
            }
        } else {
            int[] nArray = (int[])object;
            n4 = nArray.length;
            if (n2 < n4) {
                return nArray[n2];
            }
            n3 = Arrays.binarySearch(nArray, n2);
            if (n3 < 0) {
                n3 = -n3 - 1;
            }
            int n7 = n2 - n4;
            while (nArray[n3 - 1] - (n3 - 1) > n7) {
                --n3;
            }
        }
        return n2 - n4 + n3;
    }

    public void finishRefs(ConstantPool.Index index) {
        if (this.fixups != null) {
            this.fixups.finishRefs(index);
            this.fixups = null;
        }
    }

    Instruction instructionAt(int n2) {
        return Instruction.at(this.bytes, n2);
    }

    static boolean flagsRequireCode(int n2) {
        return (n2 & 0x500) == 0;
    }

    public String toString() {
        return this.m + ".Code";
    }

    public int getInt(int n2) {
        return Instruction.getInt(this.bytes, n2);
    }

    public int getShort(int n2) {
        return Instruction.getShort(this.bytes, n2);
    }

    public int getByte(int n2) {
        return Instruction.getByte(this.bytes, n2);
    }

    void setInt(int n2, int n3) {
        Instruction.setInt(this.bytes, n2, n3);
    }

    void setShort(int n2, int n3) {
        Instruction.setShort(this.bytes, n2, n3);
    }

    void setByte(int n2, int n3) {
        Instruction.setByte(this.bytes, n2, n3);
    }
}

