/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SOFMarkerSegment
extends MarkerSegment {
    int samplePrecision;
    int numLines;
    int samplesPerLine;
    ComponentSpec[] componentSpecs;

    SOFMarkerSegment(boolean bl2, boolean bl3, boolean bl4, byte[] byArray, int n2) {
        super(bl2 ? 194 : (bl3 ? 193 : 192));
        this.samplePrecision = 8;
        this.numLines = 0;
        this.samplesPerLine = 0;
        this.componentSpecs = new ComponentSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 1;
            int n4 = 0;
            if (bl4) {
                n3 = 2;
                if (i2 == 1 || i2 == 2) {
                    n3 = 1;
                    n4 = 1;
                }
            }
            this.componentSpecs[i2] = new ComponentSpec(byArray[i2], n3, n4);
        }
    }

    SOFMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        this.samplePrecision = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.numLines = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.numLines |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.samplesPerLine = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.samplesPerLine |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        int n2 = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.componentSpecs = new ComponentSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.componentSpecs[i2] = new ComponentSpec(jPEGBuffer);
        }
        jPEGBuffer.bufAvail -= this.length;
    }

    SOFMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(192);
        this.samplePrecision = 8;
        this.numLines = 0;
        this.samplesPerLine = 0;
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)super.clone();
        if (this.componentSpecs != null) {
            sOFMarkerSegment.componentSpecs = (ComponentSpec[])this.componentSpecs.clone();
            for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
                sOFMarkerSegment.componentSpecs[i2] = (ComponentSpec)this.componentSpecs[i2].clone();
            }
        }
        return sOFMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("sof");
        iIOMetadataNode.setAttribute("process", Integer.toString(this.tag - 192));
        iIOMetadataNode.setAttribute("samplePrecision", Integer.toString(this.samplePrecision));
        iIOMetadataNode.setAttribute("numLines", Integer.toString(this.numLines));
        iIOMetadataNode.setAttribute("samplesPerLine", Integer.toString(this.samplesPerLine));
        iIOMetadataNode.setAttribute("numFrameComponents", Integer.toString(this.componentSpecs.length));
        for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
            iIOMetadataNode.appendChild(this.componentSpecs[i2].getNativeNode());
        }
        return iIOMetadataNode;
    }

    void updateFromNativeNode(Node node, boolean bl2) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = SOFMarkerSegment.getAttributeValue(node, namedNodeMap, "process", 0, 2, false);
        this.tag = n2 != -1 ? n2 + 192 : this.tag;
        n2 = SOFMarkerSegment.getAttributeValue(node, namedNodeMap, "samplePrecision", 8, 8, false);
        n2 = SOFMarkerSegment.getAttributeValue(node, namedNodeMap, "numLines", 0, 65535, false);
        this.numLines = n2 != -1 ? n2 : this.numLines;
        n2 = SOFMarkerSegment.getAttributeValue(node, namedNodeMap, "samplesPerLine", 0, 65535, false);
        this.samplesPerLine = n2 != -1 ? n2 : this.samplesPerLine;
        int n3 = SOFMarkerSegment.getAttributeValue(node, namedNodeMap, "numFrameComponents", 1, 4, false);
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() != n3) {
            throw new IIOInvalidTreeException("numFrameComponents must match number of children", node);
        }
        this.componentSpecs = new ComponentSpec[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.componentSpecs[i2] = new ComponentSpec(nodeList.item(i2));
        }
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("SOF");
        System.out.print("Sample precision: ");
        System.out.println(this.samplePrecision);
        System.out.print("Number of lines: ");
        System.out.println(this.numLines);
        System.out.print("Samples per line: ");
        System.out.println(this.samplesPerLine);
        System.out.print("Number of components: ");
        System.out.println(this.componentSpecs.length);
        for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
            this.componentSpecs[i2].print();
        }
    }

    int getIDencodedCSType() {
        for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
            if (this.componentSpecs[i2].componentId >= 65) continue;
            return 0;
        }
        switch (this.componentSpecs.length) {
            case 3: {
                if (this.componentSpecs[0].componentId == 82 && this.componentSpecs[0].componentId == 71 && this.componentSpecs[0].componentId == 66) {
                    return 2;
                }
                if (this.componentSpecs[0].componentId != 89 || this.componentSpecs[0].componentId != 67 || this.componentSpecs[0].componentId != 99) break;
                return 5;
            }
            case 4: {
                if (this.componentSpecs[0].componentId == 82 && this.componentSpecs[0].componentId == 71 && this.componentSpecs[0].componentId == 66 && this.componentSpecs[0].componentId == 65) {
                    return 6;
                }
                if (this.componentSpecs[0].componentId != 89 || this.componentSpecs[0].componentId != 67 || this.componentSpecs[0].componentId != 99 || this.componentSpecs[0].componentId != 65) break;
                return 10;
            }
        }
        return 0;
    }

    ComponentSpec getComponentSpec(byte by, int n2, int n3) {
        return new ComponentSpec(by, n2, n3);
    }

    class ComponentSpec
    implements Cloneable {
        int componentId;
        int HsamplingFactor;
        int VsamplingFactor;
        int QtableSelector;

        ComponentSpec(byte by, int n2, int n3) {
            this.componentId = by;
            this.HsamplingFactor = n2;
            this.VsamplingFactor = n2;
            this.QtableSelector = n3;
        }

        ComponentSpec(JPEGBuffer jPEGBuffer) {
            this.componentId = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
            this.HsamplingFactor = jPEGBuffer.buf[jPEGBuffer.bufPtr] >>> 4;
            this.VsamplingFactor = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
            this.QtableSelector = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        }

        ComponentSpec(Node node) throws IIOInvalidTreeException {
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.componentId = MarkerSegment.getAttributeValue(node, namedNodeMap, "componentId", 0, 255, true);
            this.HsamplingFactor = MarkerSegment.getAttributeValue(node, namedNodeMap, "HsamplingFactor", 1, 255, true);
            this.VsamplingFactor = MarkerSegment.getAttributeValue(node, namedNodeMap, "VsamplingFactor", 1, 255, true);
            this.QtableSelector = MarkerSegment.getAttributeValue(node, namedNodeMap, "QtableSelector", 0, 3, true);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("componentSpec");
            iIOMetadataNode.setAttribute("componentId", Integer.toString(this.componentId));
            iIOMetadataNode.setAttribute("HsamplingFactor", Integer.toString(this.HsamplingFactor));
            iIOMetadataNode.setAttribute("VsamplingFactor", Integer.toString(this.VsamplingFactor));
            iIOMetadataNode.setAttribute("QtableSelector", Integer.toString(this.QtableSelector));
            return iIOMetadataNode;
        }

        void print() {
            System.out.print("Component ID: ");
            System.out.println(this.componentId);
            System.out.print("H sampling factor: ");
            System.out.println(this.HsamplingFactor);
            System.out.print("V sampling factor: ");
            System.out.println(this.VsamplingFactor);
            System.out.print("Q table selector: ");
            System.out.println(this.QtableSelector);
        }
    }
}

