/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPImageWriter;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMPImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.bmp.BMPImageReaderSpi"};
    private static String[] formatNames = new String[]{"bmp", "BMP"};
    private static String[] entensions = new String[]{"bmp"};
    private static String[] mimeType = new String[]{"image/bmp"};
    private boolean registered = false;

    public BMPImageWriterSpi() {
        super("Sun Microsystems, Inc.", "1.0", formatNames, entensions, mimeType, "com.sun.imageio.plugins.bmp.BMPImageWriter", STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_bmp_1.0", "com.sun.imageio.plugins.bmp.BMPMetadataFormat", null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Standard BMP Image Writer";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        int n2 = imageTypeSpecifier.getSampleModel().getDataType();
        if (n2 < 0 || n2 > 3) {
            return false;
        }
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int n3 = sampleModel.getNumBands();
        if (n3 != 1 && n3 != 3) {
            return false;
        }
        if (n3 == 1 && n2 != 0) {
            return false;
        }
        return n2 <= 0 || sampleModel instanceof SinglePixelPackedSampleModel;
    }

    @Override
    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new BMPImageWriter(this);
    }
}

