/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.servicecontext;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContextData;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;

public class ServiceContextRegistry {
    private ORB orb;
    private Vector scCollection = new Vector();

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public ServiceContextRegistry(ORB oRB) {
        this.orb = oRB;
    }

    public void register(Class clazz) {
        ServiceContextData serviceContextData;
        if (ORB.ORBInitDebug) {
            this.dprint("Registering service context class " + clazz);
        }
        if (this.findServiceContextData((serviceContextData = new ServiceContextData(clazz)).getId()) != null) {
            throw new BAD_PARAM("Tried to register duplicate service context");
        }
        this.scCollection.addElement(serviceContextData);
    }

    public ServiceContextData findServiceContextData(int n2) {
        if (ORB.ORBInitDebug) {
            this.dprint("Searching registry for service context id " + n2);
        }
        Enumeration enumeration = this.scCollection.elements();
        while (enumeration.hasMoreElements()) {
            ServiceContextData serviceContextData = (ServiceContextData)enumeration.nextElement();
            if (serviceContextData.getId() != n2) continue;
            if (ORB.ORBInitDebug) {
                this.dprint("Service context data found: " + serviceContextData);
            }
            return serviceContextData;
        }
        if (ORB.ORBInitDebug) {
            this.dprint("Service context data not found");
        }
        return null;
    }
}

