/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class LogWrapperBase {
    protected Logger logger;
    protected String loggerName;

    protected LogWrapperBase(Logger logger) {
        this.logger = logger;
        this.loggerName = logger.getName();
    }

    protected void doLog(Level level, String string, Object[] objectArray, Class clazz, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        this.inferCaller(clazz, logRecord);
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(this.loggerName);
        logRecord.setResourceBundle(this.logger.getResourceBundle());
        this.logger.log(logRecord);
    }

    private void inferCaller(Class clazz, LogRecord logRecord) {
        String string;
        int n2;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StackTraceElement stackTraceElement = null;
        String string2 = clazz.getName();
        String string3 = LogWrapperBase.class.getName();
        for (n2 = 0; n2 < stackTraceElementArray.length && ((string = (stackTraceElement = stackTraceElementArray[n2]).getClassName()).equals(string2) || string.equals(string3)); ++n2) {
        }
        if (n2 < stackTraceElementArray.length) {
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
    }

    protected void doLog(Level level, String string, Class clazz, Throwable throwable) {
        this.doLog(level, string, null, clazz, throwable);
    }
}

