/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.util.Arrays;

public abstract class ObjectWriter {
    protected StringBuffer result = new StringBuffer();

    public static ObjectWriter make(boolean bl2, int n2, int n3) {
        if (bl2) {
            return new IndentingObjectWriter(n2, n3);
        }
        return new SimpleObjectWriter();
    }

    public abstract void startObject(Object var1);

    public abstract void startElement();

    public abstract void endElement();

    public abstract void endObject(String var1);

    public abstract void endObject();

    public String toString() {
        return this.result.toString();
    }

    public void append(boolean bl2) {
        this.result.append(bl2);
    }

    public void append(char c2) {
        this.result.append(c2);
    }

    public void append(short s2) {
        this.result.append(s2);
    }

    public void append(int n2) {
        this.result.append(n2);
    }

    public void append(long l2) {
        this.result.append(l2);
    }

    public void append(float f2) {
        this.result.append(f2);
    }

    public void append(double d2) {
        this.result.append(d2);
    }

    public void append(String string) {
        this.result.append(string);
    }

    protected ObjectWriter() {
    }

    protected void appendObjectHeader(Object object) {
        this.result.append(object.getClass().getName());
        this.result.append("<");
        this.result.append(System.identityHashCode(object));
        this.result.append(">");
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null) {
            this.result.append("[");
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                this.result.append(blArray.length);
                this.result.append("]");
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.result.append(byArray.length);
                this.result.append("]");
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.result.append(sArray.length);
                this.result.append("]");
            } else if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.result.append(nArray.length);
                this.result.append("]");
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.result.append(lArray.length);
                this.result.append("]");
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.result.append(cArray.length);
                this.result.append("]");
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.result.append(fArray.length);
                this.result.append("]");
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.result.append(dArray.length);
                this.result.append("]");
            } else {
                Object[] objectArray = (Object[])object;
                this.result.append(objectArray.length);
                this.result.append("]");
            }
        }
        this.result.append("(");
    }

    private static class IndentingObjectWriter
    extends ObjectWriter {
        private int level;
        private int increment;

        public IndentingObjectWriter(int n2, int n3) {
            this.level = n2;
            this.increment = n3;
            this.startLine();
        }

        private void startLine() {
            char[] cArray = new char[this.level * this.increment];
            Arrays.fill(cArray, ' ');
            this.result.append(cArray);
        }

        public void startObject(Object object) {
            this.appendObjectHeader(object);
            ++this.level;
        }

        public void startElement() {
            this.result.append("\n");
            this.startLine();
        }

        public void endElement() {
        }

        public void endObject(String string) {
            --this.level;
            this.result.append(string);
            this.result.append(")");
        }

        public void endObject() {
            --this.level;
            this.result.append("\n");
            this.startLine();
            this.result.append(")");
        }
    }

    private static class SimpleObjectWriter
    extends ObjectWriter {
        private SimpleObjectWriter() {
        }

        public void startObject(Object object) {
            this.appendObjectHeader(object);
            this.result.append(" ");
        }

        public void startElement() {
            this.result.append(" ");
        }

        public void endObject(String string) {
            this.result.append(string);
            this.result.append(")");
        }

        public void endElement() {
        }

        public void endObject() {
            this.result.append(")");
        }
    }
}

