/************************************************************/
/**
 * open_theme:
 * 
 * @theme: NULL terminated string indicating theme. If NULL is 
 * specified, then the default gtk icon theme for screen is
 * used. 
 * 
 * @size: Size of icons requested. If size > 0, then a disk based
 * hash table will be used where the paths to the best match for that
 * size are cached. If size <= 0, then the cache is not used. Instead,
 * all icon filesizes are saved in memory hash table. The memory hash
 * table can be entered globally or selectively according to the icon
 * context (defined in icon.theme) requested.
 * 
 *
 * Returns: 0 if theme cannot be opened, 1 if theme has been opened, 
 * -1 if theme is already opened (therefore not opened again)
 * 
 **/


int 
open_theme(		gchar *theme,
			int size);

/**
 * close_theme:
 * 
 * Function to be used when open_theme does not specify to use
 * the disk based cache. This will free all memory associated
 * with the memory resident hash tables. 
 *
 * It is not necesary to use this function if open_theme is
 * called with size > 0, since in this case there are no
 * memory resident hash tables.
 *
 * Returns: nothing
 * 
 **/

void
close_theme(		void);

/************************************************************/
/**
 * find_icon_path:
 * 
 * @key: NULL terminated string indicating name of the icon. Any
 * file extension is ignored since all gtk supported formats are
 * regexp'd.
 *
 * @size: The size used to determine the best match for the icon.
 * This field is only used if open_theme is called with size <= 0.
 * Otherwise, the size specified in the call to open_theme is used
 * to figure out the best match (from cache).
 * 
 * @context: If open_theme is called with size > 0, this field is
 * ignored. Otherwise, this is the context for the requested icon 
 * (from index.theme). If context is NULL, then the memory based
 * hashtable is searched in a contextless environment. If context 
 * is specified, the icon will be searched for in this context
 * (first).
 *
 *
 * Returns: full path to best match for icon pixmap or NULL if
 * no match is found.
 *
 **/


const gchar *
find_icon_path(		const gchar *key,
			int size,
			const gchar *context);

