# xlog.spec
#
# Copyright (c) 2002-2004 Joop Stakenborg pg4i@amsat.org
#
%define name xlog
%define version 0.9.6
%define release 1

# required items
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Application/Databases
Prefix: /usr
BuildRoot: /var/tmp/%{name}-%{version}
Summary: Logging program for Hamradio Operators
Vendor: Joop Stakenborg <pg4i@amsat.org>
URL: http://www.qsl.net/pg4i/linux/xlog.html
Packager: Joop Stakenborg <pg4i@amsat.org>
Source: %{name}-%{version}.tar.gz

%description
xlog is a logging program for amateur radio operators. The log is stored
into a text file. QSO's are presented in a list. Items in the list can be
added, deleted or updated. For each contact, dxcc information is displayed
and bearings and distance is calculated, both short and long path.
xlog supports trlog, adif, cabrillo, edit, twlog and editest files.

%prep
%setup -q

%build
export RPM_OPT_FLAGS="-O2 -march=i386"
export CFLAGS="-O2"
%configure --enable-hamlib
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog
/usr/bin/xlog
/usr/share/locale/nl/LC_MESSAGES/xlog.mo
/usr/share/locale/fr/LC_MESSAGES/xlog.mo
/usr/share/locale/da/LC_MESSAGES/xlog.mo
/usr/share/locale/es/LC_MESSAGES/xlog.mo
/usr/share/xlog/pixmaps/*.xpm
/usr/share/xlog/pixmaps/*.png
/usr/share/xlog/dxcc/cty.dat
/usr/share/xlog/dxcc/xlog.dat
/usr/share/man/man1/xlog.1.gz
/usr/share/xlog/README
/usr/share/xlog/FAQ
/usr/share/xlog/THANKS
/usr/share/xlog/TODO
/usr/share/xlog/AUTHORS
/usr/share/xlog/MANUAL
/usr/share/xlog/qsllabels.glabels

%changelog
* Sat Feb 09 2002 Joop Stakenborg
- Initial spec file
