/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_aboutdialog.c - creation of the about dialog */

#include <gtk/gtk.h>

#include "gui_aboutdialog.h"
#include "gui_utils.h"
#include "support.h"
#include "types.h"

extern preferencestype preferences;

void
on_menu_about_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *aboutdialog;
	GdkPixbuf *aboutdialog_icon_pixbuf;
	GtkWidget *aboutdialogvbox;
	GtkWidget *aboutlayout;
	GtkWidget *aboutimage;
	GtkWidget *aboutlabel;
	GtkWidget *aboutlabel2;
	GtkWidget *dialog_action_area;
	GtkWidget *aboutbutton;
	gchar *labeltext;
	gint response;

	aboutdialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (aboutdialog), _("xlog - about"));
	gtk_window_set_position (GTK_WINDOW (aboutdialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_default_size (GTK_WINDOW (aboutdialog), 600, 250);
	aboutdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (aboutdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (aboutdialog), aboutdialog_icon_pixbuf);
			g_object_unref (aboutdialog_icon_pixbuf);
		}

	aboutdialogvbox = GTK_DIALOG (aboutdialog)->vbox;
	gtk_widget_show (aboutdialogvbox);

	aboutlayout = gtk_layout_new (NULL, NULL);
	gtk_widget_show (aboutlayout);
	gtk_box_pack_start (GTK_BOX (aboutdialogvbox), aboutlayout, TRUE, TRUE, 0);
	gtk_layout_set_size (GTK_LAYOUT (aboutlayout), 400, 400);
	GTK_ADJUSTMENT (GTK_LAYOUT (aboutlayout)->hadjustment)->step_increment = 0;
	GTK_ADJUSTMENT (GTK_LAYOUT (aboutlayout)->vadjustment)->step_increment = 0;

	aboutimage = create_pixmap (aboutdialog, "xlog-logo.png");
	gtk_widget_show (aboutimage);
	gtk_layout_put (GTK_LAYOUT (aboutlayout), aboutimage, 190, 0);
	gtk_widget_set_size_request (aboutimage, 200, 200);

	aboutlabel = gtk_label_new ("");
	gtk_widget_show (aboutlabel);
	gtk_layout_put (GTK_LAYOUT (aboutlayout), aboutlabel, 24, 40);
	gtk_widget_set_size_request (aboutlabel, 550, 30);
	labeltext = g_strdup_printf (_("%s version %s, "
	"logbook program for amateur radio operators"), PACKAGE, VERSION);
	gtk_label_set_text (GTK_LABEL (aboutlabel), labeltext);
	g_free (labeltext);

	aboutlabel2 = gtk_label_new ("Copyright (C) 2001-2004, "
			"Joop Stakenborg PG4I <pg4i@amsat.org>,\n"
			"Stephane Fillod F8CFE <f8cfe@free.fr>\n\n"
			"Homepage: http://www.qsl.net/pg4i/linux/xlog.html\n"
			"Mailing list: http://mail.nongnu.org/mailman/listinfo/xlog-discussion");
	gtk_widget_show (aboutlabel2);
	gtk_layout_put (GTK_LAYOUT (aboutlayout), aboutlabel2, 24, 90);
	gtk_widget_set_size_request (aboutlabel2, 550, 90);

	setlabelstyle (aboutlabel, preferences.themecolor, preferences.themefont);
	setlabelstyle (aboutlabel2, preferences.themecolor, preferences.themefont);

	dialog_action_area = GTK_DIALOG (aboutdialog)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);

	aboutbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (aboutbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (aboutdialog), aboutbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (aboutbutton, GTK_CAN_DEFAULT);

	response = gtk_dialog_run (GTK_DIALOG (aboutdialog));
	gtk_widget_destroy (aboutdialog);
}
