/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_mainwindow_toolbar.c - clickable toolbar
 */

#include <gtk/gtk.h>
#include "callbacks_mainwindow_toolbar.h"
#include "support.h"
#include "preferences.h"
#include "types.h"
#include "log.h"
#include "utils.h"

#if WANT_HAMLIB
#	include <hamlib/rig.h>
#	include "hamlib-utils.h"
#endif

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern statetype state;
extern gchar **bandsplit;
extern gchar **modesplit;
extern gchar **qso;
extern GList *logwindowlist;

/* add a new qso to the log */
void
on_abutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
		*remarksentry, *bandentry, *modeentry, *bandoptionmenu,
		*modeoptionmenu, *incheckbutton, *outcheckbutton,
		*qsoframe, *menu, *active_item, *endhbox, *endentry, *powerhbox,
		*powerentry, *namehbox, *nameentry, *qthhbox, *qthentry,
		*locatorhbox, *locatorentry, *unknown1hbox, *unknownentry1,
		*unknown2hbox, *unknownentry2, *qslhbox, *remarksvbox, *framelabel;
	gchar *temp, *logfile;
	gint bandindex, modeindex, i = 0, page;
	logtype *logw = NULL;
	GtkTreeIter iter, selected;
	GtkTreeModel *model;
	GtkTreePath *path;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));
	if (page >= 0)
	{
		logw = g_list_nth_data (logwindowlist, page);

		dateentry = lookup_widget (mainwindow, "dateentry");
		gmtentry = lookup_widget (mainwindow, "gmtentry");
		callentry = lookup_widget (mainwindow, "callentry");
		bandentry = lookup_widget (mainwindow, "bandentry");
		bandoptionmenu = lookup_widget (mainwindow, "bandoptionmenu");
		modeentry = lookup_widget (mainwindow, "modeentry");
		modeoptionmenu = lookup_widget (mainwindow, "modeoptionmenu");
		rstentry = lookup_widget (mainwindow, "rstentry");
		myrstentry = lookup_widget (mainwindow, "myrstentry");

		for (i = 0; i < QSO_FIELDS; i++) qso[i] = g_strdup ("");
		qso[NR] = g_strdup_printf ("%d", ++logw->qsos);
		qso[DATE] = gtk_editable_get_chars (GTK_EDITABLE (dateentry), 0, -1);
		qso[GMT] = gtk_editable_get_chars (GTK_EDITABLE (gmtentry), 0, -1);
		qso[CALL] = gtk_editable_get_chars (GTK_EDITABLE (callentry), 0, -1);
		if (preferences.bandseditbox == 0)
		{
			menu = GTK_OPTION_MENU (bandoptionmenu)->menu;
			active_item = gtk_menu_get_active (GTK_MENU (menu));
			bandindex = g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
			qso[BAND] = lookup_band (bandsplit[bandindex]);
		}
		else
			qso[BAND] = gtk_editable_get_chars (GTK_EDITABLE (bandentry), 0, -1);
		if (preferences.modeseditbox == 0)
		{
			menu = GTK_OPTION_MENU (modeoptionmenu)->menu;
			active_item = gtk_menu_get_active (GTK_MENU (menu));
			modeindex = g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
			qso[MODE] = lookup_mode (modesplit[modeindex]);
		}
		else
			qso[MODE] = gtk_editable_get_chars (GTK_EDITABLE (modeentry), 0, -1);

		powerhbox = lookup_widget (mainwindow, "powerhbox");
		powerentry = lookup_widget (mainwindow, "powerentry");
		if (GTK_WIDGET_VISIBLE (powerhbox))
		{
			qso[POWER] = gtk_editable_get_chars (GTK_EDITABLE (powerentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (powerentry), 0, -1);
		}

		qso[RST] = gtk_editable_get_chars (GTK_EDITABLE (rstentry), 0, -1);
		qso[MYRST] = gtk_editable_get_chars (GTK_EDITABLE (myrstentry), 0, -1);

		endhbox = lookup_widget (mainwindow, "endhbox");
		if (GTK_WIDGET_VISIBLE (endhbox))
		{
			endentry = lookup_widget (mainwindow, "endentry");
			qso[GMTEND] =	gtk_editable_get_chars (GTK_EDITABLE (endentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (endentry), 0, -1);
		}

		qslhbox = lookup_widget (mainwindow, "qslhbox");
		if (GTK_WIDGET_VISIBLE (qslhbox))
		{
			incheckbutton = lookup_widget (mainwindow, "incheckbutton");
			outcheckbutton = lookup_widget (mainwindow, "outcheckbutton");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (outcheckbutton)))
				qso[QSLOUT] = g_strdup ("X");
			else
				qso[QSLOUT] = g_strdup ("");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (incheckbutton)))
				qso[QSLIN] = g_strdup ("X");
			else
				qso[QSLIN] = g_strdup ("");
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton),	FALSE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton), FALSE);
		}

		namehbox = lookup_widget (mainwindow, "namehbox");
		if (GTK_WIDGET_VISIBLE (namehbox))
		{
			nameentry = lookup_widget (mainwindow, "nameentry");
			qso[NAME] =	gtk_editable_get_chars (GTK_EDITABLE (nameentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (nameentry), 0, -1);
		}

		qthhbox = lookup_widget (mainwindow, "qthhbox");
		if (GTK_WIDGET_VISIBLE (qthhbox))
		{
			qthentry = lookup_widget (mainwindow, "qthentry");
			qso[QTH] = gtk_editable_get_chars (GTK_EDITABLE (qthentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (qthentry), 0, -1);
		}

		locatorhbox = lookup_widget (mainwindow, "locatorhbox");
		if (GTK_WIDGET_VISIBLE (locatorhbox))
		{
			locatorentry = lookup_widget (mainwindow, "locatorentry");
			qso[LOCATOR] = gtk_editable_get_chars (GTK_EDITABLE (locatorentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (locatorentry), 0, -1);
		}

		unknown1hbox = lookup_widget (mainwindow, "unknown1hbox");
		if (GTK_WIDGET_VISIBLE (unknown1hbox))
		{
			unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
			qso[U1] =	gtk_editable_get_chars (GTK_EDITABLE (unknownentry1), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (unknownentry1), 0, -1);
		}

		unknown2hbox = lookup_widget (mainwindow, "unknown2hbox");
		if (GTK_WIDGET_VISIBLE (unknown2hbox))
		{
			unknownentry2 = lookup_widget (mainwindow, "unknownentry2");
			qso[U2] =	gtk_editable_get_chars (GTK_EDITABLE (unknownentry2), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (unknownentry2), 0, -1);
		}

		remarksvbox = lookup_widget (mainwindow, "remarksvbox");
		if (GTK_WIDGET_VISIBLE (remarksvbox))
		{
			remarksentry = lookup_widget (mainwindow, "remarksentry");
			qso[REMARKS] = gtk_editable_get_chars (GTK_EDITABLE (remarksentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (remarksentry), 0, -1);
		}

		/* add the QSO */
		model = gtk_tree_view_get_model (GTK_TREE_VIEW(logw->treeview));
		gtk_tree_store_prepend (GTK_TREE_STORE(model), &iter, NULL);
		gtk_tree_store_set (GTK_TREE_STORE(model), &iter, NR, qso[NR], 
			DATE, qso[DATE], GMT, qso[GMT], GMTEND, qso[GMTEND], CALL, qso[CALL], 
			BAND, qso[BAND], MODE, qso[MODE], RST, qso[RST], MYRST, qso[MYRST], 
			QSLOUT, qso[QSLOUT], QSLIN, qso[QSLIN], POWER, qso[POWER], NAME, qso[NAME], 
			QTH, qso[QTH], LOCATOR, qso[LOCATOR], U1, qso[U1], U2, qso[U2], 
			REMARKS, qso[REMARKS], -1);

		/* scroll there */
		path = gtk_tree_path_new_from_string ("0");
		gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW(logw->treeview), path, NULL, TRUE, 1.0, 0.0);
		gtk_tree_path_free (path);

		gtk_editable_delete_text (GTK_EDITABLE (gmtentry), 0, -1);
		gtk_editable_delete_text (GTK_EDITABLE (callentry), 0, -1);
		if (preferences.modeseditbox == 1)
			gtk_editable_delete_text (GTK_EDITABLE (modeentry), 0, -1);
		if (preferences.bandseditbox == 1)
		gtk_editable_delete_text (GTK_EDITABLE (bandentry), 0, -1);
		gtk_editable_delete_text (GTK_EDITABLE (rstentry), 0, -1);
		gtk_editable_delete_text (GTK_EDITABLE (myrstentry), 0, -1);

		/* unselect any selected QSO */
		if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW(logw->treeview)), &model, &selected))
			gtk_tree_selection_unselect_all (gtk_tree_view_get_selection (GTK_TREE_VIEW (logw->treeview)));

		if (preferences.saving == 2)
		{
			logfile = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, logw->logname, ".xlog", NULL);
			savelog (logw, logfile, TYPE_FLOG, 1, logw->qsos);
			logw->logchanged = FALSE;
			temp = g_strdup_printf (_("QSO %s added to %s log, log saved"), qso[NR], logw->logname);
		}
		else
		{
			temp = g_strdup_printf (_("QSO %s added to %s log"), qso[NR], logw->logname);
			logw->logchanged = TRUE;
			gtk_label_set_text (GTK_LABEL (logw->label),
			g_strconcat (logw->logname, " *", NULL));
		}
		update_statusbar (temp);
		g_free (temp);

		qsoframe = lookup_widget (mainwindow, "qsoframe");
		framelabel = gtk_frame_get_label_widget (GTK_FRAME(qsoframe));
		gtk_label_set_text (GTK_LABEL (framelabel), _("New QSO"));

		gtk_widget_grab_focus (callentry);
	}
}


/* delete a qso from the log */
void
on_dbutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *gmtbutton, *gmtentry, *endentry, *callentry, *bandentry,
		*modeentry, *rstentry, *myrstentry, *remarksentry, *powerentry,
		*nameentry, *qthentry, *unknownentry1, *unknownentry2,
		*locatorentry, *incheckbutton, *outcheckbutton;
	gchar *statustext, *qsonumber, *logfile;
	gint i, page;
	logtype *logwindow;
	GtkTreeIter selected, iter;
	GtkTreeModel *model;
 
	page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));
	logwindow = g_list_nth_data (logwindowlist, page);

	if (page >= 0)
	{
		if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW(logwindow->treeview)), &model, &selected))
		{
			gtk_tree_model_get (model, &selected, NR, &qsonumber, -1);
			statustext = g_strdup_printf (_("QSO %s deleted, %s log renumbered"), qsonumber, logwindow->logname);
			update_statusbar (statustext);
			g_free (statustext);

			gmtentry = lookup_widget (mainwindow, "gmtentry");
			endentry = lookup_widget (mainwindow, "endentry");
			callentry = lookup_widget (mainwindow, "callentry");
			bandentry = lookup_widget (mainwindow, "bandentry");
			modeentry = lookup_widget (mainwindow, "modeentry");
			rstentry = lookup_widget (mainwindow, "rstentry");
			myrstentry = lookup_widget (mainwindow, "myrstentry");
			remarksentry = lookup_widget (mainwindow, "remarksentry");
			incheckbutton = lookup_widget (mainwindow, "incheckbutton");
			outcheckbutton = lookup_widget (mainwindow, "outcheckbutton");
			powerentry = lookup_widget (mainwindow, "powerentry");
			nameentry = lookup_widget (mainwindow, "nameentry");
			qthentry = lookup_widget (mainwindow, "qthentry");
			locatorentry = lookup_widget (mainwindow, "locatorentry");
			unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
			unknownentry2 = lookup_widget (mainwindow, "unknownentry2");
			gtk_editable_delete_text (GTK_EDITABLE (gmtentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (endentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (callentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (modeentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (bandentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (rstentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (myrstentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (remarksentry), 0, -1);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton), FALSE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton), FALSE);
			gtk_editable_delete_text (GTK_EDITABLE (powerentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (nameentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (qthentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (locatorentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (unknownentry1), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (unknownentry2), 0, -1);

			/* now remove the QSO from the log */
			gtk_tree_store_remove (GTK_TREE_STORE (model), &selected);
			logwindow->qsos--;

			if (preferences.saving != 2)
			{
				logwindow->logchanged = TRUE;
				gtk_label_set_text (GTK_LABEL (logwindow->label),	g_strconcat (logwindow->logname, " *", NULL));
			}

			/* update the first column with the number of qso's */
			gtk_tree_model_get_iter_first (model, &iter);
			for (i = 0; i < logwindow->qsos; i++)
			{
				qsonumber = g_strdup_printf ("%d", logwindow->qsos - i);
				gtk_tree_store_set (GTK_TREE_STORE(model), &iter, NR, qsonumber, -1); 
				g_free (qsonumber);
				if (!(i % 50)) /* needed for responsiveness */
				{
					while (gtk_events_pending ())	gtk_main_iteration ();
				}
				gtk_tree_model_iter_next (model, &iter);
			}

			gmtbutton = lookup_widget (mainwindow, "gmtbutton");
			gtk_widget_grab_focus (gmtbutton);

			if (preferences.saving == 2)
			{
				logfile = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, logwindow->logname, ".xlog", NULL);
				savelog (logwindow, logfile, TYPE_FLOG, 1, logwindow->qsos);
				logwindow->logchanged = FALSE;
			}
		}
	}
}


/* update/modify a log entry */
void
on_ubutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
		*remarksentry, *bandentry, *modeentry, *incheckbutton,
		*outcheckbutton, *modeoptionmenu, *bandoptionmenu, *menu,
		*active_item, *qsoframe, *endhbox, *endentry, *powerhbox,
		*powerentry, *namehbox, *nameentry, *qthhbox, *qthentry,
		*locatorhbox, *locatorentry, *unknown1hbox, *unknownentry1,
		*unknown2hbox, *unknownentry2, *qslhbox, *remarksvbox, *gmtbutton,
		*framelabel;
	gint bandindex, modeindex, i = 0, page;
	gchar *statustext, *logfile;
	logtype *logw;
	GtkTreeIter selected;
	GtkTreeModel *model;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));
	logw = g_list_nth_data (logwindowlist, page);

	if (page >= 0)
	{
		dateentry = lookup_widget (mainwindow, "dateentry");
		gmtentry = lookup_widget (mainwindow, "gmtentry");
		callentry = lookup_widget (mainwindow, "callentry");
		bandentry = lookup_widget (mainwindow, "bandentry");
		modeentry = lookup_widget (mainwindow, "modeentry");
		rstentry = lookup_widget (mainwindow, "rstentry");
		myrstentry = lookup_widget (mainwindow, "myrstentry");
		modeoptionmenu = lookup_widget (mainwindow, "modeoptionmenu");
		bandoptionmenu = lookup_widget (mainwindow, "bandoptionmenu");

		for (i = 0; i < QSO_FIELDS; i++)
			qso[i] = g_strdup ("");

		if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW(logw->treeview)), &model, &selected))
		{
			gtk_tree_model_get (model, &selected, NR, &qso[NR], -1);
					
			qso[DATE] =	gtk_editable_get_chars (GTK_EDITABLE (dateentry), 0, -1);
			qso[GMT] = gtk_editable_get_chars (GTK_EDITABLE (gmtentry), 0, -1);
			qso[CALL] = gtk_editable_get_chars (GTK_EDITABLE (callentry), 0, -1);

			if (preferences.bandseditbox == 1)
			{
				qso[BAND] = gtk_editable_get_chars (GTK_EDITABLE (bandentry), 0, -1);
			}
			else
			{
				menu = GTK_OPTION_MENU (bandoptionmenu)->menu;
				active_item = gtk_menu_get_active (GTK_MENU (menu));
				bandindex = g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
				qso[BAND] = lookup_band (bandsplit[bandindex]);
			}

			if (preferences.modeseditbox == 1)
			{
				qso[MODE] = gtk_editable_get_chars (GTK_EDITABLE (modeentry), 0, -1);
			}
			else
			{
				menu = GTK_OPTION_MENU (modeoptionmenu)->menu;
				active_item = gtk_menu_get_active (GTK_MENU (menu));
				modeindex = g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
				qso[MODE] = lookup_mode (modesplit[modeindex]);
			}

			powerhbox = lookup_widget (mainwindow, "powerhbox");
			if (GTK_WIDGET_VISIBLE (powerhbox))
			{
				powerentry = lookup_widget (mainwindow, "powerentry");
				qso[POWER] = gtk_editable_get_chars (GTK_EDITABLE (powerentry), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (powerentry), 0, -1);
			}

			qso[RST] = gtk_editable_get_chars (GTK_EDITABLE (rstentry), 0, -1);
			qso[MYRST] = gtk_editable_get_chars (GTK_EDITABLE (myrstentry), 0, -1);

			endhbox = lookup_widget (mainwindow, "endhbox");
			if (GTK_WIDGET_VISIBLE (endhbox))
			{
				endentry = lookup_widget (mainwindow, "endentry");
				qso[GMTEND] =	gtk_editable_get_chars (GTK_EDITABLE (endentry), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (endentry), 0, -1);
			}

			qslhbox = lookup_widget (mainwindow, "qslhbox");
			if (GTK_WIDGET_VISIBLE (qslhbox))
			{
				incheckbutton = lookup_widget (mainwindow, "incheckbutton");
				outcheckbutton = lookup_widget (mainwindow, "outcheckbutton");
				if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (outcheckbutton)))
					qso[QSLOUT] = g_strdup ("X");
				else
					qso[QSLOUT] = g_strdup ("");
				if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (incheckbutton)))
					qso[QSLIN] = g_strdup ("X");
				else
					qso[QSLIN] = g_strdup ("");
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON	(outcheckbutton), FALSE);
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton), FALSE);
			}

			namehbox = lookup_widget (mainwindow, "namehbox");
			if (GTK_WIDGET_VISIBLE (namehbox))
			{
				nameentry = lookup_widget (mainwindow, "nameentry");
				qso[NAME] =	gtk_editable_get_chars (GTK_EDITABLE (nameentry), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (nameentry), 0, -1);
			}

			qthhbox = lookup_widget (mainwindow, "qthhbox");
			if (GTK_WIDGET_VISIBLE (qthhbox))
			{
				qthentry = lookup_widget (mainwindow, "qthentry");
				qso[QTH] = gtk_editable_get_chars (GTK_EDITABLE (qthentry), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (qthentry), 0, -1);
			}

			locatorhbox = lookup_widget (mainwindow, "locatorhbox");
			if (GTK_WIDGET_VISIBLE (locatorhbox))
			{
				locatorentry = lookup_widget (mainwindow, "locatorentry");
				qso[LOCATOR] = gtk_editable_get_chars (GTK_EDITABLE (locatorentry), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (locatorentry), 0, -1);
			}

			unknown1hbox = lookup_widget (mainwindow, "unknown1hbox");
			if (GTK_WIDGET_VISIBLE (unknown1hbox))
			{
				unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
				qso[U1] =	gtk_editable_get_chars (GTK_EDITABLE (unknownentry1), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (unknownentry1), 0, -1);
			}

			unknown2hbox = lookup_widget (mainwindow, "unknown2hbox");
			if (GTK_WIDGET_VISIBLE (unknown2hbox))
			{
				unknownentry2 = lookup_widget (mainwindow, "unknownentry2");
				qso[U2] =	gtk_editable_get_chars (GTK_EDITABLE (unknownentry2), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (unknownentry2), 0, -1);
			}

			remarksvbox = lookup_widget (mainwindow, "remarksvbox");
			if (GTK_WIDGET_VISIBLE (remarksvbox))
			{
				remarksentry = lookup_widget (mainwindow, "remarksentry");
				qso[REMARKS] = gtk_editable_get_chars (GTK_EDITABLE (remarksentry), 0, -1);
				gtk_editable_delete_text (GTK_EDITABLE (remarksentry), 0, -1);
			}

			/* change the selected QSO */
			gtk_tree_store_set (GTK_TREE_STORE(model), &selected, NR, qso[NR], 
				DATE, qso[DATE], GMT, qso[GMT], GMTEND, qso[GMTEND], CALL, qso[CALL], 
				BAND, qso[BAND], MODE, qso[MODE], RST, qso[RST], MYRST, qso[MYRST], 
				QSLOUT, qso[QSLOUT], QSLIN, qso[QSLIN], POWER, qso[POWER], NAME, qso[NAME], 
				QTH, qso[QTH], LOCATOR, qso[LOCATOR], U1, qso[U1], U2, qso[U2], 
				REMARKS, qso[REMARKS], -1);

			gtk_tree_selection_unselect_all (gtk_tree_view_get_selection (GTK_TREE_VIEW (logw->treeview)));

			gtk_editable_delete_text (GTK_EDITABLE (gmtentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (callentry), 0, -1);
			if (preferences.modeseditbox == 1)
				gtk_editable_delete_text (GTK_EDITABLE (modeentry), 0, -1);
			if (preferences.bandseditbox == 1)
				gtk_editable_delete_text (GTK_EDITABLE (bandentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (rstentry), 0, -1);
			gtk_editable_delete_text (GTK_EDITABLE (myrstentry), 0, -1);

			qsoframe = lookup_widget (mainwindow, "qsoframe");
			framelabel = gtk_frame_get_label_widget (GTK_FRAME(qsoframe));
			gtk_label_set_text (GTK_LABEL (framelabel), _("New QSO"));

			if (preferences.saving == 2)
			{
				logfile = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, logw->logname, ".xlog", NULL);
				savelog (logw, logfile, TYPE_FLOG, 1, logw->qsos);
				logw->logchanged = FALSE;
				statustext = g_strdup_printf (_("QSO %s updated in %s log, log saved"),	qso[NR], logw->logname);
			}
			else
			{
				logw->logchanged = TRUE;
				gtk_label_set_text (GTK_LABEL (logw->label),	g_strconcat (logw->logname, " *", NULL));
				statustext =	g_strdup_printf (_("QSO %s updated in %s log"), qso[NR], logw->logname);
			}
			update_statusbar (statustext);
			g_free (statustext);

			gmtbutton = lookup_widget (mainwindow, "gmtbutton");
			gtk_widget_grab_focus (gmtbutton);
		}
	}
}
