/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest;
import com.amazonaws.services.ec2.model.ReservedInstancesConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyReservedInstancesRequestMarshaller
implements Marshaller<Request<ModifyReservedInstancesRequest>, ModifyReservedInstancesRequest> {
    public Request<ModifyReservedInstancesRequest> marshall(ModifyReservedInstancesRequest modifyReservedInstancesRequest) {
        if (modifyReservedInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReservedInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyReservedInstances");
        request.addParameter("Version", "2014-05-01");
        if (modifyReservedInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)modifyReservedInstancesRequest.getClientToken()));
        }
        List<String> reservedInstancesIdsList = modifyReservedInstancesRequest.getReservedInstancesIds();
        int reservedInstancesIdsListIndex = 1;
        for (String reservedInstancesIdsListValue : reservedInstancesIdsList) {
            if (reservedInstancesIdsListValue != null) {
                request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringUtils.fromString((String)reservedInstancesIdsListValue));
            }
            ++reservedInstancesIdsListIndex;
        }
        List<ReservedInstancesConfiguration> targetConfigurationsList = modifyReservedInstancesRequest.getTargetConfigurations();
        int targetConfigurationsListIndex = 1;
        for (ReservedInstancesConfiguration targetConfigurationsListValue : targetConfigurationsList) {
            ReservedInstancesConfiguration reservedInstancesConfigurationMember = targetConfigurationsListValue;
            if (reservedInstancesConfigurationMember != null) {
                if (reservedInstancesConfigurationMember.getAvailabilityZone() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".AvailabilityZone", StringUtils.fromString((String)reservedInstancesConfigurationMember.getAvailabilityZone()));
                }
                if (reservedInstancesConfigurationMember.getPlatform() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Platform", StringUtils.fromString((String)reservedInstancesConfigurationMember.getPlatform()));
                }
                if (reservedInstancesConfigurationMember.getInstanceCount() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceCount", StringUtils.fromInteger((Integer)reservedInstancesConfigurationMember.getInstanceCount()));
                }
                if (reservedInstancesConfigurationMember.getInstanceType() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceType", StringUtils.fromString((String)reservedInstancesConfigurationMember.getInstanceType()));
                }
            }
            ++targetConfigurationsListIndex;
        }
        return request;
    }
}

