---
title: PostgreSQL JDBC Driver 42.2.0 Released
date: 2018-01-17 20:11:10 +0300
categories:
  - new_release
version: 42.2.0
---
**Notable changes**

### Known issues
- SCRAM authentication does not work as scram client classes are not packaged
- client_encoding has to be UTF8 even with allowEncodingChanges=true

### Added
- Support SCRAM-SHA-256 for PostgreSQL 10 in the JDBC 4.2 version (Java 8+) using the Ongres SCRAM library. [PR 842](https://github.com/pgjdbc/pgjdbc/pull/842)
- Make SELECT INTO and CREATE TABLE AS return row counts to the client in their command tags. [Issue 958](https://github.com/pgjdbc/pgjdbc/issues/958) [PR 962](https://github.com/pgjdbc/pgjdbc/pull/962)
- Support Subject Alternative Names for SSL connections. [PR 952](https://github.com/pgjdbc/pgjdbc/pull/952)
- Support isAutoIncrement metadata for PostgreSQL 10 IDENTITY column. [PR 1004](https://github.com/pgjdbc/pgjdbc/pull/1004)
- Support for primitive arrays [PR 887](https://github.com/pgjdbc/pgjdbc/pull/887) [3e0491a](https://github.com/pgjdbc/pgjdbc/commit/3e0491ac3833800721b98e7437635cf6ab338162)
- Implement support for get/setNetworkTimeout() in connections. [PR 849](https://github.com/pgjdbc/pgjdbc/pull/849)
- Make GSS JAAS login optional, add an option "jaasLogin" [PR 922](https://github.com/pgjdbc/pgjdbc/pull/922) see [Connecting to the Database](https://jdbc.postgresql.org/documentation/head/connect.html)

### Changed
- Improve behaviour of ResultSet.getObject(int, Class). [PR 932](https://github.com/pgjdbc/pgjdbc/pull/932)
- Parse CommandComplete message using a regular expression, allows complete catch of server returned commands for INSERT, UPDATE, DELETE, SELECT, FETCH, MOVE, COPY and future commands. [PR 962](https://github.com/pgjdbc/pgjdbc/pull/962)
- Use 'time with timezone' and 'timestamp with timezone' as is and ignore the user provided Calendars, 'time' and 'timestamp' work as earlier except "00:00:00" now maps to 1970-01-01 and "24:00:00" uses the system provided Calendar ignoring the user-provided one [PR 1053](https://github.com/pgjdbc/pgjdbc/pull/1053)
- Change behaviour of multihost connection. The new behaviour is to try all secondaries first before trying the master [PR 844](https://github.com/pgjdbc/pgjdbc/pull/844).
- Avoid reflective access to TimeZone.defaultTimeZone in Java 9+ [PR 1002](https://github.com/pgjdbc/pgjdbc/pull/1002) fixes [Issue 986](https://github.com/pgjdbc/pgjdbc/issues/986)

### Fixed
- Make warnings available as soon as they are received from the server. This is useful for long running queries, where it can be beneficial to know about a warning before the query completes. [PR 857](https://github.com/pgjdbc/pgjdbc/pull/857)
- Use 00:00:00 and 24:00:00 for LocalTime.MIN/MAX. [PR 992](https://github.com/pgjdbc/pgjdbc/pull/992)
- Now the DatabaseMetaData.getFunctions() implementation complies with the JDBC docs. [PR 918](https://github.com/pgjdbc/pgjdbc/pull/918)
- Execute autosave/rollback savepoint via simple queries always to prevent "statement S_xx not exists" when autosaving fixes [Issue #955](https://github.com/pgjdbc/pgjdbc/issues/955)
- Received resultset tuples, but no field structure for them" when bind failure happens on 5th execution of a statement [Issue 811](https://github.com/pgjdbc/pgjdbc/issues/811)

### Removed
- Drop support for the (insecure) crypt authentication method. [PR 1026](https://github.com/pgjdbc/pgjdbc/pull/1026)

### Deprecated
- Reintroduce Driver.getVersion for backward compatibility reasons, mark it as deprecated as application should not rely on it (regression since 42.0.0) [50d5dd3e](https://github.com/pgjdbc/pgjdbc/commit/50d5dd3e708a92602e04d6b4aa0822ad3f110a78)
- slave and preferSlave values for the targetServerType connection property have been deprecated in favour of secondary and preferSecondary respectively. 

<!--more-->

**Commits by author**

AlexElin (9):

* docs: fix header in CONTRIBUTING [PR 902](https://github.com/pgjdbc/pgjdbc/pull/902) [38ff0fe](https://github.com/pgjdbc/pgjdbc/commit/38ff0fe4728addf9a34d6fb0069ce4963aaae7ee)
* refactor: remove dead code from PGStream, implement Closeable [PR 901](https://github.com/pgjdbc/pgjdbc/pull/901) [acff949](https://github.com/pgjdbc/pgjdbc/commit/acff9495b8745bce30d93d61e77caf81d9748b4b)
* refactor: replace some usages of assertTrue [PR 957](https://github.com/pgjdbc/pgjdbc/pull/957) [c759a58](https://github.com/pgjdbc/pgjdbc/commit/c759a58313c4344924a311021e1c860580f3e318)
* refactor: state of PGXAConnection as enum [PR 966](https://github.com/pgjdbc/pgjdbc/pull/966) [7618822](https://github.com/pgjdbc/pgjdbc/commit/76188228ddb412db74959fbe59b5c2d6ef5eddfc)
* refactor: make PgStream implements Flushable [PR 1008](https://github.com/pgjdbc/pgjdbc/pull/1008) [0c3a2fc](https://github.com/pgjdbc/pgjdbc/commit/0c3a2fc132101f83dbb0990ac2c49c49b9c65ffe)
* style: add MissingDeprecated into checkstyle [PR 1019](https://github.com/pgjdbc/pgjdbc/pull/1019) [d74386d](https://github.com/pgjdbc/pgjdbc/commit/d74386def0d39f450f5dcfdb21ff6171ba0a89f3)
* chore: update checkstyle [PR 1025](https://github.com/pgjdbc/pgjdbc/pull/1025) [69e3b8b](https://github.com/pgjdbc/pgjdbc/commit/69e3b8b2ef7fb80ece8df23b55855fa4208e8a00)
* refactor: simplify methods in ConnectionFactoryImpl [PR 1028](https://github.com/pgjdbc/pgjdbc/pull/1028) [ed27c5b](https://github.com/pgjdbc/pgjdbc/commit/ed27c5b464563448079189b1759ecf05d4726ea0)
* refactor: replace some usages of initCause [PR 1037](https://github.com/pgjdbc/pgjdbc/pull/1037) [0c29823](https://github.com/pgjdbc/pgjdbc/commit/0c29823ad8eca86e3b8f27bcee5f116d41e367f9)

Álvaro Hernández Tortosa (1):

* Add SCRAM-SHA-256 support [PR 842](https://github.com/pgjdbc/pgjdbc/pull/842) [befea18](https://github.com/pgjdbc/pgjdbc/commit/befea18d153dda7814daef4e036d3f5daf8de1e5)

Barnabas Bodnar (1):

* fix: don't attempt to read a SQLXML more than once [PR 965](https://github.com/pgjdbc/pgjdbc/pull/965) [8f5e245](https://github.com/pgjdbc/pgjdbc/commit/8f5e2454185a929f1bc6ef66813d6681bb38e736)

Brett Okken (1):

* feat: primitive arrays [PR 887](https://github.com/pgjdbc/pgjdbc/pull/887) [3e0491a](https://github.com/pgjdbc/pgjdbc/commit/3e0491ac3833800721b98e7437635cf6ab338162)

Brett Wooldridge (1):

* Fixes #638 Implement support for get/setNetworkTimeout() [PR 849](https://github.com/pgjdbc/pgjdbc/pull/849) [8a30044](https://github.com/pgjdbc/pgjdbc/commit/8a30044d9e97c1038ee4401ae745d37a11f008db)

Chen Huajun (1):

* fix: improve multihost connection for preferSlave case (verify expired hosts before connecting to cached master) [PR 844](https://github.com/pgjdbc/pgjdbc/pull/844) [c6fec34](https://github.com/pgjdbc/pgjdbc/commit/c6fec34661b51cd9cbee157d0c334a3ab29859e8)

Dave Cramer (11):

* Update thread safety status of the driver to reflect reality; that being that the driver is not thread safe [PR 928](https://github.com/pgjdbc/pgjdbc/pull/928) [ad47aba](https://github.com/pgjdbc/pgjdbc/commit/ad47abafa1754f8d0f2126ef1d26aa9b037b49e5)
* fix: use 00:00:00 and 24:00:00 for LocalTime.MIN/MAX [PR 992](https://github.com/pgjdbc/pgjdbc/pull/992) [f2d8ec5](https://github.com/pgjdbc/pgjdbc/commit/f2d8ec5740aa26c417d666a7afedaaf0fdf62d37)
* fix: support Subject Alternative Names for SSL connections [PR 952](https://github.com/pgjdbc/pgjdbc/pull/952) [2dcb91e](https://github.com/pgjdbc/pgjdbc/commit/2dcb91ef1fd8f0fe08f107c9c30cdc57d4c44b05)
* test: Appveyor configuration [PR 1000](https://github.com/pgjdbc/pgjdbc/pull/1000) [059628f](https://github.com/pgjdbc/pgjdbc/commit/059628fcdf2058cfd05cb80eac64799ca26ad0d2)
* add test for identity, fix isAutoincrement in postgresql 10 fixes #130 [PR 1004](https://github.com/pgjdbc/pgjdbc/pull/1004) [2f6633b](https://github.com/pgjdbc/pgjdbc/commit/2f6633bd9e1e9d7f313ea4dfec37f9671fc07453)
* elaborate on sslmode options [PR 1054](https://github.com/pgjdbc/pgjdbc/pull/1054) [aa7a420](https://github.com/pgjdbc/pgjdbc/commit/aa7a4202e41bc58c4958e06161c5fd4daa36a7f9)
* prefer the word secondary over slave [PR 1063](https://github.com/pgjdbc/pgjdbc/pull/1063) [2e8c2b6](https://github.com/pgjdbc/pgjdbc/commit/2e8c2b67e22ddaa38894be4b2578ccd4bf97a27d)
* Revert "refactor: replace some usages of initCause [PR 1037](https://github.com/pgjdbc/pgjdbc/pull/1037)" (#1064) [e6a1ecc](https://github.com/pgjdbc/pgjdbc/commit/e6a1eccb148c3c59e8cf122e98ad01afc5bb555a)
* prefer secondary over slave referring to standby or secondary servers [PR 1070](https://github.com/pgjdbc/pgjdbc/pull/1070) [32c53902](https://github.com/pgjdbc/pgjdbc/commit/32c539020db3c940bae9b2a42425b1f23e864c73)
* first pass at release notes and some fixes to previous notes [PR 1041](https://github.com/pgjdbc/pgjdbc/pull/1041) [a8260f5](https://github.com/pgjdbc/pgjdbc/commit/a8260f5d0e31d00c1b44d2b94f62d86a72e2b2d5)
* Update 2018-01-16-42.2.0-release.md [b36867f](https://github.com/pgjdbc/pgjdbc/commit/b36867f34719d2af559b60b6f63b2df036798231)

Hugh Cole-Baker (1):

* Make GSS JAAS login optional [PR 922](https://github.com/pgjdbc/pgjdbc/pull/922) [d7f0f27](https://github.com/pgjdbc/pgjdbc/commit/d7f0f271b73adbf0ae22146beea122e014d9f9f2)

Jeff Klukas (1):

* fix: advance lastReceiveLSN on keepalive messages [PR 1038](https://github.com/pgjdbc/pgjdbc/pull/1038) [1be8a9e](https://github.com/pgjdbc/pgjdbc/commit/1be8a9ebafbfbcff118385a61a350745addcaf3d)

Joe Kutner (1):

* fix: Added support for socksNonProxyHosts property [PR 975](https://github.com/pgjdbc/pgjdbc/pull/975) (#985) [9813c68](https://github.com/pgjdbc/pgjdbc/commit/9813c685cae2cbfbc561a6220ba388cef08f34b0)

Jorge Solorzano (13):

* chore: use mainly Trusty in Travis, reorder CI jobs, and jdk tests [PR 939](https://github.com/pgjdbc/pgjdbc/pull/939) [646a868](https://github.com/pgjdbc/pgjdbc/commit/646a868c0bc80def5fa62374e83b71d65fef9a14)
* fix: ignore replication test until 11.1 to avoid random failures [PR 949](https://github.com/pgjdbc/pgjdbc/pull/949) [ee6443d](https://github.com/pgjdbc/pgjdbc/commit/ee6443db167da735f5a9402d16f31c3ee6d719dc)
* chore: streamlining jobs [PR 959](https://github.com/pgjdbc/pgjdbc/pull/959) [ed0a398](https://github.com/pgjdbc/pgjdbc/commit/ed0a398edb47d0eea62e7f53723e14d9ed278fbb)
* docs: move changelog to separate file [PR 956](https://github.com/pgjdbc/pgjdbc/pull/956) [e67e8f9](https://github.com/pgjdbc/pgjdbc/commit/e67e8f9685e6c8235134baedeb790f39de39e77c)
* docs: improve website front page [PR 968](https://github.com/pgjdbc/pgjdbc/pull/968) [65170f1](https://github.com/pgjdbc/pgjdbc/commit/65170f1690bb571c8dbe0425b205ba8498c8173f)
* docs: fix test db password in docs [PR 984](https://github.com/pgjdbc/pgjdbc/pull/984) [7df56f8](https://github.com/pgjdbc/pgjdbc/commit/7df56f816770a7129cb56d150c6d556c64632a5c)
* test: add openj9 to the matrix [PR 974](https://github.com/pgjdbc/pgjdbc/pull/974) [f187645](https://github.com/pgjdbc/pgjdbc/commit/f187645896e9f86a654390581163a7064b611404)
* chore: remove testing of the latest Java updates [PR 993](https://github.com/pgjdbc/pgjdbc/pull/993) [0d8fde6](https://github.com/pgjdbc/pgjdbc/commit/0d8fde6da6dd28a14e12715a3b01d3787cac7fb8)
* chore: updates to CHANGELOG.md in release_notes.sh [PR 981](https://github.com/pgjdbc/pgjdbc/pull/981) [bdfc1db](https://github.com/pgjdbc/pgjdbc/commit/bdfc1dbb45315d659a49c1ef7a831ca2d6326be4)
* test: querymode extendedCacheEverything [PR 1007](https://github.com/pgjdbc/pgjdbc/pull/1007) [f574285](https://github.com/pgjdbc/pgjdbc/commit/f5742853b6d79cc20f718339855904c1384c59cd)
* fix: first composite query not calling getNativeSql() [PR 1020](https://github.com/pgjdbc/pgjdbc/pull/1020) [2cae5a1](https://github.com/pgjdbc/pgjdbc/commit/2cae5a199c2d08768ea9f784ee3f60cef244c4b0)
* drop old and unused crypt auth [PR 1026](https://github.com/pgjdbc/pgjdbc/pull/1026) [405f14e](https://github.com/pgjdbc/pgjdbc/commit/405f14eefc9d7e01bfaa1b526f1a6a0bac50d3c4)
* chore: collect coverage for Java 7 [PR 1030](https://github.com/pgjdbc/pgjdbc/pull/1030) [b629934](https://github.com/pgjdbc/pgjdbc/commit/b6299347e15ea2a40c80de9907ae3f137caa4401)

Magnus (1):

* fix: make warnings available as soon as they are received [PR 857](https://github.com/pgjdbc/pgjdbc/pull/857) [83dd5fe](https://github.com/pgjdbc/pgjdbc/commit/83dd5fea94928b349e05c1417e264797052f2bbe)

Magnus Hagander (1):

* Fix documentation spelling of sslpasswordcallback [PR 1021](https://github.com/pgjdbc/pgjdbc/pull/1021) [8ba5841](https://github.com/pgjdbc/pgjdbc/commit/8ba58418ae10f80530f67f0c8628161011c5a228)

MichaelZg (1):

* fix: trim trailing zeros in timestamp strings returned in binary mode [PR 896](https://github.com/pgjdbc/pgjdbc/pull/896) [d28deff](https://github.com/pgjdbc/pgjdbc/commit/d28deff57684349707d2b2a357048f59b0861bb1)

Michael Glaesemann (1):

* refactor: use TypeInfo getPGArrayType instead of munging type name [PR 913](https://github.com/pgjdbc/pgjdbc/pull/913) [634e157](https://github.com/pgjdbc/pgjdbc/commit/634e157e4cdbc2f78f1a90ac4d9f538f39caf4f9)

Pavel Raiskup (2):

* packaging: rpm_ci: add missing BuildRequires [4e0cdc1](https://github.com/pgjdbc/pgjdbc/commit/4e0cdc13ec659f21a318b05c3a67cac7c75c957e)
* packaging: rpm_ci: don't shade scram jar into pgjdbc [1fd6c4f](https://github.com/pgjdbc/pgjdbc/commit/1fd6c4fe5ccc93ab7d08bf77bcd5344bc60dd334)

Philippe Marschall (2):

* feat: improve ResultSet#getObject(int, Class) [PR 932](https://github.com/pgjdbc/pgjdbc/pull/932) [fcb28c7](https://github.com/pgjdbc/pgjdbc/commit/fcb28c7c87a18ba6673b7fd3a48f3421410eb942)
* test: add ubenchmark for UTF-8 decoding [PR 988](https://github.com/pgjdbc/pgjdbc/pull/988) [0d918c3](https://github.com/pgjdbc/pgjdbc/commit/0d918c3b21ba2a368da34bd30668908723dc4d36)

Piyush Sharma (1):

* doc: Added quotes to URL in '@see' tag over org.postgresql.sspi.NTDSAPI#DsMakeSpnW for syntactic correctness [PR 926](https://github.com/pgjdbc/pgjdbc/pull/926) [29f574a](https://github.com/pgjdbc/pgjdbc/commit/29f574a0116ab93eade3c80e2db20573390a6a31)

Sehrope Sarkuni (1):

* feat: parse command complete message via regex [PR 962](https://github.com/pgjdbc/pgjdbc/pull/962) [097db5e](https://github.com/pgjdbc/pgjdbc/commit/097db5e70ae8bf193c736b11603332feadb8d544)

Thach Hoang (2):

* Update ServerVersionTest to actually compare versions [PR 1015](https://github.com/pgjdbc/pgjdbc/pull/1015) [cccd6cd](https://github.com/pgjdbc/pgjdbc/commit/cccd6cde4672de30ac0bbac6621b63e81aae9474)
* fix: always return Short[] for java.sql.Array.getArray() on smallint[] [PR 1017](https://github.com/pgjdbc/pgjdbc/pull/1017) [279fb43](https://github.com/pgjdbc/pgjdbc/commit/279fb435b392114c45266ecef901bfd59470842a)

Vladimir Sitnikov (23):

* fix: reintroduce Driver.getVersion for backward compatibility reasons [PR 905](https://github.com/pgjdbc/pgjdbc/pull/905) [50d5dd3](https://github.com/pgjdbc/pgjdbc/commit/50d5dd3e708a92602e04d6b4aa0822ad3f110a78)
* style: make PGReplicationStream, LargeObject implement AutoCloseable for Java 7+ [PR 1016](https://github.com/pgjdbc/pgjdbc/pull/1016) [9f07c9a](https://github.com/pgjdbc/pgjdbc/commit/9f07c9ae2eb0c1ec18455e3a3d66460dd264c790)
* fix: prevent statement hang in case close() called when query is in progress [PR 1022](https://github.com/pgjdbc/pgjdbc/pull/1022) [04c5dbb](https://github.com/pgjdbc/pgjdbc/commit/04c5dbb5058008a8ddad0194156af9819595c315)
* fix: synchronize Statement#result field access to make #close() more thread-safe [4139248](https://github.com/pgjdbc/pgjdbc/commit/41392481d5f2c7f89d783a535ade2d3afb565654)
* fix: avoid reflective access to TimeZone.defaultTimeZone in Java 9+ [PR 1002](https://github.com/pgjdbc/pgjdbc/pull/1002) [fd0eeee](https://github.com/pgjdbc/pgjdbc/commit/fd0eeee8f123b1355b523425a1e11fdd59b057a5)
* fix: throw TOO\_MANY\_RESULTS (0100E) instead of "PgResultSet: tuples must be non-null" [0d31d46](https://github.com/pgjdbc/pgjdbc/commit/0d31d46adff4e9772db843195e1638531bc703e0)
* fix: "Received resultset tuples, but no field structure for them" when bind failure happens on 5th execution of a statement [PR 811](https://github.com/pgjdbc/pgjdbc/pull/811) [082d009](https://github.com/pgjdbc/pgjdbc/commit/082d00941ad5f8abf44a0785a6f086c106b3c746)
* tests: correct assertion to use proper column [63918eb](https://github.com/pgjdbc/pgjdbc/commit/63918eb9b1211e0115c8b55401e22c7a3f37e534)
* fix: add type parameter so code is Java 6/7 compatible [1361c52](https://github.com/pgjdbc/pgjdbc/commit/1361c5208d6afc5d54e4df1053c48cdb31df9038)
* chore: avoid non-blocking IO for stdout to workaround "stdout: write error" in Travis [12bb084](https://github.com/pgjdbc/pgjdbc/commit/12bb084035a13c4fb690df93837b37e85354ebc4)
* test: run Travis tests with non-default time zone [a3982b4](https://github.com/pgjdbc/pgjdbc/commit/a3982b474dd92cd32c8fb1b7dafbd28c853c4177)
* fix: execute autosave/rollback savepoint via simple queries always to prevent "statement S_xx not exists" when autosaving [PR 955](https://github.com/pgjdbc/pgjdbc/pull/955) [684a699](https://github.com/pgjdbc/pgjdbc/commit/684a69920e08017c74ab4194d1a77067f544a28b)
* fix: use 'time with time zone' and 'timestamp with time zone' values as is and avoid computation with user-provided/default Calendars [e8c43f3](https://github.com/pgjdbc/pgjdbc/commit/e8c43f36ab2a6843f37d27e7417a5214f7142084)
* test: refactor SetObject310Test to use proper assertion messages and use less statements (make it faster) [be06946](https://github.com/pgjdbc/pgjdbc/commit/be06946f8b908536f4d659aaf6fc660bed339f67)
* refactor: factor out receiveParameterStatus so all the ParameterStatus messages are handled in the same way [a94cfea](https://github.com/pgjdbc/pgjdbc/commit/a94cfeace5d66b4fe8d8fa3b16986baebaec2a11)
* fix: add Provide-Capability OSGi manifest [PR 1029](https://github.com/pgjdbc/pgjdbc/pull/1029) [236805b](https://github.com/pgjdbc/pgjdbc/commit/236805bcaf0dd1d9df3542c5865a15b24375a01c)
* chore: update version to 42.2.0-SNAPSHOT to reflect the next release version [e27ee74](https://github.com/pgjdbc/pgjdbc/commit/e27ee740535a4034084d450cddefda2fbcb1b2af)
* packaging: add missing maven-clean-plugin dependency [a2ed9b5](https://github.com/pgjdbc/pgjdbc/commit/a2ed9b50e304a3437f92b945217c19197226d53f)
* chore: introduce release via Travis [acb9bdd](https://github.com/pgjdbc/pgjdbc/commit/acb9bddf36a8af6d1dd09857a6a05014c3e8849a)
* chore: skip CI builds for tags; skip Fedora and extendedCacheEverything jobs when building pull requests [3ba3b63](https://github.com/pgjdbc/pgjdbc/commit/3ba3b6334761909183334a3be3af0aa8dc4798da)
* fix: avoid NPE from getObject(..., Date.class) and getObject(..., Calendar.class) on null timestamps [PR 1071](https://github.com/pgjdbc/pgjdbc/pull/1071) [eb33c4c](https://github.com/pgjdbc/pgjdbc/commit/eb33c4c8e27d6df6ccd9c0a81eb119edeb069d55)
* test: add "as" to test queries so they work with PostgreSQL 8.3 [71b3c11](https://github.com/pgjdbc/pgjdbc/commit/71b3c118f6a9e125c06e58faa50bf54b6a8f3400)
* docs: make pgjdbc's javadocs to inherit base Java documentation [eb406dc](https://github.com/pgjdbc/pgjdbc/commit/eb406dcbee469a8724723f008f7dc5a515457cbe)

Zemian Deng (3):

* refactor: use PGProperty enum instead of text ref for targetServerType, hostRecheckSeconds, loadBalanceHosts [PR 912](https://github.com/pgjdbc/pgjdbc/pull/912) (#915) [b0cfc33](https://github.com/pgjdbc/pgjdbc/commit/b0cfc33483759ed3583b57cd845311d17670524f)
* fix: correct javadoc on PGResultSetMetaData.getFormat [PR 917](https://github.com/pgjdbc/pgjdbc/pull/917) [cd77693](https://github.com/pgjdbc/pgjdbc/commit/cd77693ca22924479a39b8d925f276879023672a)
* fix: Correct DatabaseMetaData.getFunctions() implementation [PR 918](https://github.com/pgjdbc/pgjdbc/pull/918) [8884202](https://github.com/pgjdbc/pgjdbc/commit/8884202b9e7785a1eaf67ddcd97f2ba689d0cf19)

bpd0018 (3):

* docs - change load.md to reflect current practice [PR 1058](https://github.com/pgjdbc/pgjdbc/pull/1058) [90535d9](https://github.com/pgjdbc/pgjdbc/commit/90535d9289141c398b2e62f2ee7571617c5aecc3)
* docs: fix the URL regex [PR 1057](https://github.com/pgjdbc/pgjdbc/pull/1057) [6c5490f](https://github.com/pgjdbc/pgjdbc/commit/6c5490f90da434f37abd0be0f7bbdc38169ec33f)
* docs: fix no parameter connect string example [PR 1056](https://github.com/pgjdbc/pgjdbc/pull/1056) [bb8a315](https://github.com/pgjdbc/pgjdbc/commit/bb8a31508f3caef7532b87b50c19e092af2ec5f0)

djydewang (1):

* style: disallowing user to use incomplete fully qualified Check names in config file [PR 961](https://github.com/pgjdbc/pgjdbc/pull/961) [3286c8c](https://github.com/pgjdbc/pgjdbc/commit/3286c8caa16efe59307b2713784c348e603ee67d)

eperez (1):

* Someone forgot to get the next column [PR 973](https://github.com/pgjdbc/pgjdbc/pull/973) [15aec6a](https://github.com/pgjdbc/pgjdbc/commit/15aec6a99c5615cdf0c0adaf5fc47b5419c617d4)

mjanczykowski (1):

* feat: add setURL method to BaseDataSource [PR 999](https://github.com/pgjdbc/pgjdbc/pull/999) [2277ffb](https://github.com/pgjdbc/pgjdbc/commit/2277ffb7b65d3cba9ef05be36408e2fdbef00ee7)

rnveach (1):

* style: remove deprecated maxLineLength from LeftCurlyCheck [PR 904](https://github.com/pgjdbc/pgjdbc/pull/904) [5f083d1](https://github.com/pgjdbc/pgjdbc/commit/5f083d118eea30e180500864d70f292b411c19af)

steinarb (1):
* fix: add Provide-Capability org.osgi.service.jdbc.DataSourceFactory to OSGi manifest [Issue 1029](https://github.com/pgjdbc/pgjdbc/issues/1029)

zapov (1):

* fix: avoid integer overflow when sending large arguments [PR 946](https://github.com/pgjdbc/pgjdbc/pull/946) [266ed61](https://github.com/pgjdbc/pgjdbc/commit/266ed61b30e89c2840b7967a8af7ac8ab86407ff)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[AlexElin](https://github.com/AlexElin)  
[Álvaro Hernández Tortosa](https://github.com/ahachete)  
[Barnabas Bodnar](https://github.com/bbodnar)  
[Brett Okken](https://github.com/bokken)  
[Brett Wooldridge](https://github.com/brettwooldridge)  
[Chen Huajun](https://github.com/ChenHuajun)  
[Dave Cramer](davec@postgresintl.com)  
[Hugh Cole-Baker](https://github.com/sigmaris)  
[Jeff Klukas](https://github.com/jklukas)  
[Joe Kutner](https://github.com/jkutner)  
[Jorge Solorzano](https://github.com/jorsol)  
[Magnus](https://github.com/magJ)  
[Magnus Hagander](https://github.com/mhagander)  
[MichaelZg](https://github.com/michaelzg)  
[Michael Glaesemann](https://github.com/grzm)  
[Pavel Raiskup](https://github.com/praiskup)  
[Philippe Marschall](https://github.com/marschall)  
[Piyush Sharma](https://github.com/ps-sp)  
[Sehrope Sarkuni](https://github.com/sehrope)  
[Thach Hoang](https://github.com/thachhoang)  
[Vladimir Sitnikov](https://github.com/vlsi)  
[Zemian Deng](https://github.com/zemian)  
[bpd0018](https://github.com/bpd0018)  
[djydewang](https://github.com/djydewang)  
[eperez](https://github.com/eperez)  
[mjanczykowski](https://github.com/mjanczykowski)  
[rnveach](https://github.com/rnveach)  
[zapov](https://github.com/zapov)  
