/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.ExtensionDependency;
import sun.misc.FileURLMapper;
import sun.misc.InvalidJarIndexException;
import sun.misc.JarIndex;
import sun.misc.Resource;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private ArrayList path = new ArrayList();
    private Stack urls = new Stack();
    private ArrayList loaders = new ArrayList();
    private HashMap lmap = new HashMap();
    private URLStreamHandler jarHandler;

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        for (int i = 0; i < uRLArray.length; ++i) {
            this.path.add(uRLArray[i]);
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURL(URL uRL) {
        Stack stack = this.urls;
        synchronized (stack) {
            this.urls.add(0, uRL);
            this.path.add(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            return (URL[])this.path.toArray(new URL[this.path.size()]);
        }
    }

    public URL findResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            URL uRL = loader.findResource(string, bl);
            if (uRL != null) {
                return uRL;
            }
            ++n;
        }
        return null;
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Enumeration findResources(final String string, final boolean bl) {
        return new Enumeration(){
            private int index = 0;
            private URL url = null;

            private boolean next() {
                Loader loader;
                if (this.url != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.url = loader.findResource(string, bl);
                    if (this.url == null) continue;
                    return true;
                }
                return false;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }
        };
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Enumeration getResources(final String string, final boolean bl) {
        return new Enumeration(){
            private int index = 0;
            private Resource res = null;

            private boolean next() {
                Loader loader;
                if (this.res != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.res = loader.getResource(string, bl);
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
        };
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Loader getLoader(int n) {
        while (this.loaders.size() < n + 1) {
            URL uRL;
            Object object;
            block7: {
                object = this.urls;
                synchronized (object) {
                    if (this.urls.empty()) {
                        return null;
                    }
                    uRL = (URL)this.urls.pop();
                }
                if (this.lmap.containsKey(uRL)) continue;
                try {
                    object = this.getLoader(uRL);
                    URL[] uRLArray = ((Loader)object).getClassPath();
                    if (uRLArray == null) break block7;
                    this.push(uRLArray);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.loaders.add(object);
            this.lmap.put(uRL, object);
        }
        return (Loader)this.loaders.get(n);
    }

    private Loader getLoader(final URL uRL) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string = uRL.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals(uRL.getProtocol())) {
                            return new FileLoader(uRL);
                        }
                        return new Loader(uRL);
                    }
                    return new JarLoader(uRL, URLClassPath.this.jarHandler, URLClassPath.this.lmap);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] uRLArray) {
        Stack stack = this.urls;
        synchronized (stack) {
            for (int i = uRLArray.length - 1; i >= 0; --i) {
                this.urls.push(uRLArray[i]);
            }
        }
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            try {
                object = new File(object.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                uRLArray[n++] = ParseUtil.fileToEncodedURL((File)object);
            }
            catch (IOException iOException) {}
        }
        if (uRLArray.length != n) {
            object = new URL[n];
            System.arraycopy(uRLArray, 0, object, 0, n);
            uRLArray = object;
        }
        return uRLArray;
    }

    public URL checkURL(URL uRL) {
        try {
            URLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static void check(URL uRL) throws IOException {
        URLConnection uRLConnection;
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = (uRLConnection = uRL.openConnection()).getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    URL uRL2 = uRL;
                    if (uRLConnection instanceof JarURLConnection) {
                        uRL2 = ((JarURLConnection)uRLConnection).getJarFileURL();
                    }
                    securityManager.checkConnect(uRL2.getHost(), uRL2.getPort());
                }
                throw securityException;
            }
        }
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            this.dir = new File(string);
        }

        URL findResource(String string, boolean bl) {
            Resource resource = this.getResource(string, bl);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), ".");
                URL uRL2 = new URL(this.getBaseURL(), string);
                if (!uRL2.getFile().startsWith(uRL.getFile())) {
                    return null;
                }
                if (bl) {
                    URLClassPath.check(uRL2);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new Resource(this, string, uRL2, file){
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ URL val$url;
                        private final /* synthetic */ File val$file;
                        private final /* synthetic */ FileLoader this$0;
                        {
                            this.this$0 = fileLoader;
                            this.val$name = string;
                            this.val$url = uRL;
                            this.val$file = file;
                        }

                        public String getName() {
                            return this.val$name;
                        }

                        public URL getURL() {
                            return this.val$url;
                        }

                        public URL getCodeSourceURL() {
                            return this.this$0.getBaseURL();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(this.val$file);
                        }

                        public int getContentLength() throws IOException {
                            return (int)this.val$file.length();
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private JarIndex index;
        private URLStreamHandler handler;
        private HashMap lmap;

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler, HashMap hashMap) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/", uRLStreamHandler));
            this.jar = this.getJarFile(uRL);
            this.index = JarIndex.getJarIndex(this.jar);
            this.csu = uRL;
            this.handler = uRLStreamHandler;
            this.lmap = hashMap;
            if (this.index != null) {
                String[] stringArray = this.index.getJarFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        URL uRL2 = new URL(this.csu, stringArray[i]);
                        if (this.lmap.containsKey(uRL2)) continue;
                        this.lmap.put(uRL2, null);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                FileURLMapper fileURLMapper = new FileURLMapper(uRL);
                if (!fileURLMapper.exists()) {
                    throw new FileNotFoundException(fileURLMapper.getPath());
                }
                return new JarFile(fileURLMapper.getPath());
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        JarIndex getIndex() {
            return this.index;
        }

        Resource checkResource(String string, boolean bl, JarEntry jarEntry) {
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), string);
                if (bl) {
                    URLClassPath.check(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (AccessControlException accessControlException) {
                return null;
            }
            return new Resource(this, string, uRL, jarEntry){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ JarEntry val$entry;
                private final /* synthetic */ JarLoader this$0;
                {
                    this.this$0 = jarLoader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$entry = jarEntry;
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getURL() {
                    return this.val$url;
                }

                public URL getCodeSourceURL() {
                    return JarLoader.access$400(this.this$0);
                }

                public InputStream getInputStream() throws IOException {
                    return JarLoader.access$500(this.this$0).getInputStream(this.val$entry);
                }

                public int getContentLength() {
                    return (int)this.val$entry.getSize();
                }

                public Manifest getManifest() throws IOException {
                    return JarLoader.access$500(this.this$0).getManifest();
                }

                public Certificate[] getCertificates() {
                    return this.val$entry.getCertificates();
                }
            };
        }

        boolean validIndex(String string) {
            String string2 = string;
            int n = string.lastIndexOf("/");
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            Enumeration enumeration = this.jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string3 = zipEntry.getName();
                n = string3.lastIndexOf("/");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if (!string3.equals(string2)) continue;
                return true;
            }
            return false;
        }

        URL findResource(String string, boolean bl) {
            Resource resource = this.getResource(string, bl);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        Resource getResource(String string, boolean bl) {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                return this.checkResource(string, bl, jarEntry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet hashSet = new HashSet();
            return this.getResource(string, bl, hashSet);
        }

        Resource getResource(String string, boolean bl, Set set) {
            int n = 0;
            LinkedList linkedList = null;
            linkedList = this.index.get(string);
            if (linkedList == null) {
                return null;
            }
            do {
                Object[] objectArray = linkedList.toArray();
                int n2 = linkedList.size();
                while (n < n2) {
                    Resource resource;
                    boolean bl2;
                    JarLoader jarLoader;
                    URL uRL;
                    block10: {
                        String string2 = (String)objectArray[n++];
                        try {
                            uRL = new URL(this.csu, string2);
                            jarLoader = (JarLoader)this.lmap.get(uRL);
                            if (jarLoader != null) break block10;
                            jarLoader = (JarLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                                private final /* synthetic */ URL val$url;
                                private final /* synthetic */ JarLoader this$0;
                                {
                                    this.this$0 = jarLoader;
                                    this.val$url = uRL;
                                }

                                public Object run() throws IOException {
                                    return new JarLoader(this.val$url, JarLoader.access$600(this.this$0), JarLoader.access$700(this.this$0));
                                }
                            });
                            JarIndex jarIndex = jarLoader.getIndex();
                            if (jarIndex != null) {
                                int n3 = string2.lastIndexOf("/");
                                jarIndex.merge(this.index, n3 == -1 ? null : string2.substring(0, n3 + 1));
                            }
                            this.lmap.put(uRL, jarLoader);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            continue;
                        }
                    }
                    boolean bl3 = bl2 = !set.add(uRL);
                    if (!bl2) {
                        JarEntry jarEntry = jarLoader.jar.getJarEntry(string);
                        if (jarEntry != null) {
                            return jarLoader.checkResource(string, bl, jarEntry);
                        }
                        if (!jarLoader.validIndex(string)) {
                            throw new InvalidJarIndexException("Invalid index");
                        }
                    }
                    if (bl2 || jarLoader == this || jarLoader.getIndex() == null || (resource = jarLoader.getResource(string, bl, set)) == null) continue;
                    return resource;
                }
            } while (n < (linkedList = this.index.get(string)).size());
            return null;
        }

        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            if (this.index != null) {
                return null;
            }
            this.parseExtensionsDependencies();
            Manifest manifest = this.jar.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        private void parseExtensionsDependencies() throws IOException {
            ExtensionDependency.checkExtensionsDependencies(this.jar);
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                ++n;
            }
            return uRLArray;
        }

        static /* synthetic */ URL access$400(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static /* synthetic */ JarFile access$500(JarLoader jarLoader) {
            return jarLoader.jar;
        }

        static /* synthetic */ URLStreamHandler access$600(JarLoader jarLoader) {
            return jarLoader.handler;
        }

        static /* synthetic */ HashMap access$700(JarLoader jarLoader) {
            return jarLoader.lmap;
        }
    }

    private static class Loader {
        private final URL base;

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL findResource(String string, boolean bl) {
            URL uRL;
            if (string == null) {
                return null;
            }
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                URLConnection uRLConnection;
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("HEAD");
                    if (httpURLConnection.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                return uRL;
            }
            catch (Exception exception) {
                return null;
            }
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    URLClassPath.check(uRL);
                }
                uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(this, string, uRL, uRLConnection){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ URLConnection val$uc;
                private final /* synthetic */ Loader this$0;
                {
                    this.this$0 = loader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$uc = uRLConnection;
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getURL() {
                    return this.val$url;
                }

                public URL getCodeSourceURL() {
                    return Loader.access$300(this.this$0);
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$uc.getInputStream();
                }

                public int getContentLength() throws IOException {
                    return this.val$uc.getContentLength();
                }
            };
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        static /* synthetic */ URL access$300(Loader loader) {
            return loader.base;
        }
    }
}

