/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertTrue;
import static org.testng.AssertJUnit.fail;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/**
 * Unit test for FIFOConfiguration.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 4444 $
 */
@Test(groups = {"functional"})
public class FIFOConfigurationTest
{

   public void testXMLParse() throws Exception
   {
      FIFOConfiguration config = new FIFOConfiguration();
      String xml = "<region name=\"abc\">" +
            "<attribute name=\"maxNodes\">1000</attribute>" +
            "</region>";

      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(1000, config.getMaxNodes());

   }

   public void testXMLParse2() throws Exception
   {
      FIFOConfiguration config = new FIFOConfiguration();
      String xml = "<region name=\"abc\">" +
            "</region>";

      Element element = XmlHelper.stringToElement(xml);

      try
      {
         XmlConfigurationParser.parseEvictionPolicyConfig(element, config);
      }
      catch (ConfigurationException ce)
      {
         assertTrue("Configure Exception properly thrown", true);
         return;
      }
      fail("Invalid region FIFO configuration did not cause ConfigureException to be thrown");
   }

   public void testXMLParse3() throws Exception
   {
      FIFOConfiguration config = new FIFOConfiguration();
      String xml = "<region>" +
            "<attribute name=\"maxNodes\">1000</attribute>" +
            "</region>";

      Element element = XmlHelper.stringToElement(xml);

      try
      {
         XmlConfigurationParser.parseEvictionPolicyConfig(element, config);
      }
      catch (ConfigurationException ce)
      {
         assertTrue("Configure Exception properly thrown", true);
      }
   }
}
