package org.jboss.cache.notifications.event;

/**
 * This event is passed in to any method annotated with {@link org.jboss.cache.notifications.annotation.TransactionCompleted}.
 * <p/>
 * Note that this event is only delivered <i>after the fact</i>, i.e., you will never see an instance of this event
 * with {@link #isPre()} being set to <tt>true</tt>.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
public interface TransactionCompletedEvent extends TransactionalEvent
{
   /**
    * @return if <tt>true</tt>, the transaction completed by committing successfully.  If <tt>false</tt>, the transaction
    *         completed with a rollback.
    */
   boolean isSuccessful();
}
