/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib;

import com.amazon.aes.webservices.client.blockdevicelib.DiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileDiskImage
extends DiskImage {
    protected RandomAccessFile image;
    protected long size;

    public FileDiskImage(File diskImage) throws ImageVerificationException {
        try {
            this.image = new RandomAccessFile(diskImage, "r");
            this.size = this.image.length();
        }
        catch (IOException e) {
            throw new ImageVerificationException("Image not found.", e.getCause());
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public byte[] read(long offset, int length) throws ImageVerificationException {
        try {
            byte[] data = new byte[length];
            this.image.seek(offset);
            this.image.readFully(data);
            return data;
        }
        catch (IOException e) {
            throw new ImageVerificationException("Failed to read " + length + " bytes of data from offset 0x" + Double.toHexString(offset), e.getCause());
        }
    }
}

