/* IP4xxx ELF support for BFD.
   Copyright (C) 2000 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _ELF_IP_H
#define _ELF_IP_H

#include "elf/reloc-macros.h"

/* Relocations.  */
START_RELOC_NUMBERS (elf_ip_reloc_type)
  RELOC_NUMBER (R_IP4K_NONE, 0)
  RELOC_NUMBER (R_IP4K_16, 1)
  RELOC_NUMBER (R_IP4K_32, 2)
  RELOC_NUMBER (R_IP4K_LO16, 3)
  RELOC_NUMBER (R_IP4K_HI16, 4)
  RELOC_NUMBER (R_IP4K_21_PCREL, 5)
  RELOC_NUMBER (R_IP4K_24_PCREL, 6)
  RELOC_NUMBER (R_IP4K_HI24, 7)
  RELOC_NUMBER (R_IP4K_LO7_S, 8)
  RELOC_NUMBER (R_IP4K_LO7_2_S, 9)
  RELOC_NUMBER (R_IP4K_LO7_4_S, 10)
  RELOC_NUMBER (R_IP4K_LO7_D, 11)
  RELOC_NUMBER (R_IP4K_LO7_2_D, 12)
  RELOC_NUMBER (R_IP4K_LO7_4_D, 13)
  RELOC_NUMBER (R_IP4K_32_HARVARD, 14)
  RELOC_NUMBER (R_IP4K_GNU_VTINHERIT, 200)
  RELOC_NUMBER (R_IP4K_GNU_VTENTRY, 201)
END_RELOC_NUMBERS(R_IP4K_max)

#endif /* _ELF_IP_H */
