/*
 * Copyright (C) 2014-2017 Stichting Mapcode Foundation (http://www.mapcode.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// *** GENERATED FILE (fast_territories.cpp), DO NOT CHANGE OR PRETTIFY ***
#include "../mapcodelib/mapcode_territories.h"

typedef struct {
    const char *codeISO;
    enum Territory territory;
    int isAlias;
    int needsParent;
    enum Territory parent;
} TestTerritoryInfo;

static const TestTerritoryInfo TEST_TERRITORIES[] = {
        {"AAA",    TERRITORY_AAA,    0, 0, TERRITORY_NONE},
        {"AB",     TERRITORY_CA_AB,  0, 0, TERRITORY_CAN},
        {"ABW",    TERRITORY_ABW,    0, 0, TERRITORY_NONE},
        {"AC",     TERRITORY_BR_AC,  0, 0, TERRITORY_BRA},
        {"ACT",    TERRITORY_AU_ACT, 0, 0, TERRITORY_AUS},
        {"AD",     TERRITORY_RU_AD,  0, 0, TERRITORY_RUS},
        {"AFG",    TERRITORY_AFG,    0, 0, TERRITORY_NONE},
        {"AG",     TERRITORY_MX_AGU, 1, 0, TERRITORY_MEX},
        {"AGO",    TERRITORY_AGO,    0, 0, TERRITORY_NONE},
        {"AGU",    TERRITORY_MX_AGU, 0, 0, TERRITORY_MEX},
        {"AH",     TERRITORY_CN_AH,  0, 0, TERRITORY_CHN},
        {"AIA",    TERRITORY_AIA,    0, 0, TERRITORY_NONE},
        {"AK",     TERRITORY_US_AK,  0, 0, TERRITORY_USA},
        {"AL",     TERRITORY_RU_AL,  0, 1, TERRITORY_RUS},
        {"AL",     TERRITORY_US_AL,  0, 1, TERRITORY_USA},
        {"AL",     TERRITORY_BR_AL,  0, 1, TERRITORY_BRA},
        {"ALA",    TERRITORY_ALA,    0, 0, TERRITORY_NONE},
        {"ALB",    TERRITORY_ALB,    0, 0, TERRITORY_NONE},
        {"ALT",    TERRITORY_RU_ALT, 0, 0, TERRITORY_RUS},
        {"AM",     TERRITORY_BR_AM,  0, 0, TERRITORY_BRA},
        {"AMU",    TERRITORY_RU_AMU, 0, 0, TERRITORY_RUS},
        {"AN",     TERRITORY_IN_AN,  0, 0, TERRITORY_IND},
        {"AND",    TERRITORY_AND,    0, 0, TERRITORY_NONE},
        {"AP",     TERRITORY_BR_AP,  0, 1, TERRITORY_BRA},
        {"AP",     TERRITORY_IN_AP,  0, 1, TERRITORY_IND},
        {"AR",     TERRITORY_US_AR,  0, 1, TERRITORY_USA},
        {"AR",     TERRITORY_IN_AR,  0, 1, TERRITORY_IND},
        {"ARE",    TERRITORY_ARE,    0, 0, TERRITORY_NONE},
        {"ARG",    TERRITORY_ARG,    0, 0, TERRITORY_NONE},
        {"ARK",    TERRITORY_RU_ARK, 0, 0, TERRITORY_RUS},
        {"ARM",    TERRITORY_ARM,    0, 0, TERRITORY_NONE},
        {"AS",     TERRITORY_IN_AS,  0, 1, TERRITORY_IND},
        {"AS",     TERRITORY_ASM,    1, 1, TERRITORY_USA},
        {"ASC",    TERRITORY_SHN,    1, 0, TERRITORY_NONE},
        {"ASM",    TERRITORY_ASM,    0, 0, TERRITORY_NONE},
        {"AST",    TERRITORY_RU_AST, 0, 0, TERRITORY_RUS},
        {"ATA",    TERRITORY_ATA,    0, 0, TERRITORY_NONE},
        {"ATF",    TERRITORY_ATF,    0, 0, TERRITORY_NONE},
        {"ATG",    TERRITORY_ATG,    0, 0, TERRITORY_NONE},
        {"AU",     TERRITORY_AUS,    1, 0, TERRITORY_NONE},
        {"AU-ACT", TERRITORY_AU_ACT, 0, 0, TERRITORY_AUS},
        {"AU-CC",  TERRITORY_CCK,    1, 0, TERRITORY_AUS},
        {"AU-CX",  TERRITORY_CXR,    1, 0, TERRITORY_AUS},
        {"AU-HM",  TERRITORY_HMD,    1, 0, TERRITORY_AUS},
        {"AU-JBT", TERRITORY_AU_JBT, 0, 0, TERRITORY_AUS},
        {"AU-NF",  TERRITORY_NFK,    1, 0, TERRITORY_AUS},
        {"AU-NSW", TERRITORY_AU_NSW, 0, 0, TERRITORY_AUS},
        {"AU-NT",  TERRITORY_AU_NT,  0, 0, TERRITORY_AUS},
        {"AU-QLD", TERRITORY_AU_QLD, 0, 0, TERRITORY_AUS},
        {"AU-SA",  TERRITORY_AU_SA,  0, 0, TERRITORY_AUS},
        {"AU-TAS", TERRITORY_AU_TAS, 0, 0, TERRITORY_AUS},
        {"AU-VIC", TERRITORY_AU_VIC, 0, 0, TERRITORY_AUS},
        {"AU-WA",  TERRITORY_AU_WA,  0, 0, TERRITORY_AUS},
        {"AUS",    TERRITORY_AUS,    0, 0, TERRITORY_NONE},
        {"AUT",    TERRITORY_AUT,    0, 0, TERRITORY_NONE},
        {"AZ",     TERRITORY_US_AZ,  0, 0, TERRITORY_USA},
        {"AZE",    TERRITORY_AZE,    0, 0, TERRITORY_NONE},
        {"BA",     TERRITORY_RU_BA,  0, 1, TERRITORY_RUS},
        {"BA",     TERRITORY_BR_BA,  0, 1, TERRITORY_BRA},
        {"BC",     TERRITORY_CA_BC,  0, 1, TERRITORY_CAN},
        {"BC",     TERRITORY_MX_BCN, 1, 1, TERRITORY_MEX},
        {"BCN",    TERRITORY_MX_BCN, 0, 0, TERRITORY_MEX},
        {"BCS",    TERRITORY_MX_BCS, 0, 0, TERRITORY_MEX},
        {"BDI",    TERRITORY_BDI,    0, 0, TERRITORY_NONE},
        {"BE",     TERRITORY_RU_BE,  0, 0, TERRITORY_RUS},
        {"BEL",    TERRITORY_BEL,    0, 0, TERRITORY_NONE},
        {"BEN",    TERRITORY_BEN,    0, 0, TERRITORY_NONE},
        {"BES",    TERRITORY_BES,    0, 0, TERRITORY_NONE},
        {"BFA",    TERRITORY_BFA,    0, 0, TERRITORY_NONE},
        {"BGD",    TERRITORY_BGD,    0, 0, TERRITORY_NONE},
        {"BGR",    TERRITORY_BGR,    0, 0, TERRITORY_NONE},
        {"BHR",    TERRITORY_BHR,    0, 0, TERRITORY_NONE},
        {"BHS",    TERRITORY_BHS,    0, 0, TERRITORY_NONE},
        {"BIH",    TERRITORY_BIH,    0, 0, TERRITORY_NONE},
        {"BJ",     TERRITORY_CN_BJ,  0, 0, TERRITORY_CHN},
        {"BLM",    TERRITORY_BLM,    0, 0, TERRITORY_NONE},
        {"BLR",    TERRITORY_BLR,    0, 0, TERRITORY_NONE},
        {"BLZ",    TERRITORY_BLZ,    0, 0, TERRITORY_NONE},
        {"BMU",    TERRITORY_BMU,    0, 0, TERRITORY_NONE},
        {"BOL",    TERRITORY_BOL,    0, 0, TERRITORY_NONE},
        {"BR",     TERRITORY_IN_BR,  0, 0, TERRITORY_IND},
        {"BR-AC",  TERRITORY_BR_AC,  0, 0, TERRITORY_BRA},
        {"BR-AL",  TERRITORY_BR_AL,  0, 0, TERRITORY_BRA},
        {"BR-AM",  TERRITORY_BR_AM,  0, 0, TERRITORY_BRA},
        {"BR-AP",  TERRITORY_BR_AP,  0, 0, TERRITORY_BRA},
        {"BR-BA",  TERRITORY_BR_BA,  0, 0, TERRITORY_BRA},
        {"BR-CE",  TERRITORY_BR_CE,  0, 0, TERRITORY_BRA},
        {"BR-DF",  TERRITORY_BR_DF,  0, 0, TERRITORY_BRA},
        {"BR-ES",  TERRITORY_BR_ES,  0, 0, TERRITORY_BRA},
        {"BR-GO",  TERRITORY_BR_GO,  0, 0, TERRITORY_BRA},
        {"BR-MA",  TERRITORY_BR_MA,  0, 0, TERRITORY_BRA},
        {"BR-MG",  TERRITORY_BR_MG,  0, 0, TERRITORY_BRA},
        {"BR-MS",  TERRITORY_BR_MS,  0, 0, TERRITORY_BRA},
        {"BR-MT",  TERRITORY_BR_MT,  0, 0, TERRITORY_BRA},
        {"BR-PA",  TERRITORY_BR_PA,  0, 0, TERRITORY_BRA},
        {"BR-PB",  TERRITORY_BR_PB,  0, 0, TERRITORY_BRA},
        {"BR-PE",  TERRITORY_BR_PE,  0, 0, TERRITORY_BRA},
        {"BR-PI",  TERRITORY_BR_PI,  0, 0, TERRITORY_BRA},
        {"BR-PR",  TERRITORY_BR_PR,  0, 0, TERRITORY_BRA},
        {"BR-RJ",  TERRITORY_BR_RJ,  0, 0, TERRITORY_BRA},
        {"BR-RN",  TERRITORY_BR_RN,  0, 0, TERRITORY_BRA},
        {"BR-RO",  TERRITORY_BR_RO,  0, 0, TERRITORY_BRA},
        {"BR-RR",  TERRITORY_BR_RR,  0, 0, TERRITORY_BRA},
        {"BR-RS",  TERRITORY_BR_RS,  0, 0, TERRITORY_BRA},
        {"BR-SC",  TERRITORY_BR_SC,  0, 0, TERRITORY_BRA},
        {"BR-SE",  TERRITORY_BR_SE,  0, 0, TERRITORY_BRA},
        {"BR-SP",  TERRITORY_BR_SP,  0, 0, TERRITORY_BRA},
        {"BR-TO",  TERRITORY_BR_TO,  0, 0, TERRITORY_BRA},
        {"BRA",    TERRITORY_BRA,    0, 0, TERRITORY_NONE},
        {"BRB",    TERRITORY_BRB,    0, 0, TERRITORY_NONE},
        {"BRN",    TERRITORY_BRN,    0, 0, TERRITORY_NONE},
        {"BRY",    TERRITORY_RU_BRY, 0, 0, TERRITORY_RUS},
        {"BS",     TERRITORY_MX_BCS, 1, 0, TERRITORY_MEX},
        {"BTN",    TERRITORY_BTN,    0, 0, TERRITORY_NONE},
        {"BU",     TERRITORY_RU_BU,  0, 0, TERRITORY_RUS},
        {"BVT",    TERRITORY_BVT,    0, 0, TERRITORY_NONE},
        {"BWA",    TERRITORY_BWA,    0, 0, TERRITORY_NONE},
        {"CA",     TERRITORY_US_CA,  0, 0, TERRITORY_USA},
        {"CA-AB",  TERRITORY_CA_AB,  0, 0, TERRITORY_CAN},
        {"CA-BC",  TERRITORY_CA_BC,  0, 0, TERRITORY_CAN},
        {"CA-MB",  TERRITORY_CA_MB,  0, 0, TERRITORY_CAN},
        {"CA-NB",  TERRITORY_CA_NB,  0, 0, TERRITORY_CAN},
        {"CA-NL",  TERRITORY_CA_NL,  0, 0, TERRITORY_CAN},
        {"CA-NS",  TERRITORY_CA_NS,  0, 0, TERRITORY_CAN},
        {"CA-NT",  TERRITORY_CA_NT,  0, 0, TERRITORY_CAN},
        {"CA-NU",  TERRITORY_CA_NU,  0, 0, TERRITORY_CAN},
        {"CA-ON",  TERRITORY_CA_ON,  0, 0, TERRITORY_CAN},
        {"CA-PE",  TERRITORY_CA_PE,  0, 0, TERRITORY_CAN},
        {"CA-QC",  TERRITORY_CA_QC,  0, 0, TERRITORY_CAN},
        {"CA-SK",  TERRITORY_CA_SK,  0, 0, TERRITORY_CAN},
        {"CA-YT",  TERRITORY_CA_YT,  0, 0, TERRITORY_CAN},
        {"CAF",    TERRITORY_CAF,    0, 0, TERRITORY_NONE},
        {"CAM",    TERRITORY_MX_CAM, 0, 0, TERRITORY_MEX},
        {"CAN",    TERRITORY_CAN,    0, 0, TERRITORY_NONE},
        {"CC",     TERRITORY_CCK,    1, 0, TERRITORY_AUS},
        {"CCK",    TERRITORY_CCK,    0, 0, TERRITORY_NONE},
        {"CE",     TERRITORY_RU_CE,  0, 1, TERRITORY_RUS},
        {"CE",     TERRITORY_BR_CE,  0, 1, TERRITORY_BRA},
        {"CG",     TERRITORY_IN_CT,  1, 0, TERRITORY_IND},
        {"CH",     TERRITORY_RU_CH,  0, 1, TERRITORY_RUS},
        {"CH",     TERRITORY_IN_CH,  0, 1, TERRITORY_IND},
        {"CH",     TERRITORY_MX_CHH, 1, 1, TERRITORY_MEX},
        {"CHE",    TERRITORY_CHE,    0, 0, TERRITORY_NONE},
        {"CHH",    TERRITORY_MX_CHH, 0, 0, TERRITORY_MEX},
        {"CHL",    TERRITORY_CHL,    0, 0, TERRITORY_NONE},
        {"CHN",    TERRITORY_CHN,    0, 0, TERRITORY_NONE},
        {"CHP",    TERRITORY_MX_CHP, 0, 0, TERRITORY_MEX},
        {"CHU",    TERRITORY_RU_CHU, 0, 0, TERRITORY_RUS},
        {"CIV",    TERRITORY_CIV,    0, 0, TERRITORY_NONE},
        {"CL",     TERRITORY_MX_CL,  0, 0, TERRITORY_MEX},
        {"CM",     TERRITORY_MX_CAM, 1, 0, TERRITORY_MEX},
        {"CMR",    TERRITORY_CMR,    0, 0, TERRITORY_NONE},
        {"CN",     TERRITORY_CHN,    1, 0, TERRITORY_NONE},
        {"CN-11",  TERRITORY_CN_BJ,  1, 0, TERRITORY_CHN},
        {"CN-12",  TERRITORY_CN_TJ,  1, 0, TERRITORY_CHN},
        {"CN-13",  TERRITORY_CN_HE,  1, 0, TERRITORY_CHN},
        {"CN-14",  TERRITORY_CN_SX,  1, 0, TERRITORY_CHN},
        {"CN-15",  TERRITORY_CN_NM,  1, 0, TERRITORY_CHN},
        {"CN-21",  TERRITORY_CN_LN,  1, 0, TERRITORY_CHN},
        {"CN-22",  TERRITORY_CN_JL,  1, 0, TERRITORY_CHN},
        {"CN-23",  TERRITORY_CN_HL,  1, 0, TERRITORY_CHN},
        {"CN-31",  TERRITORY_CN_SH,  1, 0, TERRITORY_CHN},
        {"CN-32",  TERRITORY_CN_JS,  1, 0, TERRITORY_CHN},
        {"CN-33",  TERRITORY_CN_ZJ,  1, 0, TERRITORY_CHN},
        {"CN-34",  TERRITORY_CN_AH,  1, 0, TERRITORY_CHN},
        {"CN-35",  TERRITORY_CN_FJ,  1, 0, TERRITORY_CHN},
        {"CN-36",  TERRITORY_CN_JX,  1, 0, TERRITORY_CHN},
        {"CN-37",  TERRITORY_CN_SD,  1, 0, TERRITORY_CHN},
        {"CN-41",  TERRITORY_CN_HA,  1, 0, TERRITORY_CHN},
        {"CN-42",  TERRITORY_CN_HB,  1, 0, TERRITORY_CHN},
        {"CN-43",  TERRITORY_CN_HN,  1, 0, TERRITORY_CHN},
        {"CN-44",  TERRITORY_CN_GD,  1, 0, TERRITORY_CHN},
        {"CN-45",  TERRITORY_CN_GX,  1, 0, TERRITORY_CHN},
        {"CN-46",  TERRITORY_CN_HI,  1, 0, TERRITORY_CHN},
        {"CN-50",  TERRITORY_CN_CQ,  1, 0, TERRITORY_CHN},
        {"CN-51",  TERRITORY_CN_SC,  1, 0, TERRITORY_CHN},
        {"CN-52",  TERRITORY_CN_GZ,  1, 0, TERRITORY_CHN},
        {"CN-53",  TERRITORY_CN_YN,  1, 0, TERRITORY_CHN},
        {"CN-54",  TERRITORY_CN_XZ,  1, 0, TERRITORY_CHN},
        {"CN-61",  TERRITORY_CN_SN,  1, 0, TERRITORY_CHN},
        {"CN-62",  TERRITORY_CN_GS,  1, 0, TERRITORY_CHN},
        {"CN-63",  TERRITORY_CN_QH,  1, 0, TERRITORY_CHN},
        {"CN-64",  TERRITORY_CN_NX,  1, 0, TERRITORY_CHN},
        {"CN-65",  TERRITORY_CN_XJ,  1, 0, TERRITORY_CHN},
        {"CN-71",  TERRITORY_TWN,    1, 0, TERRITORY_CHN},
        {"CN-91",  TERRITORY_HKG,    1, 0, TERRITORY_CHN},
        {"CN-92",  TERRITORY_MAC,    1, 0, TERRITORY_CHN},
        {"CN-AH",  TERRITORY_CN_AH,  0, 0, TERRITORY_CHN},
        {"CN-BJ",  TERRITORY_CN_BJ,  0, 0, TERRITORY_CHN},
        {"CN-CQ",  TERRITORY_CN_CQ,  0, 0, TERRITORY_CHN},
        {"CN-FJ",  TERRITORY_CN_FJ,  0, 0, TERRITORY_CHN},
        {"CN-GD",  TERRITORY_CN_GD,  0, 0, TERRITORY_CHN},
        {"CN-GS",  TERRITORY_CN_GS,  0, 0, TERRITORY_CHN},
        {"CN-GX",  TERRITORY_CN_GX,  0, 0, TERRITORY_CHN},
        {"CN-GZ",  TERRITORY_CN_GZ,  0, 0, TERRITORY_CHN},
        {"CN-HA",  TERRITORY_CN_HA,  0, 0, TERRITORY_CHN},
        {"CN-HB",  TERRITORY_CN_HB,  0, 0, TERRITORY_CHN},
        {"CN-HE",  TERRITORY_CN_HE,  0, 0, TERRITORY_CHN},
        {"CN-HI",  TERRITORY_CN_HI,  0, 0, TERRITORY_CHN},
        {"CN-HK",  TERRITORY_HKG,    1, 0, TERRITORY_CHN},
        {"CN-HL",  TERRITORY_CN_HL,  0, 0, TERRITORY_CHN},
        {"CN-HN",  TERRITORY_CN_HN,  0, 0, TERRITORY_CHN},
        {"CN-JL",  TERRITORY_CN_JL,  0, 0, TERRITORY_CHN},
        {"CN-JS",  TERRITORY_CN_JS,  0, 0, TERRITORY_CHN},
        {"CN-JX",  TERRITORY_CN_JX,  0, 0, TERRITORY_CHN},
        {"CN-LN",  TERRITORY_CN_LN,  0, 0, TERRITORY_CHN},
        {"CN-MC",  TERRITORY_MAC,    1, 0, TERRITORY_CHN},
        {"CN-NM",  TERRITORY_CN_NM,  0, 0, TERRITORY_CHN},
        {"CN-NX",  TERRITORY_CN_NX,  0, 0, TERRITORY_CHN},
        {"CN-QH",  TERRITORY_CN_QH,  0, 0, TERRITORY_CHN},
        {"CN-SC",  TERRITORY_CN_SC,  0, 0, TERRITORY_CHN},
        {"CN-SD",  TERRITORY_CN_SD,  0, 0, TERRITORY_CHN},
        {"CN-SH",  TERRITORY_CN_SH,  0, 0, TERRITORY_CHN},
        {"CN-SN",  TERRITORY_CN_SN,  0, 0, TERRITORY_CHN},
        {"CN-SX",  TERRITORY_CN_SX,  0, 0, TERRITORY_CHN},
        {"CN-TJ",  TERRITORY_CN_TJ,  0, 0, TERRITORY_CHN},
        {"CN-TW",  TERRITORY_TWN,    1, 0, TERRITORY_CHN},
        {"CN-XJ",  TERRITORY_CN_XJ,  0, 0, TERRITORY_CHN},
        {"CN-XZ",  TERRITORY_CN_XZ,  0, 0, TERRITORY_CHN},
        {"CN-YN",  TERRITORY_CN_YN,  0, 0, TERRITORY_CHN},
        {"CN-ZJ",  TERRITORY_CN_ZJ,  0, 0, TERRITORY_CHN},
        {"CO",     TERRITORY_US_CO,  0, 1, TERRITORY_USA},
        {"CO",     TERRITORY_MX_COA, 1, 1, TERRITORY_MEX},
        {"COA",    TERRITORY_MX_COA, 0, 0, TERRITORY_MEX},
        {"COD",    TERRITORY_COD,    0, 0, TERRITORY_NONE},
        {"COG",    TERRITORY_COG,    0, 0, TERRITORY_NONE},
        {"COK",    TERRITORY_COK,    0, 0, TERRITORY_NONE},
        {"COL",    TERRITORY_COL,    0, 0, TERRITORY_NONE},
        {"COM",    TERRITORY_COM,    0, 0, TERRITORY_NONE},
        {"CPT",    TERRITORY_CPT,    0, 0, TERRITORY_NONE},
        {"CPV",    TERRITORY_CPV,    0, 0, TERRITORY_NONE},
        {"CQ",     TERRITORY_CN_CQ,  0, 0, TERRITORY_CHN},
        {"CRI",    TERRITORY_CRI,    0, 0, TERRITORY_NONE},
        {"CS",     TERRITORY_MX_CHP, 1, 0, TERRITORY_MEX},
        {"CT",     TERRITORY_US_CT,  0, 1, TERRITORY_USA},
        {"CT",     TERRITORY_IN_CT,  0, 1, TERRITORY_IND},
        {"CU",     TERRITORY_RU_CU,  0, 0, TERRITORY_RUS},
        {"CUB",    TERRITORY_CUB,    0, 0, TERRITORY_NONE},
        {"CUW",    TERRITORY_CUW,    0, 0, TERRITORY_NONE},
        {"CX",     TERRITORY_CXR,    1, 0, TERRITORY_AUS},
        {"CXR",    TERRITORY_CXR,    0, 0, TERRITORY_NONE},
        {"CYM",    TERRITORY_CYM,    0, 0, TERRITORY_NONE},
        {"CYP",    TERRITORY_CYP,    0, 0, TERRITORY_NONE},
        {"CZE",    TERRITORY_CZE,    0, 0, TERRITORY_NONE},
        {"DA",     TERRITORY_RU_DA,  0, 0, TERRITORY_RUS},
        {"DC",     TERRITORY_US_DC,  0, 0, TERRITORY_USA},
        {"DD",     TERRITORY_IN_DD,  0, 0, TERRITORY_IND},
        {"DE",     TERRITORY_US_DE,  0, 0, TERRITORY_USA},
        {"DEU",    TERRITORY_DEU,    0, 0, TERRITORY_NONE},
        {"DF",     TERRITORY_BR_DF,  0, 1, TERRITORY_BRA},
        {"DF",     TERRITORY_MX_DIF, 1, 1, TERRITORY_MEX},
        {"DG",     TERRITORY_MX_DUR, 1, 0, TERRITORY_MEX},
        {"DGA",    TERRITORY_IOT,    1, 0, TERRITORY_NONE},
        {"DIF",    TERRITORY_MX_DIF, 0, 0, TERRITORY_MEX},
        {"DJI",    TERRITORY_DJI,    0, 0, TERRITORY_NONE},
        {"DL",     TERRITORY_IN_DL,  0, 0, TERRITORY_IND},
        {"DMA",    TERRITORY_DMA,    0, 0, TERRITORY_NONE},
        {"DN",     TERRITORY_IN_DN,  0, 0, TERRITORY_IND},
        {"DNK",    TERRITORY_DNK,    0, 0, TERRITORY_NONE},
        {"DOM",    TERRITORY_DOM,    0, 0, TERRITORY_NONE},
        {"DUR",    TERRITORY_MX_DUR, 0, 0, TERRITORY_MEX},
        {"DZA",    TERRITORY_DZA,    0, 0, TERRITORY_NONE},
        {"ECU",    TERRITORY_ECU,    0, 0, TERRITORY_NONE},
        {"EGY",    TERRITORY_EGY,    0, 0, TERRITORY_NONE},
        {"ERI",    TERRITORY_ERI,    0, 0, TERRITORY_NONE},
        {"ES",     TERRITORY_BR_ES,  0, 0, TERRITORY_BRA},
        {"ESH",    TERRITORY_ESH,    0, 0, TERRITORY_NONE},
        {"ESP",    TERRITORY_ESP,    0, 0, TERRITORY_NONE},
        {"EST",    TERRITORY_EST,    0, 0, TERRITORY_NONE},
        {"ETH",    TERRITORY_ETH,    0, 0, TERRITORY_NONE},
        {"FIN",    TERRITORY_FIN,    0, 0, TERRITORY_NONE},
        {"FJ",     TERRITORY_CN_FJ,  0, 0, TERRITORY_CHN},
        {"FJI",    TERRITORY_FJI,    0, 0, TERRITORY_NONE},
        {"FL",     TERRITORY_US_FL,  0, 0, TERRITORY_USA},
        {"FLK",    TERRITORY_FLK,    0, 0, TERRITORY_NONE},
        {"FRA",    TERRITORY_FRA,    0, 0, TERRITORY_NONE},
        {"FRO",    TERRITORY_FRO,    0, 0, TERRITORY_NONE},
        {"FSM",    TERRITORY_FSM,    0, 0, TERRITORY_NONE},
        {"GA",     TERRITORY_US_GA,  0, 1, TERRITORY_USA},
        {"GA",     TERRITORY_IN_GA,  0, 1, TERRITORY_IND},
        {"GAB",    TERRITORY_GAB,    0, 0, TERRITORY_NONE},
        {"GBR",    TERRITORY_GBR,    0, 0, TERRITORY_NONE},
        {"GD",     TERRITORY_CN_GD,  0, 0, TERRITORY_CHN},
        {"GEO",    TERRITORY_GEO,    0, 0, TERRITORY_NONE},
        {"GGY",    TERRITORY_GGY,    0, 0, TERRITORY_NONE},
        {"GHA",    TERRITORY_GHA,    0, 0, TERRITORY_NONE},
        {"GIB",    TERRITORY_GIB,    0, 0, TERRITORY_NONE},
        {"GIN",    TERRITORY_GIN,    0, 0, TERRITORY_NONE},
        {"GJ",     TERRITORY_IN_GJ,  0, 0, TERRITORY_IND},
        {"GLP",    TERRITORY_GLP,    0, 0, TERRITORY_NONE},
        {"GMB",    TERRITORY_GMB,    0, 0, TERRITORY_NONE},
        {"GNB",    TERRITORY_GNB,    0, 0, TERRITORY_NONE},
        {"GNQ",    TERRITORY_GNQ,    0, 0, TERRITORY_NONE},
        {"GO",     TERRITORY_BR_GO,  0, 0, TERRITORY_BRA},
        {"GR",     TERRITORY_MX_GRO, 1, 0, TERRITORY_MEX},
        {"GRC",    TERRITORY_GRC,    0, 0, TERRITORY_NONE},
        {"GRD",    TERRITORY_GRD,    0, 0, TERRITORY_NONE},
        {"GRL",    TERRITORY_GRL,    0, 0, TERRITORY_NONE},
        {"GRO",    TERRITORY_MX_GRO, 0, 0, TERRITORY_MEX},
        {"GS",     TERRITORY_CN_GS,  0, 0, TERRITORY_CHN},
        {"GT",     TERRITORY_MX_GUA, 1, 0, TERRITORY_MEX},
        {"GTM",    TERRITORY_GTM,    0, 0, TERRITORY_NONE},
        {"GU",     TERRITORY_GUM,    1, 0, TERRITORY_USA},
        {"GUA",    TERRITORY_MX_GUA, 0, 0, TERRITORY_MEX},
        {"GUF",    TERRITORY_GUF,    0, 0, TERRITORY_NONE},
        {"GUM",    TERRITORY_GUM,    0, 0, TERRITORY_NONE},
        {"GUY",    TERRITORY_GUY,    0, 0, TERRITORY_NONE},
        {"GX",     TERRITORY_CN_GX,  0, 0, TERRITORY_CHN},
        {"GZ",     TERRITORY_CN_GZ,  0, 0, TERRITORY_CHN},
        {"HA",     TERRITORY_CN_HA,  0, 0, TERRITORY_CHN},
        {"HB",     TERRITORY_CN_HB,  0, 0, TERRITORY_CHN},
        {"HE",     TERRITORY_CN_HE,  0, 0, TERRITORY_CHN},
        {"HG",     TERRITORY_MX_HID, 1, 0, TERRITORY_MEX},
        {"HI",     TERRITORY_CN_HI,  0, 1, TERRITORY_CHN},
        {"HI",     TERRITORY_US_HI,  0, 1, TERRITORY_USA},
        {"HID",    TERRITORY_MX_HID, 0, 0, TERRITORY_MEX},
        {"HK",     TERRITORY_HKG,    1, 0, TERRITORY_CHN},
        {"HKG",    TERRITORY_HKG,    0, 0, TERRITORY_NONE},
        {"HL",     TERRITORY_CN_HL,  0, 0, TERRITORY_CHN},
        {"HM",     TERRITORY_HMD,    1, 0, TERRITORY_AUS},
        {"HMD",    TERRITORY_HMD,    0, 0, TERRITORY_NONE},
        {"HN",     TERRITORY_CN_HN,  0, 0, TERRITORY_CHN},
        {"HND",    TERRITORY_HND,    0, 0, TERRITORY_NONE},
        {"HP",     TERRITORY_IN_HP,  0, 0, TERRITORY_IND},
        {"HR",     TERRITORY_IN_HR,  0, 0, TERRITORY_IND},
        {"HRV",    TERRITORY_HRV,    0, 0, TERRITORY_NONE},
        {"HTI",    TERRITORY_HTI,    0, 0, TERRITORY_NONE},
        {"HUN",    TERRITORY_HUN,    0, 0, TERRITORY_NONE},
        {"IA",     TERRITORY_US_IA,  0, 0, TERRITORY_USA},
        {"ID",     TERRITORY_US_ID,  0, 0, TERRITORY_USA},
        {"IDN",    TERRITORY_IDN,    0, 0, TERRITORY_NONE},
        {"IL",     TERRITORY_US_IL,  0, 0, TERRITORY_USA},
        {"IMN",    TERRITORY_IMN,    0, 0, TERRITORY_NONE},
        {"IN",     TERRITORY_RU_IN,  0, 1, TERRITORY_RUS},
        {"IN",     TERRITORY_US_IN,  0, 1, TERRITORY_USA},
        {"IN-AN",  TERRITORY_IN_AN,  0, 0, TERRITORY_IND},
        {"IN-AP",  TERRITORY_IN_AP,  0, 0, TERRITORY_IND},
        {"IN-AR",  TERRITORY_IN_AR,  0, 0, TERRITORY_IND},
        {"IN-AS",  TERRITORY_IN_AS,  0, 0, TERRITORY_IND},
        {"IN-BR",  TERRITORY_IN_BR,  0, 0, TERRITORY_IND},
        {"IN-CG",  TERRITORY_IN_CT,  1, 0, TERRITORY_IND},
        {"IN-CH",  TERRITORY_IN_CH,  0, 0, TERRITORY_IND},
        {"IN-CT",  TERRITORY_IN_CT,  0, 0, TERRITORY_IND},
        {"IN-DD",  TERRITORY_IN_DD,  0, 0, TERRITORY_IND},
        {"IN-DL",  TERRITORY_IN_DL,  0, 0, TERRITORY_IND},
        {"IN-DN",  TERRITORY_IN_DN,  0, 0, TERRITORY_IND},
        {"IN-GA",  TERRITORY_IN_GA,  0, 0, TERRITORY_IND},
        {"IN-GJ",  TERRITORY_IN_GJ,  0, 0, TERRITORY_IND},
        {"IN-HP",  TERRITORY_IN_HP,  0, 0, TERRITORY_IND},
        {"IN-HR",  TERRITORY_IN_HR,  0, 0, TERRITORY_IND},
        {"IN-JH",  TERRITORY_IN_JH,  0, 0, TERRITORY_IND},
        {"IN-JK",  TERRITORY_IN_JK,  0, 0, TERRITORY_IND},
        {"IN-KA",  TERRITORY_IN_KA,  0, 0, TERRITORY_IND},
        {"IN-KL",  TERRITORY_IN_KL,  0, 0, TERRITORY_IND},
        {"IN-LD",  TERRITORY_IN_LD,  0, 0, TERRITORY_IND},
        {"IN-MH",  TERRITORY_IN_MH,  0, 0, TERRITORY_IND},
        {"IN-ML",  TERRITORY_IN_ML,  0, 0, TERRITORY_IND},
        {"IN-MN",  TERRITORY_IN_MN,  0, 0, TERRITORY_IND},
        {"IN-MP",  TERRITORY_IN_MP,  0, 0, TERRITORY_IND},
        {"IN-MZ",  TERRITORY_IN_MZ,  0, 0, TERRITORY_IND},
        {"IN-NL",  TERRITORY_IN_NL,  0, 0, TERRITORY_IND},
        {"IN-OD",  TERRITORY_IN_OR,  1, 0, TERRITORY_IND},
        {"IN-OR",  TERRITORY_IN_OR,  0, 0, TERRITORY_IND},
        {"IN-PB",  TERRITORY_IN_PB,  0, 0, TERRITORY_IND},
        {"IN-PY",  TERRITORY_IN_PY,  0, 0, TERRITORY_IND},
        {"IN-RJ",  TERRITORY_IN_RJ,  0, 0, TERRITORY_IND},
        {"IN-SK",  TERRITORY_IN_SK,  0, 0, TERRITORY_IND},
        {"IN-TG",  TERRITORY_IN_TG,  0, 0, TERRITORY_IND},
        {"IN-TN",  TERRITORY_IN_TN,  0, 0, TERRITORY_IND},
        {"IN-TR",  TERRITORY_IN_TR,  0, 0, TERRITORY_IND},
        {"IN-UK",  TERRITORY_IN_UT,  1, 0, TERRITORY_IND},
        {"IN-UP",  TERRITORY_IN_UP,  0, 0, TERRITORY_IND},
        {"IN-UT",  TERRITORY_IN_UT,  0, 0, TERRITORY_IND},
        {"IN-WB",  TERRITORY_IN_WB,  0, 0, TERRITORY_IND},
        {"IND",    TERRITORY_IND,    0, 0, TERRITORY_NONE},
        {"IOT",    TERRITORY_IOT,    0, 0, TERRITORY_NONE},
        {"IRK",    TERRITORY_RU_IRK, 0, 0, TERRITORY_RUS},
        {"IRL",    TERRITORY_IRL,    0, 0, TERRITORY_NONE},
        {"IRN",    TERRITORY_IRN,    0, 0, TERRITORY_NONE},
        {"IRQ",    TERRITORY_IRQ,    0, 0, TERRITORY_NONE},
        {"ISL",    TERRITORY_ISL,    0, 0, TERRITORY_NONE},
        {"ISR",    TERRITORY_ISR,    0, 0, TERRITORY_NONE},
        {"ITA",    TERRITORY_ITA,    0, 0, TERRITORY_NONE},
        {"IVA",    TERRITORY_RU_IVA, 0, 0, TERRITORY_RUS},
        {"JA",     TERRITORY_MX_JAL, 1, 0, TERRITORY_MEX},
        {"JAL",    TERRITORY_MX_JAL, 0, 0, TERRITORY_MEX},
        {"JAM",    TERRITORY_JAM,    0, 0, TERRITORY_NONE},
        {"JBT",    TERRITORY_AU_JBT, 0, 0, TERRITORY_AUS},
        {"JEY",    TERRITORY_JEY,    0, 0, TERRITORY_NONE},
        {"JH",     TERRITORY_IN_JH,  0, 0, TERRITORY_IND},
        {"JK",     TERRITORY_IN_JK,  0, 0, TERRITORY_IND},
        {"JL",     TERRITORY_CN_JL,  0, 0, TERRITORY_CHN},
        {"JOR",    TERRITORY_JOR,    0, 0, TERRITORY_NONE},
        {"JPN",    TERRITORY_JPN,    0, 0, TERRITORY_NONE},
        {"JS",     TERRITORY_CN_JS,  0, 0, TERRITORY_CHN},
        {"JTN",    TERRITORY_UMI,    1, 0, TERRITORY_NONE},
        {"JX",     TERRITORY_CN_JX,  0, 0, TERRITORY_CHN},
        {"KA",     TERRITORY_IN_KA,  0, 0, TERRITORY_IND},
        {"KAM",    TERRITORY_RU_KAM, 0, 0, TERRITORY_RUS},
        {"KAZ",    TERRITORY_KAZ,    0, 0, TERRITORY_NONE},
        {"KB",     TERRITORY_RU_KB,  0, 0, TERRITORY_RUS},
        {"KC",     TERRITORY_RU_KC,  0, 0, TERRITORY_RUS},
        {"KDA",    TERRITORY_RU_KDA, 0, 0, TERRITORY_RUS},
        {"KEM",    TERRITORY_RU_KEM, 0, 0, TERRITORY_RUS},
        {"KEN",    TERRITORY_KEN,    0, 0, TERRITORY_NONE},
        {"KGD",    TERRITORY_RU_KGD, 0, 0, TERRITORY_RUS},
        {"KGN",    TERRITORY_RU_KGN, 0, 0, TERRITORY_RUS},
        {"KGZ",    TERRITORY_KGZ,    0, 0, TERRITORY_NONE},
        {"KHA",    TERRITORY_RU_KHA, 0, 0, TERRITORY_RUS},
        {"KHM",    TERRITORY_KHM,    0, 0, TERRITORY_NONE},
        {"KI",     TERRITORY_RU_KI,  0, 0, TERRITORY_RUS},
        {"KIR",    TERRITORY_KIR,    0, 0, TERRITORY_NONE},
        {"KK",     TERRITORY_RU_KK,  0, 0, TERRITORY_RUS},
        {"KL",     TERRITORY_RU_KL,  0, 1, TERRITORY_RUS},
        {"KL",     TERRITORY_IN_KL,  0, 1, TERRITORY_IND},
        {"KLU",    TERRITORY_RU_KLU, 0, 0, TERRITORY_RUS},
        {"KM",     TERRITORY_RU_KM,  0, 0, TERRITORY_RUS},
        {"KNA",    TERRITORY_KNA,    0, 0, TERRITORY_NONE},
        {"KO",     TERRITORY_RU_KO,  0, 0, TERRITORY_RUS},
        {"KOR",    TERRITORY_KOR,    0, 0, TERRITORY_NONE},
        {"KOS",    TERRITORY_RU_KOS, 0, 0, TERRITORY_RUS},
        {"KR",     TERRITORY_RU_KR,  0, 0, TERRITORY_RUS},
        {"KRS",    TERRITORY_RU_KRS, 0, 0, TERRITORY_RUS},
        {"KS",     TERRITORY_US_KS,  0, 0, TERRITORY_USA},
        {"KWT",    TERRITORY_KWT,    0, 0, TERRITORY_NONE},
        {"KY",     TERRITORY_US_KY,  0, 0, TERRITORY_USA},
        {"KYA",    TERRITORY_RU_KYA, 0, 0, TERRITORY_RUS},
        {"LA",     TERRITORY_US_LA,  0, 0, TERRITORY_USA},
        {"LAO",    TERRITORY_LAO,    0, 0, TERRITORY_NONE},
        {"LBN",    TERRITORY_LBN,    0, 0, TERRITORY_NONE},
        {"LBR",    TERRITORY_LBR,    0, 0, TERRITORY_NONE},
        {"LBY",    TERRITORY_LBY,    0, 0, TERRITORY_NONE},
        {"LCA",    TERRITORY_LCA,    0, 0, TERRITORY_NONE},
        {"LD",     TERRITORY_IN_LD,  0, 0, TERRITORY_IND},
        {"LEN",    TERRITORY_RU_LEN, 0, 0, TERRITORY_RUS},
        {"LIE",    TERRITORY_LIE,    0, 0, TERRITORY_NONE},
        {"LIP",    TERRITORY_RU_LIP, 0, 0, TERRITORY_RUS},
        {"LKA",    TERRITORY_LKA,    0, 0, TERRITORY_NONE},
        {"LN",     TERRITORY_CN_LN,  0, 0, TERRITORY_CHN},
        {"LSO",    TERRITORY_LSO,    0, 0, TERRITORY_NONE},
        {"LTU",    TERRITORY_LTU,    0, 0, TERRITORY_NONE},
        {"LUX",    TERRITORY_LUX,    0, 0, TERRITORY_NONE},
        {"LVA",    TERRITORY_LVA,    0, 0, TERRITORY_NONE},
        {"MA",     TERRITORY_US_MA,  0, 1, TERRITORY_USA},
        {"MA",     TERRITORY_BR_MA,  0, 1, TERRITORY_BRA},
        {"MAC",    TERRITORY_MAC,    0, 0, TERRITORY_NONE},
        {"MAF",    TERRITORY_MAF,    0, 0, TERRITORY_NONE},
        {"MAG",    TERRITORY_RU_MAG, 0, 0, TERRITORY_RUS},
        {"MAR",    TERRITORY_MAR,    0, 0, TERRITORY_NONE},
        {"MB",     TERRITORY_CA_MB,  0, 0, TERRITORY_CAN},
        {"MC",     TERRITORY_MAC,    1, 0, TERRITORY_CHN},
        {"MCO",    TERRITORY_MCO,    0, 0, TERRITORY_NONE},
        {"MD",     TERRITORY_US_MD,  0, 0, TERRITORY_USA},
        {"MDA",    TERRITORY_MDA,    0, 0, TERRITORY_NONE},
        {"MDG",    TERRITORY_MDG,    0, 0, TERRITORY_NONE},
        {"MDV",    TERRITORY_MDV,    0, 0, TERRITORY_NONE},
        {"ME",     TERRITORY_RU_ME,  0, 1, TERRITORY_RUS},
        {"ME",     TERRITORY_US_ME,  0, 1, TERRITORY_USA},
        {"ME",     TERRITORY_MX_MX,  1, 1, TERRITORY_MEX},
        {"MEX",    TERRITORY_MEX,    0, 0, TERRITORY_NONE},
        {"MG",     TERRITORY_BR_MG,  0, 0, TERRITORY_BRA},
        {"MH",     TERRITORY_IN_MH,  0, 0, TERRITORY_IND},
        {"MHL",    TERRITORY_MHL,    0, 0, TERRITORY_NONE},
        {"MI",     TERRITORY_US_MI,  0, 1, TERRITORY_USA},
        {"MI",     TERRITORY_MX_MIC, 1, 1, TERRITORY_MEX},
        {"MIC",    TERRITORY_MX_MIC, 0, 0, TERRITORY_MEX},
        {"MID",    TERRITORY_US_HI,  1, 0, TERRITORY_USA},
        {"MKD",    TERRITORY_MKD,    0, 0, TERRITORY_NONE},
        {"ML",     TERRITORY_IN_ML,  0, 0, TERRITORY_IND},
        {"MLI",    TERRITORY_MLI,    0, 0, TERRITORY_NONE},
        {"MLT",    TERRITORY_MLT,    0, 0, TERRITORY_NONE},
        {"MMR",    TERRITORY_MMR,    0, 0, TERRITORY_NONE},
        {"MN",     TERRITORY_US_MN,  0, 1, TERRITORY_USA},
        {"MN",     TERRITORY_IN_MN,  0, 1, TERRITORY_IND},
        {"MNE",    TERRITORY_MNE,    0, 0, TERRITORY_NONE},
        {"MNG",    TERRITORY_MNG,    0, 0, TERRITORY_NONE},
        {"MNP",    TERRITORY_MNP,    0, 0, TERRITORY_NONE},
        {"MO",     TERRITORY_RU_MO,  0, 1, TERRITORY_RUS},
        {"MO",     TERRITORY_US_MO,  0, 1, TERRITORY_USA},
        {"MO",     TERRITORY_MX_MOR, 1, 1, TERRITORY_MEX},
        {"MOR",    TERRITORY_MX_MOR, 0, 0, TERRITORY_MEX},
        {"MOS",    TERRITORY_RU_MOS, 0, 0, TERRITORY_RUS},
        {"MOW",    TERRITORY_RU_MOW, 0, 0, TERRITORY_RUS},
        {"MOZ",    TERRITORY_MOZ,    0, 0, TERRITORY_NONE},
        {"MP",     TERRITORY_IN_MP,  0, 1, TERRITORY_IND},
        {"MP",     TERRITORY_MNP,    1, 1, TERRITORY_USA},
        {"MRT",    TERRITORY_MRT,    0, 0, TERRITORY_NONE},
        {"MS",     TERRITORY_US_MS,  0, 1, TERRITORY_USA},
        {"MS",     TERRITORY_BR_MS,  0, 1, TERRITORY_BRA},
        {"MSR",    TERRITORY_MSR,    0, 0, TERRITORY_NONE},
        {"MT",     TERRITORY_US_MT,  0, 1, TERRITORY_USA},
        {"MT",     TERRITORY_BR_MT,  0, 1, TERRITORY_BRA},
        {"MTQ",    TERRITORY_MTQ,    0, 0, TERRITORY_NONE},
        {"MUR",    TERRITORY_RU_MUR, 0, 0, TERRITORY_RUS},
        {"MUS",    TERRITORY_MUS,    0, 0, TERRITORY_NONE},
        {"MWI",    TERRITORY_MWI,    0, 0, TERRITORY_NONE},
        {"MX",     TERRITORY_MX_MX,  0, 0, TERRITORY_MEX},
        {"MX-AG",  TERRITORY_MX_AGU, 1, 0, TERRITORY_MEX},
        {"MX-AGU", TERRITORY_MX_AGU, 0, 0, TERRITORY_MEX},
        {"MX-BC",  TERRITORY_MX_BCN, 1, 0, TERRITORY_MEX},
        {"MX-BCN", TERRITORY_MX_BCN, 0, 0, TERRITORY_MEX},
        {"MX-BCS", TERRITORY_MX_BCS, 0, 0, TERRITORY_MEX},
        {"MX-BS",  TERRITORY_MX_BCS, 1, 0, TERRITORY_MEX},
        {"MX-CAM", TERRITORY_MX_CAM, 0, 0, TERRITORY_MEX},
        {"MX-CH",  TERRITORY_MX_CHH, 1, 0, TERRITORY_MEX},
        {"MX-CHH", TERRITORY_MX_CHH, 0, 0, TERRITORY_MEX},
        {"MX-CHP", TERRITORY_MX_CHP, 0, 0, TERRITORY_MEX},
        {"MX-CL",  TERRITORY_MX_CL,  0, 0, TERRITORY_MEX},
        {"MX-CM",  TERRITORY_MX_CAM, 1, 0, TERRITORY_MEX},
        {"MX-CO",  TERRITORY_MX_COA, 1, 0, TERRITORY_MEX},
        {"MX-COA", TERRITORY_MX_COA, 0, 0, TERRITORY_MEX},
        {"MX-COL", TERRITORY_MX_CL,  1, 0, TERRITORY_MEX},
        {"MX-CS",  TERRITORY_MX_CHP, 1, 0, TERRITORY_MEX},
        {"MX-DF",  TERRITORY_MX_DIF, 1, 0, TERRITORY_MEX},
        {"MX-DG",  TERRITORY_MX_DUR, 1, 0, TERRITORY_MEX},
        {"MX-DIF", TERRITORY_MX_DIF, 0, 0, TERRITORY_MEX},
        {"MX-DUR", TERRITORY_MX_DUR, 0, 0, TERRITORY_MEX},
        {"MX-GR",  TERRITORY_MX_GRO, 1, 0, TERRITORY_MEX},
        {"MX-GRO", TERRITORY_MX_GRO, 0, 0, TERRITORY_MEX},
        {"MX-GT",  TERRITORY_MX_GUA, 1, 0, TERRITORY_MEX},
        {"MX-GUA", TERRITORY_MX_GUA, 0, 0, TERRITORY_MEX},
        {"MX-HG",  TERRITORY_MX_HID, 1, 0, TERRITORY_MEX},
        {"MX-HID", TERRITORY_MX_HID, 0, 0, TERRITORY_MEX},
        {"MX-JA",  TERRITORY_MX_JAL, 1, 0, TERRITORY_MEX},
        {"MX-JAL", TERRITORY_MX_JAL, 0, 0, TERRITORY_MEX},
        {"MX-ME",  TERRITORY_MX_MX,  1, 0, TERRITORY_MEX},
        {"MX-MEX", TERRITORY_MX_MX,  1, 0, TERRITORY_MEX},
        {"MX-MI",  TERRITORY_MX_MIC, 1, 0, TERRITORY_MEX},
        {"MX-MIC", TERRITORY_MX_MIC, 0, 0, TERRITORY_MEX},
        {"MX-MO",  TERRITORY_MX_MOR, 1, 0, TERRITORY_MEX},
        {"MX-MOR", TERRITORY_MX_MOR, 0, 0, TERRITORY_MEX},
        {"MX-MX",  TERRITORY_MX_MX,  0, 0, TERRITORY_MEX},
        {"MX-NA",  TERRITORY_MX_NAY, 1, 0, TERRITORY_MEX},
        {"MX-NAY", TERRITORY_MX_NAY, 0, 0, TERRITORY_MEX},
        {"MX-NL",  TERRITORY_MX_NLE, 1, 0, TERRITORY_MEX},
        {"MX-NLE", TERRITORY_MX_NLE, 0, 0, TERRITORY_MEX},
        {"MX-OA",  TERRITORY_MX_OAX, 1, 0, TERRITORY_MEX},
        {"MX-OAX", TERRITORY_MX_OAX, 0, 0, TERRITORY_MEX},
        {"MX-PB",  TERRITORY_MX_PUE, 1, 0, TERRITORY_MEX},
        {"MX-PUE", TERRITORY_MX_PUE, 0, 0, TERRITORY_MEX},
        {"MX-QE",  TERRITORY_MX_QUE, 1, 0, TERRITORY_MEX},
        {"MX-QR",  TERRITORY_MX_ROO, 1, 0, TERRITORY_MEX},
        {"MX-QUE", TERRITORY_MX_QUE, 0, 0, TERRITORY_MEX},
        {"MX-ROO", TERRITORY_MX_ROO, 0, 0, TERRITORY_MEX},
        {"MX-SI",  TERRITORY_MX_SIN, 1, 0, TERRITORY_MEX},
        {"MX-SIN", TERRITORY_MX_SIN, 0, 0, TERRITORY_MEX},
        {"MX-SL",  TERRITORY_MX_SLP, 1, 0, TERRITORY_MEX},
        {"MX-SLP", TERRITORY_MX_SLP, 0, 0, TERRITORY_MEX},
        {"MX-SO",  TERRITORY_MX_SON, 1, 0, TERRITORY_MEX},
        {"MX-SON", TERRITORY_MX_SON, 0, 0, TERRITORY_MEX},
        {"MX-TAB", TERRITORY_MX_TAB, 0, 0, TERRITORY_MEX},
        {"MX-TAM", TERRITORY_MX_TAM, 0, 0, TERRITORY_MEX},
        {"MX-TAM", TERRITORY_MX_TAM, 1, 0, TERRITORY_MEX},
        {"MX-TB",  TERRITORY_MX_TAB, 1, 0, TERRITORY_MEX},
        {"MX-TL",  TERRITORY_MX_TLA, 1, 0, TERRITORY_MEX},
        {"MX-TLA", TERRITORY_MX_TLA, 0, 0, TERRITORY_MEX},
        {"MX-TM",  TERRITORY_MX_TAM, 1, 0, TERRITORY_MEX},
        {"MX-VE",  TERRITORY_MX_VER, 1, 0, TERRITORY_MEX},
        {"MX-VER", TERRITORY_MX_VER, 0, 0, TERRITORY_MEX},
        {"MX-YU",  TERRITORY_MX_YUC, 1, 0, TERRITORY_MEX},
        {"MX-YUC", TERRITORY_MX_YUC, 0, 0, TERRITORY_MEX},
        {"MX-ZA",  TERRITORY_MX_ZAC, 1, 0, TERRITORY_MEX},
        {"MX-ZAC", TERRITORY_MX_ZAC, 0, 0, TERRITORY_MEX},
        {"MYS",    TERRITORY_MYS,    0, 0, TERRITORY_NONE},
        {"MYT",    TERRITORY_MYT,    0, 0, TERRITORY_NONE},
        {"MZ",     TERRITORY_IN_MZ,  0, 0, TERRITORY_IND},
        {"NA",     TERRITORY_MX_NAY, 1, 0, TERRITORY_MEX},
        {"NAM",    TERRITORY_NAM,    0, 0, TERRITORY_NONE},
        {"NAY",    TERRITORY_MX_NAY, 0, 0, TERRITORY_MEX},
        {"NB",     TERRITORY_CA_NB,  0, 0, TERRITORY_CAN},
        {"NC",     TERRITORY_US_NC,  0, 0, TERRITORY_USA},
        {"NCL",    TERRITORY_NCL,    0, 0, TERRITORY_NONE},
        {"ND",     TERRITORY_US_ND,  0, 0, TERRITORY_USA},
        {"NE",     TERRITORY_US_NE,  0, 0, TERRITORY_USA},
        {"NEN",    TERRITORY_RU_NEN, 0, 0, TERRITORY_RUS},
        {"NER",    TERRITORY_NER,    0, 0, TERRITORY_NONE},
        {"NF",     TERRITORY_NFK,    1, 0, TERRITORY_AUS},
        {"NFK",    TERRITORY_NFK,    0, 0, TERRITORY_NONE},
        {"NGA",    TERRITORY_NGA,    0, 0, TERRITORY_NONE},
        {"NGR",    TERRITORY_RU_NGR, 0, 0, TERRITORY_RUS},
        {"NH",     TERRITORY_US_NH,  0, 0, TERRITORY_USA},
        {"NIC",    TERRITORY_NIC,    0, 0, TERRITORY_NONE},
        {"NIU",    TERRITORY_NIU,    0, 0, TERRITORY_NONE},
        {"NIZ",    TERRITORY_RU_NIZ, 0, 0, TERRITORY_RUS},
        {"NJ",     TERRITORY_US_NJ,  0, 0, TERRITORY_USA},
        {"NL",     TERRITORY_CA_NL,  0, 1, TERRITORY_CAN},
        {"NL",     TERRITORY_IN_NL,  0, 1, TERRITORY_IND},
        {"NL",     TERRITORY_MX_NLE, 1, 1, TERRITORY_MEX},
        {"NLD",    TERRITORY_NLD,    0, 0, TERRITORY_NONE},
        {"NLE",    TERRITORY_MX_NLE, 0, 0, TERRITORY_MEX},
        {"NM",     TERRITORY_CN_NM,  0, 1, TERRITORY_CHN},
        {"NM",     TERRITORY_US_NM,  0, 1, TERRITORY_USA},
        {"NOR",    TERRITORY_NOR,    0, 0, TERRITORY_NONE},
        {"NPL",    TERRITORY_NPL,    0, 0, TERRITORY_NONE},
        {"NRU",    TERRITORY_NRU,    0, 0, TERRITORY_NONE},
        {"NS",     TERRITORY_CA_NS,  0, 0, TERRITORY_CAN},
        {"NSW",    TERRITORY_AU_NSW, 0, 0, TERRITORY_AUS},
        {"NT",     TERRITORY_CA_NT,  0, 1, TERRITORY_CAN},
        {"NT",     TERRITORY_AU_NT,  0, 1, TERRITORY_AUS},
        {"NU",     TERRITORY_CA_NU,  0, 0, TERRITORY_CAN},
        {"NV",     TERRITORY_US_NV,  0, 0, TERRITORY_USA},
        {"NVS",    TERRITORY_RU_NVS, 0, 0, TERRITORY_RUS},
        {"NX",     TERRITORY_CN_NX,  0, 0, TERRITORY_CHN},
        {"NY",     TERRITORY_US_NY,  0, 0, TERRITORY_USA},
        {"NZL",    TERRITORY_NZL,    0, 0, TERRITORY_NONE},
        {"OA",     TERRITORY_MX_OAX, 1, 0, TERRITORY_MEX},
        {"OAX",    TERRITORY_MX_OAX, 0, 0, TERRITORY_MEX},
        {"OD",     TERRITORY_IN_OR,  1, 0, TERRITORY_IND},
        {"OH",     TERRITORY_US_OH,  0, 0, TERRITORY_USA},
        {"OK",     TERRITORY_US_OK,  0, 0, TERRITORY_USA},
        {"OMN",    TERRITORY_OMN,    0, 0, TERRITORY_NONE},
        {"OMS",    TERRITORY_RU_OMS, 0, 0, TERRITORY_RUS},
        {"ON",     TERRITORY_CA_ON,  0, 0, TERRITORY_CAN},
        {"OR",     TERRITORY_US_OR,  0, 1, TERRITORY_USA},
        {"OR",     TERRITORY_IN_OR,  0, 1, TERRITORY_IND},
        {"ORE",    TERRITORY_RU_ORE, 0, 0, TERRITORY_RUS},
        {"ORL",    TERRITORY_RU_ORL, 0, 0, TERRITORY_RUS},
        {"PA",     TERRITORY_US_PA,  0, 1, TERRITORY_USA},
        {"PA",     TERRITORY_BR_PA,  0, 1, TERRITORY_BRA},
        {"PAK",    TERRITORY_PAK,    0, 0, TERRITORY_NONE},
        {"PAN",    TERRITORY_PAN,    0, 0, TERRITORY_NONE},
        {"PB",     TERRITORY_BR_PB,  0, 1, TERRITORY_BRA},
        {"PB",     TERRITORY_IN_PB,  0, 1, TERRITORY_IND},
        {"PB",     TERRITORY_MX_PUE, 1, 1, TERRITORY_MEX},
        {"PCN",    TERRITORY_PCN,    0, 0, TERRITORY_NONE},
        {"PE",     TERRITORY_CA_PE,  0, 1, TERRITORY_CAN},
        {"PE",     TERRITORY_BR_PE,  0, 1, TERRITORY_BRA},
        {"PER",    TERRITORY_PER,    0, 0, TERRITORY_NONE},
        {"PHL",    TERRITORY_PHL,    0, 0, TERRITORY_NONE},
        {"PI",     TERRITORY_BR_PI,  0, 0, TERRITORY_BRA},
        {"PLW",    TERRITORY_PLW,    0, 0, TERRITORY_NONE},
        {"PM",     TERRITORY_RU_PM,  0, 0, TERRITORY_RUS},
        {"PNG",    TERRITORY_PNG,    0, 0, TERRITORY_NONE},
        {"PNZ",    TERRITORY_RU_PNZ, 0, 0, TERRITORY_RUS},
        {"PO",     TERRITORY_RU_PO,  0, 0, TERRITORY_RUS},
        {"POL",    TERRITORY_POL,    0, 0, TERRITORY_NONE},
        {"PR",     TERRITORY_BR_PR,  0, 1, TERRITORY_BRA},
        {"PR",     TERRITORY_PRI,    1, 1, TERRITORY_USA},
        {"PRI",    TERRITORY_PRI,    0, 0, TERRITORY_NONE},
        {"PRK",    TERRITORY_PRK,    0, 0, TERRITORY_NONE},
        {"PRT",    TERRITORY_PRT,    0, 0, TERRITORY_NONE},
        {"PRY",    TERRITORY_PRY,    0, 0, TERRITORY_NONE},
        {"PSE",    TERRITORY_PSE,    0, 0, TERRITORY_NONE},
        {"PSK",    TERRITORY_RU_PSK, 0, 0, TERRITORY_RUS},
        {"PUE",    TERRITORY_MX_PUE, 0, 0, TERRITORY_MEX},
        {"PY",     TERRITORY_IN_PY,  0, 0, TERRITORY_IND},
        {"PYF",    TERRITORY_PYF,    0, 0, TERRITORY_NONE},
        {"QAT",    TERRITORY_QAT,    0, 0, TERRITORY_NONE},
        {"QC",     TERRITORY_CA_QC,  0, 0, TERRITORY_CAN},
        {"QE",     TERRITORY_MX_QUE, 1, 0, TERRITORY_MEX},
        {"QH",     TERRITORY_CN_QH,  0, 0, TERRITORY_CHN},
        {"QLD",    TERRITORY_AU_QLD, 0, 0, TERRITORY_AUS},
        {"QR",     TERRITORY_MX_ROO, 1, 0, TERRITORY_MEX},
        {"QUE",    TERRITORY_MX_QUE, 0, 0, TERRITORY_MEX},
        {"REU",    TERRITORY_REU,    0, 0, TERRITORY_NONE},
        {"RI",     TERRITORY_US_RI,  0, 0, TERRITORY_USA},
        {"RJ",     TERRITORY_BR_RJ,  0, 1, TERRITORY_BRA},
        {"RJ",     TERRITORY_IN_RJ,  0, 1, TERRITORY_IND},
        {"RN",     TERRITORY_BR_RN,  0, 0, TERRITORY_BRA},
        {"RO",     TERRITORY_BR_RO,  0, 0, TERRITORY_BRA},
        {"ROO",    TERRITORY_MX_ROO, 0, 0, TERRITORY_MEX},
        {"ROS",    TERRITORY_RU_ROS, 0, 0, TERRITORY_RUS},
        {"ROU",    TERRITORY_ROU,    0, 0, TERRITORY_NONE},
        {"RR",     TERRITORY_BR_RR,  0, 0, TERRITORY_BRA},
        {"RS",     TERRITORY_BR_RS,  0, 0, TERRITORY_BRA},
        {"RU",     TERRITORY_RUS,    1, 0, TERRITORY_NONE},
        {"RU-AD",  TERRITORY_RU_AD,  0, 0, TERRITORY_RUS},
        {"RU-AL",  TERRITORY_RU_AL,  0, 0, TERRITORY_RUS},
        {"RU-ALT", TERRITORY_RU_ALT, 0, 0, TERRITORY_RUS},
        {"RU-AMU", TERRITORY_RU_AMU, 0, 0, TERRITORY_RUS},
        {"RU-ARK", TERRITORY_RU_ARK, 0, 0, TERRITORY_RUS},
        {"RU-AST", TERRITORY_RU_AST, 0, 0, TERRITORY_RUS},
        {"RU-BA",  TERRITORY_RU_BA,  0, 0, TERRITORY_RUS},
        {"RU-BE",  TERRITORY_RU_BE,  0, 0, TERRITORY_RUS},
        {"RU-BEL", TERRITORY_RU_BE,  1, 0, TERRITORY_RUS},
        {"RU-BRY", TERRITORY_RU_BRY, 0, 0, TERRITORY_RUS},
        {"RU-BU",  TERRITORY_RU_BU,  0, 0, TERRITORY_RUS},
        {"RU-CE",  TERRITORY_RU_CE,  0, 0, TERRITORY_RUS},
        {"RU-CH",  TERRITORY_RU_CH,  0, 0, TERRITORY_RUS},
        {"RU-CHE", TERRITORY_RU_CH,  1, 0, TERRITORY_RUS},
        {"RU-CHU", TERRITORY_RU_CHU, 0, 0, TERRITORY_RUS},
        {"RU-CU",  TERRITORY_RU_CU,  0, 0, TERRITORY_RUS},
        {"RU-DA",  TERRITORY_RU_DA,  0, 0, TERRITORY_RUS},
        {"RU-IN",  TERRITORY_RU_IN,  0, 0, TERRITORY_RUS},
        {"RU-IRK", TERRITORY_RU_IRK, 0, 0, TERRITORY_RUS},
        {"RU-IVA", TERRITORY_RU_IVA, 0, 0, TERRITORY_RUS},
        {"RU-KAM", TERRITORY_RU_KAM, 0, 0, TERRITORY_RUS},
        {"RU-KB",  TERRITORY_RU_KB,  0, 0, TERRITORY_RUS},
        {"RU-KC",  TERRITORY_RU_KC,  0, 0, TERRITORY_RUS},
        {"RU-KDA", TERRITORY_RU_KDA, 0, 0, TERRITORY_RUS},
        {"RU-KEM", TERRITORY_RU_KEM, 0, 0, TERRITORY_RUS},
        {"RU-KGD", TERRITORY_RU_KGD, 0, 0, TERRITORY_RUS},
        {"RU-KGN", TERRITORY_RU_KGN, 0, 0, TERRITORY_RUS},
        {"RU-KHA", TERRITORY_RU_KHA, 0, 0, TERRITORY_RUS},
        {"RU-KHM", TERRITORY_RU_KM,  1, 0, TERRITORY_RUS},
        {"RU-KI",  TERRITORY_RU_KI,  0, 0, TERRITORY_RUS},
        {"RU-KIR", TERRITORY_RU_KI,  1, 0, TERRITORY_RUS},
        {"RU-KK",  TERRITORY_RU_KK,  0, 0, TERRITORY_RUS},
        {"RU-KL",  TERRITORY_RU_KL,  0, 0, TERRITORY_RUS},
        {"RU-KLU", TERRITORY_RU_KLU, 0, 0, TERRITORY_RUS},
        {"RU-KM",  TERRITORY_RU_KM,  0, 0, TERRITORY_RUS},
        {"RU-KO",  TERRITORY_RU_KO,  0, 0, TERRITORY_RUS},
        {"RU-KOS", TERRITORY_RU_KOS, 0, 0, TERRITORY_RUS},
        {"RU-KR",  TERRITORY_RU_KR,  0, 0, TERRITORY_RUS},
        {"RU-KRS", TERRITORY_RU_KRS, 0, 0, TERRITORY_RUS},
        {"RU-KYA", TERRITORY_RU_KYA, 0, 0, TERRITORY_RUS},
        {"RU-LEN", TERRITORY_RU_LEN, 0, 0, TERRITORY_RUS},
        {"RU-LIP", TERRITORY_RU_LIP, 0, 0, TERRITORY_RUS},
        {"RU-MAG", TERRITORY_RU_MAG, 0, 0, TERRITORY_RUS},
        {"RU-ME",  TERRITORY_RU_ME,  0, 0, TERRITORY_RUS},
        {"RU-MO",  TERRITORY_RU_MO,  0, 0, TERRITORY_RUS},
        {"RU-MOS", TERRITORY_RU_MOS, 0, 0, TERRITORY_RUS},
        {"RU-MOW", TERRITORY_RU_MOW, 0, 0, TERRITORY_RUS},
        {"RU-MUR", TERRITORY_RU_MUR, 0, 0, TERRITORY_RUS},
        {"RU-NEN", TERRITORY_RU_NEN, 0, 0, TERRITORY_RUS},
        {"RU-NGR", TERRITORY_RU_NGR, 0, 0, TERRITORY_RUS},
        {"RU-NIZ", TERRITORY_RU_NIZ, 0, 0, TERRITORY_RUS},
        {"RU-NVS", TERRITORY_RU_NVS, 0, 0, TERRITORY_RUS},
        {"RU-OMS", TERRITORY_RU_OMS, 0, 0, TERRITORY_RUS},
        {"RU-ORE", TERRITORY_RU_ORE, 0, 0, TERRITORY_RUS},
        {"RU-ORL", TERRITORY_RU_ORL, 0, 0, TERRITORY_RUS},
        {"RU-PER", TERRITORY_RU_PM,  1, 0, TERRITORY_RUS},
        {"RU-PM",  TERRITORY_RU_PM,  0, 0, TERRITORY_RUS},
        {"RU-PNZ", TERRITORY_RU_PNZ, 0, 0, TERRITORY_RUS},
        {"RU-PO",  TERRITORY_RU_PO,  0, 0, TERRITORY_RUS},
        {"RU-PRI", TERRITORY_RU_PO,  1, 0, TERRITORY_RUS},
        {"RU-PSK", TERRITORY_RU_PSK, 0, 0, TERRITORY_RUS},
        {"RU-ROS", TERRITORY_RU_ROS, 0, 0, TERRITORY_RUS},
        {"RU-RYA", TERRITORY_RU_RYA, 0, 0, TERRITORY_RUS},
        {"RU-SA",  TERRITORY_RU_SA,  0, 0, TERRITORY_RUS},
        {"RU-SAK", TERRITORY_RU_SAK, 0, 0, TERRITORY_RUS},
        {"RU-SAM", TERRITORY_RU_SAM, 0, 0, TERRITORY_RUS},
        {"RU-SAR", TERRITORY_RU_SAR, 0, 0, TERRITORY_RUS},
        {"RU-SE",  TERRITORY_RU_SE,  0, 0, TERRITORY_RUS},
        {"RU-SMO", TERRITORY_RU_SMO, 0, 0, TERRITORY_RUS},
        {"RU-SPE", TERRITORY_RU_SPE, 0, 0, TERRITORY_RUS},
        {"RU-STA", TERRITORY_RU_STA, 0, 0, TERRITORY_RUS},
        {"RU-SVE", TERRITORY_RU_SVE, 0, 0, TERRITORY_RUS},
        {"RU-TA",  TERRITORY_RU_TA,  0, 0, TERRITORY_RUS},
        {"RU-TAM", TERRITORY_RU_TT,  1, 0, TERRITORY_RUS},
        {"RU-TOM", TERRITORY_RU_TOM, 0, 0, TERRITORY_RUS},
        {"RU-TT",  TERRITORY_RU_TT,  0, 0, TERRITORY_RUS},
        {"RU-TUL", TERRITORY_RU_TUL, 0, 0, TERRITORY_RUS},
        {"RU-TVE", TERRITORY_RU_TVE, 0, 0, TERRITORY_RUS},
        {"RU-TY",  TERRITORY_RU_TY,  0, 0, TERRITORY_RUS},
        {"RU-TYU", TERRITORY_RU_TYU, 0, 0, TERRITORY_RUS},
        {"RU-UD",  TERRITORY_RU_UD,  0, 0, TERRITORY_RUS},
        {"RU-ULY", TERRITORY_RU_ULY, 0, 0, TERRITORY_RUS},
        {"RU-VGG", TERRITORY_RU_VGG, 0, 0, TERRITORY_RUS},
        {"RU-VLA", TERRITORY_RU_VLA, 0, 0, TERRITORY_RUS},
        {"RU-VLG", TERRITORY_RU_VLG, 0, 0, TERRITORY_RUS},
        {"RU-VOR", TERRITORY_RU_VOR, 0, 0, TERRITORY_RUS},
        {"RU-YAN", TERRITORY_RU_YAN, 0, 0, TERRITORY_RUS},
        {"RU-YAR", TERRITORY_RU_YAR, 0, 0, TERRITORY_RUS},
        {"RU-YEV", TERRITORY_RU_YEV, 0, 0, TERRITORY_RUS},
        {"RU-ZAB", TERRITORY_RU_ZAB, 0, 0, TERRITORY_RUS},
        {"RUS",    TERRITORY_RUS,    0, 0, TERRITORY_NONE},
        {"RWA",    TERRITORY_RWA,    0, 0, TERRITORY_NONE},
        {"RYA",    TERRITORY_RU_RYA, 0, 0, TERRITORY_RUS},
        {"SA",     TERRITORY_RU_SA,  0, 1, TERRITORY_RUS},
        {"SA",     TERRITORY_AU_SA,  0, 1, TERRITORY_AUS},
        {"SAK",    TERRITORY_RU_SAK, 0, 0, TERRITORY_RUS},
        {"SAM",    TERRITORY_RU_SAM, 0, 0, TERRITORY_RUS},
        {"SAR",    TERRITORY_RU_SAR, 0, 0, TERRITORY_RUS},
        {"SAU",    TERRITORY_SAU,    0, 0, TERRITORY_NONE},
        {"SC",     TERRITORY_CN_SC,  0, 1, TERRITORY_CHN},
        {"SC",     TERRITORY_US_SC,  0, 1, TERRITORY_USA},
        {"SC",     TERRITORY_BR_SC,  0, 1, TERRITORY_BRA},
        {"SD",     TERRITORY_CN_SD,  0, 1, TERRITORY_CHN},
        {"SD",     TERRITORY_US_SD,  0, 1, TERRITORY_USA},
        {"SDN",    TERRITORY_SDN,    0, 0, TERRITORY_NONE},
        {"SE",     TERRITORY_RU_SE,  0, 1, TERRITORY_RUS},
        {"SE",     TERRITORY_BR_SE,  0, 1, TERRITORY_BRA},
        {"SEN",    TERRITORY_SEN,    0, 0, TERRITORY_NONE},
        {"SGP",    TERRITORY_SGP,    0, 0, TERRITORY_NONE},
        {"SGS",    TERRITORY_SGS,    0, 0, TERRITORY_NONE},
        {"SH",     TERRITORY_CN_SH,  0, 0, TERRITORY_CHN},
        {"SHN",    TERRITORY_SHN,    0, 0, TERRITORY_NONE},
        {"SI",     TERRITORY_MX_SIN, 1, 0, TERRITORY_MEX},
        {"SIN",    TERRITORY_MX_SIN, 0, 0, TERRITORY_MEX},
        {"SJM",    TERRITORY_SJM,    0, 0, TERRITORY_NONE},
        {"SK",     TERRITORY_CA_SK,  0, 1, TERRITORY_CAN},
        {"SK",     TERRITORY_IN_SK,  0, 1, TERRITORY_IND},
        {"SL",     TERRITORY_MX_SLP, 1, 0, TERRITORY_MEX},
        {"SLB",    TERRITORY_SLB,    0, 0, TERRITORY_NONE},
        {"SLE",    TERRITORY_SLE,    0, 0, TERRITORY_NONE},
        {"SLP",    TERRITORY_MX_SLP, 0, 0, TERRITORY_MEX},
        {"SLV",    TERRITORY_SLV,    0, 0, TERRITORY_NONE},
        {"SMO",    TERRITORY_RU_SMO, 0, 0, TERRITORY_RUS},
        {"SMR",    TERRITORY_SMR,    0, 0, TERRITORY_NONE},
        {"SN",     TERRITORY_CN_SN,  0, 0, TERRITORY_CHN},
        {"SO",     TERRITORY_MX_SON, 1, 0, TERRITORY_MEX},
        {"SOM",    TERRITORY_SOM,    0, 0, TERRITORY_NONE},
        {"SON",    TERRITORY_MX_SON, 0, 0, TERRITORY_MEX},
        {"SP",     TERRITORY_BR_SP,  0, 0, TERRITORY_BRA},
        {"SPE",    TERRITORY_RU_SPE, 0, 0, TERRITORY_RUS},
        {"SPM",    TERRITORY_SPM,    0, 0, TERRITORY_NONE},
        {"SRB",    TERRITORY_SRB,    0, 0, TERRITORY_NONE},
        {"SSD",    TERRITORY_SSD,    0, 0, TERRITORY_NONE},
        {"STA",    TERRITORY_RU_STA, 0, 0, TERRITORY_RUS},
        {"STP",    TERRITORY_STP,    0, 0, TERRITORY_NONE},
        {"SUR",    TERRITORY_SUR,    0, 0, TERRITORY_NONE},
        {"SVE",    TERRITORY_RU_SVE, 0, 0, TERRITORY_RUS},
        {"SVK",    TERRITORY_SVK,    0, 0, TERRITORY_NONE},
        {"SVN",    TERRITORY_SVN,    0, 0, TERRITORY_NONE},
        {"SWE",    TERRITORY_SWE,    0, 0, TERRITORY_NONE},
        {"SWZ",    TERRITORY_SWZ,    0, 0, TERRITORY_NONE},
        {"SX",     TERRITORY_CN_SX,  0, 0, TERRITORY_CHN},
        {"SXM",    TERRITORY_SXM,    0, 0, TERRITORY_NONE},
        {"SYC",    TERRITORY_SYC,    0, 0, TERRITORY_NONE},
        {"SYR",    TERRITORY_SYR,    0, 0, TERRITORY_NONE},
        {"TA",     TERRITORY_RU_TA,  0, 0, TERRITORY_RUS},
        {"TAA",    TERRITORY_SHN,    1, 0, TERRITORY_NONE},
        {"TAB",    TERRITORY_MX_TAB, 0, 0, TERRITORY_MEX},
        {"TAM",    TERRITORY_MX_TAM, 0, 0, TERRITORY_MEX},
        {"TAS",    TERRITORY_AU_TAS, 0, 0, TERRITORY_AUS},
        {"TB",     TERRITORY_MX_TAB, 1, 0, TERRITORY_MEX},
        {"TCA",    TERRITORY_TCA,    0, 0, TERRITORY_NONE},
        {"TCD",    TERRITORY_TCD,    0, 0, TERRITORY_NONE},
        {"TG",     TERRITORY_IN_TG,  0, 0, TERRITORY_IND},
        {"TGO",    TERRITORY_TGO,    0, 0, TERRITORY_NONE},
        {"THA",    TERRITORY_THA,    0, 0, TERRITORY_NONE},
        {"TJ",     TERRITORY_CN_TJ,  0, 0, TERRITORY_CHN},
        {"TJK",    TERRITORY_TJK,    0, 0, TERRITORY_NONE},
        {"TKL",    TERRITORY_TKL,    0, 0, TERRITORY_NONE},
        {"TKM",    TERRITORY_TKM,    0, 0, TERRITORY_NONE},
        {"TL",     TERRITORY_MX_TLA, 1, 0, TERRITORY_MEX},
        {"TLA",    TERRITORY_MX_TLA, 0, 0, TERRITORY_MEX},
        {"TLS",    TERRITORY_TLS,    0, 0, TERRITORY_NONE},
        {"TM",     TERRITORY_MX_TAM, 1, 0, TERRITORY_MEX},
        {"TN",     TERRITORY_US_TN,  0, 1, TERRITORY_USA},
        {"TN",     TERRITORY_IN_TN,  0, 1, TERRITORY_IND},
        {"TO",     TERRITORY_BR_TO,  0, 0, TERRITORY_BRA},
        {"TOM",    TERRITORY_RU_TOM, 0, 0, TERRITORY_RUS},
        {"TON",    TERRITORY_TON,    0, 0, TERRITORY_NONE},
        {"TR",     TERRITORY_IN_TR,  0, 0, TERRITORY_IND},
        {"TT",     TERRITORY_RU_TT,  0, 0, TERRITORY_RUS},
        {"TTO",    TERRITORY_TTO,    0, 0, TERRITORY_NONE},
        {"TUL",    TERRITORY_RU_TUL, 0, 0, TERRITORY_RUS},
        {"TUN",    TERRITORY_TUN,    0, 0, TERRITORY_NONE},
        {"TUR",    TERRITORY_TUR,    0, 0, TERRITORY_NONE},
        {"TUV",    TERRITORY_TUV,    0, 0, TERRITORY_NONE},
        {"TVE",    TERRITORY_RU_TVE, 0, 0, TERRITORY_RUS},
        {"TW",     TERRITORY_TWN,    1, 0, TERRITORY_CHN},
        {"TWN",    TERRITORY_TWN,    0, 0, TERRITORY_NONE},
        {"TX",     TERRITORY_US_TX,  0, 0, TERRITORY_USA},
        {"TY",     TERRITORY_RU_TY,  0, 0, TERRITORY_RUS},
        {"TYU",    TERRITORY_RU_TYU, 0, 0, TERRITORY_RUS},
        {"TZA",    TERRITORY_TZA,    0, 0, TERRITORY_NONE},
        {"UD",     TERRITORY_RU_UD,  0, 0, TERRITORY_RUS},
        {"UGA",    TERRITORY_UGA,    0, 0, TERRITORY_NONE},
        {"UK",     TERRITORY_IN_UT,  1, 0, TERRITORY_IND},
        {"UKR",    TERRITORY_UKR,    0, 0, TERRITORY_NONE},
        {"ULY",    TERRITORY_RU_ULY, 0, 0, TERRITORY_RUS},
        {"UM",     TERRITORY_UMI,    1, 0, TERRITORY_USA},
        {"UMI",    TERRITORY_UMI,    0, 0, TERRITORY_NONE},
        {"UP",     TERRITORY_IN_UP,  0, 0, TERRITORY_IND},
        {"URY",    TERRITORY_URY,    0, 0, TERRITORY_NONE},
        {"US",     TERRITORY_USA,    1, 0, TERRITORY_NONE},
        {"US-AK",  TERRITORY_US_AK,  0, 0, TERRITORY_USA},
        {"US-AL",  TERRITORY_US_AL,  0, 0, TERRITORY_USA},
        {"US-AR",  TERRITORY_US_AR,  0, 0, TERRITORY_USA},
        {"US-AS",  TERRITORY_ASM,    1, 0, TERRITORY_USA},
        {"US-AZ",  TERRITORY_US_AZ,  0, 0, TERRITORY_USA},
        {"US-CA",  TERRITORY_US_CA,  0, 0, TERRITORY_USA},
        {"US-CO",  TERRITORY_US_CO,  0, 0, TERRITORY_USA},
        {"US-CT",  TERRITORY_US_CT,  0, 0, TERRITORY_USA},
        {"US-DC",  TERRITORY_US_DC,  0, 0, TERRITORY_USA},
        {"US-DE",  TERRITORY_US_DE,  0, 0, TERRITORY_USA},
        {"US-FL",  TERRITORY_US_FL,  0, 0, TERRITORY_USA},
        {"US-GA",  TERRITORY_US_GA,  0, 0, TERRITORY_USA},
        {"US-GU",  TERRITORY_GUM,    1, 0, TERRITORY_USA},
        {"US-HI",  TERRITORY_US_HI,  0, 0, TERRITORY_USA},
        {"US-IA",  TERRITORY_US_IA,  0, 0, TERRITORY_USA},
        {"US-ID",  TERRITORY_US_ID,  0, 0, TERRITORY_USA},
        {"US-IL",  TERRITORY_US_IL,  0, 0, TERRITORY_USA},
        {"US-IN",  TERRITORY_US_IN,  0, 0, TERRITORY_USA},
        {"US-KS",  TERRITORY_US_KS,  0, 0, TERRITORY_USA},
        {"US-KY",  TERRITORY_US_KY,  0, 0, TERRITORY_USA},
        {"US-LA",  TERRITORY_US_LA,  0, 0, TERRITORY_USA},
        {"US-MA",  TERRITORY_US_MA,  0, 0, TERRITORY_USA},
        {"US-MD",  TERRITORY_US_MD,  0, 0, TERRITORY_USA},
        {"US-ME",  TERRITORY_US_ME,  0, 0, TERRITORY_USA},
        {"US-MI",  TERRITORY_US_MI,  0, 0, TERRITORY_USA},
        {"US-MID", TERRITORY_US_HI,  1, 0, TERRITORY_USA},
        {"US-MN",  TERRITORY_US_MN,  0, 0, TERRITORY_USA},
        {"US-MO",  TERRITORY_US_MO,  0, 0, TERRITORY_USA},
        {"US-MP",  TERRITORY_MNP,    1, 0, TERRITORY_USA},
        {"US-MS",  TERRITORY_US_MS,  0, 0, TERRITORY_USA},
        {"US-MT",  TERRITORY_US_MT,  0, 0, TERRITORY_USA},
        {"US-NC",  TERRITORY_US_NC,  0, 0, TERRITORY_USA},
        {"US-ND",  TERRITORY_US_ND,  0, 0, TERRITORY_USA},
        {"US-NE",  TERRITORY_US_NE,  0, 0, TERRITORY_USA},
        {"US-NH",  TERRITORY_US_NH,  0, 0, TERRITORY_USA},
        {"US-NJ",  TERRITORY_US_NJ,  0, 0, TERRITORY_USA},
        {"US-NM",  TERRITORY_US_NM,  0, 0, TERRITORY_USA},
        {"US-NV",  TERRITORY_US_NV,  0, 0, TERRITORY_USA},
        {"US-NY",  TERRITORY_US_NY,  0, 0, TERRITORY_USA},
        {"US-OH",  TERRITORY_US_OH,  0, 0, TERRITORY_USA},
        {"US-OK",  TERRITORY_US_OK,  0, 0, TERRITORY_USA},
        {"US-OR",  TERRITORY_US_OR,  0, 0, TERRITORY_USA},
        {"US-PA",  TERRITORY_US_PA,  0, 0, TERRITORY_USA},
        {"US-PR",  TERRITORY_PRI,    1, 0, TERRITORY_USA},
        {"US-RI",  TERRITORY_US_RI,  0, 0, TERRITORY_USA},
        {"US-SC",  TERRITORY_US_SC,  0, 0, TERRITORY_USA},
        {"US-SD",  TERRITORY_US_SD,  0, 0, TERRITORY_USA},
        {"US-TN",  TERRITORY_US_TN,  0, 0, TERRITORY_USA},
        {"US-TX",  TERRITORY_US_TX,  0, 0, TERRITORY_USA},
        {"US-UM",  TERRITORY_UMI,    1, 0, TERRITORY_USA},
        {"US-UT",  TERRITORY_US_UT,  0, 0, TERRITORY_USA},
        {"US-VA",  TERRITORY_US_VA,  0, 0, TERRITORY_USA},
        {"US-VI",  TERRITORY_VIR,    1, 0, TERRITORY_USA},
        {"US-VT",  TERRITORY_US_VT,  0, 0, TERRITORY_USA},
        {"US-WA",  TERRITORY_US_WA,  0, 0, TERRITORY_USA},
        {"US-WI",  TERRITORY_US_WI,  0, 0, TERRITORY_USA},
        {"US-WV",  TERRITORY_US_WV,  0, 0, TERRITORY_USA},
        {"US-WY",  TERRITORY_US_WY,  0, 0, TERRITORY_USA},
        {"USA",    TERRITORY_USA,    0, 0, TERRITORY_NONE},
        {"UT",     TERRITORY_US_UT,  0, 1, TERRITORY_USA},
        {"UT",     TERRITORY_IN_UT,  0, 1, TERRITORY_IND},
        {"UZB",    TERRITORY_UZB,    0, 0, TERRITORY_NONE},
        {"VA",     TERRITORY_US_VA,  0, 0, TERRITORY_USA},
        {"VAT",    TERRITORY_VAT,    0, 0, TERRITORY_NONE},
        {"VCT",    TERRITORY_VCT,    0, 0, TERRITORY_NONE},
        {"VE",     TERRITORY_MX_VER, 1, 0, TERRITORY_MEX},
        {"VEN",    TERRITORY_VEN,    0, 0, TERRITORY_NONE},
        {"VER",    TERRITORY_MX_VER, 0, 0, TERRITORY_MEX},
        {"VGB",    TERRITORY_VGB,    0, 0, TERRITORY_NONE},
        {"VGG",    TERRITORY_RU_VGG, 0, 0, TERRITORY_RUS},
        {"VI",     TERRITORY_VIR,    1, 0, TERRITORY_USA},
        {"VIC",    TERRITORY_AU_VIC, 0, 0, TERRITORY_AUS},
        {"VIR",    TERRITORY_VIR,    0, 0, TERRITORY_NONE},
        {"VLA",    TERRITORY_RU_VLA, 0, 0, TERRITORY_RUS},
        {"VLG",    TERRITORY_RU_VLG, 0, 0, TERRITORY_RUS},
        {"VNM",    TERRITORY_VNM,    0, 0, TERRITORY_NONE},
        {"VOR",    TERRITORY_RU_VOR, 0, 0, TERRITORY_RUS},
        {"VT",     TERRITORY_US_VT,  0, 0, TERRITORY_USA},
        {"VUT",    TERRITORY_VUT,    0, 0, TERRITORY_NONE},
        {"WA",     TERRITORY_US_WA,  0, 1, TERRITORY_USA},
        {"WA",     TERRITORY_AU_WA,  0, 1, TERRITORY_AUS},
        {"WAK",    TERRITORY_MHL,    1, 0, TERRITORY_NONE},
        {"WB",     TERRITORY_IN_WB,  0, 0, TERRITORY_IND},
        {"WI",     TERRITORY_US_WI,  0, 0, TERRITORY_USA},
        {"WLF",    TERRITORY_WLF,    0, 0, TERRITORY_NONE},
        {"WSM",    TERRITORY_WSM,    0, 0, TERRITORY_NONE},
        {"WV",     TERRITORY_US_WV,  0, 0, TERRITORY_USA},
        {"WY",     TERRITORY_US_WY,  0, 0, TERRITORY_USA},
        {"XJ",     TERRITORY_CN_XJ,  0, 0, TERRITORY_CHN},
        {"XZ",     TERRITORY_CN_XZ,  0, 0, TERRITORY_CHN},
        {"YAN",    TERRITORY_RU_YAN, 0, 0, TERRITORY_RUS},
        {"YAR",    TERRITORY_RU_YAR, 0, 0, TERRITORY_RUS},
        {"YEM",    TERRITORY_YEM,    0, 0, TERRITORY_NONE},
        {"YEV",    TERRITORY_RU_YEV, 0, 0, TERRITORY_RUS},
        {"YN",     TERRITORY_CN_YN,  0, 0, TERRITORY_CHN},
        {"YT",     TERRITORY_CA_YT,  0, 0, TERRITORY_CAN},
        {"YU",     TERRITORY_MX_YUC, 1, 0, TERRITORY_MEX},
        {"YUC",    TERRITORY_MX_YUC, 0, 0, TERRITORY_MEX},
        {"ZA",     TERRITORY_MX_ZAC, 1, 0, TERRITORY_MEX},
        {"ZAB",    TERRITORY_RU_ZAB, 0, 0, TERRITORY_RUS},
        {"ZAC",    TERRITORY_MX_ZAC, 0, 0, TERRITORY_MEX},
        {"ZAF",    TERRITORY_ZAF,    0, 0, TERRITORY_NONE},
        {"ZJ",     TERRITORY_CN_ZJ,  0, 0, TERRITORY_CHN},
        {"ZMB",    TERRITORY_ZMB,    0, 0, TERRITORY_NONE},
        {"ZWE",    TERRITORY_ZWE,    0, 0, TERRITORY_NONE}
};
