/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;
import java.util.Hashtable;

public class HashtableStringKeyCollections { 
  public int identifier;
  public Hashtable HashtableOfString_Object0;
  public Hashtable HashtableOfString_Object1;
  public Hashtable HashtableOfString_Object2;
  public Hashtable HashtableOfString_SimpleClass3;
  public Hashtable HashtableOfString_SimpleClass4;
  public Hashtable HashtableOfString_SimpleClass5;
  public Hashtable HashtableOfString_SimpleInterface6;
  public Hashtable HashtableOfString_SimpleInterface7;
  public Hashtable HashtableOfString_SimpleInterface8;
  public Hashtable HashtableOfString_String9;
  public Hashtable HashtableOfString_String10;
  public Hashtable HashtableOfString_String11;
  public Hashtable HashtableOfString_Date12;
  public Hashtable HashtableOfString_Date13;
  public Hashtable HashtableOfString_Date14;
  public Hashtable HashtableOfString_Locale15;
  public Hashtable HashtableOfString_Locale16;
  public Hashtable HashtableOfString_Locale17;
  public Hashtable HashtableOfString_BigDecimal18;
  public Hashtable HashtableOfString_BigDecimal19;
  public Hashtable HashtableOfString_BigDecimal20;
  public Hashtable HashtableOfString_BigInteger21;
  public Hashtable HashtableOfString_BigInteger22;
  public Hashtable HashtableOfString_BigInteger23;
  public Hashtable HashtableOfString_Byte24;
  public Hashtable HashtableOfString_Byte25;
  public Hashtable HashtableOfString_Byte26;
  public Hashtable HashtableOfString_Double27;
  public Hashtable HashtableOfString_Double28;
  public Hashtable HashtableOfString_Double29;
  public Hashtable HashtableOfString_Float30;
  public Hashtable HashtableOfString_Float31;
  public Hashtable HashtableOfString_Float32;
  public Hashtable HashtableOfString_Integer33;
  public Hashtable HashtableOfString_Integer34;
  public Hashtable HashtableOfString_Integer35;
  public Hashtable HashtableOfString_Long36;
  public Hashtable HashtableOfString_Long37;
  public Hashtable HashtableOfString_Long38;
  public Hashtable HashtableOfString_Short39;
  public Hashtable HashtableOfString_Short40;
  public Hashtable HashtableOfString_Short41;
  public Hashtable HashtableOfString_Object42;
  public Hashtable HashtableOfString_Object43;
  public Hashtable HashtableOfString_SimpleClass45;
  public Hashtable HashtableOfString_SimpleClass46;
  public Hashtable HashtableOfString_SimpleInterface48;
  public Hashtable HashtableOfString_SimpleInterface49;
  public Hashtable HashtableOfString_String51;
  public Hashtable HashtableOfString_String52;
  public Hashtable HashtableOfString_Date54;
  public Hashtable HashtableOfString_Date55;
  public Hashtable HashtableOfString_Locale57;
  public Hashtable HashtableOfString_Locale58;
  public Hashtable HashtableOfString_BigDecimal60;
  public Hashtable HashtableOfString_BigDecimal61;
  public Hashtable HashtableOfString_BigInteger63;
  public Hashtable HashtableOfString_BigInteger64;
  public Hashtable HashtableOfString_Byte66;
  public Hashtable HashtableOfString_Byte67;
  public Hashtable HashtableOfString_Double69;
  public Hashtable HashtableOfString_Double70;
  public Hashtable HashtableOfString_Float72;
  public Hashtable HashtableOfString_Float73;
  public Hashtable HashtableOfString_Integer75;
  public Hashtable HashtableOfString_Integer76;
  public Hashtable HashtableOfString_Long78;
  public Hashtable HashtableOfString_Long79;
  public Hashtable HashtableOfString_Short81;
  public Hashtable HashtableOfString_Short82;
  public Hashtable HashtableOfString_Object84;
  public Hashtable HashtableOfString_Object86;
  public Hashtable HashtableOfString_SimpleClass87;
  public Hashtable HashtableOfString_SimpleClass89;
  public Hashtable HashtableOfString_SimpleInterface90;
  public Hashtable HashtableOfString_SimpleInterface92;
  public Hashtable HashtableOfString_String93;
  public Hashtable HashtableOfString_String95;
  public Hashtable HashtableOfString_Date96;
  public Hashtable HashtableOfString_Date98;
  public Hashtable HashtableOfString_Locale99;
  public Hashtable HashtableOfString_Locale101;
  public Hashtable HashtableOfString_BigDecimal102;
  public Hashtable HashtableOfString_BigDecimal104;
  public Hashtable HashtableOfString_BigInteger105;
  public Hashtable HashtableOfString_BigInteger107;
  public Hashtable HashtableOfString_Byte108;
  public Hashtable HashtableOfString_Byte110;
  public Hashtable HashtableOfString_Double111;
  public Hashtable HashtableOfString_Double113;
  public Hashtable HashtableOfString_Float114;
  public Hashtable HashtableOfString_Float116;
  public Hashtable HashtableOfString_Integer117;
  public Hashtable HashtableOfString_Integer119;
  public Hashtable HashtableOfString_Long120;
  public Hashtable HashtableOfString_Long122;
  public Hashtable HashtableOfString_Short123;
  public Hashtable HashtableOfString_Short125;

  public static final String [] fieldSpecs = { 
  "public Hashtable HashtableOfString_Object0",
  "embedded-value=true public Hashtable HashtableOfString_Object1",
  "embedded-value=false public Hashtable HashtableOfString_Object2",
  "public Hashtable HashtableOfString_SimpleClass3",
  "embedded-value=true public Hashtable HashtableOfString_SimpleClass4",
  "embedded-value=false public Hashtable HashtableOfString_SimpleClass5",
  "public Hashtable HashtableOfString_SimpleInterface6",
  "embedded-value=true public Hashtable HashtableOfString_SimpleInterface7",
  "embedded-value=false public Hashtable HashtableOfString_SimpleInterface8",
  "public Hashtable HashtableOfString_String9",
  "embedded-value=true public Hashtable HashtableOfString_String10",
  "embedded-value=false public Hashtable HashtableOfString_String11",
  "public Hashtable HashtableOfString_Date12",
  "embedded-value=true public Hashtable HashtableOfString_Date13",
  "embedded-value=false public Hashtable HashtableOfString_Date14",
  "public Hashtable HashtableOfString_Locale15",
  "embedded-value=true public Hashtable HashtableOfString_Locale16",
  "embedded-value=false public Hashtable HashtableOfString_Locale17",
  "public Hashtable HashtableOfString_BigDecimal18",
  "embedded-value=true public Hashtable HashtableOfString_BigDecimal19",
  "embedded-value=false public Hashtable HashtableOfString_BigDecimal20",
  "public Hashtable HashtableOfString_BigInteger21",
  "embedded-value=true public Hashtable HashtableOfString_BigInteger22",
  "embedded-value=false public Hashtable HashtableOfString_BigInteger23",
  "public Hashtable HashtableOfString_Byte24",
  "embedded-value=true public Hashtable HashtableOfString_Byte25",
  "embedded-value=false public Hashtable HashtableOfString_Byte26",
  "public Hashtable HashtableOfString_Double27",
  "embedded-value=true public Hashtable HashtableOfString_Double28",
  "embedded-value=false public Hashtable HashtableOfString_Double29",
  "public Hashtable HashtableOfString_Float30",
  "embedded-value=true public Hashtable HashtableOfString_Float31",
  "embedded-value=false public Hashtable HashtableOfString_Float32",
  "public Hashtable HashtableOfString_Integer33",
  "embedded-value=true public Hashtable HashtableOfString_Integer34",
  "embedded-value=false public Hashtable HashtableOfString_Integer35",
  "public Hashtable HashtableOfString_Long36",
  "embedded-value=true public Hashtable HashtableOfString_Long37",
  "embedded-value=false public Hashtable HashtableOfString_Long38",
  "public Hashtable HashtableOfString_Short39",
  "embedded-value=true public Hashtable HashtableOfString_Short40",
  "embedded-value=false public Hashtable HashtableOfString_Short41",
  "embedded-key=true  public Hashtable HashtableOfString_Object42",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Object43",
  "embedded-key=true  public Hashtable HashtableOfString_SimpleClass45",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_SimpleClass46",
  "embedded-key=true  public Hashtable HashtableOfString_SimpleInterface48",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_SimpleInterface49",
  "embedded-key=true  public Hashtable HashtableOfString_String51",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_String52",
  "embedded-key=true  public Hashtable HashtableOfString_Date54",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Date55",
  "embedded-key=true  public Hashtable HashtableOfString_Locale57",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Locale58",
  "embedded-key=true  public Hashtable HashtableOfString_BigDecimal60",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_BigDecimal61",
  "embedded-key=true  public Hashtable HashtableOfString_BigInteger63",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_BigInteger64",
  "embedded-key=true  public Hashtable HashtableOfString_Byte66",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Byte67",
  "embedded-key=true  public Hashtable HashtableOfString_Double69",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Double70",
  "embedded-key=true  public Hashtable HashtableOfString_Float72",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Float73",
  "embedded-key=true  public Hashtable HashtableOfString_Integer75",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Integer76",
  "embedded-key=true  public Hashtable HashtableOfString_Long78",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Long79",
  "embedded-key=true  public Hashtable HashtableOfString_Short81",
  "embedded-key=true embedded-value=true public Hashtable HashtableOfString_Short82",
  "embedded-key=false  public Hashtable HashtableOfString_Object84",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Object86",
  "embedded-key=false  public Hashtable HashtableOfString_SimpleClass87",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_SimpleClass89",
  "embedded-key=false  public Hashtable HashtableOfString_SimpleInterface90",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_SimpleInterface92",
  "embedded-key=false  public Hashtable HashtableOfString_String93",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_String95",
  "embedded-key=false  public Hashtable HashtableOfString_Date96",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Date98",
  "embedded-key=false  public Hashtable HashtableOfString_Locale99",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Locale101",
  "embedded-key=false  public Hashtable HashtableOfString_BigDecimal102",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_BigDecimal104",
  "embedded-key=false  public Hashtable HashtableOfString_BigInteger105",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_BigInteger107",
  "embedded-key=false  public Hashtable HashtableOfString_Byte108",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Byte110",
  "embedded-key=false  public Hashtable HashtableOfString_Double111",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Double113",
  "embedded-key=false  public Hashtable HashtableOfString_Float114",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Float116",
  "embedded-key=false  public Hashtable HashtableOfString_Integer117",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Integer119",
  "embedded-key=false  public Hashtable HashtableOfString_Long120",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Long122",
  "embedded-key=false  public Hashtable HashtableOfString_Short123",
  "embedded-key=false embedded-value=false public Hashtable HashtableOfString_Short125"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public Hashtable get(int index)
  {
    switch (index)
    {
      case(0):
        return HashtableOfString_Object0;
      case(1):
        return HashtableOfString_Object1;
      case(2):
        return HashtableOfString_Object2;
      case(3):
        return HashtableOfString_SimpleClass3;
      case(4):
        return HashtableOfString_SimpleClass4;
      case(5):
        return HashtableOfString_SimpleClass5;
      case(6):
        return HashtableOfString_SimpleInterface6;
      case(7):
        return HashtableOfString_SimpleInterface7;
      case(8):
        return HashtableOfString_SimpleInterface8;
      case(9):
        return HashtableOfString_String9;
      case(10):
        return HashtableOfString_String10;
      case(11):
        return HashtableOfString_String11;
      case(12):
        return HashtableOfString_Date12;
      case(13):
        return HashtableOfString_Date13;
      case(14):
        return HashtableOfString_Date14;
      case(15):
        return HashtableOfString_Locale15;
      case(16):
        return HashtableOfString_Locale16;
      case(17):
        return HashtableOfString_Locale17;
      case(18):
        return HashtableOfString_BigDecimal18;
      case(19):
        return HashtableOfString_BigDecimal19;
      case(20):
        return HashtableOfString_BigDecimal20;
      case(21):
        return HashtableOfString_BigInteger21;
      case(22):
        return HashtableOfString_BigInteger22;
      case(23):
        return HashtableOfString_BigInteger23;
      case(24):
        return HashtableOfString_Byte24;
      case(25):
        return HashtableOfString_Byte25;
      case(26):
        return HashtableOfString_Byte26;
      case(27):
        return HashtableOfString_Double27;
      case(28):
        return HashtableOfString_Double28;
      case(29):
        return HashtableOfString_Double29;
      case(30):
        return HashtableOfString_Float30;
      case(31):
        return HashtableOfString_Float31;
      case(32):
        return HashtableOfString_Float32;
      case(33):
        return HashtableOfString_Integer33;
      case(34):
        return HashtableOfString_Integer34;
      case(35):
        return HashtableOfString_Integer35;
      case(36):
        return HashtableOfString_Long36;
      case(37):
        return HashtableOfString_Long37;
      case(38):
        return HashtableOfString_Long38;
      case(39):
        return HashtableOfString_Short39;
      case(40):
        return HashtableOfString_Short40;
      case(41):
        return HashtableOfString_Short41;
      case(42):
        return HashtableOfString_Object42;
      case(43):
        return HashtableOfString_Object43;
      case(44):
        return HashtableOfString_SimpleClass45;
      case(45):
        return HashtableOfString_SimpleClass46;
      case(46):
        return HashtableOfString_SimpleInterface48;
      case(47):
        return HashtableOfString_SimpleInterface49;
      case(48):
        return HashtableOfString_String51;
      case(49):
        return HashtableOfString_String52;
      case(50):
        return HashtableOfString_Date54;
      case(51):
        return HashtableOfString_Date55;
      case(52):
        return HashtableOfString_Locale57;
      case(53):
        return HashtableOfString_Locale58;
      case(54):
        return HashtableOfString_BigDecimal60;
      case(55):
        return HashtableOfString_BigDecimal61;
      case(56):
        return HashtableOfString_BigInteger63;
      case(57):
        return HashtableOfString_BigInteger64;
      case(58):
        return HashtableOfString_Byte66;
      case(59):
        return HashtableOfString_Byte67;
      case(60):
        return HashtableOfString_Double69;
      case(61):
        return HashtableOfString_Double70;
      case(62):
        return HashtableOfString_Float72;
      case(63):
        return HashtableOfString_Float73;
      case(64):
        return HashtableOfString_Integer75;
      case(65):
        return HashtableOfString_Integer76;
      case(66):
        return HashtableOfString_Long78;
      case(67):
        return HashtableOfString_Long79;
      case(68):
        return HashtableOfString_Short81;
      case(69):
        return HashtableOfString_Short82;
      case(70):
        return HashtableOfString_Object84;
      case(71):
        return HashtableOfString_Object86;
      case(72):
        return HashtableOfString_SimpleClass87;
      case(73):
        return HashtableOfString_SimpleClass89;
      case(74):
        return HashtableOfString_SimpleInterface90;
      case(75):
        return HashtableOfString_SimpleInterface92;
      case(76):
        return HashtableOfString_String93;
      case(77):
        return HashtableOfString_String95;
      case(78):
        return HashtableOfString_Date96;
      case(79):
        return HashtableOfString_Date98;
      case(80):
        return HashtableOfString_Locale99;
      case(81):
        return HashtableOfString_Locale101;
      case(82):
        return HashtableOfString_BigDecimal102;
      case(83):
        return HashtableOfString_BigDecimal104;
      case(84):
        return HashtableOfString_BigInteger105;
      case(85):
        return HashtableOfString_BigInteger107;
      case(86):
        return HashtableOfString_Byte108;
      case(87):
        return HashtableOfString_Byte110;
      case(88):
        return HashtableOfString_Double111;
      case(89):
        return HashtableOfString_Double113;
      case(90):
        return HashtableOfString_Float114;
      case(91):
        return HashtableOfString_Float116;
      case(92):
        return HashtableOfString_Integer117;
      case(93):
        return HashtableOfString_Integer119;
      case(94):
        return HashtableOfString_Long120;
      case(95):
        return HashtableOfString_Long122;
      case(96):
        return HashtableOfString_Short123;
      case(97):
        return HashtableOfString_Short125;
      default:
        throw new IndexOutOfBoundsException("Bad index " + index);
    }
  }
  public boolean set(int index,Hashtable value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        HashtableOfString_Object0= value;
         break;
      case(1):
        HashtableOfString_Object1= value;
         break;
      case(2):
        HashtableOfString_Object2= value;
         break;
      case(3):
        HashtableOfString_SimpleClass3= value;
         break;
      case(4):
        HashtableOfString_SimpleClass4= value;
         break;
      case(5):
        HashtableOfString_SimpleClass5= value;
         break;
      case(6):
        HashtableOfString_SimpleInterface6= value;
         break;
      case(7):
        HashtableOfString_SimpleInterface7= value;
         break;
      case(8):
        HashtableOfString_SimpleInterface8= value;
         break;
      case(9):
        HashtableOfString_String9= value;
         break;
      case(10):
        HashtableOfString_String10= value;
         break;
      case(11):
        HashtableOfString_String11= value;
         break;
      case(12):
        HashtableOfString_Date12= value;
         break;
      case(13):
        HashtableOfString_Date13= value;
         break;
      case(14):
        HashtableOfString_Date14= value;
         break;
      case(15):
        HashtableOfString_Locale15= value;
         break;
      case(16):
        HashtableOfString_Locale16= value;
         break;
      case(17):
        HashtableOfString_Locale17= value;
         break;
      case(18):
        HashtableOfString_BigDecimal18= value;
         break;
      case(19):
        HashtableOfString_BigDecimal19= value;
         break;
      case(20):
        HashtableOfString_BigDecimal20= value;
         break;
      case(21):
        HashtableOfString_BigInteger21= value;
         break;
      case(22):
        HashtableOfString_BigInteger22= value;
         break;
      case(23):
        HashtableOfString_BigInteger23= value;
         break;
      case(24):
        HashtableOfString_Byte24= value;
         break;
      case(25):
        HashtableOfString_Byte25= value;
         break;
      case(26):
        HashtableOfString_Byte26= value;
         break;
      case(27):
        HashtableOfString_Double27= value;
         break;
      case(28):
        HashtableOfString_Double28= value;
         break;
      case(29):
        HashtableOfString_Double29= value;
         break;
      case(30):
        HashtableOfString_Float30= value;
         break;
      case(31):
        HashtableOfString_Float31= value;
         break;
      case(32):
        HashtableOfString_Float32= value;
         break;
      case(33):
        HashtableOfString_Integer33= value;
         break;
      case(34):
        HashtableOfString_Integer34= value;
         break;
      case(35):
        HashtableOfString_Integer35= value;
         break;
      case(36):
        HashtableOfString_Long36= value;
         break;
      case(37):
        HashtableOfString_Long37= value;
         break;
      case(38):
        HashtableOfString_Long38= value;
         break;
      case(39):
        HashtableOfString_Short39= value;
         break;
      case(40):
        HashtableOfString_Short40= value;
         break;
      case(41):
        HashtableOfString_Short41= value;
         break;
      case(42):
        HashtableOfString_Object42= value;
         break;
      case(43):
        HashtableOfString_Object43= value;
         break;
      case(44):
        HashtableOfString_SimpleClass45= value;
         break;
      case(45):
        HashtableOfString_SimpleClass46= value;
         break;
      case(46):
        HashtableOfString_SimpleInterface48= value;
         break;
      case(47):
        HashtableOfString_SimpleInterface49= value;
         break;
      case(48):
        HashtableOfString_String51= value;
         break;
      case(49):
        HashtableOfString_String52= value;
         break;
      case(50):
        HashtableOfString_Date54= value;
         break;
      case(51):
        HashtableOfString_Date55= value;
         break;
      case(52):
        HashtableOfString_Locale57= value;
         break;
      case(53):
        HashtableOfString_Locale58= value;
         break;
      case(54):
        HashtableOfString_BigDecimal60= value;
         break;
      case(55):
        HashtableOfString_BigDecimal61= value;
         break;
      case(56):
        HashtableOfString_BigInteger63= value;
         break;
      case(57):
        HashtableOfString_BigInteger64= value;
         break;
      case(58):
        HashtableOfString_Byte66= value;
         break;
      case(59):
        HashtableOfString_Byte67= value;
         break;
      case(60):
        HashtableOfString_Double69= value;
         break;
      case(61):
        HashtableOfString_Double70= value;
         break;
      case(62):
        HashtableOfString_Float72= value;
         break;
      case(63):
        HashtableOfString_Float73= value;
         break;
      case(64):
        HashtableOfString_Integer75= value;
         break;
      case(65):
        HashtableOfString_Integer76= value;
         break;
      case(66):
        HashtableOfString_Long78= value;
         break;
      case(67):
        HashtableOfString_Long79= value;
         break;
      case(68):
        HashtableOfString_Short81= value;
         break;
      case(69):
        HashtableOfString_Short82= value;
         break;
      case(70):
        HashtableOfString_Object84= value;
         break;
      case(71):
        HashtableOfString_Object86= value;
         break;
      case(72):
        HashtableOfString_SimpleClass87= value;
         break;
      case(73):
        HashtableOfString_SimpleClass89= value;
         break;
      case(74):
        HashtableOfString_SimpleInterface90= value;
         break;
      case(75):
        HashtableOfString_SimpleInterface92= value;
         break;
      case(76):
        HashtableOfString_String93= value;
         break;
      case(77):
        HashtableOfString_String95= value;
         break;
      case(78):
        HashtableOfString_Date96= value;
         break;
      case(79):
        HashtableOfString_Date98= value;
         break;
      case(80):
        HashtableOfString_Locale99= value;
         break;
      case(81):
        HashtableOfString_Locale101= value;
         break;
      case(82):
        HashtableOfString_BigDecimal102= value;
         break;
      case(83):
        HashtableOfString_BigDecimal104= value;
         break;
      case(84):
        HashtableOfString_BigInteger105= value;
         break;
      case(85):
        HashtableOfString_BigInteger107= value;
         break;
      case(86):
        HashtableOfString_Byte108= value;
         break;
      case(87):
        HashtableOfString_Byte110= value;
         break;
      case(88):
        HashtableOfString_Double111= value;
         break;
      case(89):
        HashtableOfString_Double113= value;
         break;
      case(90):
        HashtableOfString_Float114= value;
         break;
      case(91):
        HashtableOfString_Float116= value;
         break;
      case(92):
        HashtableOfString_Integer117= value;
         break;
      case(93):
        HashtableOfString_Integer119= value;
         break;
      case(94):
        HashtableOfString_Long120= value;
         break;
      case(95):
        HashtableOfString_Long122= value;
         break;
      case(96):
        HashtableOfString_Short123= value;
         break;
      case(97):
        HashtableOfString_Short125= value;
         break;
      default:
        throw new IndexOutOfBoundsException("Bad index " + index);
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }

    }   
}
