#
# repack()
# This is a function called by prototype files when one source tree
# builds multiple binary packages.
#

repack() {
   # $1 is our subpackage name to create

   if [ "$1" = "" ]
   then
      echo "ERROR:  Subpackage name not specified for repack() call."
   else
      ### the way repack works is similar to protopkg.  it inherits certain
      ### pieces of information from the main prototype, but has it's own
      ### as well.  it's kinda hard to follow (especially at 5:43AM), so
      ### pay close attention.   -David

      # look for a subproto
      if [ ! -f $CWD/prototype.$1 ]
      then
         echo "ERROR:  Aborting repack(), prototype.$1 not found."
         return
      else
         . $CWD/prototype.$1
      fi

      echo
      echo "Building subpackage $1..."
      echo

      ### VERIFY SUBPROTOTYPE FILE
      echo -n "Verifying subpackage prototype file..."
      verifyproto "sub" "$1"
      echo "good, building package [$SUBPKGNAME]"

      ### DO WE NEED TO COMPILE?
      if [ ! "$COMPILED" = "y" ]
      then
         echo -n "Compiling package [$PKGNAME]..."
         cd $TMP
         if [ "$VERBOSE" = "y" ]
         then
            echo
            compile
         else
            compile 2>/dev/null 1>/dev/null
            echo "done."
         fi
         COMPILED=y
      fi

      ### BUILD LIST OF INSTALLED FILES
      echo -n "Generating list of files for subpackage [$SUBPKGNAME]..."
      beforeinstall
      if [ "$VERBOSE" = "y" ]
      then
         echo
         subinstall
      else
         subinstall 2>/dev/null 1>/dev/null
      fi
      afterinstall
      if [ ! "$VERBOSE" = "y" ]
      then
         echo "done."
      fi

      ### HAVE USER PLAY WITH PACKAGE LIST UNLESS BATCH MODE IS SET
      if [ ! "$BATCH" = "y" ]
      then
         cat << EOF

protopkg has gathered a list of what it things should be in the subpackage.
You will now be given the opportunity to edit that list if you see that
protopkg missed anything or got something wrong.  Just type in the editor
you want to use and hit enter to edit the package list.  After you exit
the editor, protopkg will finish making the subpackage.

EOF
         echo -n "Editor to use [default: $EDITOR]: "
         read usered

         if [ "$usered" = "" ]
         then
            $EDITOR $TMP/package.lst
         else
            if [ ! -x $usered -a ! -f $usered ]
            then
               echo
               echo "Error with editor specified, defaulting to $EDITOR"
               $EDITOR $TMP/package.lst
            else
               $usered $TMP/package.lst
            fi
         fi
      fi
      echo

      ### SET THE SUBPACKAGE AND SUBPACKAGE CONTROL VARIABLES
      SUBPKG=$TMP/pkg-$SUBPKGNAME
      SUBCTL=$SUBPKG/install

      if [ "$VERBOSE" = "y" ]
      then
         echo "Creating subpackage tree..."
         build_package $SUBPKGNAME $SUBPKG
         stripeverything $SUBPKG
         restoredoctimes $SUBPKGNAME $SUBPKG
         permissionize $SUBPKG
         compressdocs $SUBPKG
      else
         echo -n "Creating subpackage tree..."
         build_package $SUBPKGNAME $SUBPKG 2>/dev/null 1>/dev/null
         stripeverything $SUBPKG 2>/dev/null 1>/dev/null
         restoredoctimes $SUBPKGNAME $SUBPKG 2>/dev/null 1>/dev/null
         permissionize $SUBPKG 2>/dev/null 1>/dev/null
         compressdocs $SUBPKG 2>/dev/null 1>/dev/null
      fi

      if [ ! "$VERBOSE" = "y" ]
      then
         echo "done."
      fi

      ### CHECK FOR ZERO-LENGTH FILES
      if [ "$VERBOSE" = "y" ]
      then
         echo "Checking for zero-length files..."
      fi
      zerocheck $SUBPKG

      ### MAKE THE SYMLINKS FOR THE DOINST
      if [ "$VERBOSE" = "y" ]
      then
         symlinks $SUBPKG $SUBCTL
      else
         symlinks $SUBPKG $SUBCTL 2>/dev/null 1>/dev/null
      fi

      ### RUN THE SPECIAL FUNCTION
      cd $SUBPKG
      if [ "$VERBOSE" = "y" ]
      then
         subspecial
      else
         subspecial 2>/dev/null 1>/dev/null
      fi

      ### READ THE RULES FILE AND PREPARE INCOMING CONFIG FILES
      if [ "$VERBOSE" = "y" ]
      then
         echo "Preparing incoming configuration files for processing..."
         prepare_conf $SUBPKGNAME
      else
         prepare_conf $SUBPKGNAME 2>/dev/null 1>/dev/null
      fi

      ### FIXATE PACKAGE
      if [ "$VERBOSE" = "y" ]
      then
         echo "Fixating package [$SUBPKGNAME]..."
      else
         echo -n "Fixating package [$SUBPKGNAME]..."
      fi
      fixate_package $SUBPKGNAME $SUBPKG $SUBCTL

      if [ ! "$VERBOSE" = "y" ]
      then
         echo "done."
      fi

      echo
   fi
}
