#
# build_package()
# Called by protopkg() after afterinstall() has been run.  It takes the
# list of files that go in the package and tars them up.  It then moves to
# the temporary package build directory and untars those files there.
# This is done so that permissions and such can be fixed up on the package
# contents.
#
# Parameters:   $1    The package name
#               $2    The package tree
#

build_package() {
   cd $TMP
   mkdir -p $2
   chown root.root $2
   chmod 755 $2

   for hejaz in `cat $TMP/package.lst`
   do
      if [ ! "`file $hejaz | grep \"symbolic link\"`" = "" ]
      then
         # we want symbolic links
         echo $hejaz >> $TMP/archive.lst
      elif [ ! "`file $hejaz | grep \"directory\$\"`" = "" -a ! -f $hejaz ]
      then
         # empty directories get caught for later creation
         echo $hejaz >> $TMP/emptydirs.lst
      elif [ ! -d $hejaz ]
      then
         # catch all other files
         echo $hejaz >> $TMP/archive.lst
      fi
   done

   rm -rf $TMP/package.lst

   # create the package tree
   cd $2
   if [ "$VERBOSE" = "y" ]
   then
      tar -cvf $TMP/$1.tar -T $TMP/archive.lst
      tar -xvf $TMP/$1.tar
      rm -f $TMP/$1.tar
   else
      tar -cvf $TMP/$1.tar -T $TMP/archive.lst 1>/dev/null 2>/dev/null
      tar -xvf $TMP/$1.tar 1>/dev/null 2>/dev/null
      rm -f $TMP/$1.tar 1>/dev/null 2>/dev/null
   fi

   # run through our directory list and make that in the tree
   for d in `cat $TMP/emptydirs.lst`
   do
      tmpD=`trim_slash $d`
      if [ ! -d $PKG/$tmpD ]
      then
         mkdir -p $PKG/$tmpD
      fi
   done

   rm -rf $TMP/emptydirs.lst
   rm -rf $TMP/archive.lst
}
